(* *********************************************************************** *)
(*									   *)
(* Project: HOL-CASL 							   *)
(* Author: Kolyang, University of Bremen    			           *)
(* Date: 16.05.97				 			   *)
(* Purpose of this file: Basic CASL Goaling infra structure		   *)
(*			 						   *)
(*									   *)
(* *********************************************************************** *)

(* Provides Isabelle-like goal infrastructure for CASL theories.
 *)


structure Basic_CASLproof :
  sig

    type caslproof
    val restore_caslproof : caslproof -> thm list
    val save_caslproof : unit -> caslproof
    val pop_caslproof : unit -> thm list
    val push_caslproof : unit -> unit
    val CASL_goal : CASLTheory.casltheory -> string -> thm list
    val Goal : string -> thm list
    val CASL_goalw : CASLTheory.casltheory -> thm list -> string -> thm list
    val prove_caslgoalw : CASLTheory.casltheory
                       -> thm list
                          -> string -> (thm list -> tactic list) -> thm
(*    val HOLThms : (string * thm) list*)

  end

= struct

local open  GlobalEnv CASLTheory CASLThyRead in


fun CASL_goalw (caslthy as CASLTheory.CASLthy{casl_env,thy}) rths agoal = 
    
     goalw_cterm rths (cterm_of(sign_of thy) (read_formula false caslthy agoal))
     handle ERROR => error (*from type_assign, etc via prepare_proof*)
	    ("The error above occurred for " ^ quote agoal);
    


fun prove_caslgoalw(caslthy as CASLTheory.CASLthy{casl_env,thy}) prm agoal tct =
     prove_goalw_cterm prm (cterm_of(sign_of thy)
			         (read_formula false caslthy agoal)) tct
     handle ERROR => error (*from type_assign, etc via prepare_proof*)
	    ("The error above occurred for " ^ quote agoal);
   


fun CASL_goal caslthy gl = 
    (CASL_goalw caslthy [] gl);

fun Goal (s:string) : thm list = 
    if take(4,explode (Sign.name_of (sign_of (Context.the_context ())))) <> ["C","A","S","L"]
    then Goals.Goal s
    else CASL_goal (CASL_Context.CASL_the_context ()) s;  

(* getting the thms from HOL 

val HOLThy = Symtab.lookup (!loaded_caslthys, "HOL_CASL");
val (Some thH) = HOLThy;
val CASLThyInfo pla = thH;
val HOLCASL = #theory pla;
val HOLThms = Symtab.dest (#thms pla);
*)
     
(* in the same way  caslQED ... *)

datatype caslproof = mk_caslproof of GlobalEnv.spec_lenv * proof;

fun save_caslproof () = mk_caslproof(!GlobalEnv.ENV, save_proof());

fun restore_caslproof (mk_caslproof(caslenv,prf)) = 
	(GlobalEnv.ENV:=caslenv; restore_proof prf);

fun pop_caslproof () = 
	(!GlobalEnv.ENV; pop_proof ());
	
fun push_caslproof() = 
	(!GlobalEnv.ENV; push_proof ());

	end
	end;
	
     

