(* ----------------------------------------------------------------------- *)
(* xml_iface.sml                          Pascal Schmidt <pharao90@tzi.de> *)
(* ----------------------------------------------------------------------- *)
(* interface functions for XML generator                                   *)
(* ----------------------------------------------------------------------- *)

(* $Id: xml_iface.sml,v 1.1 2004/02/13 11:29:21 7till Exp $ *)

signature xml_iface_sig
=
sig
  val lib2string     : bool -> AS.LIB_DEFN -> string
  val lib2file       : bool -> AS.LIB_DEFN -> string -> unit

  val lib_env2string : bool -> (AS.LIB_DEFN * GlobalEnv.global_env) -> string
  val lib_env2file   : bool -> (AS.LIB_DEFN * GlobalEnv.global_env) -> string
                       -> unit

  val libitem2string : bool -> AS.LIB_ITEM -> string
  val libitem2file   : bool -> AS.LIB_ITEM -> string -> unit

  val casenv2string  : bool -> GlobalEnv.global_env -> string
  val casenv2file    : bool -> GlobalEnv.global_env -> string -> unit

  val fcasenv2string : bool -> GlobalEnv.f_global_env -> string
  val fcasenv2file   : bool -> GlobalEnv.f_global_env -> string -> unit

  val file2lib       : string -> AS.LIB_DEFN * GlobalEnv.global_env
end

structure xml_iface : xml_iface_sig
=
struct

  exception NotYet

  open xml_types xml_convert xml_share xml_treeconv xml_to_as

  fun file2lib s = xml_to_as.a_lib_defn (xml_treeconv.read_xml s)

  fun lib2string b tr = if b then
                          sxml2str (share_all (x_lib_defn tr))
                        else
                          xml2str (x_lib_defn tr) 
  
  fun lib2file b tr f = if b then
                          sxml2file (share_all (x_lib_defn tr)) f
                        else
                          xml2file (x_lib_defn tr) f

  fun lib_env2string b (tr,ge) = if b then
                                   sxml2str (share_all (x_lib_defn2 (tr,ge)))
                                 else
                                   xml2str (x_lib_defn2 (tr,ge)) 
  
  fun lib_env2file b (tr,ge) f = if b then
                                  sxml2file (share_all (x_lib_defn2 (tr,ge))) f
                                 else
                                  xml2file (x_lib_defn2 (tr,ge)) f

  fun libitem2string b tr = if b then
                              sxml2str (share_all (x_lib_item tr))
                            else
                              xml2str (x_lib_item tr) 
  
  fun libitem2file b tr f = if b then
                              sxml2file (share_all (x_lib_item tr)) f
                            else
                              xml2file (x_lib_item tr) f
  
  fun casenv2string b g = if b then
                            sxml2str (share_all (x_global_env g))
                          else
                            xml2str (x_global_env g)

  fun casenv2file b g f = if b then
                            sxml2file (share_all (x_global_env g)) f
                          else
                            xml2file (x_global_env g) f

  fun fcasenv2string b g = if b then
                             sxml2str (share_all (x_f_global_env g))
                           else
                             xml2str (x_f_global_env g)

  fun fcasenv2file b g f = if b then
                             sxml2file (share_all (x_f_global_env g)) f
                           else
                             xml2file (x_f_global_env g) f

end
