(* ----------------------------------------------------------------------- *)
(* xml_treeconv.sml                       Pascal Schmidt <pharao90@tzi.de> *)
(* ----------------------------------------------------------------------- *)
(* conversion of fxp's parse tree with ids to one with strings             *)
(* ----------------------------------------------------------------------- *)

(* $Id: xml_treeconv.sml,v 1.1 2004/02/13 11:29:21 7till Exp $ *)

structure xml_treeconv
=
struct

  local open xml_types TreeData Utils in

  infix mem

  val real_empty_tags = xml_dtd.dtd_empty_elems

  fun readtree loc =
    let
      val dtd  = Dtd.initDtdTables()
      val tree = ParseTree.parseTree (SOME (Uri.String2Uri loc)) (SOME dtd)
    in
      (dtd,tree)
    end

  fun idx2str dtd i = UniChar.Data2String (Dtd.Index2Element dtd i)

  fun tconv d (TEXT v)          = pcdata (UniChar.Vector2String v)
    | tconv d (ELEM ((x,_),[])) = let
                                    val name = idx2str d x
                                  in
                                    if (name mem real_empty_tags)
                                    then
                                      empty_tag (name,[])
                                    else
                                      tag (name,[],[])
                                  end
    | tconv d (ELEM ((x,_),l))  = tag ((idx2str d x),[],(map (tconv d)) l)

  fun read_xml loc = let
                       val (dtd,tree) = readtree loc
                     in
                       tconv dtd tree
                     end

  end (* local open ... in *)

end
