{- |
Module      :  $Header: /repository/caslbook/lncs2960-CD/Tools/Hets/src/Common/Named.hs,v 1.1 2004/02/13 14:50:41 5maeder Exp $
Copyright   :  (c) Christian Maeder and Uni Bremen 2002-2003
Licence     :  similar to LGPL, see HetCATS/LICENCE.txt or LIZENZ.txt

Maintainer  :  hets@tzi.de
Stability   :  provisional
Portability :  portable
    
name sentences in CASL, Logic and elsewhere
-}

module Common.Named where

import Common.PrettyPrint
import Common.Lib.Pretty
import Common.Print_AS_Annotation
import Common.AS_Annotation
import Data.Dynamic

data Named s = NamedSen { senName  :: String,
                          sentence :: s }
	       deriving (Eq, Show)

instance PrettyPrint s => PrettyPrint (Named s) where
    printText0 ga (NamedSen{senName = label, sentence = s}) =
	printText0 ga s <+> printText0 ga (Label [label] [])

-- used in version 1.4 2003/02/25 Static/DGToSpec.hs:38:
namedTc :: TyCon
namedTc = mkTyCon "Common.Named.Named"

instance Typeable s => Typeable (Named s) where 
  typeOf s = mkAppTy namedTc [typeOf ((undefined :: Named a -> a) s)]
