{- Generated by DrIFT (Automatic class derivations for Haskell) -}
{-# LINE 1 "Syntax/AS_Architecture.der.hs" #-}
{-| 
   
Module      :  $Header: /repository/caslbook/lncs2960-CD/Tools/Hets/src/Syntax/AS_Architecture.hs,v 1.1 2004/02/13 14:50:49 5maeder Exp $
Copyright   :  (c) Klaus Lttich, Uni Bremen 2002-2004
Licence     :  similar to LGPL, see HetCATS/LICENCE.txt or LIZENZ.txt

Maintainer  :  hets@tzi.de
Stability   :  provisional
Portability :  non-portable(Grothendieck)

   These data structures describe the abstract syntax tree for heterogenous 
   architectural specifications in HetCASL.
-}

{-

   todo:
     - ATermConversion SML-CATS has now his own module 
       (s. HetCATS/aterm_conv/)
     - LaTeX Pretty Printing
-}

module Syntax.AS_Architecture where

import Common.Id
import Common.AS_Annotation

import Syntax.AS_Structured
import Logic.Grothendieck

-- Drift directive:
{-! global : UpPos !-}

data ARCH_SPEC_DEFN = Arch_spec_defn ARCH_SPEC_NAME (Annoted ARCH_SPEC) [Pos]
		      -- pos: "arch","spec","=",opt "end"
		      deriving (Show)

data ARCH_SPEC = Basic_arch_spec [Annoted UNIT_DECL_DEFN]
		                 (Annoted UNIT_EXPRESSION) [Pos]
	         -- pos: "unit","result"
	       | Arch_spec_name ARCH_SPEC_NAME
	       | Group_arch_spec (Annoted ARCH_SPEC) [Pos]
		 -- pos: "{","}"
		 deriving (Show)

data UNIT_DECL_DEFN = Unit_decl UNIT_NAME UNIT_SPEC [Annoted UNIT_TERM] [Pos]
		      -- pos: ":",opt ("given"; Annoted holds pos of commas)
		    | Unit_defn UNIT_NAME UNIT_EXPRESSION [Pos]
		      -- pos: "="
		      deriving (Show)

data UNIT_SPEC_DEFN = Unit_spec_defn SPEC_NAME UNIT_SPEC [Pos]
		      -- pos: "unit","spec","=", opt "end"
		      deriving (Show)

data UNIT_SPEC = Unit_type [Annoted SPEC] (Annoted SPEC) [Pos]
	         -- pos: opt "*"s , "->"
	       | Spec_name SPEC_NAME
	       | Arch_unit_spec (Annoted ARCH_SPEC) [Pos] 
		 -- pos: "arch","spec"
		 -- The ARCH_SPEC has to be surrounded with braces and
		 -- after the opening brace is a [Annotation] allowed
	       | Closed_unit_spec UNIT_SPEC [Pos]
		 -- pos: "closed"
		 deriving (Show)

data UNIT_EXPRESSION = Unit_expression [UNIT_BINDING] (Annoted UNIT_TERM) [Pos]
		       -- pos: opt "lambda",semi colons, "."
		       deriving (Show)

data UNIT_BINDING = Unit_binding UNIT_NAME UNIT_SPEC [Pos]
		    -- pos: ":"
		    deriving (Show) 

data UNIT_TERM = Unit_reduction (Annoted UNIT_TERM) RESTRICTION
	       | Unit_translation (Annoted UNIT_TERM) RENAMING 
	       | Amalgamation [Annoted UNIT_TERM] [Pos]
		 -- pos: "and"s
	       | Local_unit [Annoted UNIT_DECL_DEFN] (Annoted UNIT_TERM) [Pos] 
		 -- pos: "local", "within"
	       | Unit_appl UNIT_NAME [FIT_ARG_UNIT] [Pos]
		 -- pos: many of "[","]"
	       | Group_unit_term (Annoted UNIT_TERM) [Pos]
		 -- pos: "{","}"
		 deriving (Show)

data FIT_ARG_UNIT = Fit_arg_unit (Annoted UNIT_TERM) 
		                 G_symb_map_items_list [Pos] 
		    -- pos: opt "fit"
		    deriving (Show)

type ARCH_SPEC_NAME = SIMPLE_ID
type UNIT_NAME = SIMPLE_ID
{- ? Generated by DrIFT : Look, but Don't Touch. (works w/ haddock) ? -}
instance PosItem ARCH_SPEC_DEFN where
    up_pos_l fn1 (Arch_spec_defn aa ab ac) =
	(Arch_spec_defn aa ab (fn1 ac))
    get_pos_l (Arch_spec_defn _ _ ac) = Just ac

instance PosItem ARCH_SPEC where
    up_pos_l fn1 (Basic_arch_spec aa ab ac) =
	(Basic_arch_spec aa ab (fn1 ac))
    up_pos_l _ (Arch_spec_name aa) = (Arch_spec_name aa)
    up_pos_l fn1 (Group_arch_spec aa ab) =
	(Group_arch_spec aa (fn1 ab))
    get_pos_l (Basic_arch_spec _ _ ac) = Just ac
    get_pos_l (Arch_spec_name _) = Nothing
    get_pos_l (Group_arch_spec _ ab) = Just ab

instance PosItem UNIT_DECL_DEFN where
    up_pos_l fn1 (Unit_decl aa ab ac ad) =
	(Unit_decl aa ab ac (fn1 ad))
    up_pos_l fn1 (Unit_defn aa ab ac) = (Unit_defn aa ab (fn1 ac))
    get_pos_l (Unit_decl _ _ _ ad) = Just ad
    get_pos_l (Unit_defn _ _ ac) = Just ac

instance PosItem UNIT_SPEC_DEFN where
    up_pos_l fn1 (Unit_spec_defn aa ab ac) =
	(Unit_spec_defn aa ab (fn1 ac))
    get_pos_l (Unit_spec_defn _ _ ac) = Just ac

instance PosItem UNIT_SPEC where
    up_pos_l fn1 (Unit_type aa ab ac) = (Unit_type aa ab (fn1 ac))
    up_pos_l _ (Spec_name aa) = (Spec_name aa)
    up_pos_l fn1 (Arch_unit_spec aa ab) = (Arch_unit_spec aa (fn1 ab))
    up_pos_l fn1 (Closed_unit_spec aa ab) =
	(Closed_unit_spec aa (fn1 ab))
    get_pos_l (Unit_type _ _ ac) = Just ac
    get_pos_l (Spec_name _) = Nothing
    get_pos_l (Arch_unit_spec _ ab) = Just ab
    get_pos_l (Closed_unit_spec _ ab) = Just ab

instance PosItem UNIT_EXPRESSION where
    up_pos_l fn1 (Unit_expression aa ab ac) =
	(Unit_expression aa ab (fn1 ac))
    get_pos_l (Unit_expression _ _ ac) = Just ac

instance PosItem UNIT_BINDING where
    up_pos_l fn1 (Unit_binding aa ab ac) =
	(Unit_binding aa ab (fn1 ac))
    get_pos_l (Unit_binding _ _ ac) = Just ac

instance PosItem UNIT_TERM where
    up_pos_l _ (Unit_reduction aa ab) = (Unit_reduction aa ab)
    up_pos_l _ (Unit_translation aa ab) = (Unit_translation aa ab)
    up_pos_l fn1 (Amalgamation aa ab) = (Amalgamation aa (fn1 ab))
    up_pos_l fn1 (Local_unit aa ab ac) = (Local_unit aa ab (fn1 ac))
    up_pos_l fn1 (Unit_appl aa ab ac) = (Unit_appl aa ab (fn1 ac))
    up_pos_l fn1 (Group_unit_term aa ab) =
	(Group_unit_term aa (fn1 ab))
    get_pos_l (Unit_reduction _ _) = Nothing
    get_pos_l (Unit_translation _ _) = Nothing
    get_pos_l (Amalgamation _ ab) = Just ab
    get_pos_l (Local_unit _ _ ac) = Just ac
    get_pos_l (Unit_appl _ _ ac) = Just ac
    get_pos_l (Group_unit_term _ ab) = Just ab

instance PosItem FIT_ARG_UNIT where
    up_pos_l fn1 (Fit_arg_unit aa ab ac) =
	(Fit_arg_unit aa ab (fn1 ac))
    get_pos_l (Fit_arg_unit _ _ ac) = Just ac

--  Imported from other files :-
