-- -----------------------------------------------------------------------
--
-- $Source: /repository/uni/htk/devices/Bell.hs,v $
--
-- HTk - a GUI toolkit for Haskell  -  (c) Universitaet Bremen
--
-- $Revision: 1.4 $ from $Date: 2002/01/07 21:14:13 $  
-- Last modification by $Author: ludi $
--
-- -----------------------------------------------------------------------

---
-- This module provides access to the terminal bell.
module Bell (

  Window,
  ringBell,
  bell
        
) where

import Window
import Toplevel
import Core


-- -----------------------------------------------------------------------
-- Ring Bell 
-- -----------------------------------------------------------------------

---
-- Rings the bell for the given window.
ringBell :: Window w => Maybe w -> IO ()
ringBell Nothing = execTclScript [tkRing Nothing]
ringBell (Just win) = execMethod win (\ nm -> [tkRing (Just nm)])

---
-- Rings the bell.
bell :: IO ()
bell = ringBell (Nothing :: Maybe Toplevel)


-- -----------------------------------------------------------------------
-- Unparsing of Commands
-- -----------------------------------------------------------------------

tkRing :: Maybe ObjectName -> TclCmd
tkRing Nothing = "bell"
tkRing (Just win) = "bell -displayof " ++ show win 
{-# INLINE tkRing #-}
