-- -----------------------------------------------------------------------
--
-- $Source: /repository/uni/htk/menuitems/MenuRadioButton.hs,v $
--
-- HTk - a GUI toolkit for Haskell  -  (c) Universitaet Bremen
--
-- $Revision: 1.4 $ from $Date: 2001/12/17 20:54:56 $
-- Last modification by $Author: ludi $
--
-- -----------------------------------------------------------------------

---
-- HTk's <strong>menu radiobutton</strong>.<br>
-- A simple radiobutton inside a menu associated with a polymorphic
-- variable.
module MenuRadioButton (

  HasIndicator(..),
  HasAccelerator(..),

  MenuRadioButton,
  createMenuRadioButton

) where

import Core
import Configuration
import Image
import BitMap
import Menu
import MenuItem
import Indicator
import Synchronized
import Computation
import TkVariables


-- -----------------------------------------------------------------------
-- datatype
-- -----------------------------------------------------------------------

---
-- The <code>MenuRadioButton</code> datatype.
newtype MenuRadioButton = MenuRadioButton GUIOBJECT deriving Eq


-- -----------------------------------------------------------------------
-- commands
-- -----------------------------------------------------------------------

---
-- Constructs a new menu radiobutton and returns a handler.
-- @param m       - the parent menu.
-- @param cnf     - the list of configuration options for this menu
--                  radiobutton.
-- @return result - A menu radiobutton.
createMenuRadioButton :: Menu -> [Config MenuRadioButton] ->
                         IO MenuRadioButton
createMenuRadioButton m cnf =
  createMenuItem m MENURADIOBUTTON MenuRadioButton cnf


-- -----------------------------------------------------------------------
-- instances
-- -----------------------------------------------------------------------

---
-- A menu radiobutton is a menu item (any menu item instantiates the
-- abstract <code>class MenuItem</code>).
instance MenuItem MenuRadioButton

---
-- Internal.
instance GUIObject MenuRadioButton where 
---
-- Internal.
  toGUIObject (MenuRadioButton w) = w
---
-- Internal.
  cname _ = "MenuRadioButton"

---
-- You can synchronize on a menu radiobutton.
instance Synchronized MenuRadioButton where
---
-- Synchronizes on a menu radiobutton.
  synchronize = synchronize . toGUIObject

---
-- A menu radiobutton has an optional text to display as a reminder
-- about a keystroke binding.
instance HasAccelerator MenuRadioButton

---
-- A menu radiobutton can contain a bitmap (instead of text or an image).
instance HasBitMap MenuRadioButton

---
-- A menu radiobutton has a configureable border.
instance HasBorder MenuRadioButton

---
-- A menu radiobutton has a normal foreground and background colour and
-- an active/disabled foreground and background colour.
instance HasColour MenuRadioButton where 
---
-- Internal.
  legalColourID = buttonColours

---
-- A menu radiobutton is a stateful object, it can be enabled or
-- disabled.
instance HasEnable MenuRadioButton

---
-- You can specify the font of a menu radiobutton.
instance HasFont MenuRadioButton

---
-- A menu radiobutton has a configureable text justification.
instance HasJustify MenuRadioButton

---
-- You can display an indicator with a menu radiobutton.
instance HasIndicator MenuRadioButton

---
-- You can specify the size of a menu radiobutton.
instance HasPhoto MenuRadioButton

---
-- You can specify the size of a menu radiobutton.
instance HasSize MenuRadioButton

---
-- A menu radiobutton can contain text (instead of an image or bitmap).
instance GUIValue v => HasText MenuRadioButton v where
---
-- Sets the text to display.
  text str w = cset w "label" str >> return w
---
-- Gets the displayed text.
  getText w = cget w "label"

---
-- You can set the index of a text character to underline.
instance HasUnderline MenuRadioButton

---
-- The polymorphic variable the menu radiobutton's value is associated
-- with.
instance HasVariable MenuRadioButton

---
-- A menu radiobutton has a value, that corresponds to a polymorphic
-- <code>TkVariable</code>.
instance GUIValue v => HasValue MenuRadioButton v

---
-- When a menu radiobutton is clicked, a corresponding event is invoked.
instance HasCommand MenuRadioButton
