(* ------------------------------------------------------------------------ *)
(* writer_spec.sml                                                          *)
(* LIB_DEFN writer for the casl standalone tool                             *)
(* Pascal Schmidt <pharao90@tzi.de>                                         *)
(* ------------------------------------------------------------------------ *)

(* $Id: writer_spec.sml,v 1.1 2004/02/13 11:29:10 7till Exp $ *)


signature WriterSpecSig
=
sig
  val write_specs : Options.casl_options ->
                    (string * (GlobalEnv.lib_env * GlobalEnv.global_env
                     * AS.LIB_DEFN)) list ->
                    unit list
end

structure WriterSpec : WriterSpecSig
=
struct

open Utils

fun basen []       = []
  | basen ("/"::t) = []
  | basen (h::t)   = h :: (basen t)

fun basename x = (implode o rev o basen o rev o explode) x

fun writef l (x,(le,ge,tr)) = if (x<>"") then
                              ( if (Options.sp_aterm l) then
                                  if (Options.output_env l) then
                                    AT.mkA_genv_file (out (x^".tree.trm")) (ge,tr)
                                  else
                                    AT.mkA_file (out (x^".tree.trm")) tr
                                else
                                  () ;
                                if (Options.sp_xml l) then
                                  if (Options.output_env l) then
                                    xml_iface.lib_env2file true (tr,ge)
                                                           (out (x^".xml"))
                                  else
                                    xml_iface.lib2file true tr (out (x^".xml"))
                                else
                                  () ;
				if (Options.sp_gen_aterm l) then
				    ATLib.aterm_to_file 
					(out (x^".tree.gen_trm"))
					(AT_gen.at_LIB_DEFN tr)
				else
				    ();
				if (Options.sp_text l) then
				    Utils.write
					(out (x^".struct.casl"))
					(StructuredPrint.print_LIB_DEFN
					     tr)
				else
				    ()
                              ) else ()


fun writer l n = (map (writef l)) n

fun dobin l (x,(le,ge,tr)) = 
    if (x<>"") then
        if (Options.sp_aterm l) then
            if (Options.output_bin l) then
                ( writeln ("Compressing "^x^".tree.trm to "^x^".tree.baf");
                  OS.Process.system ("mv "^x^".tree.trm /tmp/"^(basename x));
                  OS.Process.system ("trm2baf < /tmp/"^(basename x)^
				     " > "^x^".tree.baf");
                  OS.Process.system ("rm /tmp/"^(basename x));
                  () )
            else 
		() 
	else 
	    if (Options.sp_aterm l) then
		if (Options.output_bin l) then
                    ( OS.Process.system ("mv "^x^".tree.gen_trm /tmp/"^
					 (basename x));
                      OS.Process.system ("trm2baf < /tmp/"^(basename x)^
				     " > "^x^".tree.gen_baf");
                      OS.Process.system ("rm /tmp/"^(basename x));
                      () )
		else 
		    () 
	    else 
		() 
    else 
	()

fun dobins l n = (map (dobin l)) n

fun write_specs l n = ( writer l n ; (dobins l n) )

end
