(* *********************************************************************** *)
(*									   *)
(* Project: CATS 							   *)
(* Author: Till Mossakowski, University of Bremen			   *)
(* Date: 1998				 			           *)
(* Purpose of this file: Abstract syntax                     	           *)
(*			 						   *)	
(*									   *)
(* *********************************************************************** *)

(* The abstract syntax largely follows the CASL summary.
   Annoations are inserted at those places where an annotation is allowed.
   Position information is included as well, using extra constructors
   for each data type.
*)

structure AS =
struct

open AS_types

local open Library in

fun make_sid s = simple_id ([token s], s,None)

fun token_or_mifix2simple_id (tl,s,ln) = (s,ln)

fun is_mixfix (simple_id(toks,_,_)) = place mem toks
  | is_mixfix (compound_id((toks,_,_),_)) = place mem toks
  
val empty_lib_name = lib (path_name "")

val empty_lib_defn = lib_defn (empty_lib_name,[],[])

datatype ParserResult = lib_defn_value of LIB_DEFN
                      | anno_value of ANNO

end
end
