
structure CASL98Pure =
struct

local open Library Term Mixfix

in

infix |>


val sign =

Sign.pre_pure
  |> Sign.prep_ext
  |> Sign.add_path "/"
  |> Sign.add_types
   (("fun", 2, NoSyn) ::
    ("prop", 0, NoSyn) ::
    ("itself", 1, NoSyn) ::
    Syntax.pure_types)
(*  |> Theory.add_classes_i [(logicC, [])]
  |> Theory.add_defsort_i logicS
  |> Theory.add_arities_i
   [("fun", [logicS, logicS], logicS),
    ("prop", [], logicS),
    ("itself", [logicS], logicS)]
  |> Theory.add_syntax Syntax.pure_syntax
  |> Theory.add_modesyntax ("symbols", true) Syntax.pure_sym_syntax
  |> Theory.add_trfuns Syntax.pure_trfuns
  |> Theory.add_trfunsT Syntax.pure_trfunsT
  |> Theory.add_syntax
   [("==>", "[prop, prop] => prop", Delimfix "op ==>")]
  |> Theory.add_consts
   [("==", "['a::{}, 'a] => prop", InfixrName ("==", 2)),
    ("=?=", "['a::{}, 'a] => prop", InfixrName ("=?=", 2)),
    ("==>", "[prop, prop] => prop", Mixfix ("(_/ ==> _)", [2, 1], 1)),
    ("all", "('a => prop) => prop", Binder ("!!", 0, 0)),
    ("TYPE", "'a itself", NoSyn)]
  |> Theory.add_path "ProtoPure"
  |> add_store_defs [("flexpair_def", "(t =?= u) == (t == u::'a::{})")]
  |> Theory.add_name "ProtoPure";*)

|>
  Sign.add_types
[("SimpleTerm", 0, NoSyn),
 ("LibItem", 0, NoSyn),
 ("BasicItems", 0, NoSyn),
 ("BasicSpec", 0, NoSyn),
 ("SpecList", 0, NoSyn),
 ("SomeSorts", 0, NoSyn),
 ("IsoDecl", 0, NoSyn),
 ("SortGenItem", 0, NoSyn),
 ("WORDS1", 0, NoSyn),
 ("SymbOrMapList", 0, NoSyn),
 ("PLACE", 0, NoSyn),
 ("SIGN1", 0, NoSyn),
 ("SIGNS", 0, NoSyn),
 ("ANNO", 0, NoSyn),
 ("TOKEN", 0, NoSyn),
 ("NUMBER", 0, NoSyn),
 ("BRACKET", 0, NoSyn),
 ("SIGNS_BRACKETS", 0, NoSyn),
 ("BRACKET_SIGNS", 0, NoSyn),
 ("PLACE_TOKEN_ID", 0, NoSyn),
 ("PLACE_TOKEN_IDList", 0, NoSyn),
 ("TOKEN_ID", 0, NoSyn),
 ("TOKEN_ID_List", 0, NoSyn),
 ("TOKEN_ID", 0, NoSyn),
 ("TOKEN_IDList1", 0, NoSyn),
 ("MIXFIX_ID", 0, NoSyn),
 ("ID", 0, NoSyn),
 ("ID_List", 0, NoSyn),
 ("ID", 0, NoSyn),
 ("ID_List", 0, NoSyn),
 ("ID_Group", 0, NoSyn),
 ("SIMPLE_ID", 0, NoSyn),
 ("SIMPLE_ID_List", 0, NoSyn),
 ("PATH1", 0, NoSyn),
 ("Symb", 0, NoSyn),
 ("SymbList", 0, NoSyn),
 ("Anno", 0, NoSyn),
 ("ExtAnno", 0, NoSyn),
 ("Literal", 0, NoSyn),
 ("TTerm", 0, NoSyn),
 ("TTerms", 0, NoSyn),
 ("TTermList", 0, NoSyn),
 ("Membership", 0, NoSyn),
 ("VarDecl", 0, NoSyn),
 ("VarDeclList", 0, NoSyn),
 ("ArgDecl", 0, NoSyn),
 ("ArgDeclList", 0, NoSyn),
 ("PredItem", 0, NoSyn),
 ("PredItemList", 0, NoSyn),
 ("Alternative", 0, NoSyn),
 ("AlternativeList", 0, NoSyn),
 ("Component", 0, NoSyn),
 ("ComponentList", 0, NoSyn),
 ("DataTypeDecl", 0, NoSyn),
 ("DataTypeDecls", 0, NoSyn),
 ("PredType", 0, NoSyn),
 ("OpType", 0, NoSyn),
 ("Predication", 0, NoSyn),
 ("DataTypeHead", 0, NoSyn),
 ("QualPredName", 0, NoSyn),
 ("QualOpName", 0, NoSyn),
 ("OpSymb", 0, NoSyn),
 ("PredSymb", 0, NoSyn),
 ("OpItem", 0, NoSyn),
 ("OpItemList", 0, NoSyn),
 ("OpItem1", 0, NoSyn),
 ("Axiom", 0, NoSyn),
 ("AxiomList", 0, NoSyn),
 ("Atom", 0, NoSyn),
 ("AtomList", 0, NoSyn),
 ("SortItem", 0, NoSyn),
 ("SortItemList", 0, NoSyn),
 ("VarItem", 0, NoSyn),
 ("VarItems", 0, NoSyn),
 ("SigItems", 0, NoSyn),
 ("SigItemsList", 0, NoSyn),
 ("Formula", 0, NoSyn),
 ("Quantification", 0, NoSyn),
 ("L_Formula", 0, NoSyn),
 ("L_FormulaList", 0, NoSyn),
 ("AndFormula", 0, NoSyn),
 ("OrFormula", 0, NoSyn),
 ("ImpFormula", 0, NoSyn),
 ("IfFormula", 0, NoSyn),
 ("OpAttr", 0, NoSyn),
 ("OpAttrList", 0, NoSyn),
 ("OpHead", 0, NoSyn),
 ("PredHead", 0, NoSyn),
 ("Label", 0, NoSyn),
 ("LIB_ID", 0, NoSyn),
 ("LIB_NAME", 0, NoSyn),
 ("VERSION", 0, NoSyn),
 ("ITEM_NAME_OR_MAP", 0, NoSyn),
 ("ITEM_NAME_OR_MAP_LIST", 0, NoSyn),
 ("SymbOrMap", 0, NoSyn),
 ("SymbMap", 0, NoSyn),
 ("Symb", 0, NoSyn),
 ("SymbMapList", 0, NoSyn),
 ("SymbMapItems", 0, NoSyn),
 ("SymbItems", 0, NoSyn),
 ("SymbItemsList", 0, NoSyn),
 ("SymbMapItemsList", 0, NoSyn),
 ("SymbMapItemsList1", 0, NoSyn),
 ("SymbItemsList1", 0, NoSyn),
 ("VIEW_TYPE", 0, NoSyn),
 ("VIEW_DEFN", 0, NoSyn),
 ("VIEW_NAME", 0, NoSyn),
 ("FitArg", 0, NoSyn),
 ("FitArgList", 0, NoSyn),
 ("Spec", 0, NoSyn),
 ("GroupSpec", 0, NoSyn),
 ("AndSpecList", 0, NoSyn),
 ("ThenSpecList", 0, NoSyn),
 ("Renaming", 0, NoSyn),
 ("Restriction", 0, NoSyn),
 ("Then", 0, NoSyn),
 ("Equals", 0, NoSyn),
 ("SpecDefn", 0, NoSyn),
 ("SomeGenerics", 0, NoSyn),
 ("SomeParams", 0, NoSyn),
 ("SomeImports", 0, NoSyn),
 ("FitArgUnit", 0, NoSyn),
 ("UnitTerm", 0, NoSyn),
 ("FitArgUnitList", 0, NoSyn),
 ("GroupUnitTerm", 0, NoSyn),
 ("UnitDefnList", 0, NoSyn),
 ("UnitSpec", 0, NoSyn),
 ("UnitBinding", 0, NoSyn),
 ("UnitBindingList", 0, NoSyn),
 ("UnitExpression", 0, NoSyn),
 ("GroupSpecList", 0, NoSyn),
 ("ArchSpec", 0, NoSyn),
 ("ArchSpecDefn", 0, NoSyn),
 ("BasicArchSpec", 0, NoSyn),
 ("GroupArchSpec", 0, NoSyn),
 ("ArchSpec", 0, NoSyn),
 ("UnitDeclDefnList", 0, NoSyn),
 ("UnitDeclDefn", 0, NoSyn),
 ("UnitDeclDefnList", 0, NoSyn),
 ("UnitDecl", 0, NoSyn),
 ("GroupUnitTermList", 0, NoSyn),
 ("GroupUnitTerm", 0, NoSyn),
 ("UnitDefn", 0, NoSyn),
 ("UnitSpecDefn", 0, NoSyn),
 ("SpecName", 0, NoSyn),
 ("UnitSpec", 0, NoSyn),
 ("UnitSpecDefn", 0, NoSyn),
 ("AndUnitTerm", 0, NoSyn)]


|> curry Sign.add_modesyntax
("", true)
[("number1", "DIGIT  => NUMBER ", Mixfix ("_", [], max_pri)),
 ("number2", "NNUMBER  => NUMBER ", Mixfix ("_", [], max_pri)),
 ("word1", "WORDS  => WORDS1 ", Mixfix ("_", [], max_pri)),
 ("word2", "NUMBER  => WORDS1 ", Mixfix ("_", [], max_pri)),
 ("__", "PLACE ", Mixfix ("'_'_", [], max_pri)),
 ("brackets1", "BRACKET ", Mixfix ("[", [], max_pri)),
 ("brackets2", "BRACKET ", Mixfix ("]", [], max_pri)),
 ("brackets3", "BRACKET ", Mixfix ("{", [], max_pri)),
 ("brackets4", "BRACKET ", Mixfix ("}", [], max_pri)),
 ("sign", "SIGN  => SIGN1 ", Mixfix ("_", [], max_pri)),
 ("emptyset", "SIGN1 ", Mixfix ("{}", [], max_pri)),
 ("lessthan", "SIGN1 ", Mixfix ("<", [], max_pri)),
 ("times", "SIGN1 ", Mixfix ("*", [], max_pri)),
 ("question", "SIGN1 ", Mixfix ("?", [], max_pri)),
 ("divides", "SIGN1 ", Mixfix ("'/", [], max_pri)),
 ("arrow", "SIGN1 ", Mixfix ("->", [], max_pri)),
 ("parrow", "SIGN1 ", Mixfix ("->?", [], max_pri)),
 ("unequal", "SIGN1 ", Mixfix ("<>", [], max_pri)),
 ("signs1", "SIGN1  => SIGNS ", Mixfix ("_", [], max_pri)),
 ("signs2", "[SIGN1 , BRACKET ] => SIGNS ", Mixfix ("__", [], max_pri)),
 ("signs3", "[SIGN1 , BRACKET , SIGNS ] => SIGNS ", Mixfix ("___", [], max_pri)),
 ("signs4", "BRACKET  => SIGNS ", Mixfix ("_", [], max_pri)),
 ("signs5", "[BRACKET , SIGNS ] => SIGNS ", Mixfix ("__", [], max_pri)),
 ("simple_id", "WORDS  => SIMPLE_ID ", Mixfix ("_", [], max_pri)),
 ("token1", "WORDS  => TOKEN ", Mixfix ("_", [], max_pri)),
 ("token2", "SIGNS  => TOKEN ", Mixfix ("_", [], max_pri)),
 ("token3", "DOT_WORDS  => TOKEN ", Mixfix ("_", [], max_pri)),
 ("token4", "DIGIT  => TOKEN ", Mixfix ("_", [], max_pri)),
 ("char", "CHAR  => TOKEN ", Mixfix ("_", [], max_pri)),
 ("token", "[PLACE , TOKEN_ID ] => PLACE_TOKEN_ID ", Mixfix ("_  _", [], max_pri)),
 ("place", "PLACE  => PLACE_TOKEN_ID ", Mixfix ("_", [], max_pri)),
 ("tokenorplace1", "[PLACE_TOKEN_ID ] => PLACE_TOKEN_IDList ", Mixfix ("_", [], max_pri)),
 ("tokenorplace2", "[PLACE_TOKEN_ID , PLACE_TOKEN_IDList ] => PLACE_TOKEN_IDList ", Mixfix ("_ _", [], max_pri)),
 ("simple_tid", "TOKEN  => TOKEN_ID ", Mixfix ("_", [], max_pri)),
 ("compound_tid", "[TOKEN , ID_List ] => TOKEN_ID ", Mixfix ("_' '[' _' ']", [], max_pri)),
 ("mixfix_id1", "[TOKEN_ID , PLACE_TOKEN_IDList ] => MIXFIX_ID ", Mixfix ("_ _", [], max_pri)),
 ("mixfix_id2", "[PLACE_TOKEN_IDList ] => MIXFIX_ID ", Mixfix ("_", [], max_pri)),
 ("token_id", "TOKEN_ID  => ID ", Mixfix ("_", [], max_pri)),
 ("mixfix_id", "MIXFIX_ID  => ID ", Mixfix ("_", [], max_pri)),
 ("anno", "[STRING ] => ANNO ", Mixfix ("_", [], max_pri)),
 ("_id", "SIMPLE_ID  => SIMPLE_ID_List ", Mixfix ("_", [], 40)),
 ("_consid", "[SIMPLE_ID , SIMPLE_ID_List ] => SIMPLE_ID_List ", Mixfix ("_,/_", [41, 40], 40)),
 ("_cid", "ID  => ID_List ", Mixfix ("_", [], max_pri)),
 ("_conscid", "[ID , ID_List ] => ID_List ", Mixfix ("_,/_", [], max_pri)),
 ("_tid", "TOKEN_ID  => TOKEN_ID_List ", Mixfix ("_", [], max_pri)),
 ("_constid", "[TOKEN_ID , TOKEN_ID_List ] => TOKEN_ID_List ", Mixfix ("_,/_", [], max_pri)),
 ("group", "ID_List  => ID_Group ", Mixfix ("{ _ }", [], max_pri)),
 ("nnumber", "[NNUMBER ] => Literal ", Mixfix ("_", [], max_pri)),
 ("float", "[FLOAT ] => Literal ", Mixfix ("_", [], max_pri)),
 ("string", "[STRING ] => Literal ", Mixfix ("_", [], max_pri)),
 ("number_anno", "ID  => Anno ", Mixfix ("%number _", [], max_pri)),
 ("floating_anno", "[ID , ID ] => Anno ", Mixfix ("%floating _, _", [], max_pri)),
 ("string_anno", "[ID , ID ] => Anno ", Mixfix ("%string _, _", [], max_pri)),
 ("list_anno", "[SIGNS , SIGNS , ID , ID ] => Anno ", Mixfix ("%list _ '_'_ _, _, _", [], max_pri)),
 ("prec_anno1", "[ID_Group , ID_Group ] => Anno ", Mixfix ("%prec _ < _", [], max_pri)),
 ("prec_anno2", "[ID_Group , ID_Group ] => Anno ", Mixfix ("%prec _ <> _", [], max_pri)),
 ("cons", "ExtAnno ", Mixfix ("%cons", [], max_pri)),
 ("def", "ExtAnno ", Mixfix ("%def", [], max_pri)),
 ("implies", "ExtAnno ", Mixfix ("%implies", [], max_pri)),
 ("label_anno", "ID_List  => Label ", Mixfix ("%[' _' ]", [], max_pri)),
 ("no_label", "Label ", Mixfix ("%[]", [], max_pri)),
 ("lib_name1", "LIB_ID  => LIB_NAME ", Mixfix ("_", [], max_pri)),
 ("lib_name2", "[LIB_ID , VERSION ] => LIB_NAME ", Mixfix ("_ version _", [], max_pri)),
 ("path1", "WORDS1  => PATH1 ", Mixfix ("_", [], max_pri)),
 ("path2", "[WORDS1 , PATH1 ] => PATH1 ", Mixfix ("_'/_", [], max_pri)),
 ("lib_id1", "URL  => LIB_ID ", Mixfix ("_", [], max_pri)),
 ("lib_id2", "PATH1  => LIB_ID ", Mixfix ("_", [], max_pri)),
 ("version1", "NUMBER  => VERSION ", Mixfix ("_", [], max_pri)),
 ("version2", "[NUMBER , VERSION ] => VERSION ", Mixfix ("_' .' _", [], max_pri)),
 ("version3", "FLOAT  => VERSION ", Mixfix ("_", [], max_pri)),
 ("libdefn", "[LIB_NAME ] => LibItem ", Mixfix ("library _", [6], max_pri)),
 ("BI", "BasicItems  => BasicSpec ", Mixfix ("_", [], max_pri)),
 ("_comb", "[BasicItems , BasicSpec ] => BasicSpec ", Mixfix ("_//_", [10, 9], 9)),
 ("EmptyBasicItem", "BasicSpec ", Mixfix ("{}", [], max_pri)),
 ("anno", "Anno  => BasicItems ", Mixfix ("_", [], max_pri)),
 ("sigitems", "SigItems  => BasicItems ", Mixfix ("_", [], max_pri)),
 ("freedatatypes1", "DataTypeDecls  => BasicItems ", Mixfix ("free type _", [], 10)),
 ("freedatatypes2", "DataTypeDecls  => BasicItems ", Mixfix ("free type _ ;", [], 10)),
 ("freedatatypes3", "DataTypeDecls  => BasicItems ", Mixfix ("free types _", [], 10)),
 ("freedatatypes4", "DataTypeDecls  => BasicItems ", Mixfix ("free types _ ;", [], 10)),
 ("freedatatypes5", "DataTypeDecls  => BasicItems ", Mixfix ("generated type _", [], 10)),
 ("freedatatypes6", "DataTypeDecls  => BasicItems ", Mixfix ("generated type _ ;", [], 10)),
 ("freedatatypes7", "DataTypeDecls  => BasicItems ", Mixfix ("generated types _", [], 10)),
 ("freedatatypes8", "DataTypeDecls  => BasicItems ", Mixfix ("generated types _ ;", [], 10)),
 ("sortgenitems1", "SigItemsList  => BasicItems ", Mixfix ("generated { _ }", [], 10)),
 ("sortgenitems2", "SigItemsList  => BasicItems ", Mixfix ("generated { _ } ;", [], 10)),
 ("varitems1", "VarDeclList  => BasicItems ", Mixfix ("var _", [], 10)),
 ("varitems2", "VarDeclList  => BasicItems ", Mixfix ("var _ ;", [], 10)),
 ("varitems3", "VarDeclList  => BasicItems ", Mixfix ("vars _ ", [], 10)),
 ("varitems4", "VarDeclList  => BasicItems ", Mixfix ("vars _ ;", [], 10)),
 ("varitems5", "[VarDeclList , L_FormulaList ] => BasicItems ", Mixfix ("var _ . _", [], 10)),
 ("varitems6", "[VarDeclList , L_FormulaList ] => BasicItems ", Mixfix ("vars _ . _", [], 10)),
 ("varitems7", "[VarDeclList , L_FormulaList ] => BasicItems ", Mixfix ("var _ . _;", [], 10)),
 ("varitems8", "[VarDeclList , L_FormulaList ] => BasicItems ", Mixfix ("vars _ . _;", [], 10)),
 ("aitems1", "AxiomList  => BasicItems ", Mixfix ("axiom _", [], 10)),
 ("aitems2", "AxiomList  => BasicItems ", Mixfix ("axioms _", [], 10)),
 ("aitems3", "AxiomList  => BasicItems ", Mixfix ("axiom _ ;", [], 10)),
 ("aitems4", "AxiomList  => BasicItems ", Mixfix ("axioms _ ;", [], 10)),
 ("SigItem1", "SortItemList  => SigItems ", Mixfix ("sort _", [], 10)),
 ("SigItem2", "SortItemList  => SigItems ", Mixfix ("sorts _", [], 10)),
 ("SigItem3", "SortItemList  => SigItems ", Mixfix ("sort _ ;", [], 10)),
 ("SigItem4", "SortItemList  => SigItems ", Mixfix ("sorts _ ;", [], 10)),
 ("SigItem5", "OpItemList  => SigItems ", Mixfix ("op _", [], 10)),
 ("SigItem6", "OpItemList  => SigItems ", Mixfix ("ops _", [], 10)),
 ("SigItem7", "OpItemList  => SigItems ", Mixfix ("op _ ;", [], 10)),
 ("SigItem8", "OpItemList  => SigItems ", Mixfix ("ops _ ;", [], 10)),
 ("SigItem9", "PredItemList  => SigItems ", Mixfix ("pred _", [], 10)),
 ("SigItem10", "PredItemList  => SigItems ", Mixfix ("preds _", [], 10)),
 ("SigItem11", "PredItemList  => SigItems ", Mixfix ("pred _ ;", [], 10)),
 ("SigItem12", "PredItemList  => SigItems ", Mixfix ("preds _ ;", [], 10)),
 ("types3", "DataTypeDecls  => SigItems ", Mixfix ("type _ ;", [], 10)),
 ("types4", "DataTypeDecls  => SigItems ", Mixfix ("types _ ;", [], 10)),
 ("types1", "DataTypeDecls  => SigItems ", Mixfix ("type _", [], 10)),
 ("types2", "DataTypeDecls  => SigItems ", Mixfix ("types _", [], 10)),
 ("SD", "SigItems  => SigItemsList ", Mixfix ("_", [], max_pri)),
 ("_combGenitem", "[SigItems , SigItemsList ] => SigItemsList ", Mixfix ("__", [], max_pri)),
 ("sortdecl", "TOKEN_ID_List  => SortItem ", Mixfix ("_", [30], 15)),
 ("subsort", "[TOKEN_ID_List , TOKEN_ID ] => SortItem ", Mixfix ("_ < _ ", [28, 28], 15)),
 ("subsortdefn", "[TOKEN_ID , SIMPLE_ID , TOKEN_ID , Formula ] => SortItem ", Mixfix ("_ = { _ : _ . _ }", [50, 50, 50, 0], 15)),
 ("isodecl1", "[TOKEN_ID , TOKEN_ID ] => IsoDecl ", Mixfix ("_ = _ ", [], 15)),
 ("isodecl2", "[IsoDecl , TOKEN_ID ] => IsoDecl ", Mixfix ("_ = _ ", [], 15)),
 ("isodeclsortitem", "[IsoDecl ] => SortItem ", Mixfix ("_", [], 15)),
 ("_idS", "SortItem  => SortItemList ", Mixfix ("_", [], 14)),
 ("_combSitem", "[SortItem , SortItemList ] => SortItemList ", Mixfix ("_ ;/_", [15, 14], 14)),
 ("opitem1", "[ID_List , OpType ] => OpItem1 ", Mixfix ("_ : _ ", [30, 20], 15)),
 ("opitem2", "[ID_List , OpType , OpAttrList ] => OpItem1 ", Mixfix ("_ : _  , _", [30, 20, 30], 15)),
 ("opitem3", "[ID , OpHead , TTerm ] => OpItem1 ", Mixfix ("_ _ = _ ", [30, 20, 0], 15)),
 ("opitem4", "[Label , ID , OpHead , TTerm ] => OpItem1 ", Mixfix ("_ _ _ = _ ", [0, 30, 20, 0], 15)),
 ("opitem", "OpItem1  => OpItem ", Mixfix ("_", [], max_pri)),
 ("opitemlanno", "OpItem1  => OpItem ", Mixfix ("_ %left assoc", [], max_pri)),
 ("opitemranno", "OpItem1  => OpItem ", Mixfix ("_ %right assoc", [], max_pri)),
 ("optype1", "[SomeSorts , TOKEN_ID ] => OpType ", Mixfix ("_ -> _", [20, 30], 20)),
 ("optype2", "[SomeSorts , TOKEN_ID ] => OpType ", Mixfix ("_ ->? _", [20, 30], 20)),
 ("optype3", "TOKEN_ID  => OpType ", Mixfix ("_", [30], 20)),
 ("optype4", "TOKEN_ID  => OpType ", Mixfix ("? _", [30], 20)),
 ("P", "TOKEN_ID  => SomeSorts ", Mixfix ("_", [], max_pri)),
 ("product", "[TOKEN_ID , SomeSorts ] => SomeSorts ", Mixfix ("_ * _", [21, 20], 20)),
 ("oppattr1", "OpAttr  => OpAttrList ", Mixfix ("_", [], max_pri)),
 ("oppattr2", "[OpAttr , OpAttrList ] => OpAttrList ", Mixfix ("_ , _", [], max_pri)),
 ("opattr1", "OpAttr ", Mixfix ("assoc", [], max_pri)),
 ("opattr2", "OpAttr ", Mixfix ("comm", [], max_pri)),
 ("opattr3", "OpAttr ", Mixfix ("idem", [], max_pri)),
 ("opattr4", "TTerm  => OpAttr ", Mixfix ("unit _", [], max_pri)),
 ("ophead1", "[ArgDeclList , TOKEN_ID ] => OpHead ", Mixfix ("'( _ ') : _ ", [], max_pri)),
 ("ophead2", "[TOKEN_ID ] => OpHead ", Mixfix (": _", [], max_pri)),
 ("ophead3", "[ArgDeclList , TOKEN_ID ] => OpHead ", Mixfix ("'( _ ') :? _", [], max_pri)),
 ("ophead4", "[TOKEN_ID ] => OpHead ", Mixfix (":? _", [], max_pri)),
 ("_idOp", "OpItem  => OpItemList ", Mixfix ("_", [], 14)),
 ("_combitem", "[OpItem , OpItemList ] => OpItemList ", Mixfix ("_;/_", [15, 14], 14)),
 ("preditem1", "[ID_List , PredType ] => PredItem ", Mixfix ("_ : _", [30, 20], 15)),
 ("preditem2", "[ID , PredHead , Formula ] => PredItem ", Mixfix ("_ _ <=> _", [30, 20, 30], 15)),
 ("preditem3", "[ID , Formula ] => PredItem ", Mixfix ("_ <=> _", [30, 30], 15)),
 ("preditem4", "[Label , ID , PredHead , Formula ] => PredItem ", Mixfix ("_ _ _ <=> _", [0, 30, 20, 30], 15)),
 ("preditem5", "[Label , ID , Formula ] => PredItem ", Mixfix ("_ _ <=> _", [0, 30, 30], 15)),
 ("_idPred", "PredItem  => PredItemList ", Mixfix ("_", [], 14)),
 ("_combpred", "[PredItem , PredItemList ] => PredItemList ", Mixfix ("_ ;/ _", [15, 14], 14)),
 ("predtype1", "SomeSorts  => PredType ", Mixfix ("_", [], 20)),
 ("predtype2", "PredType ", Mixfix ("'(' ')", [], 20)),
 ("predhead", "ArgDeclList  => PredHead ", Mixfix ("'(_')", [], 20)),
 ("dataTypedecl1", "DataTypeDecl  => DataTypeDecls ", Mixfix ("_", [], 15)),
 ("dataTypedecl2", "[DataTypeDecl , DataTypeDecls ] => DataTypeDecls ", Mixfix ("_ ; _", [], 15)),
 ("dataTypedecl3", "[DataTypeHead , AlternativeList ] => DataTypeDecl ", Mixfix ("_ _", [], 15)),
 ("dataTypehead1", "[TOKEN_ID ] => DataTypeHead ", Mixfix ("_ ::= ", [], 15)),
 ("dataTypehead2", "[Label , TOKEN_ID ] => DataTypeHead ", Mixfix ("_ _ ::=", [], 15)),
 ("alternative1", "Alternative  => AlternativeList ", Mixfix ("_ ", [], 15)),
 ("alternative2", "[Alternative , AlternativeList ] => AlternativeList ", Mixfix ("_ | _ ", [], 15)),
 ("alternative3", "[ID , ComponentList ] => Alternative ", Mixfix ("_ '( _') ", [], 15)),
 ("alternative4", "[ID , ComponentList ] => Alternative ", Mixfix ("_ '( _')? ", [], 15)),
 ("alternative5", "[ID ] => Alternative ", Mixfix ("_ ", [], 15)),
 ("alternative6", "[TOKEN_ID_List ] => Alternative ", Mixfix ("sort _  ", [], 15)),
 ("alternative7", "[TOKEN_ID_List ] => Alternative ", Mixfix ("sorts _  ", [], 15)),
 ("alternative8", "[Label , ID , ComponentList ] => Alternative ", Mixfix ("_ _ '( _') ", [], 15)),
 ("alternative9", "[Label , ID , ComponentList ] => Alternative ", Mixfix ("_ _ '( _')? ", [], 15)),
 ("alternative10", "[Label , ID ] => Alternative ", Mixfix ("_ _ ", [], 15)),
 ("alternative11", "[Label , TOKEN_ID_List ] => Alternative ", Mixfix ("_ sort _  ", [], 15)),
 ("alternative12", "[Label , TOKEN_ID_List ] => Alternative ", Mixfix ("_ sorts _  ", [], 15)),
 ("component1", "Component  => ComponentList ", Mixfix ("_ ", [], 15)),
 ("component2", "[Component , ComponentList ] => ComponentList ", Mixfix ("_ ; _ ", [], 15)),
 ("component3", "[Label , ID_List , TOKEN_ID ] => Component ", Mixfix ("_ _ : _ ", [], 15)),
 ("component4", "[Label , ID_List , TOKEN_ID ] => Component ", Mixfix ("_ _ :? _ ", [], 15)),
 ("component5", "[Label , TOKEN_ID ] => Component ", Mixfix ("_ _ ", [], 15)),
 ("component6", "[ID_List , TOKEN_ID ] => Component ", Mixfix ("_ : _ ", [], 15)),
 ("component7", "[ID_List , TOKEN_ID ] => Component ", Mixfix ("_ :? _ ", [], 15)),
 ("component8", "[TOKEN_ID ] => Component ", Mixfix ("_ ", [], 15)),
 ("_idVar1", "[SIMPLE_ID_List , TOKEN_ID ] => VarDecl ", Mixfix ("_ : _", [0, 41], 21)),
 ("idVar2", "VarDecl  => VarDeclList ", Mixfix ("_", [], max_pri)),
 ("_consV", "[VarDecl , VarDeclList ] => VarDeclList ", Mixfix ("_;/_", [21, 20], 20)),
 ("_idArg1", "[Label , SIMPLE_ID_List , TOKEN_ID ] => ArgDecl ", Mixfix ("_ _ : _", [0, 40, 41], 21)),
 ("_idArg1a", "[SIMPLE_ID_List , TOKEN_ID ] => ArgDecl ", Mixfix ("_ : _", [40, 41], 21)),
 ("idArg2", "ArgDecl  => ArgDeclList ", Mixfix ("_", [], max_pri)),
 ("_consArg", "[ArgDecl , ArgDeclList ] => ArgDeclList ", Mixfix ("_;/_", [21, 20], 20)),
 ("F", "L_Formula  => L_FormulaList ", Mixfix ("_", [], max_pri)),
 ("_combform", "[L_Formula , L_FormulaList ] => L_FormulaList ", Mixfix ("_ . _", [33, 32], 32)),
 ("F1", "L_Formula  => AxiomList ", Mixfix ("_", [], max_pri)),
 ("_combform1", "[L_Formula , AxiomList ] => AxiomList ", Mixfix ("_ ; _", [33, 32], 32)),
 ("labeled_formula1", "[Label , Formula ] => L_Formula ", Mixfix ("_ _", [], max_pri)),
 ("labeled_formula2", "[Formula ] => L_Formula ", Mixfix ("_", [], max_pri)),
 ("formula", "Atom  => Formula ", Mixfix ("_", [], 40)),
 ("Q", "Quantification  => Formula ", Mixfix ("_", [], 33)),
 ("parFormula", "Formula  => Formula ", Mixfix ("'( _ ')", [], 40)),
 ("FORMULAAnd", "[Formula , Formula ] => AndFormula ", Mixfix ("_ '/\\ _", [37, 37], max_pri)),
 ("FORMULAAnd1", "[Formula , AndFormula ] => AndFormula ", Mixfix ("_ '/\\ _", [37, 0], max_pri)),
 ("FORMULAAnd2", "[Formula , Quantification ] => Formula ", Mixfix ("_ '/\\ _", [36, 0], 33)),
 ("FAnd", "AndFormula  => Formula ", Mixfix ("_", [], 36)),
 ("FORMULAOr", "[Formula , Formula ] => OrFormula ", Mixfix ("_ \\'/ _", [37, 37], max_pri)),
 ("FORMULAOr1", "[Formula , OrFormula ] => OrFormula ", Mixfix ("_ \\'/ _", [37, 0], max_pri)),
 ("FORMULAOr2", "[Formula , Quantification ] => Formula ", Mixfix ("_ \\'/ _", [36, 0], 33)),
 ("FOr", "OrFormula  => Formula ", Mixfix ("_", [], 36)),
 ("FORMULAImp", "[Formula , Formula ] => ImpFormula ", Mixfix ("_ => _", [35, 35], max_pri)),
 ("FORMULAImp1", "[Formula , ImpFormula ] => ImpFormula ", Mixfix ("_ => _", [35, 0], max_pri)),
 ("FORMULAImp2", "[Formula , Quantification ] => Formula ", Mixfix ("_ => _", [35, 0], 33)),
 ("FImp", "ImpFormula  => Formula ", Mixfix ("_", [], 34)),
 ("FORMULAIf", "[Formula , Formula ] => IfFormula ", Mixfix ("_ if _", [35, 35], max_pri)),
 ("FORMULAIf1", "[IfFormula , Formula ] => IfFormula ", Mixfix ("_ if _", [0, 35], max_pri)),
 ("FORMULAIf2", "[Formula , Quantification ] => Formula ", Mixfix ("_ if _", [35, 0], 33)),
 ("FIf", "IfFormula  => Formula ", Mixfix ("_", [], 34)),
 ("FORMULAEquiv", "[Formula , Formula ] => Formula ", Mixfix ("_ <=>_", [35, 35], 34)),
 ("FORMULAEquiv2", "[Formula , Quantification ] => Formula ", Mixfix ("_ <=> _", [35, 0], 33)),
 ("FORMULANot", "Formula  => Formula ", Mixfix ("not _ ", [40], 40)),
 ("FORMULANot2", "Quantification  => Formula ", Mixfix ("not _ ", [], 33)),
 ("quantall", "[VarDeclList , Formula ] => Quantification ", Mixfix ("forall _ . _ ", [20, 32], 33)),
 ("quantex", "[VarDeclList , Formula ] => Quantification ", Mixfix ("exists _ . _ ", [20, 32], 33)),
 ("quantex1", "[VarDeclList , Formula ] => Quantification ", Mixfix ("exists! _ . _ ", [20, 32], 33)),
 ("TRUE", "Atom ", Mixfix ("true", [], max_pri)),
 ("FALSE", "Atom ", Mixfix ("false", [], max_pri)),
 ("membership", "Membership  => Atom ", Mixfix ("_", [], 30)),
 ("TERM7", "[TTerm , TOKEN_ID ] => Membership ", Mixfix ("_ in _", [], max_pri)),
 ("ATOM", "TTerm  => Atom ", Mixfix ("def _", [], 40)),
 ("ATOM4", "[TTerm , TTerm ] => Atom ", Mixfix ("_ = _ ", [0, 0], 34)),
 ("ATOM6", "[TTerm , TTerm ] => Atom ", Mixfix ("_ =e= _", [0, 0], 35)),
 ("opsymb1", "ID  => OpSymb ", Mixfix ("_", [], max_pri)),
 ("opsymb2", "[ID , OpType ] => OpSymb ", Mixfix ("'( op _ : _ ')", [], max_pri)),
 ("predsymb1", "[ID ] => PredSymb ", Mixfix ("_ ", [], max_pri)),
 ("predsymb2", "[ID , PredType ] => PredSymb ", Mixfix ("'( pred _:_ ')", [], max_pri)),
 ("viewname", "SIMPLE_ID  => VIEW_NAME ", Mixfix ("_", [], max_pri)),
 ("spec1", "BasicSpec  => Spec ", Mixfix ("_", [], max_pri)),
 ("spec2", "[Spec , Renaming ] => Spec ", Mixfix ("_ _", [16, 0], 16)),
 ("spec3", "[Spec , Restriction ] => Spec ", Mixfix ("_ _", [16, 0], 16)),
 ("spec4", "[Spec , AndSpecList ] => Spec ", Mixfix ("_ _", [13, 0], 12)),
 ("spec5", "[Spec , ThenSpecList ] => Spec ", Mixfix ("_ _", [11, 0], 10)),
 ("spec6", "GroupSpec  => Spec ", Mixfix ("free _", [], max_pri)),
 ("spec7", "[Spec , Spec ] => Spec ", Mixfix ("local _ within _", [0, 14], 14)),
 ("spec8", "Spec  => Spec ", Mixfix ("closed _", [15], 15)),
 ("spec9", "GroupSpec  => Spec ", Mixfix ("_", [], max_pri)),
 ("andspecList1", "Spec  => AndSpecList ", Mixfix ("and _", [13], max_pri)),
 ("andspecList2", "[Spec , AndSpecList ] => AndSpecList ", Mixfix ("and _ _", [13, 0], max_pri)),
 ("then", "Then ", Mixfix ("then", [], max_pri)),
 ("thenanno", "ExtAnno  => Then ", Mixfix ("then _", [], max_pri)),
 ("thenspecList1", "[Then , Spec ] => ThenSpecList ", Mixfix ("//_ _", [0, 11], max_pri)),
 ("thenspecList2", "[Then , Spec , ThenSpecList ] => ThenSpecList ", Mixfix ("//_ _ _", [0, 11, 0], max_pri)),
 ("specList1", "Spec  => SpecList ", Mixfix (" _", [11], max_pri)),
 ("specList2", "[Spec , SpecList ] => SpecList ", Mixfix (" _ , _", [11, 0], max_pri)),
 ("groupspec1", "Spec  => GroupSpec ", Mixfix ("{ _ }", [], max_pri)),
 ("groupspec2", "SIMPLE_ID  => GroupSpec ", Mixfix ("_", [], max_pri)),
 ("groupspec3", "[SIMPLE_ID , FitArgList ] => GroupSpec ", Mixfix ("_ _", [], max_pri)),
 ("fitArglist1", "[FitArg ] => FitArgList ", Mixfix ("'[ _ ']", [], max_pri)),
 ("fitArglist2", "[FitArg , FitArgList ] => FitArgList ", Mixfix ("'[ _ '] _", [], max_pri)),
 ("renaming", "SymbMapItemsList  => Renaming ", Mixfix ("with _", [], max_pri)),
 ("restriction1", "SymbItemsList  => Restriction ", Mixfix ("hide _", [], max_pri)),
 ("restriction2", "SymbMapItemsList  => Restriction ", Mixfix ("reveal _", [], max_pri)),
 ("equals", "Equals ", Mixfix ("=", [], max_pri)),
 ("equalsanno", "ExtAnno  => Equals ", Mixfix ("= _", [], max_pri)),
 ("SPEC1", "[SIMPLE_ID , Spec ] => LibItem ", Mixfix ("spec _ = // _  end ", [], 8)),
 ("SPEC2", "[SIMPLE_ID , Spec ] => LibItem ", Mixfix ("spec _ = // _  ", [], 8)),
 ("SPEC3", "[SIMPLE_ID , SomeGenerics , Equals , Spec ] => LibItem ", Mixfix ("spec _ _ _ // _  end ", [], 8)),
 ("SPEC4", "[SIMPLE_ID , SomeGenerics , Equals , Spec ] => LibItem ", Mixfix ("spec _ _ _ // _  ", [], 8)),
 ("somegenerics1", "[SomeParams ] => SomeGenerics ", Mixfix ("_ ", [], max_pri)),
 ("somegenerics2", "[SomeParams , SomeImports ] => SomeGenerics ", Mixfix ("_ _", [], max_pri)),
 ("someparams", "Spec  => SomeParams ", Mixfix ("'[ _ ']", [], max_pri)),
 ("someparams2", "[Spec , SomeParams ] => SomeParams ", Mixfix ("'[ _ '] _", [], max_pri)),
 ("someimports", "SpecList  => SomeImports ", Mixfix ("given _", [], max_pri)),
 ("fitarg1", "[Spec , SymbMapItemsList ] => FitArg ", Mixfix ("_ fit _", [], max_pri)),
 ("fitarg2", "[Spec ] => FitArg ", Mixfix ("_", [], max_pri)),
 ("fitarg3", "[VIEW_NAME ] => FitArg ", Mixfix ("view _", [], max_pri)),
 ("fitarg4", "[VIEW_NAME , FitArgList ] => FitArgList ", Mixfix ("view _ _", [], max_pri)),
 ("viewdefn1", "[VIEW_NAME , VIEW_TYPE ] => LibItem ", Mixfix ("view _ : _", [], max_pri)),
 ("viewdefn2", "[VIEW_NAME , VIEW_TYPE ] => LibItem ", Mixfix ("view _ : _ end", [], max_pri)),
 ("viewdefn3", "[VIEW_NAME , VIEW_TYPE , SymbMapItemsList ] => LibItem ", Mixfix ("view _ : _ = _ end", [], max_pri)),
 ("viewdefn4", "[VIEW_NAME , VIEW_TYPE , SymbMapItemsList ] => LibItem ", Mixfix ("view _ : _ = _", [], max_pri)),
 ("viewdefn5", "[VIEW_NAME , SomeGenerics , VIEW_TYPE ] => LibItem ", Mixfix ("view _ _ : _ end", [], max_pri)),
 ("viewdefn6", "[VIEW_NAME , SomeGenerics , VIEW_TYPE ] => LibItem ", Mixfix ("view _ _ : _", [], max_pri)),
 ("viewdefn7", "[VIEW_NAME , SomeGenerics , VIEW_TYPE , SymbMapItemsList ] => LibItem ", Mixfix ("view _ _ : _ = _ end", [], max_pri)),
 ("viewdefn8", "[VIEW_NAME , SomeGenerics , VIEW_TYPE , SymbMapItemsList ] => LibItem ", Mixfix ("view _ _ : _ = _", [], max_pri)),
 ("viewtype", "[GroupSpec , GroupSpec ] => VIEW_TYPE ", Mixfix ("_ to _", [], max_pri)),
 ("symbitemslist1", "[SymbItems ] => SymbItemsList1 ", Mixfix ("_", [], max_pri)),
 ("symbitemslist2", "[SymbItems , SymbItemsList1 ] => SymbItemsList1 ", Mixfix ("_,_", [], max_pri)),
 ("symbitemslist11", "[SymbItemsList1 ] => SymbItemsList ", Mixfix ("_", [], max_pri)),
 ("symbitemslist12", "[SymbList , SymbItemsList1 ] => SymbItemsList ", Mixfix ("_,_", [], max_pri)),
 ("symbitemslist13", "[SymbList ] => SymbItemsList ", Mixfix ("_", [], max_pri)),
 ("symbitems2", "[SymbList ] => SymbItems ", Mixfix ("sort _", [], max_pri)),
 ("symbitems3", "[SymbList ] => SymbItems ", Mixfix ("sorts _", [], max_pri)),
 ("symbitems4", "[SymbList ] => SymbItems ", Mixfix ("op  _", [], max_pri)),
 ("symbitems5", "[SymbList ] => SymbItems ", Mixfix ("ops _", [], max_pri)),
 ("symbitems6", "[SymbList ] => SymbItems ", Mixfix ("pred _", [], max_pri)),
 ("symbitems7", "[SymbList ] => SymbItems ", Mixfix ("preds _", [], max_pri)),
 ("symbmapitems2", "[SymbOrMapList ] => SymbMapItems ", Mixfix ("sort _", [], max_pri)),
 ("symbmapitems3", "[SymbOrMapList ] => SymbMapItems ", Mixfix ("sorts _", [], max_pri)),
 ("symbmapitems4", "[SymbOrMapList ] => SymbMapItems ", Mixfix ("op _", [], max_pri)),
 ("symbmapitems5", "[SymbOrMapList ] => SymbMapItems ", Mixfix ("ops _", [], max_pri)),
 ("symbmapitems6", "[SymbOrMapList ] => SymbMapItems ", Mixfix ("pred  _", [], max_pri)),
 ("symbmapitems7", "[SymbOrMapList ] => SymbMapItems ", Mixfix ("preds  _", [], max_pri)),
 ("symbmapitemslist1", "[SymbMapItems ] => SymbMapItemsList1 ", Mixfix ("_", [], max_pri)),
 ("symbmapitemslist2", "[SymbMapItems , SymbMapItemsList1 ] => SymbMapItemsList1 ", Mixfix ("_ , _", [], max_pri)),
 ("symbmapitemslist11", "[SymbMapItemsList1 ] => SymbMapItemsList ", Mixfix ("_", [], max_pri)),
 ("symbmapitemslist12", "[SymbOrMapList , SymbMapItemsList1 ] => SymbMapItemsList ", Mixfix ("_ , _", [], max_pri)),
 ("symbmapitemslist13", "[SymbOrMapList ] => SymbMapItemsList ", Mixfix ("_", [], max_pri)),
 ("symblist1", "[Symb ] => SymbList ", Mixfix ("_", [], max_pri)),
 ("symblist2", "[Symb , SymbList ] => SymbList ", Mixfix ("_ , _", [], max_pri)),
 ("symbormaplist1", "[SymbOrMap ] => SymbOrMapList ", Mixfix ("_", [], max_pri)),
 ("symbormaplist2", "[SymbOrMap , SymbOrMapList ] => SymbOrMapList ", Mixfix ("_ , _", [], max_pri)),
 ("symb1", "[ID ] => Symb ", Mixfix ("_", [], max_pri)),
 ("symb2", "[ID , OpType ] => Symb ", Mixfix ("_ : _", [], max_pri)),
 ("symb3", "[ID , PredType ] => Symb ", Mixfix ("_ : _", [], max_pri)),
 ("symbmap", "[Symb , Symb ] => SymbMap ", Mixfix ("_ |-> _", [], max_pri)),
 ("symbormap1", "[Symb ] => SymbOrMap ", Mixfix ("_", [], max_pri)),
 ("symbormap2", "[SymbMap ] => SymbOrMap ", Mixfix ("_", [], max_pri)),
 ("archSpecDefn1", "[SIMPLE_ID , ArchSpec ] => LibItem ", Mixfix ("arch spec _ = _ ", [], max_pri)),
 ("archSpecDefn2", "[SIMPLE_ID , ArchSpec ] => LibItem ", Mixfix ("arch spec _ = _ end ", [], max_pri)),
 ("archSpec1", "[BasicArchSpec ] => ArchSpec ", Mixfix (" _ ", [], max_pri)),
 ("archSpec2", "[GroupArchSpec ] => ArchSpec ", Mixfix (" _ ", [], max_pri)),
 ("groupArchSpec1", "[ArchSpec ] => GroupArchSpec ", Mixfix ("{ _ }", [], max_pri)),
 ("groupArchSpec2", "[SIMPLE_ID ] => GroupArchSpec ", Mixfix (" _ ", [], max_pri)),
 ("basicArchSpec1", "[UnitDeclDefnList , UnitExpression ] => BasicArchSpec ", Mixfix ("unit _  result _ ;", [], max_pri)),
 ("basicArchSpec2", "[UnitDeclDefnList , UnitExpression ] => BasicArchSpec ", Mixfix ("unit _  result _ ", [], max_pri)),
 ("basicArchSpec3", "[UnitDeclDefnList , UnitExpression ] => BasicArchSpec ", Mixfix ("unit _ ; result _ ;", [], max_pri)),
 ("basicArchSpec4", "[UnitDeclDefnList , UnitExpression ] => BasicArchSpec ", Mixfix ("unit _ ; result _ ", [], max_pri)),
 ("basicArchSpec5", "[UnitDeclDefnList , UnitExpression ] => BasicArchSpec ", Mixfix ("units _  result _ ;", [], max_pri)),
 ("basicArchSpec6", "[UnitDeclDefnList , UnitExpression ] => BasicArchSpec ", Mixfix ("units _  result _ ", [], max_pri)),
 ("basicArchSpec7", "[UnitDeclDefnList , UnitExpression ] => BasicArchSpec ", Mixfix ("units _ ; result _ ;", [], max_pri)),
 ("basicArchSpec8", "[UnitDeclDefnList , UnitExpression ] => BasicArchSpec ", Mixfix ("units _ ; result _ ", [], max_pri)),
 ("unitDeclList1", "UnitDeclDefn  => UnitDeclDefnList ", Mixfix (" _ ", [], max_pri)),
 ("unitDeclList2", "[UnitDeclDefn , UnitDeclDefnList ] => UnitDeclDefnList ", Mixfix (" _ ; _ ", [], max_pri)),
 ("unitDeclDefn1", "[UnitDecl ] => UnitDeclDefn ", Mixfix ("_", [], max_pri)),
 ("unitDeclDefn2", "[UnitDefn ] => UnitDeclDefn ", Mixfix (" _ ", [], max_pri)),
 ("unitDecl1", "[SIMPLE_ID , UnitSpec ] => UnitDecl ", Mixfix ("_ : _", [], max_pri)),
 ("unitDecl2", "[SIMPLE_ID , UnitSpec , GroupUnitTermList ] => UnitDecl ", Mixfix ("_ : _ given _", [], max_pri)),
 ("groupUnitTermList1", "GroupUnitTerm  => GroupUnitTermList ", Mixfix (" _ ", [], max_pri)),
 ("groupUnitTermList2", "[GroupUnitTerm , GroupUnitTermList ] => GroupUnitTermList ", Mixfix ("_ , _ ", [], max_pri)),
 ("unitDefn", "[SIMPLE_ID , UnitExpression ] => UnitDefn ", Mixfix (" _ = _", [], max_pri)),
 ("unitSpecDefn1", "[SIMPLE_ID , UnitSpec ] => LibItem ", Mixfix ("unit spec _ = _", [], max_pri)),
 ("unitSpecDefn2", "[SIMPLE_ID , UnitSpec ] => LibItem ", Mixfix ("unit spec _ = _ end", [], max_pri)),
 ("unitSpec1", "[GroupSpec ] => UnitSpec ", Mixfix (" _ ", [], max_pri)),
 ("unitSpec2", "[GroupSpecList , GroupSpec ] => UnitSpec ", Mixfix ("_ -> _", [], max_pri)),
 ("unitSpec3", "[GroupArchSpec ] => UnitSpec ", Mixfix ("arch spec  _", [], max_pri)),
 ("unitSpec4", "[UnitSpec ] => UnitSpec ", Mixfix ("closed _", [], max_pri)),
 ("groupSpecList1", "GroupSpec  => GroupSpecList ", Mixfix (" _ ", [], max_pri)),
 ("groupSpecList2", "[GroupSpec , GroupSpecList ] => GroupSpecList ", Mixfix ("_ * _ ", [], max_pri)),
 ("unitExpression1", "[UnitTerm ] => UnitExpression ", Mixfix ("_", [], max_pri)),
 ("unitExpression2", "[UnitBindingList , UnitTerm ] => UnitExpression ", Mixfix ("lambda _ . _ ", [], max_pri)),
 ("unitBindingList1", "UnitBinding  => UnitBindingList ", Mixfix (" _ ", [], max_pri)),
 ("unitBindingList2", "[UnitBinding , UnitBindingList ] => UnitBindingList ", Mixfix (" _ ; _ ", [], max_pri)),
 ("unitBinding", "[SIMPLE_ID , UnitSpec ] => UnitBinding ", Mixfix (" _ : _ ", [], max_pri)),
 ("unitTerm1", "[UnitTerm , Renaming ] => UnitTerm ", Mixfix (" _ _ ", [], max_pri)),
 ("unitTerm2", "[UnitTerm , Restriction ] => UnitTerm ", Mixfix (" _ _ ", [], max_pri)),
 ("unitTerm3", "[AndUnitTerm ] => UnitTerm ", Mixfix (" _ ", [], max_pri)),
 ("unitTerm4", "[UnitDefnList , UnitTerm ] => UnitTerm ", Mixfix ("local _ ; within _ ", [], max_pri)),
 ("unitTerm5", "[UnitDefnList , UnitTerm ] => UnitTerm ", Mixfix ("local _  within _ ", [], max_pri)),
 ("unitTerm6", "[GroupUnitTerm ] => UnitTerm ", Mixfix (" _ ", [], max_pri)),
 ("andUnitTerm1", "[UnitTerm , UnitTerm ] => AndUnitTerm ", Mixfix (" _ and _ ", [], max_pri)),
 ("andUnitTerm2", "[UnitTerm , AndUnitTerm ] => AndUnitTerm ", Mixfix (" _ and _ ", [], max_pri)),
 ("unitDefnList1", "[UnitDefn ] => UnitDefnList ", Mixfix (" _ ", [], max_pri)),
 ("unitDefnList2", "[UnitDefn , UnitDefnList ] => UnitDefnList ", Mixfix (" _ ; _ ", [], max_pri)),
 ("groupUnitTerm1", "[UnitTerm ] => GroupUnitTerm ", Mixfix ("{ _ }", [], max_pri)),
 ("groupUnitTerm2", "[SIMPLE_ID ] => GroupUnitTerm ", Mixfix (" _ ", [], max_pri)),
 ("groupUnitTerm3", "[SIMPLE_ID , FitArgUnitList ] => GroupUnitTerm ", Mixfix (" _ _ ", [], max_pri)),
 ("fitArgUnitList1", "[FitArgUnit ] => FitArgUnitList ", Mixfix ("'[ _ '] ", [], max_pri)),
 ("fitArgUnitList2", "[FitArgUnit , FitArgUnitList ] => FitArgUnitList ", Mixfix (" '[ _ '] _ ", [], max_pri)),
 ("fitArgUnit1", "UnitTerm  => FitArgUnit ", Mixfix ("_", [], max_pri)),
 ("fitArgUnit2", "[UnitTerm , SymbMapItemsList ] => FitArgUnit ", Mixfix ("_ fit _", [], max_pri)),
 ("download1", "[LIB_NAME , ITEM_NAME_OR_MAP_LIST ] => LibItem ", Mixfix ("from _ get _", [], max_pri)),
 ("download2", "[LIB_NAME , ITEM_NAME_OR_MAP_LIST ] => LibItem ", Mixfix ("from _ get _ end", [], max_pri)),
 ("iomlist1", "[ITEM_NAME_OR_MAP ] => ITEM_NAME_OR_MAP_LIST ", Mixfix ("_", [], max_pri)),
 ("iomlist2", "[ITEM_NAME_OR_MAP , ITEM_NAME_OR_MAP_LIST ] => ITEM_NAME_OR_MAP_LIST ", Mixfix ("_,_", [], max_pri)),
 ("iom1", "SIMPLE_ID  => ITEM_NAME_OR_MAP ", Mixfix ("_", [], max_pri)),
 ("iom2", "[SIMPLE_ID , SIMPLE_ID ] => ITEM_NAME_OR_MAP ", Mixfix ("_ |-> _", [], max_pri))]

|> Library.curry Sign.add_modesyntax
("latex", false)
[("LatexLabel", "[SIMPLE_ID , Formula ] => Formula ", Mixfix ("(\\%[_]~/ _)", [], 40)),
 ("LatexAtom", "Atom  => Formula ", Mixfix ("_", [], 40)),
 ("parFormula", "Formula  => Formula ", Mixfix ("'( _ ')", [], 40)),
 ("LatexConj", "[Formula , Formula ] => Formula ", Mixfix ("( _ (3)~\\land~/ _ )", [37, 37], max_pri)),
 ("LatexDisj", "[Formula , Formula ] => Formula ", Mixfix ("( _ (3)~\\lor~/ _ )", [37, 37], max_pri)),
 ("LatexImpl", "[Formula , Formula ] => Formula ", Mixfix ("( _ (3)~\\imp~/ _ )", [35, 35], max_pri)),
 ("LatexIf", "[Formula , Formula ] => Formula ", Mixfix ("( _ (3)~\\IF~/ _ )", [35, 35], max_pri)),
 ("LatexEqui", "[Formula , Formula ] => Formula ", Mixfix ("( _ (3)~\\iff~/ _ )", [35, 35], 34)),
 ("LatexNega", "Formula  => Formula ", Mixfix ("( (2)\\neg~ _ )", [40], 40)),
 ("LatexForall", "[SIMPLE_ID , Formula ] => Formula ", Mixfix ("( (2)\\forall~ _ (3)~\\.~/ _ )", [20, 32], 33)),
 ("LatexExists", "[SIMPLE_ID , Formula ] => Formula ", Mixfix ("( (2)\\exists~ _ (3)~\\.~/ _ )", [20, 32], 33)),
 ("LatexExistU", "[SIMPLE_ID , Formula ] => Formula ", Mixfix ("( (2)\\exists!~ _ (3)~\\.~/ _ )", [20, 32], 33)),
 ("LatexTrue", "Atom ", Mixfix ("( (4)\\TRUE )", [], max_pri)),
 ("LatexFalse", "Atom ", Mixfix ("( (5)\\FALSE )", [], max_pri)),
 ("LatexUnpF", "[SIMPLE_ID ] => Formula ", Mixfix ("_", [], 40)),
 ("LatexUnpT", "[SIMPLE_ID ] => TTerm ", Mixfix ("_", [], 40)),
 ("LatexMemb", "[TTerm , SIMPLE_ID ] => Atom ", Mixfix ("( _ /(3)~\\in~ _ )", [], 30)),
 ("LatexDefi", "TTerm  => Atom ", Mixfix ("( (2)\\DEF~ _ )", [], 40)),
 ("LatexEqua", "[TTerm , TTerm ] => Atom ", Mixfix ("( _ (3)~=~/ _ )", [0, 0], 34)),
 ("LatexEEqu", "[TTerm , TTerm ] => Atom ", Mixfix ("( _ (3)~\\eeq~/ _ )", [0, 0], 35)),
 ("LatexPlace", "TTerm ", Mixfix ("( \\'_\\'_ )", [], max_pri))]

|> Sign.add_name "CASL98Pure";


end;
end;


