(***************************************************************** *)
(*								   *)
(* Project: CATS						   *)
(* Author: Till Mossakowski, University of Bremen		   *)
(* Date: 19.05.00						   *)
(* Purpose of this file: Global variables	 		   *)
(*								   *)
(*								   *)
(***************************************************************** *)

structure Global =
struct

local open Library in

val test = ref(false);

val quiet_mode  = ref false;

val yacc_parser  = ref true;

val casldir = pwd();

val cur_file = ref "";

val Lexer_line_lengths = ref [0];
end

fun InternalError err = 
    print("An internal error occured"
            ^(if err="" then "" else ": "^err)^".\n"
            ^"Please send the specification and the cats command line you used to cofi@tzi.de\n")
end
