CASL_context FreeNat.casl;
AddsimpAll();

(* In order to prove not x<0 with predicate induction, 
   we need to transform this into the form "x<y => ..." *)
Goal "forall x,y:Nat . x<y => not(y=0)";
(* Predicate induction is just resolution with ga_pred_induction_xxx *)
br ga_pred_induction_Lt_ 1;
by Auto_tac;
qed "not_x_lt_0a";

(* Then, we can prove the original goal by forward reasoning
   using dres_inst_tac *)
Goal "forall x:Nat . not x<0";
by (rewrite_goals_tac [not_def]);
br impI 1;
by (dres_inst_tac [("y1","0")] (not_x_lt_0a RS mp) 1);
by Auto_tac;
qed "not_x_lt_0";
Addsimps [not_x_lt_0];

(* Again, we transform our goal into the form "x<y => ..." *)
Goal "forall x,y:Nat . x<y => ((x=0 /\\ 0<y) \\/exists x1,y1:Nat . (x=suc(x1)) /\\ y=suc(y1) /\\ x1<y1)";
br ga_pred_induction_Lt_ 1;
by Auto_tac;
qed "less_aux";

(* ... and use forward reasoning to prove the original goal *)
Goal "forall m,n:Nat . suc(n) < suc(m) => n < m";
br impI 1;
by (dres_inst_tac [("x1","suc(n)"),("y1","suc(m)")] (less_aux RS mp) 1);
by Auto_tac;
qed "suc_less";

Goal "forall x,y:Nat . x<y => x<suc(y)";
br ga_pred_induction_Lt_ 1;
by Auto_tac;
qed "lt_suc_right";
Addsimps [lt_suc_right];
