(* *********************************************************************** *)
(*									   *)
(* Project: HOL-CASL	                                                   *)
(* Author: Kolyang and Till Mossakowski, University of Bremen	           *)
(* Date: 19.08.99				 			   *)
(* Purpose of this file: ROOT for HOL-CASL IsaWin system                   *)
(* *********************************************************************** *)

(* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! *)
(* Attention !
   To set up IsaWin properly, you have to set the SMLTK_LIB
   and the WISH environment variables. The WISH variable
   must be set to the result of

      which wish

   and the SMLTK_LIB variable must be set as follows:
      
   setenv SMLTK_LIB $CASL/sml_tk/lib                     (C shell)
   export SMLTK_LIB=$CASL/sml_tk/lib                     (bash)

   where $CASL is a directory that must contain the following
   repositories:
   
   CATS
   atermlib
   sml_tk
   git

*)   
(* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! *)


(*******************************************************************)
(*** Load HOL-CASL                                               ***)
(*******************************************************************)

use"ROOT.ML";

(*******************************************************************)
(*** Instantiate IsaWin with HOL-CASL                            ***)
(*******************************************************************)
 
val isawindir = HOL_CASL_dir^"/../../git/src/isa_win"; (* the isawin directory *)
cd isawindir; (* stepping in the isawin directory *)
use "root_casl.sml";
cd HOL_CASL_dir; (*stepping out*)


(* Use
   
   use"mk_isawin.sml";
   
   for creating a standalone heap image *)
   
