(* ----------------------------------------------------------------------- *)
(* posget.sml                             Pascal Schmidt <pharao90@tzi.de> *)
(* ----------------------------------------------------------------------- *)
(* extract region or element from pos_X AS construct                       *)
(* ----------------------------------------------------------------------- *)

(* $Id: posget.sml,v 1.1 2004/02/13 11:29:20 7till Exp $ *)

structure latex_posget
=
struct

  local open latex_regions AS in

    val rtt = region_to_tuple
    
    fun rre () = raise RegionExpected

    fun pos_anno (pos_ANNO (r,_)) = rtt r
      | pos_anno _                = rre()
      
    fun pos_lib_id (pos_LIB_ID (r,_)) = rtt r
      | pos_lib_id _                  = rre()

    fun pos_version (pos_VERSION (r,_)) = rtt r
      | pos_version _                   = rre()
      
    fun pos_lib_name (pos_LIB_NAME (r,_)) = rtt r
      | pos_lib_name _                    = rre()

    fun pos_sorts (pos_SORTS (r,_)) = rtt r
      | pos_sorts _                 = rre()

    fun pos_arg_decl (pos_ARG_DECL (r,_)) = rtt r
      | pos_arg_decl _                    = rre()

    fun pos_op_type (pos_OP_TYPE (r,_)) = rtt r
      | pos_op_type _                   = rre()

    fun pos_op_head (pos_OP_HEAD (r,_)) = rtt r
      | pos_op_head _                   = rre()
    
    fun pos_op_symb (pos_OP_SYMB (r,_)) = rtt r
      | pos_op_symb _                   = rre()

    fun pos_pred_type (pos_PRED_TYPE (r,_)) = rtt r
      | pos_pred_type _                     = rre()
      
    fun pos_pred_head (pos_PRED_HEAD (r,_)) = rtt r
      | pos_pred_head _                     = rre()
      
    fun pos_pred_symb (pos_PRED_SYMB (r,_)) = rtt r
      | pos_pred_symb _                     = rre()

    fun pos_term (pos_TERM (r,_,_)) = rtt r
      | pos_term _                  = rre()

    fun pos_terms (pos_TERMS (r,_)) = rtt r
      | pos_terms _                 = rre()

    fun pos_quantifier (pos_QUANTIFIER (r,_)) = rtt r
      | pos_quantifier _                      = rre()

    fun pos_formula (pos_FORMULA (r,_,_)) = rtt r
      | pos_formula _                     = rre()

    fun pos_components (pos_COMPONENTS (r,_)) = rtt r
      | pos_components _                      = rre()

    fun pos_alternative (pos_ALTERNATIVE (r,_)) = rtt r
      | pos_alternative _                       = rre()

    fun pos_datatype_decl (pos_DATATYPE_DECL (r,_)) = rtt r
      | pos_datatype_decl _                         = rre()

    fun pos_op_attr (pos_OP_ATTR (r,_)) = rtt r
      | pos_op_attr _                   = rre()

    fun pos_op_item (pos_OP_ITEM (r,_)) = rtt r
      | pos_op_item _                   = rre()

    fun pos_pred_item (pos_PRED_ITEM (r,_)) = rtt r
      | pos_pred_item _                     = rre()

    fun pos_sort_item (pos_SORT_ITEM (r,_)) = rtt r
      | pos_sort_item _                     = rre()
      
    fun pos_sig_items (pos_SIG_ITEMS (r,_)) = rtt r
      | pos_sig_items _                     = rre()
      
    fun pos_basic_items (pos_BASIC_ITEMS (r,_)) = rtt r
      | pos_basic_items _                       = rre()

    fun pos_basic_spec (pos_BASIC_SPEC (r,_)) = rtt r
      | pos_basic_spec _                      = rre()

    fun pos_type (pos_TYPE (r,_)) = rtt r
      | pos_type _                = rre()

    fun pos_symb (pos_SYMB (r,_)) = rtt r
      | pos_symb _                = rre()

    fun pos_symb_map (pos_SYMB_MAP (r,_)) = rtt r
      | pos_symb_map _                    = rre()
      
    fun pos_symb_or_map (pos_SYMB_OR_MAP (r,_)) = rtt r
      | pos_symb_or_map _                       = rre()
      
    fun pos_symb_kind (pos_SYMB_KIND (r,_)) = rtt r
      | pos_symb_kind _                     = rre()

    fun pos_symb_map_items (pos_SYMB_MAP_ITEMS (r,_)) = rtt r
      | pos_symb_map_items _                          = rre()

    fun pos_fit_arg (pos_FIT_ARG (r,_)) = rtt r
      | pos_fit_arg _                   = rre()

    fun pos_symb_items (pos_SYMB_ITEMS (r,_)) = rtt r
      | pos_symb_items _                      = rre()

    fun pos_renaming (pos_RENAMING (r,_)) = rtt r
      | pos_renaming _                    = rre()

    fun pos_restriction (pos_RESTRICTION (r,_)) = rtt r
      | pos_restriction _                       = rre()

    fun pos_genericity (pos_GENERICITY (r,_)) = rtt r
      | pos_genericity _                      = rre()

    fun pos_params (pos_PARAMS (r,_)) = rtt r
      | pos_params _                  = rre()

    fun pos_imports (pos_IMPORTS (r,_)) = rtt r
      | pos_imports _                   = rre()

    fun pos_spec (pos_SPEC (r,_,_)) = rtt r
      | pos_spec _                = rre()

    fun pos_view_type (pos_VIEW_TYPE (r,_)) = rtt r
      | pos_view_type _                     = rre()

    fun pos_arch_spec (pos_ARCH_SPEC (r,_)) = rtt r
      | pos_arch_spec _                     = rre()

    fun pos_unit_decl_defn (pos_UNIT_DECL_DEFN (r,_)) = rtt r
      | pos_unit_decl_defn _                          = rre()

    fun pos_unit_decl (pos_UNIT_DECL (r,_)) = rtt r
      | pos_unit_decl _                     = rre()

    fun pos_unit_imports (pos_UNIT_IMPORTS (r,_)) = rtt r
      | pos_unit_imports _                        = rre()

    fun pos_unit_defn (pos_UNIT_DEFN (r,_)) = rtt r
      | pos_unit_defn _                     = rre()

    fun pos_unit_spec (pos_UNIT_SPEC (r,_)) = rtt r
      | pos_unit_spec _                     = rre()

    fun pos_unit_type (pos_UNIT_TYPE (r,_)) = rtt r
      | pos_unit_type _                     = rre()

    fun pos_result_unit (pos_RESULT_UNIT (r,_)) = rtt r
      | pos_result_unit _                       = rre()

    fun pos_unit_expression (pos_UNIT_EXPRESSION (r,_)) = rtt r
      | pos_unit_expression _                           = rre()

    fun pos_unit_binding (pos_UNIT_BINDING (r,_)) = rtt r
      | pos_unit_binding _                        = rre()

    fun pos_unit_term (pos_UNIT_TERM (r,_,_)) = rtt r
      | pos_unit_term _                     = rre()

    fun pos_fit_arg_unit (pos_FIT_ARG_UNIT (r,_)) = rtt r
      | pos_fit_arg_unit _                        = rre()

    fun pos_item_name_or_map (pos_ITEM_NAME_OR_MAP (r,_)) = rtt r
      | pos_item_name_or_map _                            = rre()

    fun pos_lib_item (pos_LIB_ITEM (r,_)) = rtt r
      | pos_lib_item _                    = rre()

    fun pos_lib_defn (pos_LIB_DEFN (r,_)) = rtt r
      | pos_lib_defn _                    = rre()

    fun get_anno (pos_ANNO (_,r)) = r
      | get_anno _                = rre()
      
    fun get_lib_id (pos_LIB_ID (_,r)) = r
      | get_lib_id _                  = rre()

    fun get_version (pos_VERSION (_,r)) = r
      | get_version _                   = rre()
      
    fun get_lib_name (pos_LIB_NAME (_,r)) = r
      | get_lib_name _                    = rre()

    fun get_sorts (pos_SORTS (_,r)) = r
      | get_sorts _                 = rre()

    fun get_arg_decl (pos_ARG_DECL (_,r)) = r
      | get_arg_decl _                    = rre()

    fun get_op_type (pos_OP_TYPE (_,r)) = r
      | get_op_type _                   = rre()

    fun get_op_head (pos_OP_HEAD (_,r)) = r
      | get_op_head _                   = rre()
    
    fun get_op_symb (pos_OP_SYMB (_,r)) = r
      | get_op_symb _                   = rre()

    fun get_pred_type (pos_PRED_TYPE (_,r)) = r
      | get_pred_type _                     = rre()
      
    fun get_pred_head (pos_PRED_HEAD (_,r)) = r
      | get_pred_head _                     = rre()
      
    fun get_pred_symb (pos_PRED_SYMB (_,r)) = r
      | get_pred_symb _                     = rre()

    fun get_term (pos_TERM (_,_,r)) = r
      | get_term _                  = rre()

    fun get_terms (pos_TERMS (_,r)) = r
      | get_terms _                 = rre()

    fun get_quantifier (pos_QUANTIFIER (_,r)) = r
      | get_quantifier _                      = rre()

    fun get_formula (pos_FORMULA (_,_,r)) = r
      | get_formula _                     = rre()

    fun get_components (pos_COMPONENTS (_,r)) = r
      | get_components _                      = rre()

    fun get_alternative (pos_ALTERNATIVE (_,r)) = r
      | get_alternative _                       = rre()

    fun get_datatype_decl (pos_DATATYPE_DECL (_,r)) = r
      | get_datatype_decl _                         = rre()

    fun get_op_attr (pos_OP_ATTR (_,r)) = r
      | get_op_attr _                   = rre()

    fun get_op_item (pos_OP_ITEM (_,r)) = r
      | get_op_item _                   = rre()

    fun get_pred_item (pos_PRED_ITEM (_,r)) = r
      | get_pred_item _                     = rre()

    fun get_sort_item (pos_SORT_ITEM (_,r)) = r
      | get_sort_item _                     = rre()
      
    fun get_sig_items (pos_SIG_ITEMS (_,r)) = r
      | get_sig_items _                     = rre()
      
    fun get_basic_items (pos_BASIC_ITEMS (_,r)) = r
      | get_basic_items _                       = rre()

    fun get_basic_spec (pos_BASIC_SPEC (_,r)) = r
      | get_basic_spec _                      = rre()

    fun get_type (pos_TYPE (_,r)) = r
      | get_type _                = rre()

    fun get_symb (pos_SYMB (_,r)) = r
      | get_symb _                = rre()

    fun get_symb_map (pos_SYMB_MAP (_,r)) = r
      | get_symb_map _                    = rre()
      
    fun get_symb_or_map (pos_SYMB_OR_MAP (_,r)) = r
      | get_symb_or_map _                       = rre()
      
    fun get_symb_kind (pos_SYMB_KIND (_,r)) = r
      | get_symb_kind _                     = rre()

    fun get_symb_map_items (pos_SYMB_MAP_ITEMS (_,r)) = r
      | get_symb_map_items _                          = rre()

    fun get_fit_arg (pos_FIT_ARG (_,r)) = r
      | get_fit_arg _                   = rre()

    fun get_symb_items (pos_SYMB_ITEMS (_,r)) = r
      | get_symb_items _                      = rre()

    fun get_renaming (pos_RENAMING (_,r)) = r
      | get_renaming _                    = rre()

    fun get_restriction (pos_RESTRICTION (_,r)) = r
      | get_restriction _                       = rre()

    fun get_genericity (pos_GENERICITY (_,r)) = r
      | get_genericity _                      = rre()

    fun get_params (pos_PARAMS (_,r)) = r
      | get_params _                  = rre()

    fun get_imports (pos_IMPORTS (_,r)) = r
      | get_imports _                   = rre()

    fun get_spec (pos_SPEC (_,_,r)) = r
      | get_spec _                = rre()

    fun get_view_type (pos_VIEW_TYPE (_,r)) = r
      | get_view_type _                     = rre()

    fun get_arch_spec (pos_ARCH_SPEC (_,r)) = r
      | get_arch_spec _                     = rre()

    fun get_unit_decl_defn (pos_UNIT_DECL_DEFN (_,r)) = r
      | get_unit_decl_defn _                          = rre()

    fun get_unit_decl (pos_UNIT_DECL (_,r)) = r
      | get_unit_decl _                     = rre()

    fun get_unit_imports (pos_UNIT_IMPORTS (_,r)) = r
      | get_unit_imports _                        = rre()

    fun get_unit_defn (pos_UNIT_DEFN (_,r)) = r
      | get_unit_defn _                     = rre()

    fun get_unit_spec (pos_UNIT_SPEC (_,r)) = r
      | get_unit_spec _                     = rre()

    fun get_unit_type (pos_UNIT_TYPE (_,r)) = r
      | get_unit_type _                     = rre()

    fun get_result_unit (pos_RESULT_UNIT (_,r)) = r
      | get_result_unit _                       = rre()

    fun get_unit_expression (pos_UNIT_EXPRESSION (_,r)) = r
      | get_unit_expression _                           = rre()

    fun get_unit_binding (pos_UNIT_BINDING (_,r)) = r
      | get_unit_binding _                        = rre()

    fun get_unit_term (pos_UNIT_TERM (_,_,r)) = r
      | get_unit_term _                     = rre()

    fun get_fit_arg_unit (pos_FIT_ARG_UNIT (_,r)) = r
      | get_fit_arg_unit _                        = rre()

    fun get_item_name_or_map (pos_ITEM_NAME_OR_MAP (_,r)) = r
      | get_item_name_or_map _                            = rre()

    fun get_lib_item (pos_LIB_ITEM (_,r)) = r
      | get_lib_item _                    = rre()

    fun get_lib_defn (pos_LIB_DEFN (_,r)) = r
      | get_lib_defn _                    = rre()

  end (* open local in *)

end
