(* *********************************************************************** *)
(*									   *)
(* Project: CASL: 							   *)
(* Author:  Bartek Klin                                          	   *)
(* Date: 14.11.1999				 			   *)
(* Purpose of this file: Finite sets - trivial implementation              *)
(*			 						   *)	
(*									   *)
(* *********************************************************************** *)


structure Finset = struct

local open Utils in
infix mem;

type 'a set = 'a list;

val empty = [];
val size = length;

val set_from_list = remove_dups;

fun add (el,[]) = [el]
  | add (el1,el2::t) = if (el1=el2) then el2::t else (el2::add(el1,t))
;

(* Sum *)
fun sum ([],s) = s
  | sum (h::t,s) = sum(t,add(h,s))
;

(* fold: 'a set * ('b -> 'a -> 'b) * 'b -> 'b *)
fun fold (s,f,pocz) = foldl (fn(a,b) => f a b) (pocz,s);

(* forall: 'a set * ('a -> bool) -> bool *)
fun forall1 (s,f) = fold (s, (fn b => fn a => b andalso (f a)), true);

(* member:   'a * 'a set -> bool *)
val is_member = (op mem);

(* Intersection *)
(* 'a set * 'a set -> 'a set *)
fun intersect ([],s) = []
  | intersect (h::t,s) = if (is_member(h,s)) then h::(intersect(t,s))
                else (intersect(t,s))
;

(* Subset relation *)
(* 'a set * 'a set -> bool *)
fun is_subset ([],s) = true
  | is_subset (h::t,s) = (is_member(h,s)) andalso (is_subset(t,s))
;

(* Extensional equality *)
(* 'a set * 'a set -> bool *)
fun is_equal (s1,s2) = (is_subset(s1,s2)) andalso (is_subset(s2,s1));

(* map *)
(* ('a -> 'b) -> 'a set -> 'b set *)
val map = map;

(* Removing element *)
(* 'a * 'a set -> 'a set *)
fun remove (_,[]) = []
  | remove (a1,a2::t) = if (a1=a2) then t else a2::(remove(a1,t))
;

(* Removing a subset *)
(* 'a set * 'a set -> 'a set *)
fun remove_set ([],s) = s
  | remove_set (h::t,s) = remove_set(t,remove(h,s))
;

(* Singleton *)
(* 'a -> 'a set *)
fun singleton a = [a];

(* A (first) value *)
(* 'a set -> 'a *)
val pick_elem = hd;

(* Subset satisfying a predicate *)
(* 'a set * ('a -> bool) -> 'a set *)
fun satisfying ([],_) = []
  | satisfying (h::t,p) = if p h then h::(satisfying(t,p)) else satisfying(t,p)
;

end;
end;
