(* xml_tree.sml, read XML document into tree structure as given by *)
(*  fxp developers                                                 *)

(* $Id: xml_tree.sml,v 1.1 2004/02/13 11:29:21 7till Exp $ *)

  structure TreeData =
    struct
      exception IllFormed
      
      type Tag = int * HookData.AttSpecList
      datatype Tree = TEXT of UniChar.Vector
                    | ELEM of Tag * Content
      withtype Content = Tree list
    end
  
  structure TreeHooks =
    struct
      open IgnoreHooks TreeData UniChar
      
      type AppData = Content * (Tag * Content) list
      type AppFinal = Tree
      
      val appStart = (nil,nil)
      
      fun hookStartTag ((content,stack),(_,elems,atts,_,empty)) =
        if empty then (ELEM ((elems,atts),nil)::content,stack)
        else (nil,((elems,atts),content)::stack)
        
      fun hookEndTag ((_,nil),_) = raise IllFormed
        | hookEndTag ((content,(tag,content')::stack),_) =
          (ELEM (tag,rev content)::content',stack)
      
      fun hookData ((content,stack),(_,vec,_)) =
        (TEXT vec::content,stack)
      
      fun hookCData ((content,stack),(_,vec)) =
        (TEXT vec::content,stack)
        
      fun hookCharRef ((content,stack),(_,c,_)) =
        (TEXT (Data2Vector [c])::content,stack)
        
      fun hookFinish ([elem],nil) = elem
        | hookFinish _ = raise IllFormed
    end
  
  structure ParseTree :
    sig
      val parseTree : Uri.Uri option -> Dtd.Dtd option -> TreeData.Tree
    end
  = struct
      structure Parser = Parse ( structure Dtd     = Dtd
                                 structure Hooks   = TreeHooks
                                 structure ParserOptions = ParserOptions()
                                 structure Resolve = ResolveNull)

      fun parseTree uri dtd = Parser.parseDocument uri dtd TreeHooks.appStart
  end
