{- |
Module      :  $Header: /repository/caslbook/lncs2960-CD/Tools/Hets/src/Common/LaTeX_maps.hs,v 1.1 2004/02/13 14:50:41 5maeder Exp $
Copyright   :  (c) Klaus Lttich, Uni Bremen 2002-2004
Licence     :  similar to LGPL, see HetCATS/LICENCE.txt or LIZENZ.txt

Maintainer  :  hets@tzi.de
Stability   :  provisional
Portability :  portable

-}
    
{-
    Created by a Perl-script (HetCATS/utils/words.pl)!
    DO NOT MODIFY BY HAND!!

-}

module Common.LaTeX_maps where

import Common.Lib.Map(fromList,Map)


keyword_map :: Map String Int
keyword_map = fromList [("(",1569),(")",1569),("A",3051),("B",2871),("C",2915),("D",3095),("E",2664),("F",2539),("G",3173),("H",3158),("I",1558),("J",2274),("K",3163),("L",2534),("M",3831),("N",3158),("O",3032),("P",2759),("Q",3032),("R",3027),("S",2341),("T",2807),("U",3105),("V",3107),("W",4229),("X",3051),("Y",3152),("Z",2466),("\\%",3510),("\\_",1453),("a",2144),("and",6890),("arch",8322),("as",3899),("assoc",9898),("axiom",11112),("axioms",12916),("b",2274),("c",2035),("closed",11512),("comm",11231),("d",2341),("def",5721),("e",2035),("else",7090),("end",6760),("exists",10670),("f",1616),("false",8515),("fit",4211),("forall",9947),("free",7216),("from",8711),("g",2144),("generated",18395),("get",5686),("given",10006),("h",2404),("hide",8058),("i",1298),("idem",9055),("if",2737),("in",3703),("j",1235),("k",2341),("l",1235),("lambda",13520),("library",12741),("local",8711),("m",3510),("n",2404),("not",6177),("o",2176),("op",4485),("ops",6247),("p",2341),("pred",8518),("preds",10273),("q",2274),("r",1821),("result",10726),("reveal",11375),("s",1825),("sort",7230),("sorts",9055),("spec",8143),("t",1614),("then",8423),("to",3790),("true",7735),("type",8072),("types",9898),("u",2404),("unit",7602),("units",9406),("v",2186),("var",6110),("vars",7865),("version",13583),("view",8578),("w",3120),("when",9943),("with",8318),("within",12021),("x",2144),("y",2186),("z",1965),("~",1345)]

key_keyword_map :: Map Char [String] 
key_keyword_map = fromList [('a',["and","arch","assoc","axiom","axioms"]),('c',["closed","comm"]),('d',["def"]),('e',["else","end","exists"]),('f',["false","fit","forall","free","from"]),('g',["generated","get","given"]),('h',["hide"]),('i',["idem"]),('l',["lambda","library","local"]),('n',["not"]),('o',["ops"]),('p',["pred","preds"]),('r',["result","reveal"]),('s',["sort","sorts","spec"]),('t',["then","true","type","types"]),('u',["unit","units"]),('v',["var","vars","version","view"]),('w',["when","with","within"])]

structid_map :: Map String Int
structid_map = fromList [(".",1298),("/",2302),("0",2351),("1",2351),("2",2351),("3",2351),("4",2351),("5",2351),("6",2351),("7",2351),("8",2351),("9",2351),("A",2906),("B",2772),("C",2772),("D",2983),("E",2709),("F",2516),("G",2988),("H",3099),("I",1604),("J",2281),("K",2959),("L",2516),("M",3495),("N",3092),("O",2983),("P",2603),("Po",4875),("Q",3053),("R",2807),("S",2492),("T",2759),("U",3036),("V",2907),("W",3931),("Wo",6065),("X",2856),("Y",2948),("Z",2516),("\\_",1396),("a",2358),("b",2253),("c",2253),("d",2421),("e",2200),("f",2046),("ff",3917),("fi",3187),("fl",3917),("g",2421),("h",2513),("i",1316),("j",1860),("k",2358),("l",2046),("ll",4092),("m",2829),("n",2506),("o",2421),("ow",5363),("p",2046),("pi",3362),("q",2478),("r",2200),("s",2028),("t",2074),("u",2463),("v",2200),("w",2983),("x",2200),("y",2222),("z",2046),("~",1325),("",2906),("",2983),("",3036),("",3882),("",2358),("",2421),("",2463)]

key_structid_map :: Map Char [String] 
key_structid_map = fromList []

annotationbf_map :: Map String Int
annotationbf_map = fromList [("!",1137),("(",1453),(")",1453),(",",1074),(";",1074),("?",2084),("A",2820),("B",2656),("C",2699),("D",2864),("E",2453),("F",2349),("G",2937),("H",2920),("I",1409),("J",2047),("K",2924),("L",2280),("M",3543),("Mo",5412),("N",2920),("O",2807),("P",2552),("Po",4317),("Q",2807),("R",2801),("S",2107),("T",2600),("U",2870),("V",2872),("Va",4326),("Ve",4224),("Vi",3859),("Vo",4378),("Vu",4585),("W",3910),("Wa",5364),("We",5262),("Wi",4897),("Wo",5416),("Wu",5624),("X",2820),("Y",2914),("Ya",4326),("Ye",4224),("Yo",4378),("Yu",4585),("Z",2284),("\\%",3159),("\\_",1345),("\\{",1869),("\\}",1869),("a",1930),("b",2076),("c",1832),("d",2107),("e",1832),("f",1499),("ff",2538),("fi",2337),("fl",2337),("g",1930),("h",2163),("i",1168),("it",2590),("j",1142),("k",2107),("l",1111),("ll",2223),("m",3159),("n",2163),("o",1958),("p",2107),("pi",3275),("q",2047),("r",1639),("s",1642),("t",1453),("u",2163),("v",2024),("w",2808),("x",1972),("y",2024),("z",1769),("",2820),("",2807),("",2870),("",2091),("",1930),("",1958),("",2163)]

key_annotationbf_map :: Map Char [String] 
key_annotationbf_map = fromList []

normal_map :: Map String Int
normal_map = fromList [("!",1186),("\"'",1755),("\"`",1614),("'",1168),("''",1755),("(",1463),(")",1463),(",",1123),(".",1123),("/",2127),("0",2176),("1",2176),("2",2176),("3",2176),("4",2176),("5",2176),("6",2176),("7",2176),("8",2176),("9",2176),(":",1123),(";",1123),("?",1895),("A",2730),("B",2597),("C",2597),("D",2808),("E",2534),("F",2341),("G",2808),("H",2923),("I",1428),("J",2106),("K",2730),("L",2341),("M",3320),("N",2916),("O",2808),("P",2388),("Po",4141),("Q",2878),("R",2583),("S",2316),("T",2535),("U",2860),("V",2632),("Va",4250),("Ve",4029),("Vi",3607),("Vo",4173),("Vu",4710),("W",3607),("Wa",5173),("We",4987),("Wi",4582),("Wo",5103),("Wu",5623),("X",2632),("Y",2632),("Ya",4095),("Ye",3899),("Yo",4095),("Yu",4499),("Z",2341),("[",1477),("\\$",2176),("\\^{}",1755),("\\_",1263),("\\textbackslash{}",1755),("\\textbar",975),("\\{",1755),("\\}",1755),("\\~{}",1755),("]",1477),("`",1168),("``",1755),("a",2035),("b",2176),("c",1825),("d",2176),("e",1825),("f",1168),("ff",2348),("fi",2176),("fl",2176),("g",1951),("h",2316),("i",1105),("it",2470),("j",1072),("k",2176),("l",1105),("ll",2211),("m",3299),("n",2316),("o",2025),("p",2176),("q",2074),("r",1558),("s",1825),("t",1365),("u",2386),("v",1983),("w",2927),("x",1965),("y",1951),("z",1755),("{\\tt{}\\textquotedblright}",2106),("~",1169),("",2730),("",2808),("",2860),("",2316),("",2035),("",2025),("",2386)]

key_normal_map :: Map Char [String] 
key_normal_map = fromList [('\\',["\\^{}","\\textbackslash{}","\\textbar","\\~{}"]),('{',["{\\tt{}\\textquotedblright}"])]

comment_map :: Map String Int
comment_map = fromList [("!",1067),("\"'",1623),("\"`",1493),("'",1051),("''",1623),("(",1317),(")",1317),("*",1623),(",",1010),("-",1263),(".",1010),("0",1958),("1",1958),("2",1958),("3",1958),("4",1958),("5",1958),("6",1958),("7",1958),("8",1958),("9",1958),(":",1010),(";",1010),("<",1067),("=",2631),(">",1705),("?",1705),("@",2975),("A",2457),("B",2337),("C",2344),("D",2527),("E",2280),("F",2119),("G",2547),("H",2631),("I",1285),("J",1895),("K",2524),("L",2107),("M",2988),("N",2625),("O",2527),("P",2209),("Po",3742),("Q",2590),("R",2389),("S",2084),("T",2344),("U",2574),("V",2434),("Va",3825),("Ve",3626),("Vi",3336),("Vo",3787),("Vu",4239),("W",3336),("Wa",4689),("We",4510),("Wi",4238),("Wo",4689),("Wu",5060),("X",2434),("Y",2434),("Ya",3787),("Ye",3608),("Yo",3787),("Yu",4049),("Z",2107),("[",1329),("\\$",1958),("\\^{}",1623),("\\_",1168),("\\textbackslash{}",1623),("\\{",1623),("\\}",1623),("\\~{}",1623),("]",1329),("`",1051),("``",1623),("a",1832),("b",1958),("c",1642),("d",1958),("e",1642),("f",1051),("ff",2113),("fi",1958),("fl",1958),("g",1756),("h",2084),("i",995),("it",2223),("j",992),("k",1958),("l",995),("ll",1990),("m",2969),("n",2084),("o",1822),("p",1958),("q",1866),("r",1402),("s",1642),("t",1262),("u",2148),("v",1784),("w",2634),("x",1769),("y",1756),("z",1579),("{\\tt{}\\textquotedblright}",1895),("|",3246),("~",1082),("",2457),("",2527),("",2574),("",2084),("",1832),("",1822),("",2148)]

key_comment_map :: Map Char [String] 
key_comment_map = fromList [('\\',["\\^{}","\\textbackslash{}","\\~{}"]),('{',["{\\tt{}\\textquotedblright}"])]

axiom_map :: Map String Int
axiom_map = fromList [("!",1168),("\"'",1951),("\"`",1906),("'",1002),("''",1829),("(",1502),(")",1502),("*",1912),("+",2923),(",",975),("-",2923),(".",975),("/",1912),("0",1839),("1",1839),("2",1839),("3",1839),("4",1839),("5",1839),("6",1839),("7",1839),("8",1839),("9",1839),(":",975),(";",975),("<",2923),("=",2923),(">",2923),("?",1657),("@",3232),("A",2609),("B",2830),("C",3021),("D",2980),("E",2803),("F",2758),("G",3021),("H",3184),("I",1908),("J",2337),("K",3208),("L",2341),("M",3722),("N",3184),("O",3021),("P",2740),("Q",3021),("R",2696),("S",2393),("T",2978),("U",3211),("V",3253),("W",4150),("X",3163),("Y",3289),("Z",2662),("[",1095),("\\#",2925),("\\$",2639),("\\%",3349),("\\&",3031),("\\Leftrightarrow",3741),("\\Rightarrow",3741),("\\^{}",2027),("\\_",1263),("\\bullet",1912),("\\exists",2112),("\\exists!",3172),("\\forall",2112),("\\in",2516),("\\mapsto",3825),("\\neg",2516),("\\rightarrow",3741),("\\rightarrow?",5384),("\\textbackslash{}",1755),("\\times",2923),("\\vee",2516),("\\wedge",2516),("\\{",1912),("\\}",1912),("\\~{}",2200),("]",1095),("`",1168),("``",1839),("a",2407),("b",2179),("c",1832),("d",2439),("e",2018),("f",1955),("g",2134),("h",2418),("i",1434),("j",1584),("k",2306),("l",1284),("m",3341),("n",2360),("o",2015),("p",2179),("q",2112),("r",1857),("s",1919),("t",1540),("u",2407),("v",1992),("w",3134),("x",2197),("y",2137),("z",1969),("|",1095),("~",1169),("",2609),("",2730),("",2860),("",2334),("",2176),("",1895),("",2176)]

key_axiom_map :: Map Char [String] 
key_axiom_map = fromList [('\\',["\\Leftrightarrow","\\Rightarrow","\\^{}","\\bullet","\\exists","\\exists!","\\forall","\\in","\\mapsto","\\neg","\\rightarrow","\\rightarrow?","\\textbackslash{}","\\times","\\vee","\\wedge","\\~{}"])]

annotation_map :: Map String Int
annotation_map = fromList [("!",1382),("\"'",1623),("\"`",1493),("''",1716),("(",1352),(")",1352),("*",1721),("+",2631),(",",994),("-",2631),(".",901),("/",1721),("0",1655),("1",1655),("2",1655),("3",1655),("4",1655),("5",1655),("6",1655),("7",1655),("8",1655),("9",1655),(":",1173),(";",1173),("<",2631),("<>",5262),("=",2631),(">",2631),("?",2040),("@",2975),("A",2410),("B",2604),("C",2777),("D",2743),("E",2573),("F",2532),("G",2777),("H",2914),("I",1748),("J",2132),("K",2949),("L",2107),("M",3412),("Mo",4764),("N",2914),("O",2781),("P",2521),("Po",4056),("Q",2781),("R",2480),("S",2197),("T",2735),("U",2914),("V",2991),("Va",4094),("Ve",3892),("Vi",3717),("Vo",4018),("Vu",4283),("W",3820),("Wa",5146),("We",4969),("Wi",4546),("Wo",5095),("Wu",5229),("X",2908),("Y",3024),("Ya",4068),("Ye",3892),("Yo",4018),("Yu",4154),("Z",2445),("[",985),("\\$",2375),("\\%",3078),("\\^{}",1865),("\\_",1193),("\\textbackslash{}",1623),("\\times",2631),("\\{",1721),("\\}",1721),("\\~{}",2020),("]",985),("``",1655),("a",2167),("b",1961),("c",1666),("d",2195),("e",1816),("f",1759),("ff",2773),("fi",2239),("fl",2250),("g",1920),("h",2176),("i",1307),("it",2388),("j",1453),("k",2075),("l",1156),("ll",2147),("m",3007),("n",2124),("o",1856),("p",1961),("pi",3010),("q",1901),("r",1707),("s",1727),("t",1386),("u",2167),("v",1831),("w",2820),("x",1977),("y",1923),("z",1772),("~",1082),("",2410),("",2486),("",2574),("",2100),("",1958),("",1705),("",1958)]

key_annotation_map :: Map Char [String] 
key_annotation_map = fromList [('\\',["\\^{}","\\textbackslash{}","\\times","\\~{}"])]

ligatures :: Map String Bool
ligatures = fromList [("\"'",True),("\"`",True),("''",True),("<>",True),("Mo",True),("Po",True),("Va",True),("Ve",True),("Vi",True),("Vo",True),("Vu",True),("Wa",True),("We",True),("Wi",True),("Wo",True),("Wu",True),("Ya",True),("Ye",True),("Yo",True),("Yu",True),("\\#",True),("\\$",True),("\\%",True),("\\&",True),("\\_",True),("\\{",True),("\\}",True),("``",True),("as",True),("ff",True),("fi",True),("fl",True),("if",True),("in",True),("it",True),("ll",True),("op",True),("ow",True),("pi",True),("to",True)]


italiccorrection_map :: Map String Int
italiccorrection_map = fromList $ read "[(\"aa\",232),(\"ab\",232),(\"ac\",232),(\"ad\",232),(\"ae\",232),(\"af\",232),(\"ag\",232),(\"ah\",232),(\"ai\",232),(\"aj\",232),(\"ak\",232),(\"al\",232),(\"am\",232),(\"an\",232),(\"ao\",232),(\"ap\",232),(\"aq\",232),(\"ar\",232),(\"as\",232),(\"at\",232),(\"au\",232),(\"av\",232),(\"aw\",232),(\"ax\",232),(\"ay\",232),(\"az\",232),(\"aA\",232),(\"aB\",232),(\"aC\",232),(\"aD\",232),(\"aE\",232),(\"aF\",232),(\"aG\",232),(\"aH\",232),(\"aI\",232),(\"aJ\",232),(\"aK\",232),(\"aL\",232),(\"aM\",232),(\"aN\",232),(\"aO\",232),(\"aP\",232),(\"aQ\",232),(\"aR\",232),(\"aS\",232),(\"aT\",232),(\"aU\",232),(\"aV\",232),(\"aW\",232),(\"aX\",232),(\"aY\",232),(\"aZ\",232),(\"a0\",232),(\"a1\",232),(\"a2\",232),(\"a3\",232),(\"a4\",232),(\"a5\",232),(\"a6\",232),(\"a7\",232),(\"a8\",232),(\"a9\",232),(\"a\",232),(\"a\",232),(\"a\",232),(\"a\",232),(\"a\",232),(\"a\",232),(\"a\",232),(\"ba\",74),(\"bb\",74),(\"bc\",74),(\"bd\",74),(\"be\",74),(\"bf\",74),(\"bg\",74),(\"bh\",74),(\"bi\",74),(\"bj\",74),(\"bk\",74),(\"bl\",74),(\"bm\",74),(\"bn\",74),(\"bo\",74),(\"bp\",74),(\"bq\",74),(\"br\",74),(\"bs\",74),(\"bt\",74),(\"bu\",74),(\"bv\",74),(\"bw\",74),(\"bx\",74),(\"by\",74),(\"bz\",74),(\"bA\",74),(\"bB\",74),(\"bC\",74),(\"bD\",74),(\"bE\",74),(\"bF\",74),(\"bG\",74),(\"bH\",74),(\"bI\",74),(\"bJ\",74),(\"bK\",74),(\"bL\",74),(\"bM\",74),(\"bN\",74),(\"bO\",74),(\"bP\",74),(\"bQ\",74),(\"bR\",74),(\"bS\",74),(\"bT\",74),(\"bU\",74),(\"bV\",74),(\"bW\",74),(\"bX\",74),(\"bY\",74),(\"bZ\",74),(\"b0\",74),(\"b1\",74),(\"b2\",74),(\"b3\",74),(\"b4\",74),(\"b5\",74),(\"b6\",74),(\"b7\",74),(\"b8\",74),(\"b9\",74),(\"b\",74),(\"b\",74),(\"b\",74),(\"b\",74),(\"b\",74),(\"b\",74),(\"b\",74),(\"ca\",147),(\"cb\",147),(\"cc\",147),(\"cd\",147),(\"ce\",147),(\"cf\",147),(\"cg\",147),(\"ch\",147),(\"ci\",147),(\"cj\",147),(\"ck\",147),(\"cl\",147),(\"cm\",147),(\"cn\",147),(\"co\",147),(\"cp\",147),(\"cq\",147),(\"cr\",147),(\"cs\",147),(\"ct\",147),(\"cu\",147),(\"cv\",147),(\"cw\",147),(\"cx\",147),(\"cy\",147),(\"cz\",147),(\"cA\",147),(\"cB\",147),(\"cC\",147),(\"cD\",147),(\"cE\",147),(\"cF\",147),(\"cG\",147),(\"cH\",147),(\"cI\",147),(\"cJ\",147),(\"cK\",147),(\"cL\",147),(\"cM\",147),(\"cN\",147),(\"cO\",147),(\"cP\",147),(\"cQ\",147),(\"cR\",147),(\"cS\",147),(\"cT\",147),(\"cU\",147),(\"cV\",147),(\"cW\",147),(\"cX\",147),(\"cY\",147),(\"cZ\",147),(\"c0\",147),(\"c1\",147),(\"c2\",147),(\"c3\",147),(\"c4\",147),(\"c5\",147),(\"c6\",147),(\"c7\",147),(\"c8\",147),(\"c9\",147),(\"c\",147),(\"c\",147),(\"c\",147),(\"c\",147),(\"c\",147),(\"c\",147),(\"c\",147),(\"da\",193),(\"db\",193),(\"dc\",193),(\"dd\",193),(\"de\",193),(\"df\",193),(\"dg\",193),(\"dh\",193),(\"di\",193),(\"dj\",193),(\"dk\",193),(\"dl\",193),(\"dm\",193),(\"dn\",193),(\"do\",193),(\"dp\",193),(\"dq\",193),(\"dr\",193),(\"ds\",193),(\"dt\",193),(\"du\",193),(\"dv\",193),(\"dw\",193),(\"dx\",193),(\"dy\",193),(\"dz\",193),(\"dA\",193),(\"dB\",193),(\"dC\",193),(\"dD\",193),(\"dE\",193),(\"dF\",193),(\"dG\",193),(\"dH\",193),(\"dI\",193),(\"dJ\",193),(\"dK\",193),(\"dL\",193),(\"dM\",193),(\"dN\",193),(\"dO\",193),(\"dP\",193),(\"dQ\",193),(\"dR\",193),(\"dS\",193),(\"dT\",193),(\"dU\",193),(\"dV\",193),(\"dW\",193),(\"dX\",193),(\"dY\",193),(\"dZ\",193),(\"d0\",193),(\"d1\",193),(\"d2\",193),(\"d3\",193),(\"d4\",193),(\"d5\",193),(\"d6\",193),(\"d7\",193),(\"d8\",193),(\"d9\",193),(\"d\",193),(\"d\",193),(\"d\",193),(\"d\",193),(\"d\",193),(\"d\",193),(\"d\",193),(\"ea\",123),(\"eb\",123),(\"ec\",123),(\"ed\",123),(\"ee\",123),(\"ef\",123),(\"eg\",123),(\"eh\",123),(\"ei\",123),(\"ej\",123),(\"ek\",123),(\"el\",123),(\"em\",123),(\"en\",123),(\"eo\",123),(\"ep\",123),(\"eq\",123),(\"er\",123),(\"es\",123),(\"et\",123),(\"eu\",123),(\"ev\",123),(\"ew\",123),(\"ex\",123),(\"ey\",123),(\"ez\",123),(\"eA\",123),(\"eB\",123),(\"eC\",123),(\"eD\",123),(\"eE\",123),(\"eF\",123),(\"eG\",123),(\"eH\",123),(\"eI\",123),(\"eJ\",123),(\"eK\",123),(\"eL\",123),(\"eM\",123),(\"eN\",123),(\"eO\",123),(\"eP\",123),(\"eQ\",123),(\"eR\",123),(\"eS\",123),(\"eT\",123),(\"eU\",123),(\"eV\",123),(\"eW\",123),(\"eX\",123),(\"eY\",123),(\"eZ\",123),(\"e0\",123),(\"e1\",123),(\"e2\",123),(\"e3\",123),(\"e4\",123),(\"e5\",123),(\"e6\",123),(\"e7\",123),(\"e8\",123),(\"e9\",123),(\"e\",123),(\"e\",123),(\"e\",123),(\"e\",123),(\"e\",123),(\"e\",123),(\"e\",123),(\"fa\",762),(\"fb\",762),(\"fc\",762),(\"fd\",762),(\"fe\",762),(\"ff\",828),(\"fg\",762),(\"fh\",762),(\"fi\",698),(\"fj\",762),(\"fk\",762),(\"fl\",655),(\"fm\",762),(\"fn\",762),(\"fo\",762),(\"fp\",762),(\"fq\",762),(\"fr\",762),(\"fs\",762),(\"ft\",762),(\"fu\",762),(\"fv\",762),(\"fw\",762),(\"fx\",762),(\"fy\",762),(\"fz\",762),(\"fA\",762),(\"fB\",762),(\"fC\",762),(\"fD\",762),(\"fE\",762),(\"fF\",762),(\"fG\",762),(\"fH\",762),(\"fI\",762),(\"fJ\",762),(\"fK\",762),(\"fL\",762),(\"fM\",762),(\"fN\",762),(\"fO\",762),(\"fP\",762),(\"fQ\",762),(\"fR\",762),(\"fS\",762),(\"fT\",762),(\"fU\",762),(\"fV\",762),(\"fW\",762),(\"fX\",762),(\"fY\",762),(\"fZ\",762),(\"f0\",762),(\"f1\",762),(\"f2\",762),(\"f3\",762),(\"f4\",762),(\"f5\",762),(\"f6\",762),(\"f7\",762),(\"f8\",762),(\"f9\",762),(\"f\",762),(\"f\",762),(\"f\",762),(\"f\",762),(\"f\",762),(\"f\",762),(\"f\",762),(\"ga\",74),(\"gb\",74),(\"gc\",74),(\"gd\",74),(\"ge\",74),(\"gf\",74),(\"gg\",74),(\"gh\",74),(\"gi\",74),(\"gj\",74),(\"gk\",74),(\"gl\",74),(\"gm\",74),(\"gn\",74),(\"go\",74),(\"gp\",74),(\"gq\",74),(\"gr\",74),(\"gs\",74),(\"gt\",74),(\"gu\",74),(\"gv\",74),(\"gw\",74),(\"gx\",74),(\"gy\",74),(\"gz\",74),(\"gA\",74),(\"gB\",74),(\"gC\",74),(\"gD\",74),(\"gE\",74),(\"gF\",74),(\"gG\",74),(\"gH\",74),(\"gI\",74),(\"gJ\",74),(\"gK\",74),(\"gL\",74),(\"gM\",74),(\"gN\",74),(\"gO\",74),(\"gP\",74),(\"gQ\",74),(\"gR\",74),(\"gS\",74),(\"gT\",74),(\"gU\",74),(\"gV\",74),(\"gW\",74),(\"gX\",74),(\"gY\",74),(\"gZ\",74),(\"g0\",74),(\"g1\",74),(\"g2\",74),(\"g3\",74),(\"g4\",74),(\"g5\",74),(\"g6\",74),(\"g7\",74),(\"g8\",74),(\"g9\",74),(\"g\",74),(\"g\",74),(\"g\",74),(\"g\",74),(\"g\",74),(\"g\",74),(\"g\",74),(\"ha\",242),(\"hb\",242),(\"hc\",242),(\"hd\",242),(\"he\",242),(\"hf\",242),(\"hg\",242),(\"hh\",242),(\"hi\",242),(\"hj\",242),(\"hk\",242),(\"hl\",242),(\"hm\",242),(\"hn\",242),(\"ho\",242),(\"hp\",242),(\"hq\",242),(\"hr\",242),(\"hs\",242),(\"ht\",242),(\"hu\",242),(\"hv\",242),(\"hw\",242),(\"hx\",242),(\"hy\",242),(\"hz\",242),(\"hA\",242),(\"hB\",242),(\"hC\",242),(\"hD\",242),(\"hE\",242),(\"hF\",242),(\"hG\",242),(\"hH\",242),(\"hI\",242),(\"hJ\",242),(\"hK\",242),(\"hL\",242),(\"hM\",242),(\"hN\",242),(\"hO\",242),(\"hP\",242),(\"hQ\",242),(\"hR\",242),(\"hS\",242),(\"hT\",242),(\"hU\",242),(\"hV\",242),(\"hW\",242),(\"hX\",242),(\"hY\",242),(\"hZ\",242),(\"h0\",242),(\"h1\",242),(\"h2\",242),(\"h3\",242),(\"h4\",242),(\"h5\",242),(\"h6\",242),(\"h7\",242),(\"h8\",242),(\"h9\",242),(\"h\",242),(\"h\",242),(\"h\",242),(\"h\",242),(\"h\",242),(\"h\",242),(\"h\",242),(\"ia\",249),(\"ib\",249),(\"ic\",249),(\"id\",249),(\"ie\",249),(\"if\",249),(\"ig\",249),(\"ih\",249),(\"ii\",249),(\"ij\",249),(\"ik\",249),(\"il\",249),(\"im\",249),(\"in\",249),(\"io\",249),(\"ip\",249),(\"iq\",249),(\"ir\",249),(\"is\",249),(\"it\",249),(\"iu\",249),(\"iv\",249),(\"iw\",249),(\"ix\",249),(\"iy\",249),(\"iz\",249),(\"iA\",249),(\"iB\",249),(\"iC\",249),(\"iD\",249),(\"iE\",249),(\"iF\",249),(\"iG\",249),(\"iH\",249),(\"iI\",249),(\"iJ\",249),(\"iK\",249),(\"iL\",249),(\"iM\",249),(\"iN\",249),(\"iO\",249),(\"iP\",249),(\"iQ\",249),(\"iR\",249),(\"iS\",249),(\"iT\",249),(\"iU\",249),(\"iV\",249),(\"iW\",249),(\"iX\",249),(\"iY\",249),(\"iZ\",249),(\"i0\",249),(\"i1\",249),(\"i2\",249),(\"i3\",249),(\"i4\",249),(\"i5\",249),(\"i6\",249),(\"i7\",249),(\"i8\",249),(\"i9\",249),(\"i\",249),(\"i\",249),(\"i\",249),(\"i\",249),(\"i\",249),(\"i\",249),(\"i\",249),(\"ja\",98),(\"jb\",98),(\"jc\",98),(\"jd\",98),(\"je\",98),(\"jf\",98),(\"jg\",98),(\"jh\",98),(\"ji\",98),(\"jj\",98),(\"jk\",98),(\"jl\",98),(\"jm\",98),(\"jn\",98),(\"jo\",98),(\"jp\",98),(\"jq\",98),(\"jr\",98),(\"js\",98),(\"jt\",98),(\"ju\",98),(\"jv\",98),(\"jw\",98),(\"jx\",98),(\"jy\",98),(\"jz\",98),(\"jA\",98),(\"jB\",98),(\"jC\",98),(\"jD\",98),(\"jE\",98),(\"jF\",98),(\"jG\",98),(\"jH\",98),(\"jI\",98),(\"jJ\",98),(\"jK\",98),(\"jL\",98),(\"jM\",98),(\"jN\",98),(\"jO\",98),(\"jP\",98),(\"jQ\",98),(\"jR\",98),(\"jS\",98),(\"jT\",98),(\"jU\",98),(\"jV\",98),(\"jW\",98),(\"jX\",98),(\"jY\",98),(\"jZ\",98),(\"j0\",98),(\"j1\",98),(\"j2\",98),(\"j3\",98),(\"j4\",98),(\"j5\",98),(\"j6\",98),(\"j7\",98),(\"j8\",98),(\"j9\",98),(\"j\",98),(\"j\",98),(\"j\",98),(\"j\",98),(\"j\",98),(\"j\",98),(\"j\",98),(\"ka\",200),(\"kb\",200),(\"kc\",200),(\"kd\",200),(\"ke\",200),(\"kf\",200),(\"kg\",200),(\"kh\",200),(\"ki\",200),(\"kj\",200),(\"kk\",200),(\"kl\",200),(\"km\",200),(\"kn\",200),(\"ko\",200),(\"kp\",200),(\"kq\",200),(\"kr\",200),(\"ks\",200),(\"kt\",200),(\"ku\",200),(\"kv\",200),(\"kw\",200),(\"kx\",200),(\"ky\",200),(\"kz\",200),(\"kA\",200),(\"kB\",200),(\"kC\",200),(\"kD\",200),(\"kE\",200),(\"kF\",200),(\"kG\",200),(\"kH\",200),(\"kI\",200),(\"kJ\",200),(\"kK\",200),(\"kL\",200),(\"kM\",200),(\"kN\",200),(\"kO\",200),(\"kP\",200),(\"kQ\",200),(\"kR\",200),(\"kS\",200),(\"kT\",200),(\"kU\",200),(\"kV\",200),(\"kW\",200),(\"kX\",200),(\"kY\",200),(\"kZ\",200),(\"k0\",200),(\"k1\",200),(\"k2\",200),(\"k3\",200),(\"k4\",200),(\"k5\",200),(\"k6\",200),(\"k7\",200),(\"k8\",200),(\"k9\",200),(\"k\",200),(\"k\",200),(\"k\",200),(\"k\",200),(\"k\",200),(\"k\",200),(\"k\",200),(\"la\",218),(\"lb\",218),(\"lc\",218),(\"ld\",218),(\"le\",218),(\"lf\",218),(\"lg\",218),(\"lh\",218),(\"li\",218),(\"lj\",218),(\"lk\",218),(\"ll\",218),(\"lm\",218),(\"ln\",218),(\"lo\",218),(\"lp\",218),(\"lq\",218),(\"lr\",218),(\"ls\",218),(\"lt\",218),(\"lu\",218),(\"lv\",218),(\"lw\",218),(\"lx\",218),(\"ly\",218),(\"lz\",218),(\"lA\",218),(\"lB\",218),(\"lC\",218),(\"lD\",218),(\"lE\",218),(\"lF\",218),(\"lG\",218),(\"lH\",218),(\"lI\",218),(\"lJ\",218),(\"lK\",218),(\"lL\",218),(\"lM\",218),(\"lN\",218),(\"lO\",218),(\"lP\",218),(\"lQ\",218),(\"lR\",218),(\"lS\",218),(\"lT\",218),(\"lU\",218),(\"lV\",218),(\"lW\",218),(\"lX\",218),(\"lY\",218),(\"lZ\",218),(\"l0\",218),(\"l1\",218),(\"l2\",218),(\"l3\",218),(\"l4\",218),(\"l5\",218),(\"l6\",218),(\"l7\",218),(\"l8\",218),(\"l9\",218),(\"l\",218),(\"l\",218),(\"l\",218),(\"l\",218),(\"l\",218),(\"l\",218),(\"l\",218),(\"ma\",253),(\"mb\",253),(\"mc\",253),(\"md\",253),(\"me\",253),(\"mf\",253),(\"mg\",253),(\"mh\",253),(\"mi\",253),(\"mj\",253),(\"mk\",253),(\"ml\",253),(\"mm\",253),(\"mn\",253),(\"mo\",253),(\"mp\",253),(\"mq\",253),(\"mr\",253),(\"ms\",253),(\"mt\",253),(\"mu\",253),(\"mv\",253),(\"mw\",253),(\"mx\",253),(\"my\",253),(\"mz\",253),(\"mA\",253),(\"mB\",253),(\"mC\",253),(\"mD\",253),(\"mE\",253),(\"mF\",253),(\"mG\",253),(\"mH\",253),(\"mI\",253),(\"mJ\",253),(\"mK\",253),(\"mL\",253),(\"mM\",253),(\"mN\",253),(\"mO\",253),(\"mP\",253),(\"mQ\",253),(\"mR\",253),(\"mS\",253),(\"mT\",253),(\"mU\",253),(\"mV\",253),(\"mW\",253),(\"mX\",253),(\"mY\",253),(\"mZ\",253),(\"m0\",253),(\"m1\",253),(\"m2\",253),(\"m3\",253),(\"m4\",253),(\"m5\",253),(\"m6\",253),(\"m7\",253),(\"m8\",253),(\"m9\",253),(\"m\",253),(\"m\",253),(\"m\",253),(\"m\",253),(\"m\",253),(\"m\",253),(\"m\",253),(\"na\",184),(\"nb\",184),(\"nc\",184),(\"nd\",184),(\"ne\",184),(\"nf\",184),(\"ng\",184),(\"nh\",184),(\"ni\",184),(\"nj\",184),(\"nk\",184),(\"nl\",184),(\"nm\",184),(\"nn\",184),(\"no\",184),(\"np\",184),(\"nq\",184),(\"nr\",184),(\"ns\",184),(\"nt\",184),(\"nu\",184),(\"nv\",184),(\"nw\",184),(\"nx\",184),(\"ny\",184),(\"nz\",184),(\"nA\",184),(\"nB\",184),(\"nC\",184),(\"nD\",184),(\"nE\",184),(\"nF\",184),(\"nG\",184),(\"nH\",184),(\"nI\",184),(\"nJ\",184),(\"nK\",184),(\"nL\",184),(\"nM\",184),(\"nN\",184),(\"nO\",184),(\"nP\",184),(\"nQ\",184),(\"nR\",184),(\"nS\",184),(\"nT\",184),(\"nU\",184),(\"nV\",184),(\"nW\",184),(\"nX\",184),(\"nY\",184),(\"nZ\",184),(\"n0\",184),(\"n1\",184),(\"n2\",184),(\"n3\",184),(\"n4\",184),(\"n5\",184),(\"n6\",184),(\"n7\",184),(\"n8\",184),(\"n9\",184),(\"n\",184),(\"n\",184),(\"n\",184),(\"n\",184),(\"n\",184),(\"n\",184),(\"n\",184),(\"oa\",112),(\"ob\",112),(\"oc\",112),(\"od\",112),(\"oe\",112),(\"of\",112),(\"og\",112),(\"oh\",112),(\"oi\",112),(\"oj\",112),(\"ok\",112),(\"ol\",112),(\"om\",112),(\"on\",112),(\"oo\",112),(\"op\",112),(\"oq\",112),(\"or\",112),(\"os\",112),(\"ot\",112),(\"ou\",112),(\"ov\",112),(\"ow\",112),(\"ox\",112),(\"oy\",112),(\"oz\",112),(\"oA\",112),(\"oB\",112),(\"oC\",112),(\"oD\",112),(\"oE\",112),(\"oF\",112),(\"oG\",112),(\"oH\",112),(\"oI\",112),(\"oJ\",112),(\"oK\",112),(\"oL\",112),(\"oM\",112),(\"oN\",112),(\"oO\",112),(\"oP\",112),(\"oQ\",112),(\"oR\",112),(\"oS\",112),(\"oT\",112),(\"oU\",112),(\"oV\",112),(\"oW\",112),(\"oX\",112),(\"oY\",112),(\"oZ\",112),(\"o0\",112),(\"o1\",112),(\"o2\",112),(\"o3\",112),(\"o4\",112),(\"o5\",112),(\"o6\",112),(\"o7\",112),(\"o8\",112),(\"o9\",112),(\"o\",112),(\"o\",112),(\"o\",112),(\"o\",112),(\"o\",112),(\"o\",112),(\"o\",112),(\"pa\",70),(\"pb\",70),(\"pc\",70),(\"pd\",70),(\"pe\",70),(\"pf\",70),(\"pg\",70),(\"ph\",70),(\"pi\",70),(\"pj\",70),(\"pk\",70),(\"pl\",70),(\"pm\",70),(\"pn\",70),(\"po\",70),(\"pp\",70),(\"pq\",70),(\"pr\",70),(\"ps\",70),(\"pt\",70),(\"pu\",70),(\"pv\",70),(\"pw\",70),(\"px\",70),(\"py\",70),(\"pz\",70),(\"pA\",70),(\"pB\",70),(\"pC\",70),(\"pD\",70),(\"pE\",70),(\"pF\",70),(\"pG\",70),(\"pH\",70),(\"pI\",70),(\"pJ\",70),(\"pK\",70),(\"pL\",70),(\"pM\",70),(\"pN\",70),(\"pO\",70),(\"pP\",70),(\"pQ\",70),(\"pR\",70),(\"pS\",70),(\"pT\",70),(\"pU\",70),(\"pV\",70),(\"pW\",70),(\"pX\",70),(\"pY\",70),(\"pZ\",70),(\"p0\",70),(\"p1\",70),(\"p2\",70),(\"p3\",70),(\"p4\",70),(\"p5\",70),(\"p6\",70),(\"p7\",70),(\"p8\",70),(\"p9\",70),(\"p\",70),(\"p\",70),(\"p\",70),(\"p\",70),(\"p\",70),(\"p\",70),(\"p\",70),(\"qa\",84),(\"qb\",84),(\"qc\",84),(\"qd\",84),(\"qe\",84),(\"qf\",84),(\"qg\",84),(\"qh\",84),(\"qi\",84),(\"qj\",84),(\"qk\",84),(\"ql\",84),(\"qm\",84),(\"qn\",84),(\"qo\",84),(\"qp\",84),(\"qq\",84),(\"qr\",84),(\"qs\",84),(\"qt\",84),(\"qu\",84),(\"qv\",84),(\"qw\",84),(\"qx\",84),(\"qy\",84),(\"qz\",84),(\"qA\",84),(\"qB\",84),(\"qC\",84),(\"qD\",84),(\"qE\",84),(\"qF\",84),(\"qG\",84),(\"qH\",84),(\"qI\",84),(\"qJ\",84),(\"qK\",84),(\"qL\",84),(\"qM\",84),(\"qN\",84),(\"qO\",84),(\"qP\",84),(\"qQ\",84),(\"qR\",84),(\"qS\",84),(\"qT\",84),(\"qU\",84),(\"qV\",84),(\"qW\",84),(\"qX\",84),(\"qY\",84),(\"qZ\",84),(\"q0\",84),(\"q1\",84),(\"q2\",84),(\"q3\",84),(\"q4\",84),(\"q5\",84),(\"q6\",84),(\"q7\",84),(\"q8\",84),(\"q9\",84),(\"q\",84),(\"q\",84),(\"q\",84),(\"q\",84),(\"q\",84),(\"q\",84),(\"q\",84),(\"ra\",284),(\"rb\",284),(\"rc\",312),(\"rd\",316),(\"re\",337),(\"rf\",316),(\"rg\",295),(\"rh\",354),(\"ri\",284),(\"rj\",284),(\"rk\",284),(\"rl\",284),(\"rm\",154),(\"rn\",151),(\"ro\",319),(\"rp\",284),(\"rq\",333),(\"rr\",284),(\"rs\",284),(\"rt\",284),(\"ru\",284),(\"rv\",284),(\"rw\",284),(\"rx\",284),(\"ry\",284),(\"rz\",284),(\"rA\",284),(\"rB\",284),(\"rC\",284),(\"rD\",284),(\"rE\",284),(\"rF\",284),(\"rG\",284),(\"rH\",284),(\"rI\",284),(\"rJ\",284),(\"rK\",284),(\"rL\",284),(\"rM\",284),(\"rN\",284),(\"rO\",284),(\"rP\",284),(\"rQ\",284),(\"rR\",284),(\"rS\",284),(\"rT\",284),(\"rU\",284),(\"rV\",284),(\"rW\",284),(\"rX\",284),(\"rY\",284),(\"rZ\",284),(\"r0\",284),(\"r1\",284),(\"r2\",284),(\"r3\",284),(\"r4\",284),(\"r5\",284),(\"r6\",284),(\"r7\",284),(\"r8\",284),(\"r9\",284),(\"r\",284),(\"r\",284),(\"r\",284),(\"r\",284),(\"r\",284),(\"r\",284),(\"r\",284),(\"sa\",25),(\"sb\",25),(\"sc\",25),(\"sd\",25),(\"se\",25),(\"sf\",25),(\"sg\",25),(\"sh\",25),(\"si\",25),(\"sj\",25),(\"sk\",25),(\"sl\",25),(\"sm\",25),(\"sn\",25),(\"so\",25),(\"sp\",25),(\"sq\",25),(\"sr\",25),(\"ss\",25),(\"st\",25),(\"su\",25),(\"sv\",25),(\"sw\",25),(\"sx\",25),(\"sy\",25),(\"sz\",25),(\"sA\",25),(\"sB\",25),(\"sC\",25),(\"sD\",25),(\"sE\",25),(\"sF\",25),(\"sG\",25),(\"sH\",25),(\"sI\",25),(\"sJ\",25),(\"sK\",25),(\"sL\",25),(\"sM\",25),(\"sN\",25),(\"sO\",25),(\"sP\",25),(\"sQ\",25),(\"sR\",25),(\"sS\",25),(\"sT\",25),(\"sU\",25),(\"sV\",25),(\"sW\",25),(\"sX\",25),(\"sY\",25),(\"sZ\",25),(\"s0\",25),(\"s1\",25),(\"s2\",25),(\"s3\",25),(\"s4\",25),(\"s5\",25),(\"s6\",25),(\"s7\",25),(\"s8\",25),(\"s9\",25),(\"s\",25),(\"s\",25),(\"s\",25),(\"s\",25),(\"s\",25),(\"s\",25),(\"s\",25),(\"ta\",249),(\"tb\",249),(\"tc\",249),(\"td\",249),(\"te\",249),(\"tf\",249),(\"tg\",249),(\"th\",249),(\"ti\",249),(\"tj\",249),(\"tk\",249),(\"tl\",249),(\"tm\",249),(\"tn\",249),(\"to\",249),(\"tp\",249),(\"tq\",249),(\"tr\",249),(\"ts\",249),(\"tt\",249),(\"tu\",249),(\"tv\",249),(\"tw\",249),(\"tx\",249),(\"ty\",249),(\"tz\",249),(\"tA\",249),(\"tB\",249),(\"tC\",249),(\"tD\",249),(\"tE\",249),(\"tF\",249),(\"tG\",249),(\"tH\",249),(\"tI\",249),(\"tJ\",249),(\"tK\",249),(\"tL\",249),(\"tM\",249),(\"tN\",249),(\"tO\",249),(\"tP\",249),(\"tQ\",249),(\"tR\",249),(\"tS\",249),(\"tT\",249),(\"tU\",249),(\"tV\",249),(\"tW\",249),(\"tX\",249),(\"tY\",249),(\"tZ\",249),(\"t0\",249),(\"t1\",249),(\"t2\",249),(\"t3\",249),(\"t4\",249),(\"t5\",249),(\"t6\",249),(\"t7\",249),(\"t8\",249),(\"t9\",249),(\"t\",249),(\"t\",249),(\"t\",249),(\"t\",249),(\"t\",249),(\"t\",249),(\"t\",249),(\"ua\",232),(\"ub\",232),(\"uc\",232),(\"ud\",232),(\"ue\",232),(\"uf\",232),(\"ug\",232),(\"uh\",232),(\"ui\",232),(\"uj\",232),(\"uk\",232),(\"ul\",232),(\"um\",232),(\"un\",232),(\"uo\",232),(\"up\",232),(\"uq\",232),(\"ur\",232),(\"us\",232),(\"ut\",232),(\"uu\",232),(\"uv\",232),(\"uw\",232),(\"ux\",232),(\"uy\",232),(\"uz\",232),(\"uA\",232),(\"uB\",232),(\"uC\",232),(\"uD\",232),(\"uE\",232),(\"uF\",232),(\"uG\",232),(\"uH\",232),(\"uI\",232),(\"uJ\",232),(\"uK\",232),(\"uL\",232),(\"uM\",232),(\"uN\",232),(\"uO\",232),(\"uP\",232),(\"uQ\",232),(\"uR\",232),(\"uS\",232),(\"uT\",232),(\"uU\",232),(\"uV\",232),(\"uW\",232),(\"uX\",232),(\"uY\",232),(\"uZ\",232),(\"u0\",232),(\"u1\",232),(\"u2\",232),(\"u3\",232),(\"u4\",232),(\"u5\",232),(\"u6\",232),(\"u7\",232),(\"u8\",232),(\"u9\",232),(\"u\",232),(\"u\",232),(\"u\",232),(\"u\",232),(\"u\",232),(\"u\",232),(\"u\",232),(\"va\",77),(\"vb\",77),(\"vc\",77),(\"vd\",77),(\"ve\",77),(\"vf\",77),(\"vg\",77),(\"vh\",77),(\"vi\",77),(\"vj\",77),(\"vk\",77),(\"vl\",77),(\"vm\",77),(\"vn\",77),(\"vo\",77),(\"vp\",77),(\"vq\",77),(\"vr\",77),(\"vs\",77),(\"vt\",77),(\"vu\",77),(\"vv\",77),(\"vw\",77),(\"vx\",77),(\"vy\",77),(\"vz\",77),(\"vA\",77),(\"vB\",77),(\"vC\",77),(\"vD\",77),(\"vE\",77),(\"vF\",77),(\"vG\",77),(\"vH\",77),(\"vI\",77),(\"vJ\",77),(\"vK\",77),(\"vL\",77),(\"vM\",77),(\"vN\",77),(\"vO\",77),(\"vP\",77),(\"vQ\",77),(\"vR\",77),(\"vS\",77),(\"vT\",77),(\"vU\",77),(\"vV\",77),(\"vW\",77),(\"vX\",77),(\"vY\",77),(\"vZ\",77),(\"v0\",77),(\"v1\",77),(\"v2\",77),(\"v3\",77),(\"v4\",77),(\"v5\",77),(\"v6\",77),(\"v7\",77),(\"v8\",77),(\"v9\",77),(\"v\",77),(\"v\",77),(\"v\",77),(\"v\",77),(\"v\",77),(\"v\",77),(\"v\",77),(\"wa\",46),(\"wb\",46),(\"wc\",46),(\"wd\",46),(\"we\",46),(\"wf\",46),(\"wg\",46),(\"wh\",46),(\"wi\",46),(\"wj\",46),(\"wk\",46),(\"wl\",46),(\"wm\",46),(\"wn\",46),(\"wo\",46),(\"wp\",46),(\"wq\",46),(\"wr\",46),(\"ws\",46),(\"wt\",46),(\"wu\",46),(\"wv\",46),(\"ww\",46),(\"wx\",46),(\"wy\",46),(\"wz\",46),(\"wA\",46),(\"wB\",46),(\"wC\",46),(\"wD\",46),(\"wE\",46),(\"wF\",46),(\"wG\",46),(\"wH\",46),(\"wI\",46),(\"wJ\",46),(\"wK\",46),(\"wL\",46),(\"wM\",46),(\"wN\",46),(\"wO\",46),(\"wP\",46),(\"wQ\",46),(\"wR\",46),(\"wS\",46),(\"wT\",46),(\"wU\",46),(\"wV\",46),(\"wW\",46),(\"wX\",46),(\"wY\",46),(\"wZ\",46),(\"w0\",46),(\"w1\",46),(\"w2\",46),(\"w3\",46),(\"w4\",46),(\"w5\",46),(\"w6\",46),(\"w7\",46),(\"w8\",46),(\"w9\",46),(\"w\",46),(\"w\",46),(\"w\",46),(\"w\",46),(\"w\",46),(\"w\",46),(\"w\",46),(\"xa\",302),(\"xb\",302),(\"xc\",302),(\"xd\",302),(\"xe\",302),(\"xf\",302),(\"xg\",302),(\"xh\",302),(\"xi\",302),(\"xj\",302),(\"xk\",302),(\"xl\",302),(\"xm\",302),(\"xn\",302),(\"xo\",302),(\"xp\",302),(\"xq\",302),(\"xr\",302),(\"xs\",302),(\"xt\",302),(\"xu\",302),(\"xv\",302),(\"xw\",302),(\"xx\",302),(\"xy\",302),(\"xz\",302),(\"xA\",302),(\"xB\",302),(\"xC\",302),(\"xD\",302),(\"xE\",302),(\"xF\",302),(\"xG\",302),(\"xH\",302),(\"xI\",302),(\"xJ\",302),(\"xK\",302),(\"xL\",302),(\"xM\",302),(\"xN\",302),(\"xO\",302),(\"xP\",302),(\"xQ\",302),(\"xR\",302),(\"xS\",302),(\"xT\",302),(\"xU\",302),(\"xV\",302),(\"xW\",302),(\"xX\",302),(\"xY\",302),(\"xZ\",302),(\"x0\",302),(\"x1\",302),(\"x2\",302),(\"x3\",302),(\"x4\",302),(\"x5\",302),(\"x6\",302),(\"x7\",302),(\"x8\",302),(\"x9\",302),(\"x\",302),(\"x\",302),(\"x\",302),(\"x\",302),(\"x\",302),(\"x\",302),(\"x\",302),(\"ya\",32),(\"yb\",32),(\"yc\",32),(\"yd\",32),(\"ye\",32),(\"yf\",32),(\"yg\",32),(\"yh\",32),(\"yi\",32),(\"yj\",32),(\"yk\",32),(\"yl\",32),(\"ym\",32),(\"yn\",32),(\"yo\",32),(\"yp\",32),(\"yq\",32),(\"yr\",32),(\"ys\",32),(\"yt\",32),(\"yu\",32),(\"yv\",32),(\"yw\",32),(\"yx\",32),(\"yy\",32),(\"yz\",32),(\"yA\",32),(\"yB\",32),(\"yC\",32),(\"yD\",32),(\"yE\",32),(\"yF\",32),(\"yG\",32),(\"yH\",32),(\"yI\",32),(\"yJ\",32),(\"yK\",32),(\"yL\",32),(\"yM\",32),(\"yN\",32),(\"yO\",32),(\"yP\",32),(\"yQ\",32),(\"yR\",32),(\"yS\",32),(\"yT\",32),(\"yU\",32),(\"yV\",32),(\"yW\",32),(\"yX\",32),(\"yY\",32),(\"yZ\",32),(\"y0\",32),(\"y1\",32),(\"y2\",32),(\"y3\",32),(\"y4\",32),(\"y5\",32),(\"y6\",32),(\"y7\",32),(\"y8\",32),(\"y9\",32),(\"y\",32),(\"y\",32),(\"y\",32),(\"y\",32),(\"y\",32),(\"y\",32),(\"y\",32),(\"za\",144),(\"zb\",144),(\"zc\",144),(\"zd\",144),(\"ze\",144),(\"zf\",144),(\"zg\",144),(\"zh\",144),(\"zi\",144),(\"zj\",144),(\"zk\",144),(\"zl\",144),(\"zm\",144),(\"zn\",144),(\"zo\",144),(\"zp\",144),(\"zq\",144),(\"zr\",144),(\"zs\",144),(\"zt\",144),(\"zu\",144),(\"zv\",144),(\"zw\",144),(\"zx\",144),(\"zy\",144),(\"zz\",144),(\"zA\",144),(\"zB\",144),(\"zC\",144),(\"zD\",144),(\"zE\",144),(\"zF\",144),(\"zG\",144),(\"zH\",144),(\"zI\",144),(\"zJ\",144),(\"zK\",144),(\"zL\",144),(\"zM\",144),(\"zN\",144),(\"zO\",144),(\"zP\",144),(\"zQ\",144),(\"zR\",144),(\"zS\",144),(\"zT\",144),(\"zU\",144),(\"zV\",144),(\"zW\",144),(\"zX\",144),(\"zY\",144),(\"zZ\",144),(\"z0\",144),(\"z1\",144),(\"z2\",144),(\"z3\",144),(\"z4\",144),(\"z5\",144),(\"z6\",144),(\"z7\",144),(\"z8\",144),(\"z9\",144),(\"z\",144),(\"z\",144),(\"z\",144),(\"z\",144),(\"z\",144),(\"z\",144),(\"z\",144),(\"Aa\",70),(\"Ab\",70),(\"Ac\",70),(\"Ad\",70),(\"Ae\",70),(\"Af\",70),(\"Ag\",70),(\"Ah\",70),(\"Ai\",70),(\"Aj\",70),(\"Ak\",70),(\"Al\",70),(\"Am\",70),(\"An\",70),(\"Ao\",70),(\"Ap\",70),(\"Aq\",70),(\"Ar\",70),(\"As\",70),(\"At\",70),(\"Au\",70),(\"Av\",70),(\"Aw\",70),(\"Ax\",70),(\"Ay\",70),(\"Az\",70),(\"AA\",70),(\"AB\",70),(\"AC\",70),(\"AD\",70),(\"AE\",70),(\"AF\",70),(\"AG\",70),(\"AH\",70),(\"AI\",70),(\"AJ\",70),(\"AK\",70),(\"AL\",70),(\"AM\",70),(\"AN\",70),(\"AO\",70),(\"AP\",70),(\"AQ\",70),(\"AR\",70),(\"AS\",70),(\"AT\",88),(\"AU\",70),(\"AV\",344),(\"AW\",326),(\"AX\",70),(\"AY\",288),(\"AZ\",70),(\"A0\",70),(\"A1\",70),(\"A2\",70),(\"A3\",70),(\"A4\",70),(\"A5\",70),(\"A6\",70),(\"A7\",70),(\"A8\",70),(\"A9\",70),(\"A\",70),(\"A\",70),(\"A\",70),(\"A\",70),(\"A\",70),(\"A\",70),(\"A\",70),(\"Ba\",91),(\"Bb\",91),(\"Bc\",91),(\"Bd\",91),(\"Be\",91),(\"Bf\",91),(\"Bg\",91),(\"Bh\",91),(\"Bi\",91),(\"Bj\",91),(\"Bk\",91),(\"Bl\",91),(\"Bm\",91),(\"Bn\",91),(\"Bo\",91),(\"Bp\",91),(\"Bq\",91),(\"Br\",91),(\"Bs\",91),(\"Bt\",91),(\"Bu\",91),(\"Bv\",91),(\"Bw\",91),(\"Bx\",91),(\"By\",91),(\"Bz\",91),(\"BA\",91),(\"BB\",91),(\"BC\",91),(\"BD\",91),(\"BE\",91),(\"BF\",91),(\"BG\",91),(\"BH\",91),(\"BI\",91),(\"BJ\",91),(\"BK\",91),(\"BL\",91),(\"BM\",91),(\"BN\",91),(\"BO\",91),(\"BP\",91),(\"BQ\",91),(\"BR\",91),(\"BS\",91),(\"BT\",91),(\"BU\",91),(\"BV\",91),(\"BW\",91),(\"BX\",91),(\"BY\",91),(\"BZ\",91),(\"B0\",91),(\"B1\",91),(\"B2\",91),(\"B3\",91),(\"B4\",91),(\"B5\",91),(\"B6\",91),(\"B7\",91),(\"B8\",91),(\"B9\",91),(\"B\",91),(\"B\",91),(\"B\",91),(\"B\",91),(\"B\",91),(\"B\",91),(\"B\",91),(\"Ca\",91),(\"Cb\",91),(\"Cc\",91),(\"Cd\",91),(\"Ce\",91),(\"Cf\",91),(\"Cg\",91),(\"Ch\",91),(\"Ci\",91),(\"Cj\",91),(\"Ck\",91),(\"Cl\",91),(\"Cm\",91),(\"Cn\",91),(\"Co\",91),(\"Cp\",91),(\"Cq\",91),(\"Cr\",91),(\"Cs\",91),(\"Ct\",91),(\"Cu\",91),(\"Cv\",91),(\"Cw\",91),(\"Cx\",91),(\"Cy\",91),(\"Cz\",91),(\"CA\",91),(\"CB\",91),(\"CC\",91),(\"CD\",91),(\"CE\",91),(\"CF\",91),(\"CG\",91),(\"CH\",91),(\"CI\",91),(\"CJ\",91),(\"CK\",91),(\"CL\",91),(\"CM\",91),(\"CN\",91),(\"CO\",91),(\"CP\",91),(\"CQ\",91),(\"CR\",91),(\"CS\",91),(\"CT\",91),(\"CU\",91),(\"CV\",91),(\"CW\",91),(\"CX\",91),(\"CY\",91),(\"CZ\",91),(\"C0\",91),(\"C1\",91),(\"C2\",91),(\"C3\",91),(\"C4\",91),(\"C5\",91),(\"C6\",91),(\"C7\",91),(\"C8\",91),(\"C9\",91),(\"C\",91),(\"C\",91),(\"C\",91),(\"C\",91),(\"C\",91),(\"C\",91),(\"C\",91),(\"Da\",147),(\"Db\",147),(\"Dc\",147),(\"Dd\",147),(\"De\",147),(\"Df\",147),(\"Dg\",147),(\"Dh\",147),(\"Di\",147),(\"Dj\",147),(\"Dk\",147),(\"Dl\",147),(\"Dm\",147),(\"Dn\",147),(\"Do\",147),(\"Dp\",147),(\"Dq\",147),(\"Dr\",147),(\"Ds\",147),(\"Dt\",147),(\"Du\",147),(\"Dv\",147),(\"Dw\",147),(\"Dx\",147),(\"Dy\",147),(\"Dz\",147),(\"DA\",147),(\"DB\",147),(\"DC\",147),(\"DD\",147),(\"DE\",147),(\"DF\",147),(\"DG\",147),(\"DH\",147),(\"DI\",147),(\"DJ\",147),(\"DK\",147),(\"DL\",147),(\"DM\",147),(\"DN\",147),(\"DO\",147),(\"DP\",147),(\"DQ\",147),(\"DR\",147),(\"DS\",147),(\"DT\",147),(\"DU\",147),(\"DV\",147),(\"DW\",147),(\"DX\",147),(\"DY\",147),(\"DZ\",147),(\"D0\",147),(\"D1\",147),(\"D2\",147),(\"D3\",147),(\"D4\",147),(\"D5\",147),(\"D6\",147),(\"D7\",147),(\"D8\",147),(\"D9\",147),(\"D\",147),(\"D\",147),(\"D\",147),(\"D\",147),(\"D\",147),(\"D\",147),(\"D\",147),(\"Ea\",197),(\"Eb\",197),(\"Ec\",197),(\"Ed\",197),(\"Ee\",197),(\"Ef\",197),(\"Eg\",197),(\"Eh\",197),(\"Ei\",197),(\"Ej\",197),(\"Ek\",197),(\"El\",197),(\"Em\",197),(\"En\",197),(\"Eo\",197),(\"Ep\",197),(\"Eq\",197),(\"Er\",197),(\"Es\",197),(\"Et\",197),(\"Eu\",197),(\"Ev\",197),(\"Ew\",197),(\"Ex\",197),(\"Ey\",197),(\"Ez\",197),(\"EA\",197),(\"EB\",197),(\"EC\",197),(\"ED\",197),(\"EE\",197),(\"EF\",197),(\"EG\",197),(\"EH\",197),(\"EI\",197),(\"EJ\",197),(\"EK\",197),(\"EL\",197),(\"EM\",197),(\"EN\",197),(\"EO\",197),(\"EP\",197),(\"EQ\",197),(\"ER\",197),(\"ES\",197),(\"ET\",197),(\"EU\",197),(\"EV\",197),(\"EW\",197),(\"EX\",197),(\"EY\",197),(\"EZ\",197),(\"E0\",197),(\"E1\",197),(\"E2\",197),(\"E3\",197),(\"E4\",197),(\"E5\",197),(\"E6\",197),(\"E7\",197),(\"E8\",197),(\"E9\",197),(\"E\",197),(\"E\",197),(\"E\",197),(\"E\",197),(\"E\",197),(\"E\",197),(\"E\",197),(\"Fa\",432),(\"Fb\",432),(\"Fc\",432),(\"Fd\",432),(\"Fe\",432),(\"Ff\",432),(\"Fg\",432),(\"Fh\",432),(\"Fi\",432),(\"Fj\",432),(\"Fk\",432),(\"Fl\",432),(\"Fm\",432),(\"Fn\",432),(\"Fo\",432),(\"Fp\",432),(\"Fq\",432),(\"Fr\",432),(\"Fs\",432),(\"Ft\",432),(\"Fu\",432),(\"Fv\",432),(\"Fw\",432),(\"Fx\",432),(\"Fy\",432),(\"Fz\",432),(\"FA\",488),(\"FB\",432),(\"FC\",432),(\"FD\",432),(\"FE\",432),(\"FF\",432),(\"FG\",432),(\"FH\",432),(\"FI\",432),(\"FJ\",432),(\"FK\",432),(\"FL\",432),(\"FM\",432),(\"FN\",432),(\"FO\",432),(\"FP\",432),(\"FQ\",432),(\"FR\",432),(\"FS\",432),(\"FT\",432),(\"FU\",432),(\"FV\",432),(\"FW\",432),(\"FX\",432),(\"FY\",432),(\"FZ\",432),(\"F0\",432),(\"F1\",432),(\"F2\",432),(\"F3\",432),(\"F4\",432),(\"F5\",432),(\"F6\",432),(\"F7\",432),(\"F8\",432),(\"F9\",432),(\"F\",432),(\"F\",432),(\"F\",432),(\"F\",432),(\"F\",432),(\"F\",432),(\"F\",432),(\"Ga\",184),(\"Gb\",184),(\"Gc\",184),(\"Gd\",184),(\"Ge\",184),(\"Gf\",184),(\"Gg\",184),(\"Gh\",184),(\"Gi\",184),(\"Gj\",184),(\"Gk\",184),(\"Gl\",184),(\"Gm\",184),(\"Gn\",184),(\"Go\",184),(\"Gp\",184),(\"Gq\",184),(\"Gr\",184),(\"Gs\",184),(\"Gt\",184),(\"Gu\",184),(\"Gv\",184),(\"Gw\",184),(\"Gx\",184),(\"Gy\",184),(\"Gz\",184),(\"GA\",184),(\"GB\",184),(\"GC\",184),(\"GD\",184),(\"GE\",184),(\"GF\",184),(\"GG\",184),(\"GH\",184),(\"GI\",184),(\"GJ\",184),(\"GK\",184),(\"GL\",184),(\"GM\",184),(\"GN\",184),(\"GO\",184),(\"GP\",184),(\"GQ\",184),(\"GR\",184),(\"GS\",184),(\"GT\",184),(\"GU\",184),(\"GV\",184),(\"GW\",184),(\"GX\",184),(\"GY\",184),(\"GZ\",184),(\"G0\",184),(\"G1\",184),(\"G2\",184),(\"G3\",184),(\"G4\",184),(\"G5\",184),(\"G6\",184),(\"G7\",184),(\"G8\",184),(\"G9\",184),(\"G\",184),(\"G\",184),(\"G\",184),(\"G\",184),(\"G\",184),(\"G\",184),(\"G\",184),(\"Ha\",309),(\"Hb\",309),(\"Hc\",309),(\"Hd\",309),(\"He\",309),(\"Hf\",309),(\"Hg\",309),(\"Hh\",309),(\"Hi\",309),(\"Hj\",309),(\"Hk\",309),(\"Hl\",309),(\"Hm\",309),(\"Hn\",309),(\"Ho\",309),(\"Hp\",309),(\"Hq\",309),(\"Hr\",309),(\"Hs\",309),(\"Ht\",309),(\"Hu\",309),(\"Hv\",309),(\"Hw\",309),(\"Hx\",309),(\"Hy\",309),(\"Hz\",309),(\"HA\",309),(\"HB\",309),(\"HC\",309),(\"HD\",309),(\"HE\",309),(\"HF\",309),(\"HG\",309),(\"HH\",309),(\"HI\",309),(\"HJ\",309),(\"HK\",309),(\"HL\",309),(\"HM\",309),(\"HN\",309),(\"HO\",309),(\"HP\",309),(\"HQ\",309),(\"HR\",309),(\"HS\",309),(\"HT\",309),(\"HU\",309),(\"HV\",309),(\"HW\",309),(\"HX\",309),(\"HY\",309),(\"HZ\",309),(\"H0\",309),(\"H1\",309),(\"H2\",309),(\"H3\",309),(\"H4\",309),(\"H5\",309),(\"H6\",309),(\"H7\",309),(\"H8\",309),(\"H9\",309),(\"H\",309),(\"H\",309),(\"H\",309),(\"H\",309),(\"H\",309),(\"H\",309),(\"H\",309),(\"Ia\",323),(\"Ib\",323),(\"Ic\",323),(\"Id\",323),(\"Ie\",323),(\"If\",323),(\"Ig\",323),(\"Ih\",323),(\"Ii\",323),(\"Ij\",323),(\"Ik\",323),(\"Il\",323),(\"Im\",323),(\"In\",323),(\"Io\",323),(\"Ip\",323),(\"Iq\",323),(\"Ir\",323),(\"Is\",323),(\"It\",323),(\"Iu\",323),(\"Iv\",323),(\"Iw\",323),(\"Ix\",323),(\"Iy\",323),(\"Iz\",323),(\"IA\",323),(\"IB\",323),(\"IC\",323),(\"ID\",323),(\"IE\",323),(\"IF\",323),(\"IG\",323),(\"IH\",323),(\"II\",323),(\"IJ\",323),(\"IK\",323),(\"IL\",323),(\"IM\",323),(\"IN\",323),(\"IO\",323),(\"IP\",323),(\"IQ\",323),(\"IR\",323),(\"IS\",323),(\"IT\",323),(\"IU\",323),(\"IV\",323),(\"IW\",323),(\"IX\",323),(\"IY\",323),(\"IZ\",323),(\"I0\",323),(\"I1\",323),(\"I2\",323),(\"I3\",323),(\"I4\",323),(\"I5\",323),(\"I6\",323),(\"I7\",323),(\"I8\",323),(\"I9\",323),(\"I\",323),(\"I\",323),(\"I\",323),(\"I\",323),(\"I\",323),(\"I\",323),(\"I\",323),(\"Ja\",372),(\"Jb\",372),(\"Jc\",372),(\"Jd\",372),(\"Je\",372),(\"Jf\",372),(\"Jg\",372),(\"Jh\",372),(\"Ji\",372),(\"Jj\",372),(\"Jk\",372),(\"Jl\",372),(\"Jm\",372),(\"Jn\",372),(\"Jo\",372),(\"Jp\",372),(\"Jq\",372),(\"Jr\",372),(\"Js\",372),(\"Jt\",372),(\"Ju\",372),(\"Jv\",372),(\"Jw\",372),(\"Jx\",372),(\"Jy\",372),(\"Jz\",372),(\"JA\",372),(\"JB\",372),(\"JC\",372),(\"JD\",372),(\"JE\",372),(\"JF\",372),(\"JG\",372),(\"JH\",372),(\"JI\",372),(\"JJ\",372),(\"JK\",372),(\"JL\",372),(\"JM\",372),(\"JN\",372),(\"JO\",372),(\"JP\",372),(\"JQ\",372),(\"JR\",372),(\"JS\",372),(\"JT\",372),(\"JU\",372),(\"JV\",372),(\"JW\",372),(\"JX\",372),(\"JY\",372),(\"JZ\",372),(\"J0\",372),(\"J1\",372),(\"J2\",372),(\"J3\",372),(\"J4\",372),(\"J5\",372),(\"J6\",372),(\"J7\",372),(\"J8\",372),(\"J9\",372),(\"J\",372),(\"J\",372),(\"J\",372),(\"J\",372),(\"J\",372),(\"J\",372),(\"J\",372),(\"Ka\",295),(\"Kb\",295),(\"Kc\",295),(\"Kd\",295),(\"Ke\",295),(\"Kf\",295),(\"Kg\",295),(\"Kh\",295),(\"Ki\",295),(\"Kj\",295),(\"Kk\",295),(\"Kl\",295),(\"Km\",295),(\"Kn\",295),(\"Ko\",295),(\"Kp\",295),(\"Kq\",295),(\"Kr\",295),(\"Ks\",295),(\"Kt\",295),(\"Ku\",295),(\"Kv\",295),(\"Kw\",295),(\"Kx\",295),(\"Ky\",295),(\"Kz\",295),(\"KA\",295),(\"KB\",295),(\"KC\",295),(\"KD\",295),(\"KE\",295),(\"KF\",295),(\"KG\",295),(\"KH\",295),(\"KI\",295),(\"KJ\",295),(\"KK\",295),(\"KL\",295),(\"KM\",295),(\"KN\",295),(\"KO\",295),(\"KP\",295),(\"KQ\",295),(\"KR\",295),(\"KS\",295),(\"KT\",295),(\"KU\",295),(\"KV\",295),(\"KW\",295),(\"KX\",295),(\"KY\",295),(\"KZ\",295),(\"K0\",295),(\"K1\",295),(\"K2\",295),(\"K3\",295),(\"K4\",295),(\"K5\",295),(\"K6\",295),(\"K7\",295),(\"K8\",295),(\"K9\",295),(\"K\",295),(\"K\",295),(\"K\",295),(\"K\",295),(\"K\",295),(\"K\",295),(\"K\",295),(\"La\",267),(\"Lb\",267),(\"Lc\",267),(\"Ld\",267),(\"Le\",267),(\"Lf\",267),(\"Lg\",267),(\"Lh\",267),(\"Li\",267),(\"Lj\",267),(\"Lk\",267),(\"Ll\",267),(\"Lm\",267),(\"Ln\",267),(\"Lo\",267),(\"Lp\",267),(\"Lq\",267),(\"Lr\",267),(\"Ls\",267),(\"Lt\",267),(\"Lu\",267),(\"Lv\",267),(\"Lw\",267),(\"Lx\",267),(\"Ly\",197),(\"Lz\",267),(\"LA\",267),(\"LB\",267),(\"LC\",267),(\"LD\",267),(\"LE\",267),(\"LF\",267),(\"LG\",267),(\"LH\",267),(\"LI\",267),(\"LJ\",267),(\"LK\",267),(\"LL\",267),(\"LM\",267),(\"LN\",267),(\"LO\",267),(\"LP\",267),(\"LQ\",267),(\"LR\",267),(\"LS\",267),(\"LT\",267),(\"LU\",267),(\"LV\",253),(\"LW\",235),(\"LX\",267),(\"LY\",242),(\"LZ\",267),(\"L0\",267),(\"L1\",267),(\"L2\",267),(\"L3\",267),(\"L4\",267),(\"L5\",267),(\"L6\",267),(\"L7\",267),(\"L8\",267),(\"L9\",267),(\"L\",267),(\"L\",267),(\"L\",267),(\"L\",267),(\"L\",267),(\"L\",267),(\"L\",267),(\"Ma\",337),(\"Mb\",337),(\"Mc\",337),(\"Md\",337),(\"Me\",337),(\"Mf\",337),(\"Mg\",337),(\"Mh\",337),(\"Mi\",337),(\"Mj\",337),(\"Mk\",337),(\"Ml\",337),(\"Mm\",337),(\"Mn\",337),(\"Mo\",337),(\"Mp\",337),(\"Mq\",337),(\"Mr\",337),(\"Ms\",337),(\"Mt\",337),(\"Mu\",337),(\"Mv\",337),(\"Mw\",337),(\"Mx\",337),(\"My\",337),(\"Mz\",337),(\"MA\",337),(\"MB\",337),(\"MC\",337),(\"MD\",337),(\"ME\",337),(\"MF\",337),(\"MG\",337),(\"MH\",337),(\"MI\",337),(\"MJ\",337),(\"MK\",337),(\"ML\",337),(\"MM\",337),(\"MN\",337),(\"MO\",337),(\"MP\",337),(\"MQ\",337),(\"MR\",337),(\"MS\",337),(\"MT\",337),(\"MU\",337),(\"MV\",337),(\"MW\",337),(\"MX\",337),(\"MY\",337),(\"MZ\",337),(\"M0\",337),(\"M1\",337),(\"M2\",337),(\"M3\",337),(\"M4\",337),(\"M5\",337),(\"M6\",337),(\"M7\",337),(\"M8\",337),(\"M9\",337),(\"M\",337),(\"M\",337),(\"M\",337),(\"M\",337),(\"M\",337),(\"M\",337),(\"M\",337),(\"Na\",361),(\"Nb\",361),(\"Nc\",361),(\"Nd\",361),(\"Ne\",361),(\"Nf\",361),(\"Ng\",361),(\"Nh\",361),(\"Ni\",361),(\"Nj\",361),(\"Nk\",361),(\"Nl\",361),(\"Nm\",361),(\"Nn\",361),(\"No\",361),(\"Np\",361),(\"Nq\",361),(\"Nr\",361),(\"Ns\",361),(\"Nt\",361),(\"Nu\",361),(\"Nv\",361),(\"Nw\",361),(\"Nx\",361),(\"Ny\",361),(\"Nz\",361),(\"NA\",361),(\"NB\",361),(\"NC\",361),(\"ND\",361),(\"NE\",361),(\"NF\",361),(\"NG\",361),(\"NH\",361),(\"NI\",361),(\"NJ\",361),(\"NK\",361),(\"NL\",361),(\"NM\",361),(\"NN\",361),(\"NO\",361),(\"NP\",361),(\"NQ\",361),(\"NR\",361),(\"NS\",361),(\"NT\",361),(\"NU\",361),(\"NV\",361),(\"NW\",361),(\"NX\",361),(\"NY\",361),(\"NZ\",361),(\"N0\",361),(\"N1\",361),(\"N2\",361),(\"N3\",361),(\"N4\",361),(\"N5\",361),(\"N6\",361),(\"N7\",361),(\"N8\",361),(\"N9\",361),(\"N\",361),(\"N\",361),(\"N\",361),(\"N\",361),(\"N\",361),(\"N\",361),(\"N\",361),(\"Oa\",137),(\"Ob\",137),(\"Oc\",137),(\"Od\",137),(\"Oe\",137),(\"Of\",137),(\"Og\",137),(\"Oh\",137),(\"Oi\",137),(\"Oj\",137),(\"Ok\",137),(\"Ol\",137),(\"Om\",137),(\"On\",137),(\"Oo\",137),(\"Op\",137),(\"Oq\",137),(\"Or\",137),(\"Os\",137),(\"Ot\",137),(\"Ou\",137),(\"Ov\",137),(\"Ow\",137),(\"Ox\",137),(\"Oy\",137),(\"Oz\",137),(\"OA\",137),(\"OB\",137),(\"OC\",137),(\"OD\",137),(\"OE\",137),(\"OF\",137),(\"OG\",137),(\"OH\",137),(\"OI\",137),(\"OJ\",137),(\"OK\",137),(\"OL\",137),(\"OM\",137),(\"ON\",137),(\"OO\",137),(\"OP\",137),(\"OQ\",137),(\"OR\",137),(\"OS\",137),(\"OT\",137),(\"OU\",137),(\"OV\",137),(\"OW\",137),(\"OX\",137),(\"OY\",137),(\"OZ\",137),(\"O0\",137),(\"O1\",137),(\"O2\",137),(\"O3\",137),(\"O4\",137),(\"O5\",137),(\"O6\",137),(\"O7\",137),(\"O8\",137),(\"O9\",137),(\"O\",137),(\"O\",137),(\"O\",137),(\"O\",137),(\"O\",137),(\"O\",137),(\"O\",137),(\"Pa\",284),(\"Pb\",284),(\"Pc\",284),(\"Pd\",284),(\"Pe\",284),(\"Pf\",284),(\"Pg\",284),(\"Ph\",284),(\"Pi\",284),(\"Pj\",284),(\"Pk\",284),(\"Pl\",284),(\"Pm\",284),(\"Pn\",284),(\"Po\",284),(\"Pp\",284),(\"Pq\",284),(\"Pr\",284),(\"Ps\",284),(\"Pt\",284),(\"Pu\",284),(\"Pv\",284),(\"Pw\",284),(\"Px\",284),(\"Py\",284),(\"Pz\",284),(\"PA\",390),(\"PB\",284),(\"PC\",284),(\"PD\",284),(\"PE\",284),(\"PF\",284),(\"PG\",284),(\"PH\",284),(\"PI\",284),(\"PJ\",284),(\"PK\",284),(\"PL\",284),(\"PM\",284),(\"PN\",284),(\"PO\",284),(\"PP\",284),(\"PQ\",284),(\"PR\",284),(\"PS\",284),(\"PT\",284),(\"PU\",284),(\"PV\",284),(\"PW\",284),(\"PX\",284),(\"PY\",284),(\"PZ\",284),(\"P0\",284),(\"P1\",284),(\"P2\",284),(\"P3\",284),(\"P4\",284),(\"P5\",284),(\"P6\",284),(\"P7\",284),(\"P8\",284),(\"P9\",284),(\"P\",284),(\"P\",284),(\"P\",284),(\"P\",284),(\"P\",284),(\"P\",284),(\"P\",284),(\"Qa\",112),(\"Qb\",112),(\"Qc\",112),(\"Qd\",112),(\"Qe\",112),(\"Qf\",112),(\"Qg\",112),(\"Qh\",112),(\"Qi\",112),(\"Qj\",112),(\"Qk\",112),(\"Ql\",112),(\"Qm\",112),(\"Qn\",112),(\"Qo\",112),(\"Qp\",112),(\"Qq\",112),(\"Qr\",112),(\"Qs\",112),(\"Qt\",112),(\"Qu\",112),(\"Qv\",112),(\"Qw\",112),(\"Qx\",112),(\"Qy\",112),(\"Qz\",112),(\"QA\",112),(\"QB\",112),(\"QC\",112),(\"QD\",112),(\"QE\",112),(\"QF\",112),(\"QG\",112),(\"QH\",112),(\"QI\",112),(\"QJ\",112),(\"QK\",112),(\"QL\",112),(\"QM\",112),(\"QN\",112),(\"QO\",112),(\"QP\",112),(\"QQ\",112),(\"QR\",112),(\"QS\",112),(\"QT\",112),(\"QU\",112),(\"QV\",112),(\"QW\",112),(\"QX\",112),(\"QY\",112),(\"QZ\",112),(\"Q0\",112),(\"Q1\",112),(\"Q2\",112),(\"Q3\",112),(\"Q4\",112),(\"Q5\",112),(\"Q6\",112),(\"Q7\",112),(\"Q8\",112),(\"Q9\",112),(\"Q\",112),(\"Q\",112),(\"Q\",112),(\"Q\",112),(\"Q\",112),(\"Q\",112),(\"Q\",112),(\"Ra\",126),(\"Rb\",126),(\"Rc\",126),(\"Rd\",126),(\"Re\",126),(\"Rf\",126),(\"Rg\",126),(\"Rh\",126),(\"Ri\",126),(\"Rj\",126),(\"Rk\",126),(\"Rl\",126),(\"Rm\",126),(\"Rn\",126),(\"Ro\",126),(\"Rp\",126),(\"Rq\",126),(\"Rr\",126),(\"Rs\",126),(\"Rt\",126),(\"Ru\",126),(\"Rv\",126),(\"Rw\",126),(\"Rx\",126),(\"Ry\",126),(\"Rz\",126),(\"RA\",126),(\"RB\",126),(\"RC\",126),(\"RD\",126),(\"RE\",126),(\"RF\",126),(\"RG\",126),(\"RH\",126),(\"RI\",126),(\"RJ\",126),(\"RK\",126),(\"RL\",126),(\"RM\",126),(\"RN\",126),(\"RO\",126),(\"RP\",126),(\"RQ\",126),(\"RR\",126),(\"RS\",126),(\"RT\",-102),(\"RU\",126),(\"RV\",119),(\"RW\",119),(\"RX\",126),(\"RY\",88),(\"RZ\",126),(\"R0\",126),(\"R1\",126),(\"R2\",126),(\"R3\",126),(\"R4\",126),(\"R5\",126),(\"R6\",126),(\"R7\",126),(\"R8\",126),(\"R9\",126),(\"R\",126),(\"R\",126),(\"R\",126),(\"R\",126),(\"R\",126),(\"R\",126),(\"R\",126),(\"Sa\",98),(\"Sb\",98),(\"Sc\",98),(\"Sd\",98),(\"Se\",98),(\"Sf\",98),(\"Sg\",98),(\"Sh\",98),(\"Si\",98),(\"Sj\",98),(\"Sk\",98),(\"Sl\",98),(\"Sm\",98),(\"Sn\",98),(\"So\",98),(\"Sp\",98),(\"Sq\",98),(\"Sr\",98),(\"Ss\",98),(\"St\",98),(\"Su\",98),(\"Sv\",98),(\"Sw\",98),(\"Sx\",98),(\"Sy\",98),(\"Sz\",98),(\"SA\",98),(\"SB\",98),(\"SC\",98),(\"SD\",98),(\"SE\",98),(\"SF\",98),(\"SG\",98),(\"SH\",98),(\"SI\",98),(\"SJ\",98),(\"SK\",98),(\"SL\",98),(\"SM\",98),(\"SN\",98),(\"SO\",98),(\"SP\",98),(\"SQ\",98),(\"SR\",98),(\"SS\",98),(\"ST\",98),(\"SU\",98),(\"SV\",98),(\"SW\",98),(\"SX\",98),(\"SY\",98),(\"SZ\",98),(\"S0\",98),(\"S1\",98),(\"S2\",98),(\"S3\",98),(\"S4\",98),(\"S5\",98),(\"S6\",98),(\"S7\",98),(\"S8\",98),(\"S9\",98),(\"S\",98),(\"S\",98),(\"S\",98),(\"S\",98),(\"S\",98),(\"S\",98),(\"S\",98),(\"Ta\",407),(\"Tb\",439),(\"Tc\",383),(\"Td\",439),(\"Te\",404),(\"Tf\",439),(\"Tg\",439),(\"Th\",439),(\"Ti\",190),(\"Tj\",439),(\"Tk\",439),(\"Tl\",439),(\"Tm\",439),(\"Tn\",439),(\"To\",390),(\"Tp\",439),(\"Tq\",439),(\"Tr\",204),(\"Ts\",463),(\"Tt\",439),(\"Tu\",439),(\"Tv\",439),(\"Tw\",439),(\"Tx\",439),(\"Ty\",439),(\"Tz\",439),(\"TA\",488),(\"TB\",439),(\"TC\",439),(\"TD\",439),(\"TE\",439),(\"TF\",439),(\"TG\",439),(\"TH\",439),(\"TI\",439),(\"TJ\",439),(\"TK\",439),(\"TL\",439),(\"TM\",439),(\"TN\",439),(\"TO\",439),(\"TP\",439),(\"TQ\",439),(\"TR\",439),(\"TS\",439),(\"TT\",439),(\"TU\",439),(\"TV\",439),(\"TW\",439),(\"TX\",439),(\"TY\",439),(\"TZ\",439),(\"T0\",439),(\"T1\",439),(\"T2\",439),(\"T3\",439),(\"T4\",439),(\"T5\",439),(\"T6\",439),(\"T7\",439),(\"T8\",439),(\"T9\",439),(\"T\",439),(\"T\",439),(\"T\",439),(\"T\",439),(\"T\",439),(\"T\",439),(\"T\",439),(\"Ua\",428),(\"Ub\",428),(\"Uc\",428),(\"Ud\",428),(\"Ue\",428),(\"Uf\",428),(\"Ug\",428),(\"Uh\",428),(\"Ui\",428),(\"Uj\",428),(\"Uk\",428),(\"Ul\",428),(\"Um\",428),(\"Un\",428),(\"Uo\",428),(\"Up\",428),(\"Uq\",428),(\"Ur\",428),(\"Us\",428),(\"Ut\",428),(\"Uu\",428),(\"Uv\",428),(\"Uw\",428),(\"Ux\",428),(\"Uy\",428),(\"Uz\",428),(\"UA\",428),(\"UB\",428),(\"UC\",428),(\"UD\",428),(\"UE\",428),(\"UF\",428),(\"UG\",428),(\"UH\",428),(\"UI\",428),(\"UJ\",428),(\"UK\",428),(\"UL\",428),(\"UM\",428),(\"UN\",428),(\"UO\",428),(\"UP\",428),(\"UQ\",428),(\"UR\",428),(\"US\",428),(\"UT\",428),(\"UU\",428),(\"UV\",428),(\"UW\",428),(\"UX\",428),(\"UY\",428),(\"UZ\",428),(\"U0\",428),(\"U1\",428),(\"U2\",428),(\"U3\",428),(\"U4\",428),(\"U5\",428),(\"U6\",428),(\"U7\",428),(\"U8\",428),(\"U9\",428),(\"U\",428),(\"U\",428),(\"U\",428),(\"U\",428),(\"U\",428),(\"U\",428),(\"U\",428),(\"Va\",720),(\"Vb\",474),(\"Vc\",474),(\"Vd\",474),(\"Ve\",720),(\"Vf\",474),(\"Vg\",474),(\"Vh\",474),(\"Vi\",463),(\"Vj\",474),(\"Vk\",474),(\"Vl\",474),(\"Vm\",474),(\"Vn\",474),(\"Vo\",720),(\"Vp\",474),(\"Vq\",474),(\"Vr\",544),(\"Vs\",474),(\"Vt\",474),(\"Vu\",509),(\"Vv\",474),(\"Vw\",474),(\"Vx\",474),(\"Vy\",523),(\"Vz\",474),(\"VA\",720),(\"VB\",474),(\"VC\",474),(\"VD\",474),(\"VE\",474),(\"VF\",474),(\"VG\",474),(\"VH\",474),(\"VI\",474),(\"VJ\",474),(\"VK\",474),(\"VL\",474),(\"VM\",474),(\"VN\",474),(\"VO\",474),(\"VP\",474),(\"VQ\",474),(\"VR\",474),(\"VS\",474),(\"VT\",474),(\"VU\",474),(\"VV\",474),(\"VW\",474),(\"VX\",474),(\"VY\",474),(\"VZ\",474),(\"V0\",474),(\"V1\",474),(\"V2\",474),(\"V3\",474),(\"V4\",474),(\"V5\",474),(\"V6\",474),(\"V7\",474),(\"V8\",474),(\"V9\",474),(\"V\",474),(\"V\",474),(\"V\",474),(\"V\",474),(\"V\",474),(\"V\",474),(\"V\",474),(\"Wa\",684),(\"Wb\",474),(\"Wc\",474),(\"Wd\",474),(\"We\",684),(\"Wf\",474),(\"Wg\",474),(\"Wh\",474),(\"Wi\",463),(\"Wj\",474),(\"Wk\",474),(\"Wl\",474),(\"Wm\",474),(\"Wn\",474),(\"Wo\",684),(\"Wp\",474),(\"Wq\",474),(\"Wr\",579),(\"Ws\",474),(\"Wt\",474),(\"Wu\",544),(\"Wv\",474),(\"Ww\",474),(\"Wx\",474),(\"Wy\",523),(\"Wz\",474),(\"WA\",684),(\"WB\",474),(\"WC\",474),(\"WD\",474),(\"WE\",474),(\"WF\",474),(\"WG\",474),(\"WH\",474),(\"WI\",474),(\"WJ\",474),(\"WK\",474),(\"WL\",474),(\"WM\",474),(\"WN\",474),(\"WO\",474),(\"WP\",474),(\"WQ\",474),(\"WR\",474),(\"WS\",474),(\"WT\",474),(\"WU\",474),(\"WV\",474),(\"WW\",474),(\"WX\",474),(\"WY\",474),(\"WZ\",474),(\"W0\",474),(\"W1\",474),(\"W2\",474),(\"W3\",474),(\"W4\",474),(\"W5\",474),(\"W6\",474),(\"W7\",474),(\"W8\",474),(\"W9\",474),(\"W\",474),(\"W\",474),(\"W\",474),(\"W\",474),(\"W\",474),(\"W\",474),(\"W\",474),(\"Xa\",404),(\"Xb\",404),(\"Xc\",404),(\"Xd\",404),(\"Xe\",404),(\"Xf\",404),(\"Xg\",404),(\"Xh\",404),(\"Xi\",404),(\"Xj\",404),(\"Xk\",404),(\"Xl\",404),(\"Xm\",404),(\"Xn\",404),(\"Xo\",404),(\"Xp\",404),(\"Xq\",404),(\"Xr\",404),(\"Xs\",404),(\"Xt\",404),(\"Xu\",404),(\"Xv\",404),(\"Xw\",404),(\"Xx\",404),(\"Xy\",404),(\"Xz\",404),(\"XA\",404),(\"XB\",404),(\"XC\",404),(\"XD\",404),(\"XE\",404),(\"XF\",404),(\"XG\",404),(\"XH\",404),(\"XI\",404),(\"XJ\",404),(\"XK\",404),(\"XL\",404),(\"XM\",404),(\"XN\",404),(\"XO\",404),(\"XP\",404),(\"XQ\",404),(\"XR\",404),(\"XS\",404),(\"XT\",404),(\"XU\",404),(\"XV\",404),(\"XW\",404),(\"XX\",404),(\"XY\",404),(\"XZ\",404),(\"X0\",404),(\"X1\",404),(\"X2\",404),(\"X3\",404),(\"X4\",404),(\"X5\",404),(\"X6\",404),(\"X7\",404),(\"X8\",404),(\"X9\",404),(\"X\",404),(\"X\",404),(\"X\",404),(\"X\",404),(\"X\",404),(\"X\",404),(\"X\",404),(\"Ya\",800),(\"Yb\",523),(\"Yc\",523),(\"Yd\",523),(\"Ye\",797),(\"Yf\",523),(\"Yg\",523),(\"Yh\",523),(\"Yi\",562),(\"Yj\",523),(\"Yk\",523),(\"Yl\",523),(\"Ym\",523),(\"Yn\",523),(\"Yo\",786),(\"Yp\",653),(\"Yq\",776),(\"Yr\",523),(\"Ys\",523),(\"Yt\",523),(\"Yu\",632),(\"Yv\",590),(\"Yw\",523),(\"Yx\",523),(\"Yy\",523),(\"Yz\",523),(\"YA\",811),(\"YB\",523),(\"YC\",523),(\"YD\",523),(\"YE\",523),(\"YF\",523),(\"YG\",523),(\"YH\",523),(\"YI\",523),(\"YJ\",523),(\"YK\",523),(\"YL\",523),(\"YM\",523),(\"YN\",523),(\"YO\",523),(\"YP\",523),(\"YQ\",523),(\"YR\",523),(\"YS\",523),(\"YT\",523),(\"YU\",523),(\"YV\",523),(\"YW\",523),(\"YX\",523),(\"YY\",523),(\"YZ\",523),(\"Y0\",523),(\"Y1\",523),(\"Y2\",523),(\"Y3\",523),(\"Y4\",523),(\"Y5\",523),(\"Y6\",523),(\"Y7\",523),(\"Y8\",523),(\"Y9\",523),(\"Y\",523),(\"Y\",523),(\"Y\",523),(\"Y\",523),(\"Y\",523),(\"Y\",523),(\"Y\",523),(\"Za\",404),(\"Zb\",404),(\"Zc\",404),(\"Zd\",404),(\"Ze\",404),(\"Zf\",404),(\"Zg\",404),(\"Zh\",404),(\"Zi\",404),(\"Zj\",404),(\"Zk\",404),(\"Zl\",404),(\"Zm\",404),(\"Zn\",404),(\"Zo\",404),(\"Zp\",404),(\"Zq\",404),(\"Zr\",404),(\"Zs\",404),(\"Zt\",404),(\"Zu\",404),(\"Zv\",404),(\"Zw\",404),(\"Zx\",404),(\"Zy\",404),(\"Zz\",404),(\"ZA\",404),(\"ZB\",404),(\"ZC\",404),(\"ZD\",404),(\"ZE\",404),(\"ZF\",404),(\"ZG\",404),(\"ZH\",404),(\"ZI\",404),(\"ZJ\",404),(\"ZK\",404),(\"ZL\",404),(\"ZM\",404),(\"ZN\",404),(\"ZO\",404),(\"ZP\",404),(\"ZQ\",404),(\"ZR\",404),(\"ZS\",404),(\"ZT\",404),(\"ZU\",404),(\"ZV\",404),(\"ZW\",404),(\"ZX\",404),(\"ZY\",404),(\"ZZ\",404),(\"Z0\",404),(\"Z1\",404),(\"Z2\",404),(\"Z3\",404),(\"Z4\",404),(\"Z5\",404),(\"Z6\",404),(\"Z7\",404),(\"Z8\",404),(\"Z9\",404),(\"Z\",404),(\"Z\",404),(\"Z\",404),(\"Z\",404),(\"Z\",404),(\"Z\",404),(\"Z\",404),(\"0a\",91),(\"0b\",91),(\"0c\",91),(\"0d\",91),(\"0e\",91),(\"0f\",91),(\"0g\",91),(\"0h\",91),(\"0i\",91),(\"0j\",91),(\"0k\",91),(\"0l\",91),(\"0m\",91),(\"0n\",91),(\"0o\",91),(\"0p\",91),(\"0q\",91),(\"0r\",91),(\"0s\",91),(\"0t\",91),(\"0u\",91),(\"0v\",91),(\"0w\",91),(\"0x\",91),(\"0y\",91),(\"0z\",91),(\"0A\",91),(\"0B\",91),(\"0C\",91),(\"0D\",91),(\"0E\",91),(\"0F\",91),(\"0G\",91),(\"0H\",91),(\"0I\",91),(\"0J\",91),(\"0K\",91),(\"0L\",91),(\"0M\",91),(\"0N\",91),(\"0O\",91),(\"0P\",91),(\"0Q\",91),(\"0R\",91),(\"0S\",91),(\"0T\",91),(\"0U\",91),(\"0V\",91),(\"0W\",91),(\"0X\",91),(\"0Y\",91),(\"0Z\",91),(\"00\",91),(\"01\",91),(\"02\",91),(\"03\",91),(\"04\",91),(\"05\",91),(\"06\",91),(\"07\",91),(\"08\",91),(\"09\",91),(\"0\",91),(\"0\",91),(\"0\",91),(\"0\",91),(\"0\",91),(\"0\",91),(\"0\",91),(\"1a\",0),(\"1b\",0),(\"1c\",0),(\"1d\",0),(\"1e\",0),(\"1f\",0),(\"1g\",0),(\"1h\",0),(\"1i\",0),(\"1j\",0),(\"1k\",0),(\"1l\",0),(\"1m\",0),(\"1n\",0),(\"1o\",0),(\"1p\",0),(\"1q\",0),(\"1r\",0),(\"1s\",0),(\"1t\",0),(\"1u\",0),(\"1v\",0),(\"1w\",0),(\"1x\",0),(\"1y\",0),(\"1z\",0),(\"1A\",0),(\"1B\",0),(\"1C\",0),(\"1D\",0),(\"1E\",0),(\"1F\",0),(\"1G\",0),(\"1H\",0),(\"1I\",0),(\"1J\",0),(\"1K\",0),(\"1L\",0),(\"1M\",0),(\"1N\",0),(\"1O\",0),(\"1P\",0),(\"1Q\",0),(\"1R\",0),(\"1S\",0),(\"1T\",0),(\"1U\",0),(\"1V\",0),(\"1W\",0),(\"1X\",0),(\"1Y\",0),(\"1Z\",0),(\"10\",0),(\"11\",0),(\"12\",0),(\"13\",0),(\"14\",0),(\"15\",0),(\"16\",0),(\"17\",0),(\"18\",0),(\"19\",0),(\"1\",0),(\"1\",0),(\"1\",0),(\"1\",0),(\"1\",0),(\"1\",0),(\"1\",0),(\"2a\",56),(\"2b\",56),(\"2c\",56),(\"2d\",56),(\"2e\",56),(\"2f\",56),(\"2g\",56),(\"2h\",56),(\"2i\",56),(\"2j\",56),(\"2k\",56),(\"2l\",56),(\"2m\",56),(\"2n\",56),(\"2o\",56),(\"2p\",56),(\"2q\",56),(\"2r\",56),(\"2s\",56),(\"2t\",56),(\"2u\",56),(\"2v\",56),(\"2w\",56),(\"2x\",56),(\"2y\",56),(\"2z\",56),(\"2A\",56),(\"2B\",56),(\"2C\",56),(\"2D\",56),(\"2E\",56),(\"2F\",56),(\"2G\",56),(\"2H\",56),(\"2I\",56),(\"2J\",56),(\"2K\",56),(\"2L\",56),(\"2M\",56),(\"2N\",56),(\"2O\",56),(\"2P\",56),(\"2Q\",56),(\"2R\",56),(\"2S\",56),(\"2T\",56),(\"2U\",56),(\"2V\",56),(\"2W\",56),(\"2X\",56),(\"2Y\",56),(\"2Z\",56),(\"20\",56),(\"21\",56),(\"22\",56),(\"23\",56),(\"24\",56),(\"25\",56),(\"26\",56),(\"27\",56),(\"28\",56),(\"29\",56),(\"2\",56),(\"2\",56),(\"2\",56),(\"2\",56),(\"2\",56),(\"2\",56),(\"2\",56),(\"3a\",7),(\"3b\",7),(\"3c\",7),(\"3d\",7),(\"3e\",7),(\"3f\",7),(\"3g\",7),(\"3h\",7),(\"3i\",7),(\"3j\",7),(\"3k\",7),(\"3l\",7),(\"3m\",7),(\"3n\",7),(\"3o\",7),(\"3p\",7),(\"3q\",7),(\"3r\",7),(\"3s\",7),(\"3t\",7),(\"3u\",7),(\"3v\",7),(\"3w\",7),(\"3x\",7),(\"3y\",7),(\"3z\",7),(\"3A\",7),(\"3B\",7),(\"3C\",7),(\"3D\",7),(\"3E\",7),(\"3F\",7),(\"3G\",7),(\"3H\",7),(\"3I\",7),(\"3J\",7),(\"3K\",7),(\"3L\",7),(\"3M\",7),(\"3N\",7),(\"3O\",7),(\"3P\",7),(\"3Q\",7),(\"3R\",7),(\"3S\",7),(\"3T\",7),(\"3U\",7),(\"3V\",7),(\"3W\",7),(\"3X\",7),(\"3Y\",7),(\"3Z\",7),(\"30\",7),(\"31\",7),(\"32\",7),(\"33\",7),(\"34\",7),(\"35\",7),(\"36\",7),(\"37\",7),(\"38\",7),(\"39\",7),(\"3\",7),(\"3\",7),(\"3\",7),(\"3\",7),(\"3\",7),(\"3\",7),(\"3\",7),(\"4a\",49),(\"4b\",49),(\"4c\",49),(\"4d\",49),(\"4e\",49),(\"4f\",49),(\"4g\",49),(\"4h\",49),(\"4i\",49),(\"4j\",49),(\"4k\",49),(\"4l\",49),(\"4m\",49),(\"4n\",49),(\"4o\",49),(\"4p\",49),(\"4q\",49),(\"4r\",49),(\"4s\",49),(\"4t\",49),(\"4u\",49),(\"4v\",49),(\"4w\",49),(\"4x\",49),(\"4y\",49),(\"4z\",49),(\"4A\",49),(\"4B\",49),(\"4C\",49),(\"4D\",49),(\"4E\",49),(\"4F\",49),(\"4G\",49),(\"4H\",49),(\"4I\",49),(\"4J\",49),(\"4K\",49),(\"4L\",49),(\"4M\",49),(\"4N\",49),(\"4O\",49),(\"4P\",49),(\"4Q\",49),(\"4R\",49),(\"4S\",49),(\"4T\",49),(\"4U\",49),(\"4V\",49),(\"4W\",49),(\"4X\",49),(\"4Y\",49),(\"4Z\",49),(\"40\",49),(\"41\",49),(\"42\",49),(\"43\",49),(\"44\",49),(\"45\",49),(\"46\",49),(\"47\",49),(\"48\",49),(\"49\",49),(\"4\",49),(\"4\",49),(\"4\",49),(\"4\",49),(\"4\",49),(\"4\",49),(\"4\",49),(\"5a\",0),(\"5b\",0),(\"5c\",0),(\"5d\",0),(\"5e\",0),(\"5f\",0),(\"5g\",0),(\"5h\",0),(\"5i\",0),(\"5j\",0),(\"5k\",0),(\"5l\",0),(\"5m\",0),(\"5n\",0),(\"5o\",0),(\"5p\",0),(\"5q\",0),(\"5r\",0),(\"5s\",0),(\"5t\",0),(\"5u\",0),(\"5v\",0),(\"5w\",0),(\"5x\",0),(\"5y\",0),(\"5z\",0),(\"5A\",0),(\"5B\",0),(\"5C\",0),(\"5D\",0),(\"5E\",0),(\"5F\",0),(\"5G\",0),(\"5H\",0),(\"5I\",0),(\"5J\",0),(\"5K\",0),(\"5L\",0),(\"5M\",0),(\"5N\",0),(\"5O\",0),(\"5P\",0),(\"5Q\",0),(\"5R\",0),(\"5S\",0),(\"5T\",0),(\"5U\",0),(\"5V\",0),(\"5W\",0),(\"5X\",0),(\"5Y\",0),(\"5Z\",0),(\"50\",0),(\"51\",0),(\"52\",0),(\"53\",0),(\"54\",0),(\"55\",0),(\"56\",0),(\"57\",0),(\"58\",0),(\"59\",0),(\"5\",0),(\"5\",0),(\"5\",0),(\"5\",0),(\"5\",0),(\"5\",0),(\"5\",0),(\"6a\",132),(\"6b\",132),(\"6c\",132),(\"6d\",132),(\"6e\",132),(\"6f\",132),(\"6g\",132),(\"6h\",132),(\"6i\",132),(\"6j\",132),(\"6k\",132),(\"6l\",132),(\"6m\",132),(\"6n\",132),(\"6o\",132),(\"6p\",132),(\"6q\",132),(\"6r\",132),(\"6s\",132),(\"6t\",132),(\"6u\",132),(\"6v\",132),(\"6w\",132),(\"6x\",132),(\"6y\",132),(\"6z\",132),(\"6A\",132),(\"6B\",132),(\"6C\",132),(\"6D\",132),(\"6E\",132),(\"6F\",132),(\"6G\",132),(\"6H\",132),(\"6I\",132),(\"6J\",132),(\"6K\",132),(\"6L\",132),(\"6M\",132),(\"6N\",132),(\"6O\",132),(\"6P\",132),(\"6Q\",132),(\"6R\",132),(\"6S\",132),(\"6T\",132),(\"6U\",132),(\"6V\",132),(\"6W\",132),(\"6X\",132),(\"6Y\",132),(\"6Z\",132),(\"60\",132),(\"61\",132),(\"62\",132),(\"63\",132),(\"64\",132),(\"65\",132),(\"66\",132),(\"67\",132),(\"68\",132),(\"69\",132),(\"6\",132),(\"6\",132),(\"6\",132),(\"6\",132),(\"6\",132),(\"6\",132),(\"6\",132),(\"7a\",184),(\"7b\",184),(\"7c\",184),(\"7d\",184),(\"7e\",184),(\"7f\",184),(\"7g\",184),(\"7h\",184),(\"7i\",184),(\"7j\",184),(\"7k\",184),(\"7l\",184),(\"7m\",184),(\"7n\",184),(\"7o\",184),(\"7p\",184),(\"7q\",184),(\"7r\",184),(\"7s\",184),(\"7t\",184),(\"7u\",184),(\"7v\",184),(\"7w\",184),(\"7x\",184),(\"7y\",184),(\"7z\",184),(\"7A\",184),(\"7B\",184),(\"7C\",184),(\"7D\",184),(\"7E\",184),(\"7F\",184),(\"7G\",184),(\"7H\",184),(\"7I\",184),(\"7J\",184),(\"7K\",184),(\"7L\",184),(\"7M\",184),(\"7N\",184),(\"7O\",184),(\"7P\",184),(\"7Q\",184),(\"7R\",184),(\"7S\",184),(\"7T\",184),(\"7U\",184),(\"7V\",184),(\"7W\",184),(\"7X\",184),(\"7Y\",184),(\"7Z\",184),(\"70\",184),(\"71\",184),(\"72\",184),(\"73\",184),(\"74\",184),(\"75\",184),(\"76\",184),(\"77\",184),(\"78\",184),(\"79\",184),(\"7\",184),(\"7\",184),(\"7\",184),(\"7\",184),(\"7\",184),(\"7\",184),(\"7\",184),(\"8a\",123),(\"8b\",123),(\"8c\",123),(\"8d\",123),(\"8e\",123),(\"8f\",123),(\"8g\",123),(\"8h\",123),(\"8i\",123),(\"8j\",123),(\"8k\",123),(\"8l\",123),(\"8m\",123),(\"8n\",123),(\"8o\",123),(\"8p\",123),(\"8q\",123),(\"8r\",123),(\"8s\",123),(\"8t\",123),(\"8u\",123),(\"8v\",123),(\"8w\",123),(\"8x\",123),(\"8y\",123),(\"8z\",123),(\"8A\",123),(\"8B\",123),(\"8C\",123),(\"8D\",123),(\"8E\",123),(\"8F\",123),(\"8G\",123),(\"8H\",123),(\"8I\",123),(\"8J\",123),(\"8K\",123),(\"8L\",123),(\"8M\",123),(\"8N\",123),(\"8O\",123),(\"8P\",123),(\"8Q\",123),(\"8R\",123),(\"8S\",123),(\"8T\",123),(\"8U\",123),(\"8V\",123),(\"8W\",123),(\"8X\",123),(\"8Y\",123),(\"8Z\",123),(\"80\",123),(\"81\",123),(\"82\",123),(\"83\",123),(\"84\",123),(\"85\",123),(\"86\",123),(\"87\",123),(\"88\",123),(\"89\",123),(\"8\",123),(\"8\",123),(\"8\",123),(\"8\",123),(\"8\",123),(\"8\",123),(\"8\",123),(\"9a\",102),(\"9b\",102),(\"9c\",102),(\"9d\",102),(\"9e\",102),(\"9f\",102),(\"9g\",102),(\"9h\",102),(\"9i\",102),(\"9j\",102),(\"9k\",102),(\"9l\",102),(\"9m\",102),(\"9n\",102),(\"9o\",102),(\"9p\",102),(\"9q\",102),(\"9r\",102),(\"9s\",102),(\"9t\",102),(\"9u\",102),(\"9v\",102),(\"9w\",102),(\"9x\",102),(\"9y\",102),(\"9z\",102),(\"9A\",102),(\"9B\",102),(\"9C\",102),(\"9D\",102),(\"9E\",102),(\"9F\",102),(\"9G\",102),(\"9H\",102),(\"9I\",102),(\"9J\",102),(\"9K\",102),(\"9L\",102),(\"9M\",102),(\"9N\",102),(\"9O\",102),(\"9P\",102),(\"9Q\",102),(\"9R\",102),(\"9S\",102),(\"9T\",102),(\"9U\",102),(\"9V\",102),(\"9W\",102),(\"9X\",102),(\"9Y\",102),(\"9Z\",102),(\"90\",102),(\"91\",102),(\"92\",102),(\"93\",102),(\"94\",102),(\"95\",102),(\"96\",102),(\"97\",102),(\"98\",102),(\"99\",102),(\"9\",102),(\"9\",102),(\"9\",102),(\"9\",102),(\"9\",102),(\"9\",102),(\"9\",102),(\"a\",0),(\"b\",0),(\"c\",0),(\"d\",0),(\"e\",0),(\"f\",0),(\"g\",0),(\"h\",0),(\"i\",0),(\"j\",0),(\"k\",0),(\"l\",0),(\"m\",0),(\"n\",0),(\"o\",0),(\"p\",0),(\"q\",0),(\"r\",0),(\"s\",0),(\"t\",0),(\"u\",0),(\"v\",0),(\"w\",0),(\"x\",0),(\"y\",0),(\"z\",0),(\"A\",0),(\"B\",0),(\"C\",0),(\"D\",0),(\"E\",0),(\"F\",0),(\"G\",0),(\"H\",0),(\"I\",0),(\"J\",0),(\"K\",0),(\"L\",0),(\"M\",0),(\"N\",0),(\"O\",0),(\"P\",0),(\"Q\",0),(\"R\",0),(\"S\",0),(\"T\",0),(\"U\",0),(\"V\",0),(\"W\",0),(\"X\",0),(\"Y\",0),(\"Z\",0),(\"0\",0),(\"1\",0),(\"2\",0),(\"3\",0),(\"4\",0),(\"5\",0),(\"6\",0),(\"7\",0),(\"8\",0),(\"9\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"a\",0),(\"b\",0),(\"c\",0),(\"d\",0),(\"e\",0),(\"f\",0),(\"g\",0),(\"h\",0),(\"i\",0),(\"j\",0),(\"k\",0),(\"l\",0),(\"m\",0),(\"n\",0),(\"o\",0),(\"p\",0),(\"q\",0),(\"r\",0),(\"s\",0),(\"t\",0),(\"u\",0),(\"v\",0),(\"w\",0),(\"x\",0),(\"y\",0),(\"z\",0),(\"A\",0),(\"B\",0),(\"C\",0),(\"D\",0),(\"E\",0),(\"F\",0),(\"G\",0),(\"H\",0),(\"I\",0),(\"J\",0),(\"K\",0),(\"L\",0),(\"M\",0),(\"N\",0),(\"O\",0),(\"P\",0),(\"Q\",0),(\"R\",0),(\"S\",0),(\"T\",0),(\"U\",0),(\"V\",0),(\"W\",0),(\"X\",0),(\"Y\",0),(\"Z\",0),(\"0\",0),(\"1\",0),(\"2\",0),(\"3\",0),(\"4\",0),(\"5\",0),(\"6\",0),(\"7\",0),(\"8\",0),(\"9\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"a\",0),(\"b\",0),(\"c\",0),(\"d\",0),(\"e\",0),(\"f\",0),(\"g\",0),(\"h\",0),(\"i\",0),(\"j\",0),(\"k\",0),(\"l\",0),(\"m\",0),(\"n\",0),(\"o\",0),(\"p\",0),(\"q\",0),(\"r\",0),(\"s\",0),(\"t\",0),(\"u\",0),(\"v\",0),(\"w\",0),(\"x\",0),(\"y\",0),(\"z\",0),(\"A\",0),(\"B\",0),(\"C\",0),(\"D\",0),(\"E\",0),(\"F\",0),(\"G\",0),(\"H\",0),(\"I\",0),(\"J\",0),(\"K\",0),(\"L\",0),(\"M\",0),(\"N\",0),(\"O\",0),(\"P\",0),(\"Q\",0),(\"R\",0),(\"S\",0),(\"T\",0),(\"U\",0),(\"V\",0),(\"W\",0),(\"X\",0),(\"Y\",0),(\"Z\",0),(\"0\",0),(\"1\",0),(\"2\",0),(\"3\",0),(\"4\",0),(\"5\",0),(\"6\",0),(\"7\",0),(\"8\",0),(\"9\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"a\",0),(\"b\",0),(\"c\",0),(\"d\",0),(\"e\",0),(\"f\",0),(\"g\",0),(\"h\",0),(\"i\",0),(\"j\",0),(\"k\",0),(\"l\",0),(\"m\",0),(\"n\",0),(\"o\",0),(\"p\",0),(\"q\",0),(\"r\",0),(\"s\",0),(\"t\",0),(\"u\",0),(\"v\",0),(\"w\",0),(\"x\",0),(\"y\",0),(\"z\",0),(\"A\",0),(\"B\",0),(\"C\",0),(\"D\",0),(\"E\",0),(\"F\",0),(\"G\",0),(\"H\",0),(\"I\",0),(\"J\",0),(\"K\",0),(\"L\",0),(\"M\",0),(\"N\",0),(\"O\",0),(\"P\",0),(\"Q\",0),(\"R\",0),(\"S\",0),(\"T\",0),(\"U\",0),(\"V\",0),(\"W\",0),(\"X\",0),(\"Y\",0),(\"Z\",0),(\"0\",0),(\"1\",0),(\"2\",0),(\"3\",0),(\"4\",0),(\"5\",0),(\"6\",0),(\"7\",0),(\"8\",0),(\"9\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"a\",0),(\"b\",0),(\"c\",0),(\"d\",0),(\"e\",0),(\"f\",0),(\"g\",0),(\"h\",0),(\"i\",0),(\"j\",0),(\"k\",0),(\"l\",0),(\"m\",0),(\"n\",0),(\"o\",0),(\"p\",0),(\"q\",0),(\"r\",0),(\"s\",0),(\"t\",0),(\"u\",0),(\"v\",0),(\"w\",0),(\"x\",0),(\"y\",0),(\"z\",0),(\"A\",0),(\"B\",0),(\"C\",0),(\"D\",0),(\"E\",0),(\"F\",0),(\"G\",0),(\"H\",0),(\"I\",0),(\"J\",0),(\"K\",0),(\"L\",0),(\"M\",0),(\"N\",0),(\"O\",0),(\"P\",0),(\"Q\",0),(\"R\",0),(\"S\",0),(\"T\",0),(\"U\",0),(\"V\",0),(\"W\",0),(\"X\",0),(\"Y\",0),(\"Z\",0),(\"0\",0),(\"1\",0),(\"2\",0),(\"3\",0),(\"4\",0),(\"5\",0),(\"6\",0),(\"7\",0),(\"8\",0),(\"9\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"a\",0),(\"b\",0),(\"c\",0),(\"d\",0),(\"e\",0),(\"f\",0),(\"g\",0),(\"h\",0),(\"i\",0),(\"j\",0),(\"k\",0),(\"l\",0),(\"m\",0),(\"n\",0),(\"o\",0),(\"p\",0),(\"q\",0),(\"r\",0),(\"s\",0),(\"t\",0),(\"u\",0),(\"v\",0),(\"w\",0),(\"x\",0),(\"y\",0),(\"z\",0),(\"A\",0),(\"B\",0),(\"C\",0),(\"D\",0),(\"E\",0),(\"F\",0),(\"G\",0),(\"H\",0),(\"I\",0),(\"J\",0),(\"K\",0),(\"L\",0),(\"M\",0),(\"N\",0),(\"O\",0),(\"P\",0),(\"Q\",0),(\"R\",0),(\"S\",0),(\"T\",0),(\"U\",0),(\"V\",0),(\"W\",0),(\"X\",0),(\"Y\",0),(\"Z\",0),(\"0\",0),(\"1\",0),(\"2\",0),(\"3\",0),(\"4\",0),(\"5\",0),(\"6\",0),(\"7\",0),(\"8\",0),(\"9\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"\",0),(\"a\",116),(\"b\",116),(\"c\",116),(\"d\",116),(\"e\",116),(\"f\",116),(\"g\",116),(\"h\",116),(\"i\",116),(\"j\",116),(\"k\",116),(\"l\",116),(\"m\",116),(\"n\",116),(\"o\",116),(\"p\",116),(\"q\",116),(\"r\",116),(\"s\",116),(\"t\",116),(\"u\",116),(\"v\",116),(\"w\",116),(\"x\",116),(\"y\",116),(\"z\",116),(\"A\",116),(\"B\",116),(\"C\",116),(\"D\",116),(\"E\",116),(\"F\",116),(\"G\",116),(\"H\",116),(\"I\",116),(\"J\",116),(\"K\",116),(\"L\",116),(\"M\",116),(\"N\",116),(\"O\",116),(\"P\",116),(\"Q\",116),(\"R\",116),(\"S\",116),(\"T\",116),(\"U\",116),(\"V\",116),(\"W\",116),(\"X\",116),(\"Y\",116),(\"Z\",116),(\"0\",116),(\"1\",116),(\"2\",116),(\"3\",116),(\"4\",116),(\"5\",116),(\"6\",116),(\"7\",116),(\"8\",116),(\"9\",116),(\"\",116),(\"\",116),(\"\",116),(\"\",116),(\"\",116),(\"\",116),(\"\",116)]"
