{- Generated by DrIFT (Automatic class derivations for Haskell) -}
{-# LINE 1 "Syntax/AS_Library.der.hs" #-}
{-| 
   
Module      :  $Header: /repository/caslbook/lncs2960-CD/Tools/Hets/src/Syntax/AS_Library.hs,v 1.1 2004/02/13 14:50:49 5maeder Exp $
Copyright   :  (c) Klaus Lttich, Uni Bremen 2002-2004
Licence     :  similar to LGPL, see HetCATS/LICENCE.txt or LIZENZ.txt

Maintainer  :  hets@tzi.de
Stability   :  provisional
Portability :  non-portable(Grothendieck)

   These data structures describe the abstract syntax tree for heterogenous 
   structured specifications in HetCASL.

-}
{-
   todo:
     - ATermConversion SML-CATS has now his own module 
       (s. HetCATS/aterm_conv/)
     - LaTeX Pretty Printing
-}

module Syntax.AS_Library where

-- DrIFT command:
{-! global: UpPos !-}

import Common.Id
import Common.AS_Annotation

import qualified Syntax.AS_Architecture
import qualified Syntax.AS_Structured


data LIB_DEFN = Lib_defn LIB_NAME [Annoted LIB_ITEM] [Pos] [Annotation]
	        -- pos: "library"
	        -- list of annotations is parsed preceding the first LIB_ITEM
	        -- the last LIB_ITEM may be annotated with a following comment
	        -- the first LIB_ITEM cannot be annotated
		deriving (Show)

{- for information on the list of Pos see the documentation in
   AS_Structured.hs and AS_Architecture.hs -}

data LIB_ITEM = Spec_defn Syntax.AS_Structured.SPEC_NAME 
		          Syntax.AS_Structured.GENERICITY 
                          (Annoted Syntax.AS_Structured.SPEC) 
			  [Pos]
	      
	      | View_defn Syntax.AS_Structured.VIEW_NAME 
		          Syntax.AS_Structured.GENERICITY 
			  Syntax.AS_Structured.VIEW_TYPE 
			  [Syntax.AS_Structured.G_mapping]
			  [Pos]

	      | Arch_spec_defn Syntax.AS_Architecture.ARCH_SPEC_NAME 
		               (Annoted Syntax.AS_Architecture.ARCH_SPEC) 
			       [Pos]

	      | Unit_spec_defn Syntax.AS_Structured.SPEC_NAME 
		               Syntax.AS_Architecture.UNIT_SPEC 
			       [Pos]

	      | Download_items  LIB_NAME [ITEM_NAME_OR_MAP] [Pos] 
		-- pos: "from","get",commas, opt "end"
	      | Logic_decl Syntax.AS_Structured.Logic_name [Pos]
		-- pos:  "logic", Logic_name
		deriving (Show)

data ITEM_NAME_OR_MAP = Item_name ITEM_NAME 
		      | Item_name_map ITEM_NAME ITEM_NAME [Pos]
			-- pos: "|->"
			deriving (Show,Eq)

type ITEM_NAME = SIMPLE_ID

data LIB_NAME = Lib_version LIB_ID VERSION_NUMBER
	      | Lib_id LIB_ID

data LIB_ID = Direct_link URL [Pos]
	      -- pos: start of URL
	    | Indirect_link PATH [Pos]
	      -- pos: start of PATH



data VERSION_NUMBER = Version_number [String] [Pos]
		      -- pos: "version", start of first string
		      deriving (Show,Eq) 

type URL = String
type PATH = String


instance Show LIB_ID where
  show (Direct_link s1 _) = s1
  show (Indirect_link s1 _) = s1

instance Show LIB_NAME where
  show (Lib_version libid _) = show libid
  show (Lib_id libid) = show libid

instance Eq LIB_ID where
  Direct_link s1 _ == Direct_link s2 _ = s1==s2
  Indirect_link s1 _ == Indirect_link s2 _ = s1==s2
  _ == _ = False

instance Ord LIB_ID where
  Direct_link s1 _ <= Direct_link s2 _ = s1<=s2
  Indirect_link s1 _ <= Indirect_link s2 _ = s1<=s2
  Direct_link _ _ <= _ = True
  Indirect_link _ _ <= _ = False

getLIB_ID :: LIB_NAME -> LIB_ID
getLIB_ID (Lib_version libid _) = libid
getLIB_ID (Lib_id libid) = libid

instance Eq LIB_NAME where
  ln1 == ln2 = getLIB_ID ln1 == getLIB_ID ln2
  
instance Ord LIB_NAME where
  ln1 <= ln2 = getLIB_ID ln1 <= getLIB_ID ln2

-- functions for casts
cast_S_L_Spec_defn :: Syntax.AS_Structured.SPEC_DEFN -> LIB_ITEM 
cast_L_S_Spec_defn :: LIB_ITEM  -> Syntax.AS_Structured.SPEC_DEFN

cast_S_L_Spec_defn (Syntax.AS_Structured.Spec_defn x y z p) = 
    (Syntax.AS_Library.Spec_defn x y z p) 
cast_S_L_Spec_defn _ = error "wrong constructor for \"cast_S_L_Spec_defn\""

cast_L_S_Spec_defn (Syntax.AS_Library.Spec_defn x y z p) =
    (Syntax.AS_Structured.Spec_defn x y z p)
cast_L_S_Spec_defn _ = error "wrong constructor for \"cast_L_S_Spec_defn\""

cast_S_L_View_defn :: Syntax.AS_Structured.VIEW_DEFN -> LIB_ITEM 
cast_L_S_View_defn :: LIB_ITEM  -> Syntax.AS_Structured.VIEW_DEFN

cast_S_L_View_defn (Syntax.AS_Structured.View_defn w x y z p) = 
    (Syntax.AS_Library.View_defn w x y z p) 
cast_S_L_View_defn _ = error "wrong constructor for \"cast_S_L_View_defn\""

cast_L_S_View_defn (Syntax.AS_Library.View_defn w x y z p) =
    (Syntax.AS_Structured.View_defn w x y z p)
cast_L_S_View_defn _ = error "wrong constructor for \"cast_L_S_View_defn\""

cast_A_L_Arch_spec_defn :: Syntax.AS_Architecture.ARCH_SPEC_DEFN -> LIB_ITEM
cast_L_A_Arch_spec_defn :: LIB_ITEM       -> Syntax.AS_Architecture.ARCH_SPEC_DEFN

cast_A_L_Arch_spec_defn (Syntax.AS_Architecture.Arch_spec_defn x y p) =
    (Syntax.AS_Library.Arch_spec_defn x y p)
cast_A_L_Arch_spec_defn _ = 
    error "wrong constructor for \"cast_A_L_Arch_defn\""

cast_L_A_Arch_spec_defn (Syntax.AS_Library.Arch_spec_defn x y p) =
    (Syntax.AS_Architecture.Arch_spec_defn x y p)
cast_L_A_Arch_defn _ = error "wrong constructor for \"cast_L_A_Arch_defn\""

cast_A_L_Unit_spec_defn :: Syntax.AS_Architecture.UNIT_SPEC_DEFN -> LIB_ITEM
cast_L_A_Unit_spec_defn :: LIB_ITEM       -> Syntax.AS_Architecture.UNIT_SPEC_DEFN

cast_A_L_Unit_spec_defn (Syntax.AS_Architecture.Unit_spec_defn x y p) =
    (Syntax.AS_Library.Unit_spec_defn x y p)
cast_A_L_Unit_defn _ = error "wrong constructor for \"cast_A_L_Unit_defn\""

cast_L_A_Unit_spec_defn (Syntax.AS_Library.Unit_spec_defn x y p) =
    (Syntax.AS_Architecture.Unit_spec_defn x y p)
cast_L_A_Spec_defn _ = error "wrong constructor for \"cast_L_A_Unit_defn\""
{- ? Generated by DrIFT : Look, but Don't Touch. (works w/ haddock) ? -}
instance PosItem LIB_DEFN where
    up_pos_l fn1 (Lib_defn aa ab ac ad) = (Lib_defn aa ab (fn1 ac) ad)
    get_pos_l (Lib_defn _ _ ac _) = Just ac

instance PosItem LIB_ITEM where
    up_pos_l fn1 (Spec_defn aa ab ac ad) =
	(Spec_defn aa ab ac (fn1 ad))
    up_pos_l fn1 (View_defn aa ab ac ad ae) =
	(View_defn aa ab ac ad (fn1 ae))
    up_pos_l fn1 (Arch_spec_defn aa ab ac) =
	(Arch_spec_defn aa ab (fn1 ac))
    up_pos_l fn1 (Unit_spec_defn aa ab ac) =
	(Unit_spec_defn aa ab (fn1 ac))
    up_pos_l fn1 (Download_items aa ab ac) =
	(Download_items aa ab (fn1 ac))
    up_pos_l fn1 (Logic_decl aa ab) = (Logic_decl aa (fn1 ab))
    get_pos_l (Spec_defn _ _ _ ad) = Just ad
    get_pos_l (View_defn _ _ _ _ ae) = Just ae
    get_pos_l (Arch_spec_defn _ _ ac) = Just ac
    get_pos_l (Unit_spec_defn _ _ ac) = Just ac
    get_pos_l (Download_items _ _ ac) = Just ac
    get_pos_l (Logic_decl _ ab) = Just ab

instance PosItem ITEM_NAME_OR_MAP where
    up_pos_l _ (Item_name aa) = (Item_name aa)
    up_pos_l fn1 (Item_name_map aa ab ac) =
	(Item_name_map aa ab (fn1 ac))
    get_pos_l (Item_name _) = Nothing
    get_pos_l (Item_name_map _ _ ac) = Just ac


instance PosItem LIB_ID where
    up_pos_l fn1 (Direct_link aa ab) = (Direct_link aa (fn1 ab))
    up_pos_l fn1 (Indirect_link aa ab) = (Indirect_link aa (fn1 ab))
    get_pos_l (Direct_link _ ab) = Just ab
    get_pos_l (Indirect_link _ ab) = Just ab

instance PosItem VERSION_NUMBER where
    up_pos_l fn1 (Version_number aa ab) = (Version_number aa (fn1 ab))
    get_pos_l (Version_number _ ab) = Just ab

--  Imported from other files :-
