{- |
Module      :  $Header: /repository/caslbook/lncs2960-CD/Tools/Hets/src/Syntax/GlobalLibraryAnnotations.hs,v 1.1 2004/02/13 14:50:49 5maeder Exp $
Copyright   :  (c) Klaus Lttich, Christian Maeder and Uni Bremen 2002-2003 
Licence     :  similar to LGPL, see HetCATS/LICENCE.txt or LIZENZ.txt

Maintainer  :  hets@tzi.de
Stability   :  experimental
Portability :  non-portable (imports existential types) 
    
   A module to extract GlobalAnnos from libraries

-}

module Syntax.GlobalLibraryAnnotations where

import Common.GlobalAnnotations
import Common.AnalyseAnnos
import Common.Result
import Syntax.AS_Library(LIB_DEFN(Lib_defn))

initGlobalAnnos :: LIB_DEFN -> Result GlobalAnnos
initGlobalAnnos ld = setGlobalAnnos emptyGlobalAnnos ld

setGlobalAnnos :: GlobalAnnos -> LIB_DEFN -> Result GlobalAnnos
setGlobalAnnos ga ld = addGlobalAnnos ga annos
    where annos = case ld of Lib_defn _ _ _ as -> as	  
