#!/usr/local/bin/perl

use strict;

my $OUT ;
my $IN;

if(@ARGV == 2) {
if (open IN, "<$ARGV[0]") {
	$IN = *IN;
    } else {
	print "error while oppening input file: $ARGV[0]\n";
	exit 2;
    }
    if (open OUT, ">$ARGV[1]") {
	$OUT = *OUT;
    } else {
	print "error while oppening output file: $ARGV[1]\n";
	exit 3;
    }
} elsif (@ARGV > 2 || @ARGV < 0 || @ARGV == 1) {
    print STDTERR "wrong number of args\n",
'usage: create_sources.pl INPUT-FILE OUTPUT-FILE
';
    exit 1;
}

my @sources = ();
my $ready = 0;

while (<$IN>) {
    $ready = 1 if m/^Linking/o;
    # skip some junk
    next if m/^ghc.*:/o;
    # select the right lines
    if(m#^(Skip|Com).*\( ([\w.\-/]+\.l?hs),#o) {
	push @sources, $2;
	
    }
    
}
if($ready) {
    print $OUT
	'# This file is generated by create_sources.pl
# Please do not edit 
sources = ', join(' ', @sources), "\n";
} else {
    print STDERR "Error: Couldn't create sources!!\n";
    #print $ready;
    system qw(rm -f),$ARGV[0],$ARGV[1];
    exit 7;
}
