-- -----------------------------------------------------------------------
--
-- $Source: /repository/uni/htk/examples/simple/MainlistEx.hs,v $
--
-- HTk - a GUI toolkit for Haskell  -  (c) Universitaet Bremen
--
-- $Revision: 1.2 $ from $Date: 2002/05/31 18:20:27 $  
-- Last modification by $Author: ger $
--
-- -----------------------------------------------------------------------

module Main (main) where

import HTk

main :: IO ()
main =
  do
    main <- initHTk [text "A Listbox"]
    lb  <- newListBox main [value numbers, bg "white", size (15, 10)] ::
             IO (ListBox String)
    pack lb [Side AtLeft]
    scb <- newScrollBar main []
    pack scb [Side AtRight, Fill Y]
    lb # scrollbar Vertical scb
    (press, _) <- bindSimple lb (ButtonPress (Just 1))
    spawnEvent (forever
                  (press >> always (do
                                      sel<- getSelection lb;
				      putStrLn ("Selected "++ 
					        show (sel::
                                                        Maybe [Int])))))
    finishHTk

  where numbers =
          ["One", "Two", "Three", "Four", "Five", "Six", "Seven",
           "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen",
           "Fourteen", "Fifteen", "Sixteen", "Seventeen",
           "Eighteen", "Nineteen", "Twenty"]
