-- -----------------------------------------------------------------------
--
-- $Source: /repository/uni/htk/toolkit/TextDisplay.hs,v $
--
-- HTk - a GUI toolkit for Haskell  -  (c) Universitaet Bremen
--
-- $Revision: 1.2 $ from $Date: 2003/08/10 23:40:45 $  
-- Last modification by $Author: cxl $
--
-- -----------------------------------------------------------------------

---
-- A simple window to display uneditable, scrollable text (e.g. error logs)

module TextDisplay(

  createTextDisplayExt, -- :: String-> String-> [Config ...] -> IO()-> IO Toplvl
  createTextDisplay     -- :: String-> String-> [Config ...] -> IO ()

) where

import HTk
import Core
import ScrollBox
import MarkupText 


---
-- Display some (longish) text in an uneditable, scrollable editor.
-- Returns immediately-- the display is forked off to separate thread.
-- @param title   - the title of the window
-- @param txt     - the text to be displayed
-- @param conf    - configuration options for the text editor
-- @param unpost  - action to be executed when the window is closed
-- @return result - the window in which the text is displayed
createTextDisplayExt :: String-> String-> [Config Editor]-> IO()-> IO (Toplevel,
								       Editor)
createTextDisplayExt title txt conf unpost =
  do win <- createToplevel [text title]
     b   <- newFrame win  [relief Groove, borderwidth (cm 0.05)]    
     t   <- newLabel b [text title, HTk.font (Helvetica, Roman, 18::Int)]
     q   <- newButton b [text "Close", width 12]
     (sb, ed) <- newScrollBox b (\p-> newEditor p (state Normal:conf)) []
     pack b [Side AtTop, Fill X, Expand On]
     pack t [Side AtTop, Expand Off, PadY 10]
     pack sb [Side AtTop, Expand On]
     pack ed [Side AtTop, Expand On, Fill X]
     pack q [Side AtRight, PadX 5, PadY 5] 		 

     ed # value txt
     ed # state Disabled

     quit <- clicked q
     spawnEvent (quit >>> do destroy win; unpost)
     return (win, ed)

---
-- Display some (longish) text in an uneditable, scrollable editor.
-- Simplified version of createTextDisplayExt
-- @param title   - the title of the window
-- @param txt     - the text to be displayed
-- @param conf    - configuration options for the text editor
createTextDisplay :: String-> String-> [Config Editor]-> IO()
createTextDisplay t txt conf = do createTextDisplayExt t txt conf done; done
