(************************************************************** *)
(*  							 	  *)
(* Project : CATS						  *)
(* Author: Pascal Schmidt, University of Bremen		          *)
(* Date: ??                          			  	  *)
(* Purpose of this file: CATS command line interface              *)
(*	 							  *)	
(*								  *)
(**************************************************************** *)

(* todo:
 Fehlermeldung wenn kein Schreibrecht auf Verzeichnis
   oder wenn Datei nicht existiert

 Option for omitting partial projections
 Eigene Tool-Optionen -es -esp -eg fuer encode
 Parsing of terms (wrt. given global_env)
 Bessere Exception-Behandlung:
  Bei use_casl eine Meldung "Internal error. Please send us your spec"
    ausgeben, falls die Exception nicht auftreten darf.
    Auftreten darf: Syntax error, Mixfix error
 => einfach nur testen, ob alle Fehler richtig abgefangen werden

 Internal error: Exception ausgeben
*)


structure Standalone
=
struct

local open Utils ML_interface
in
infix mem

fun term_succ () = OS.Process.success

fun isSome (NONE) = false
  | isSome (SOME _) = true

fun gets (SOME x) = x
  | gets (NONE)   = raise ERROR

fun tester (#"\n") = true
  | tester _       = false

fun splitn x = String.fields tester x

fun readprofile () = if (isSome(OS.Process.getEnv "HOME")) then
                       if (Utils.exists (((gets o OS.Process.getEnv) "HOME")^
                          "/.cats")) then
                          (splitn o Utils.read) (((gets o
                           OS.Process.getEnv) "HOME")^"/.cats")
                       else
                         []
                     else
                       []

fun sanity l = if ((Options.input_bin l) orelse (Options.output_bin l)) then
                ( Utils.write "temp.tmp" "TEST";
                  if not ( isSuccess (OS.Process.system "trm2baf < temp.tmp > tmp.tmp")) then
                    (
                      OS.Process.system "rm temp.tmp tmp.tmp";
                      print ("Fatal: Could not execute trm2baf.\n");
                      print ("Run cats with the nobin options or put the files from the\n");
                      print ("contrib directory of the distribution into your path.\n");
                      OS.Process.terminate OS.Process.failure
                    )
                  else
                  if not ( isSuccess (OS.Process.system "baf2trm < tmp.tmp > temp.tmp")) then
                    (
                      OS.Process.system "rm temp.tmp tmp.tmp";
                      print ("Fatal: Could not execute baf2trm.\n");
                      print ("Run casl with the nobin options or put the files from the\n");
                      print ("contrib directory of the distribution into your path.\n");
                      OS.Process.terminate OS.Process.failure
                    )
                  else
                    ( OS.Process.system "rm temp.tmp tmp.tmp";
                      ()
                    )
                )
                else ()

fun caslhead () = (print (versinfo ^ 
                         "  www.tzi.de/cofi  cofi@tzi.de\n\n");
                   case OS.Process.getEnv "CASL_LIB" of
                   NONE => (print ("********************** Attention! *******************\n"
                                 ^"You have not set the CASL_LIB environment variable.\n"
                                 ^"It should be set to the folder containing the CASL\n"
                                 ^"sources and the folder Basic for the basic datatyps.\n\n"
                                 ^"You can do this by entering\n\n"
                                 ^"  export CASL_LIB=...\n\n"
                                 ^"or\n\n"
                                 ^"  setenv CASL_LIB ...\n"
                                 ^"*****************************************************\n\n");())
                   | SOME _ => ()
                  )

fun caslhelp () = ( print ("Usage: cats [options] file ... file\n\n" ^
                         "Options: -input    selects input options, give one or more of casl,\n"^
                         "                   aterm,static,nostatic,bin,nobin,empty,basic,gen_aterm,\n"^
                         "                   xml\n"^
                         "                   Default: -input=casl,static,bin,basic\n"^
                         "         -output   selects output options, give one or more of tex,\n"^
                         "                   notex,env,noenv,graph,nograph,bin,nobin\n" ^
                         "                   Default: -output=notex,noenv,nograph,bin\n"^
                         "         -spec     selects spec options, give one or more of\n"^
                         "                   aterm,noaterm,xml,noxml,gen_aterm,nogen_aterm,text,notext\n"^
                         "                   Default: -spec=aterm,noxml\n"^
                         "         -env      selects environment options, give one or more of\n"^
                         "                   CasEnv,FCasEnv,HCasEnv,SubPCFOL,SubCFOL,CFOL,SOL,\n"^
                         "                   CFOL1,SOL1,text,aterm,latex,xml,noCasEnv,noFCasEnv,\n"^
                         "                   noHCasEnv,notext,noaterm,nolatex,noxml\n"^
                         "                   Default: -env=CasEnv,SubPCFOL,aterm\n"^
                         "         -graph    selects graph options, give one or more of dot,\n"^
                         "                   ps,davinci,nodot,nops,nodavinci\n"^
                         "                   Default: -graph=davinci\n"^
                         "         -parser   selects parser to use, give isabelle or yacc\n"^
                         "                   Default: -parser=yacc\n"^
                         "         -quiet    selects quiet mode\n"^
                         "         -noquiet  deselects quiet mode\n\n" ^
                         "         -dumpdtd  dump the XML DTD used by casl on stdout\n\n" ) ;
                         (OS.Process.terminate OS.Process.success):int )

fun optfl []      = []
  | optfl (""::t) = optfl t
  | optfl (h::t)  = if ((hd o explode) h)="-" then
                      h :: (optfl t)
                    else
                      optfl t

fun filefl []      = []
  | filefl (""::t) = filefl t
  | filefl (h::t)  = if ((hd o explode) h)="-" then
                       filefl t
                     else
                       h :: (filefl t)

fun processf opts l = ( WriterSpec.write_specs opts l;
                        WriterGraph.write_graphs opts l;
                        WriterEnv.write_envs opts (Encoder.encode_all opts l);
                        WriterLatex.write_latex opts l )

fun tool l = let
               val opts = Options.get_options (readprofile() @ (optfl l))
               val sane = sanity opts
             in
               ( Global.quiet_mode := Options.quiet opts;
                 Global.yacc_parser := Options.parser_yacc opts;
                 processf opts (Reader.read_files opts (filefl l))
               )
             end
             handle ERROR => [()]
              | exn => 
                if (!Global.test) then raise exn
                else [Global.InternalError "global"];

fun cats s = (Global.test:=true; tool (Utils.space_explode " " s));

fun newtool (s,l) = if ("-cgi" mem l) then
                        (WebInterface2.web_interface2 (String.concat (tl
                        l)) ; term_succ() )  
                    else
                      if
                        ("-dumpdtd" mem l) then
                          (print xml_dtd.dtd_text; term_succ() )
                      else
                        ( (caslhead();
                          if l=[] then
                            (caslhelp() ; [()] )
                          else
                            tool l;
                          () ) ;
                          term_succ() )

end
end
(****************************************************************************)

open Standalone;



