(* ------------------------------------------------------------------------ *)
(* encoder.sml                                                              *)
(* environment encoder for the casl standalone tool                         *)
(* Pascal Schmidt <pharao90@tzi.de>                                         *)
(* ------------------------------------------------------------------------ *)

(* $Id: encoder.sml,v 1.1 2004/02/13 11:29:10 7till Exp $ *)


signature EncoderSig
=
sig
  val encode_all : Options.casl_options ->
                   (string * (GlobalEnv.lib_env * GlobalEnv.global_env
                    * AS.LIB_DEFN)) list ->
                   (string * (GlobalEnv.lib_env * GlobalEnv.global_env
                    * AS.LIB_DEFN)) list
end

structure Encoder : EncoderSig
=
struct

fun encode use_p l (a,(b,c,d)) = if (Options.env_subpcfol l) then
                               (a,(b,c,d))
                             else if (Options.env_subcfol l) then
                               (a,(b,BasicEncode.encode_SubPCFOL_SubCFOL use_p c,d))
                             else if (Options.env_cfol l) then
                               (a,(b,BasicEncode.encode_SubPCFOL_CFOL use_p c,d))
                             else
                               (a,(b,BasicEncode.encode_SubPCFOL_SOL  use_p c,d))

fun encode_all l n = (map (encode true l)) n

end
