(* ------------------------------------------------------------------------ *)
(* writer_latex.sml                                                         *)
(* latex writer for the casl standalone tool                                *)
(* Pascal Schmidt <pharao90@tzi.de>                                         *)
(* ------------------------------------------------------------------------ *)

(* $Id: writer_latex.sml,v 1.1 2004/02/13 11:29:10 7till Exp $ *)


signature WriterLatexSig
=
sig
  val write_latex : Options.casl_options ->
                    (string * (GlobalEnv.lib_env * GlobalEnv.global_env
                     * AS.LIB_DEFN)) list ->
                    unit list
end

structure WriterLatex : WriterLatexSig
=
struct

fun writef l (x,(le,ge,tr)) = if (x<>"") then
                              if (Options.output_tex l) then
                                latex_interface.latex_lib_defn_file tr
                                (x^".tex")
                              (*
                                Utils.write (x^".tex") (*(Makellos.mkTeX
                                                          ((Options.quiet l),ge,tr))*)
                              *)
               (* As long as Makellos is not complete, generate some stuff for testing purposes *)
(*
               ("\\begin{ITEMS}\n"
               ^"\\I\\SPEC \\NAMEDEFN{Test\\_Spec} = \\newline\n"
               ^"\\NAMEREF{Nat} \\AND \\NAMEREF{Bool}\n"
               ^"\\I\\THEN~  \\newline\n"
               ^"\\(\\FORALL x,y : Nat \\. x+suc(y) = suc(x+y)\\)\n"
               ^"\\I\\END  ~\n"
               ^"\\end{ITEMS}\n\n")
*)
                              else
                                ()
                              else
                                ()


fun write_latex l n = (map (writef l)) n

end
