
use_casl "Demo_Nat";

CASL_context Nat.casl;

AddsimpAll();

Goal "1+1=2";
by (Simp_tac 1);
qed "one_plus_one";

Goal "forall x,y,z:Nat . (x+y)+z = x+(y+z)";
by (induct_tac "x" 1);
by (ALLGOALS Simp_tac);
qed "Nat_add_assoc";

Goal "forall x:Nat . x+0=x";
by (induct_tac "x" 1);
by (ALLGOALS Simp_tac);
qed "Nat_add_0_right";

Goal "forall x,y:Nat . x+suc(y) = suc(x+y)";
by (induct_tac "x" 1);
by (ALLGOALS Simp_tac);
qed "Nat_add_suc_right";

Addsimps [Nat_add_0_right,Nat_add_suc_right];

Goal "forall x,y:Nat . x+y=y+x";
by (induct_tac "x" 1);
by (ALLGOALS Simp_tac);
qed "Nat_add_comm";

Goal "forall x,y,z:Nat . x+(y+z)=y+(x+z)";
by (induct_tac "x" 1);
by (ALLGOALS (simp_tac (simpset() addsimps [Nat_add_comm])));
qed "Nat_add_left_commute";

Goal "forall n:Nat . not n = 0 => exists m:Nat.  n = suc(m)";
by (induct_tac "n" 1);
by (Simp_tac 1);
by (Blast_tac 1);
qed "Nat_not0_implies_suc";

Goal "forall n:Nat . not n = 0 => exists m:Nat.  n = suc(m)";
by (induct_tac "n" 1);
by Auto_tac;
qed "Nat_not0_implies_suc";


use_casl "Demo_Int";

CASL_context Int.casl;

AddsimpAll();

Goal "forall x:Int . x-x=0";
by (induct_tac "x" 1);
(* We need the overloading equation 0:Int=0:Nat *)
by (simp_tac (overload_down() addsimps [Nat_add_comm]) 1); 
qed "Int_minus_0";
