(*  Title:      HOL/HOL.thy
    ID:         $Id: HOL_CASL.thy,v 1.1 2004/02/13 11:28:52 7till Exp $
    Author:     Tobias Nipkow
    Copyright   1993  University of Cambridge

Higher-Order Logic.
*)

HOL_CASL = HOL +

 
consts

 casl_forall           :: ('a => bool) => bool         (binder "forall " 10)
 casl_exists           :: ('a => bool) => bool         (binder "exists " 10)
  casl_exists1          :: ('a => bool) => bool         (binder "exists! " 10)

  "casl_and"       :: [bool, bool] => bool         ("_'/\\ _" 35)
  "casl_or"        :: [bool, bool] => bool         ("_ \\'/ _" 30)
  "casl_imp"       :: [bool, bool] => bool         ("_ =>_ "25)
  "casl_not"            :: bool => bool                 ("not _")
translations
 "not (x = y)" == "x ~= y" 
 "not x" == "~ x"
 "forall xs . P" == "! xs. P" 
 "exists xs . P" == "? xs. P" 
 "exists! xs . P" == "?! xs. P"   
 "A /\\ B" == "A &  B"     
 "A \\/ B"=="A |  B"      
 "A => B" == "A -->  B"  

end
