(* *********************************************************************** *)
(*									   *)
(* Project: HOL-CASL 							   *)
(* Author: Till Mossakowski, University of Bremen			   *)
(* Date: 02.03.2000				 			   *)
(* Purpose of this file: Create heap image for HOL-CASL with IsaWin        *)
(*			 						   *)
(*		              						   *)
(* *********************************************************************** *)

(* Use this file on CASL IsaWin to create a heap image of HOL-CASL.

   Future work: get date and version info from the file version.
*)


(* create heap image *)
if SMLofNJ.exportML "Isa-CASL" then
((* This is run when the image is loaded *)
 writeln 
 ("*********************************************************************\n"^
  "*                                                                   *\n"^
  "* HOL-CASL, the embedding of CASL into Isabelle/HOL, v 0.71         *\n"^
  "*                                                                   *\n"^
  "* (C) 2001, Bremen Institute for Safe Systems, University of Bremen *\n"^
  "*                                                                   *\n"^
  "                                                                    *\n"^
  "* If you have any questions, please contact us at                   *\n"^
  "*                                   cofi@tzi.de  www.tzi.de/cofi    *\n"^
  "*                                                                   *\n"^
  "*                              -- The Bremen CoFI team 27.07.2001   *\n"^
  "*                                                                   *\n"^
  "*********************************************************************\n\n");
 SmlTk.Debug.warn_on();
 SmlTk.init();
 SmlTk.Debug.warn_off();
 set trace_simp;
 CaslWin.go();
 OS.Process.exit 0
)
else ();
