(* *********************************************************************** *)
(*									   *)
(* Project: HOL-CASL	                                                   *)
(* Author: Kolyang and Till Mossakowski, University of Bremen	           *)
(* Date: 19.08.99				 			   *)
(* Purpose of this file: ROOT for HOL-CASL IsaWin system                   *)
(* *********************************************************************** *)

Compiler.Control.primaryPrompt := "HOL-CASL> ";
Compiler.Control.secondaryPrompt := "HOL-CASL# ";

structure List = BasisLibrary.List;  

(*******************************************************************)
(***  Load CASL tool set, including encoding of CASL into CFOL  ****)
(*******************************************************************)

(* use "../ROOT.ML";   -- does not work, since Isabelle hides String *)
val HOL_CASL_dir = pwd();
cd "../CASLsign";
(*use "makeas.ML";*)
cd HOL_CASL_dir;
CM.make();

(*******************************************************************)
(***  Encoding of CASL/CFOL into Isabelle/HOL                   ****)
(*******************************************************************)

local
fun save1 version name =
     if SMLofNJ.exportML name then
     ((* This is run when the image is loaded *)
       writeln 
      ("* HOL-CASL "^version^"    cofi@tzi.de  www.tzi.de/cofi\nRestored session "^name^"\n")
         )
      else ()
in
val save = save1 (Utils.read "../version")
end;


use_thy "HOL_CASL";
Context.reset_context();
use "CASLTheory.sml";
open CASLTheory;
install_pp (make_pp ["CASLTheory", "casltheory"] pprint_casltheory);
use "basic_encode.sml";
use "struct_encode.sml";
use "CASLThyRead.sml";
use "context.sml";
use "CASLgoals.sml";
use "tactic.sml";
use "simplifier.sml";

print_mode := ["Inj",""];

open StructEncodeIsabelle CASLThyRead Basic_CASLproof CASL_Tactic;


(* Use
   
   use"mk_holcasl.sml";
   
   for creating a standalone heap image *)
   
