(* ***************************************************************************
 
   $Source: /repository/caslbook/lncs2960-CD/Tools/Cats/src/HOL-CASL/tag.sml,v $
 
   Selection in Isabelle terms
 
<<<<<<< tag.sml
   $Date: 2004/02/13 11:28:53 $
   $Revision: 1.1 $
   Author: B. Wolff, C. Lueth (Last modification by $Author: 7till $)
=======
   $Date: 2004/02/13 11:28:53 $
   $Revision: 1.1 $
   Author: B. Wolff, C. Lueth (Last modification by $Author: 7till $)
>>>>>>> 1.2

   (C) 1997, Bremen Institute for Safe Systems, Universitaet Bremen
 
 ************************************************************************** *)

(*

For any print_translation, a corresponding tag_translation must be
defined. It must produce the tagging for a term to be "print_translated" - 
hence, the tag_translation must supress tagging in all parts affected by
pattern-matching of the print-translation. Since "getting the tagging
right" is a highly tricky part of interface programming - errors only 
affect the user-interface and are hard to detect - a number of facilities 
and combinators have been developped to ease this chore.

First: tag_translations are constructed analogously to print_translations:
whenever a print_translation "P" can be fired with arguments [t1,...,tn]
- i.e. a term t of the form t=Const(P,_) $ t1 $ ... $ tn was matched -
a tag_translation "P" is fired with arguments [(tt1,t1),...,(ttn,tn)].
The tti's are "tagger-functions" that tag a term t according to initial 
path p plus the local path in t. fn t p => t is the trivial tagger function,
fn t p => gen_tag p t one that produces exactly one tagging on top, and 
fn t p => tag t p the standard tagger function, i.e. that produces exactly 
one tagging around each node in t. The standard-tagger fires all 
tag_translation stored in a tagging-table whenever it finds an applicable 
one; Each tag-translation gives back a list of tagger-functions, for all its 
argument-terms each. In case a tag_translation was fired, the standard-tagger
applies each tagger-function to the ti and reconstructs the 
application-spine (the _$ _ $ _ ... _ $ _) without any internal tagging 
(such that the future print-Translation-call may match, hopefully).

Second: As mentionend, the tt1 are already adjusted with respect to their 
path to their inner positions in the application-spine. Further adjustments 
are possible with the tag-transducer-combinator tt ^^ t. t can be 
thought as a context C[XXX] with a "hole" X. The term-transducer converts
a tagger tt to one, that will map a term t (tt t p) to a term C[t] with
C remaining untagged and t tagged (where p is assumed to be the initial path
to the root of C[t]). A transducer-composition
 ([C1,...Cn] |^ t_trans) ([(tt1,t1),...,(ttn,tn)]) applies a tagger-translation
t_rans to the pairs of taggers tti and subterms ti and embeds the results 
according to the contexts C1 .. Cn.


(* Example: *)



fun print_SB [anno, Abs(_,t,body)] = 
      if !show_full_sem then raise Match else
	let fun mk_string cs = (implode (String.dest_string cs))
	in  subst_bounds([Free(mk_string anno,t)],body) end
   |print_SB _ = raise Match

fun tag_SB [(t1,anno), (t2,Abs(ss,t,body))] =
      if !show_full_sem then raise Tagging else
       [(K,anno),(t2 ^^ (Abs(ss,t,XXX)),body)]
   |tag_SB _ = raise Tagging

The K-Combinator works here as tagger-function that produces no tagging
at all.
*)


infix 9 ^^;
infix 9 |^;


structure Tag   :
  sig
    exception IllegalPath of string

    type path  (* a path into a term *)

    val encode : path   -> string
    val decode : string -> path

    val tag_term      : term -> term         (* annotate a term with paths *)

    val extend_thy    : theory-> theory      (* extend a theory's syntax so it
					      * can be used to print a 
					      * tagged term 
					      *)

    val pretty_of     : theory-> term -> string
                                             (* produces a pretty-print
                                                requires extended theory. *)
    val string_of     : theory-> term -> string
                                             (* annotate a term and return
					      * an SGML string representatio
					      * of the tagged term *)

    val print_str     : theory-> term -> string
                                             (* annotate a term and return
					      * a string representation of 
					      * the tagged term *)

    (* the following, given a term path, `cut out' the term at that position
     * or the surrounding context *)
    val cut_term    : term -> path -> term
    val cut_context : Sign.sg-> term -> path -> cterm

  end 
=


struct 

    type path= int list
    exception IllegalPath of string

(* ********************************************************************************* *)
(* PATHS                                                                             *)
(* ********************************************************************************* *)

    type path= int list
    exception IllegalPath of string

    fun encode p =
    let
	fun encode [] = "0"
	  | encode (1::S) = "1"^(encode S)
	  | encode (2::S) = "2"^(encode S)
    in  "(0)"^(encode p)
    end
       
    fun decode x = 
	let fun decode ["0"] = []
	      |decode ("1"::S) = 1:: (decode S)
	      |decode ("2"::S) = 2:: (decode S)
	in decode (tl(tl(tl(explode x)))) 
	end

    fun cut_term t hp = 
        let fun cut_term (Abs(s,t,tt)) (1::path) = Abs(s, t, cut_term tt path)
              | cut_term (Abs(s,t,tt)) []        = Abs(s, t, tt)
              | cut_term (s $ t) (1::p)          = cut_term s p
              | cut_term (s $ t) (2::p)          = cut_term t p
              | cut_term t       []              = t
              | cut_term t       (x::p)          = raise (IllegalPath 
                                                          (encode (rev hp)))
        in cut_term t (rev hp) 
        end

(*
   fun cut_context sg t hp =
        let fun gen d = Library.foldl (op $) (Bound d,
                                              map Bound ((d-1) downto 0));

            fun cut (Abs(s,t,tt)) (1::path) d = Abs(s,t,cut tt path (d+1))
              | cut (s $ t) (1::p)          d = (cut s p d) $ t
              | cut (s $ t) (2::p)          d = s $ (cut t p d)
              | cut t       []              d = gen d
              | cut t       (x::p)          d = raise (IllegalPath
                                                        (encode (rev hp)));


           fun constr_type args tt=
                let val subterm = subst_bounds(args,tt)
                    val st_type = #T(rep_cterm(cterm_of sg subterm))
                in  Library.foldl (fn (dom,Free(_, t))=> t-->dom)
                                  (st_type,args)
                end;


           fun red_type (Abs(s,t,tt)) (1::p) args = red_type tt p
                                                        (Free(s,t)::args)
              | red_type (s $ t) (1::p) args       = red_type s p args
              | red_type (s $ t) (2::p) args       = red_type t p args
              | red_type t       []     args       = constr_type args t
              | red_type t       (x::p) args       = raise (IllegalPath
                                                             (encode (rev hp)));


        in  cterm_of sg  (Abs("redex", red_type t (rev hp) [],
                                       cut t (rev hp) 0))
        end

*) 
   fun cut_context sg t hp = cterm_of sg t
   

(* ************************************************************************ *)
(* Tagger-Tables                                                            *)
(* ************************************************************************ *)

    type tgr      = term -> path -> term;
    type tgr_item = tgr * term;

    val tgr_tab = ref(Symtab.empty:(tgr_item list -> tgr_item list)Symtab.table);

(* ************************************************************************ *)
(* Tagger                                                                   *)
(* ************************************************************************ *)

    exception Tagging;
    val XXX = Var(("XXX",0),dummyT);

    (* transduce a tagger through a term *)

    fun tt ^^ (Var(("XXX",0),_))= tt
      | tt ^^ (Abs(s,t,te)) = (fn t' => fn p => Abs(s,t,(tt ^^ te) t' (1::p)))
      | tt ^^ (s $ t)       = (fn t' => fn p => ((tt ^^ s) t' (1::p)) $
     			                        ((tt ^^ t) t' (2::p)))
      | tt ^^ t             = (fn _  => fn _ => t);

    fun pS |^ f = (fn S => let fun rc (p::pS) ((tt,r)::R) = (tt^^p,r)::(rc pS R)
                                 | rc [] [] = []
                           in  rc pS (f S) end); 

    fun recombine ((tt,a),S) p = 
        let fun reco  e []            = e
            |   reco  e ((tt',a')::S) = reco (fn p=> e(1::p) $ (tt' a' (2::p))) S;
        in  (reco (fn p => tt a p) S) p end;

    fun decompose (s $ t) tt = (decompose s tt) @ [(tt,t)]
       |decompose s       tt = [(tt, s)];

    fun gen_tag t path= (Const ("_sel",dummyT) $ Free(encode path,dummyT) $ t);

    fun gen_appl_tag (s$t) p tt = gen_tag((gen_appl_tag s(1::p) tt)
				          $ (tt t (2::p))) p
       |gen_appl_tag s     p tt = tt s p;

    fun  tag (Const(s,t)) p = gen_tag (Const(s,t)) p
       | tag (Free (s,t)) p = gen_tag (Free (s,t)) p
       | tag (Var  (s,t)) p = gen_tag (Var  (s,t)) p
       | tag (Bound   n)  p = gen_tag (Bound   n)  p
       | tag (Abs(s,t,tt))p = gen_tag (Abs(s, t, tag tt (1::p))) p
       | tag (t' as (s$t))p = 
             let val ((tt,a)::R) = decompose t' tag
             in (case a of
                  Const(str,_) => 
                     (case Symtab.lookup(!tgr_tab,str) of
                        Some f => gen_tag(recombine((K,a),f R) p) p
                       | _     => raise Tagging)
                 | _ => raise Tagging)
                handle Tagging => gen_appl_tag t' p tag
             end;


   fun tag_term s = tag s [];


(* ************************************************************************ *)
(* Higher Printing Functions                                                *)
(* ************************************************************************ *)


    fun extend_thy thy = thy

(*    fun extend_thy thy = 
	let val nuthy= 
	    Theory.add_name (((Sign.name_of o sign_of) thy)^"'")
	    (Theory.add_consts  
	     [("_sel", 
	       "['a  , 'b  ] => 'b   ", 
		   Mixfix ("(2)((0)<SEL (_)(0)>(_)(0)<\\SEL>)", [], max_pri))] 
	     thy)
	in  (SGML_lib.attach_ext_syntax nuthy [] []; nuthy)
	end
*)
   fun pretty_of th t = 
        Pretty.string_of (Syntax.pretty_term (syn_of th) true (tag_term t));
      
    fun string_of th t = pretty_of (extend_thy th) t

    fun print_str th t = Sign.string_of_term 
                           (sign_of (extend_thy th))
                           (tag_term t)

(* andere Lsung: 
   - Extraktion der syntax.
   - Erweiterung um Syntax.add_consts;
     (das is kompliziert, da die entscheidenden Operationen eigtl. auf 
     sign ebene.
     - Falls scheitert wegen schon drin: Ignorieren
   - berschreiben von syn_db mittels update.

   Gross problem - Reload. Was macht attach hier?
   Vielleicht bietet da die Lsung ber's Object-Attachment
   eine grundstzliche Verbesserung.

*)

(* ************************************************************************ *)
(* Testing                                                                  *)
(* ************************************************************************ *)
(*
   fun untag_term (Const ("_sel", _) $ _ $ t) = untag_term t
      |untag_term (s $ t) = (untag_term s) $ (untag_term t)
      |untag_term (Abs(s,t,t')) = Abs(s,t,untag_term t')
      |untag_term t = t;

   fun strip_leaves (Const ("_sel", _) $ Free(s,_) $ Const x) =
                                             [(decode s, Const x)]
      |strip_leaves (Const ("_sel", _) $ Free(s,_) $ Free x) =
                                             [(decode s, Free x)]        
      |strip_leaves (Const ("_sel", _) $ Free(s,_) $ t) =
                                             strip_leaves t
      |strip_leaves (s $ t) = (strip_leaves s) @ (strip_leaves t)
      |strip_leaves  (Abs(s,t,t')) = strip_leaves t'
      |strip_leaves t = []
            
   fun test_tagging t = 
       if not(untag_term(tag_term t) = t)then
	   (writeln"ERROR: structural damage";[(untag_term(tag_term t),t)])
       else let val m = map (fn (p,t') => (strip_abs_body(cut_term t p),t'))
                val res = m (strip_leaves(tag_term t))
            in if forall (op =) (res) then []
               else (writeln("ERROR: selection paths not appropriate for");
		     filter (op =) res)
            end;

*)
end

