
structure HORN1 =
struct

local open AS

in


(* Check if a term contains total functions only *)
fun is_total t = case t of
   qual_var (x,s)  => true
 | var_or_const x  => true
 | application (op_symb(f,Utils.Some (total_op_type _)), tt) => 
   Utils.forall is_total (Utils.get_terms tt)
 | application _ => false
 | sorted_term (T, S) =>  
     is_total T
 | cast (T,S ) =>  
     false (* casts are partial functions *)
 | conditional (T1,Phi,T2) => raise Utils.ERROR (* the enclosing formula cannot be in Horn form *)
 | pos_TERM(r,b,t) => 
   is_total t

(* Transform strong equations into existential equations and definedness assertions,
   since the results about Horn forms only hold for these *)
fun elim_strong_eq f = case f of
   quantification (quant ,vlist, f) =>  
     quantification (quant ,vlist, elim_strong_eq f)
 | pred_quantification (quant,vlist,f) =>
     pred_quantification (quant ,vlist, elim_strong_eq f)
 | conjunction ff =>  conjunction (map (elim_strong_eq) ff)
 | disjunction ff => disjunction (map (elim_strong_eq) ff)
 | implication (f1, f2) => implication (elim_strong_eq f1, elim_strong_eq f2)
 | equivalence (f1, f2) => equivalence (elim_strong_eq f1, elim_strong_eq f2)
 | negation f =>  negation (elim_strong_eq f)
 | atom (strong_equation (t1,t2)) => 
   if is_total t1 andalso is_total t2 
   then atom (strong_equation (t1,t2))
   else implication (disjunction[atom(definedness t1),atom(definedness t2)], atom (existl_equation (t1,t2)) )
 | atom a => atom a
 | sort_gen_ax x => sort_gen_ax x
 | sort_cogen_ax x => sort_cogen_ax x
 | sort_cofree_ax x => sort_cofree_ax x
 | pos_FORMULA(r,b,phi) => pos_FORMULA(r,b,elim_strong_eq phi)

(* --------------------
*  function is_pos_lit:
*  returns true if the given formula is a positive
*  literal. Otherwise returns false.
*)
fun is_pos_lit (atom (ffalse)) = false
  | is_pos_lit (atom a) = true
  | is_pos_lit (x) = false

(* --------------------
*  function is_neg_lit:
*  returns true if the given formula is a negative
*  literal. Otherwise returns false. (uses function
*  is_pos_lit)
*)
fun is_neg_lit (atom (ffalse)) = true
  | is_neg_lit (negation a) = is_pos_lit(a)
  | is_neg_lit (x) = false


(* --------------------
*  function rem_allq:
*  function that removes allquantifications
*  from the beginning of a given formula in BPF
*  (Bereinigte Praenex Form)
*)
fun rem_allq (quantification (forall, _, f)) = rem_allq f
  | rem_allq x = x

(* --------------------
*  function skolemize:
*  returns the pseudo-skolem-form of a given formula in
*  BPF (Bereinigte Praenex-Form)
*)
(*fun skolemize f = skolem_rc (get_op_names_f f, 0, f) *)

(* --------------------
*  function knf_of:
*  returns the KNF formula (Konjunktive Normalform) of a
*  given skolemized formula without implications, 
*  equivalences and quantifications
*)
fun knf_of (pos_FORMULA (x, y, z)) = knf_of z
  | knf_of (atom a) = conjunction [disjunction [atom a]]
  | knf_of (negation a) = let
    fun convert (disjunction b) = conjunction ((map convert) (b))
      | convert (conjunction b) = disjunction ((map convert) (b))
      | convert (negation (atom b)) = atom b
      | convert (atom b) = negation (atom b)
    in convert (dnf_of a) end
  | knf_of (conjunction al) = conjunction (List.concat (
      (map (fn(conjunction x) => x)) ((map knf_of) al)))
  | knf_of (disjunction nil) = conjunction nil
  | knf_of (disjunction (a::nil)) = knf_of a
  | knf_of (disjunction al) = let
    fun combine nil = nil
      | combine ((conjunction bl)::nil) = bl
      | combine ((conjunction bl)::cl) = List.concat ((map (fn(disjunction dl) => 
        (map (fn(disjunction el) => disjunction (dl @ el))) (combine cl))) bl)
    in (conjunction (combine ((map knf_of) al))) end

(* --------------------
*  function dnf_of:
*  returns the DNF formula (Disjunktive Normalform) of a
*  given skolemized formula without implications, 
*  equivalences and quantifications
*)
and dnf_of (pos_FORMULA (x, y, z)) = dnf_of z
  | dnf_of (atom a) = disjunction [conjunction [atom a]]
  | dnf_of (negation a) = let
    fun convert (conjunction b) = disjunction ((map convert) (b))
      | convert (disjunction b) = conjunction ((map convert) (b))
      | convert (negation (atom b)) = atom b
      | convert (atom b) = negation (atom b)
    in convert (knf_of a) end
  | dnf_of (disjunction (al)) = disjunction (List.concat (
      (map (fn(disjunction x) => x)) ((map dnf_of) al)))
  | dnf_of (conjunction nil) = disjunction nil
  | dnf_of (conjunction (a::nil)) = dnf_of a
  | dnf_of (conjunction al) = let
    fun combine nil = nil
      | combine ((disjunction bl)::nil) = bl
      | combine ((disjunction bl)::cl) = List.concat (
        (map (fn(conjunction dl) => (map (fn(conjunction el) =>
        conjunction (dl @ el))) (combine cl))) bl)
    in (disjunction (combine ((map dnf_of) al))) end

(* --------------------
*  function rem_equi:
*  removes equivalences from a given formula
*)
fun rem_equi (quantification (a, b, c)) = quantification (a, b, rem_equi(c))
  | rem_equi (conjunction a) = (conjunction ((map rem_equi) a))
  | rem_equi (disjunction a) = (disjunction ((map rem_equi) a))
  | rem_equi (implication (a, b)) = (implication (rem_equi(a), rem_equi(b)))
  | rem_equi (negation a) = (negation (rem_equi(a)))
  | rem_equi (pos_FORMULA (a, b, c)) = pos_FORMULA (a, b, rem_equi(c))
  | rem_equi (equivalence (a, b)) = (conjunction [
    implication (rem_equi(a), rem_equi(b)),
    implication (rem_equi(b), rem_equi(a))])
  | rem_equi (x) = x

(* --------------------
*  function rem_impl:
*  removes implications from a given formula (also
*  removes equivalences using function rem_equi)
*)
fun rem_impl (quantification (a, b, c)) = quantification (a, b, rem_impl(c))
  | rem_impl (conjunction a) = (conjunction ((map rem_impl) a))
  | rem_impl (disjunction a) = (disjunction ((map rem_impl) a))
  | rem_impl (equivalence a) = (rem_impl(rem_equi(equivalence a)))
  | rem_impl (negation a) = (negation (rem_impl(a)))
  | rem_impl (pos_FORMULA (a, b, c)) = pos_FORMULA (a, b, rem_impl(c))
  | rem_impl (implication (a, b)) = (disjunction [
    negation (rem_impl(a)), rem_impl(b)])
  | rem_impl (x) = x

(* --------------------
*  function is_phorn_knf:
*  returns true if the given formula in KNF (Konjunktive
*  Normalform) is positive horn. Otherwise returns false.
*)
fun is_phorn_knf (conjunction nil) = true
  | is_phorn_knf (conjunction (a::b)) = let
    fun is_neg_lst (nil) = true
      | is_neg_lst ((negation (atom e))::f) = is_neg_lst(f)
      | is_neg_lst (e) = false
    fun is_phorn_dis (disjunction nil) = true
      | is_phorn_dis (disjunction (c::nil)) = is_pos_lit(c)
      | is_phorn_dis (disjunction (c::d)) = ((is_pos_lit(c) andalso is_neg_lst(d))
        orelse (is_neg_lit(c) andalso is_phorn_dis(disjunction d)))
    in (is_phorn_dis(a) andalso is_phorn_knf(conjunction b)) end
  | is_phorn_knf x = false

(* --------------------
*  function is_phorn:
*  returns true if the given formula is positive horn.
*  Otherwise returns false.
*)
(* !!! UNFERTIG !!! <-- kann nur Formeln in BPF annehmen *)
fun is_phorn f = (is_phorn_knf(knf_of(rem_impl(rem_allq (elim_strong_eq f)))))
    handle _ => false
end
end
