(* ----------------------------------------------------------------------- *)
(* ltypes.sml                             Pascal Schmidt <pharao90@tzi.de> *)
(* ----------------------------------------------------------------------- *)
(* latex representation types and output functions                         *)
(* ----------------------------------------------------------------------- *)

(* $Id: ltypes.sml,v 1.1 2004/02/13 11:29:20 7till Exp $ *)

structure latex_types
=
struct

  datatype lstring = nop
                   | verbatim of string
                   | newline
                   | lnewline
                   | items_begin
                   | items_end
                   | item
                   | math_begin
                   | math_end
                   | tab_begin
                   | tab_end
                   | tab
                   | indent of int

  fun printl nop          = ""
    | printl (verbatim s) = s
    | printl newline      = "\n"
    | printl lnewline     = "\\\\"
    | printl items_begin  = "\\begin{ITEMS}\n"
    | printl items_end    = "\\end{ITEMS}\n"
    | printl item         = "\\I"
    | printl math_begin   = "\\("
    | printl math_end     = "\\)"
    | printl tab_begin    = "\\["
    | printl tab_end      = "\\]"
    | printl tab          = " & "
    | printl (indent i)   = ""

  fun printll l =   "\\documentclass{article}\n"
                  ^ "\\usepackage{casl}\n"
                  ^ "\\parindent=0pt\n"
                  ^ "\\begin{document}\n"
                  ^ "\\begin{casl}\n\n" 
                  ^ String.concat ((map printl) l)
                  ^ "\n"
                  ^ "\\end{casl}\n"
                  ^ "\\end{document}\n"

  fun filel l fname = let
                        val st = TextIO.openOut fname
                      in
                        ( TextIO.output(st,printll l);
                          TextIO.closeOut st )
                      end

end
