
{- |
Module      :  $Header: /repository/caslbook/lncs2960-CD/Tools/Hets/src/Common/ListBrackets.hs,v 1.1 2004/02/13 14:50:41 5maeder Exp $
Copyright   :  (c) Christian Maeder and Uni Bremen 2003
Licence     :  similar to LGPL, see HetCATS/LICENCE.txt or LIZENZ.txt

Maintainer  :  maeder@tzi.de
Stability   :  provisional
Portability :  portable
    
parse b1__b2 in %list-annotations differently from mixIds. 

An opening square bracket in b1 must not be interpreted as the beginning of
a compound list. b1 and b2 must not contain places. b1 must at least
have one open brace or square bracket to ensure that list
elements can be comma separated. b2 may end with a
compound-list. Braces and brackets in b1__b2 together must match.

-}

module Common.ListBrackets where

import Common.Token
import Common.Id
import Common.Lib.Parsec

checkForPlaces :: ([String], [String]) -> [Token] -> GenParser Char st [Token] 
checkForPlaces l ts = 
    do let ps = filter isPlace ts
       if null ps then nextListToks topMix3 l 
	  -- topMix3 starts with square brackets 
	  else if isSingle ps then return []
	       else unexpected "multiple places"

nextListToks :: (([String], [String]) -> GenParser Char st [Token])
	     -> ([String], [String]) -> GenParser Char st [Token]
nextListToks f l = 
    do ts <- f l 
       cs <- checkForPlaces l ts
       return (ts ++ cs)

listBrackets :: ([String], [String]) -> ([String], [String]) 
	     -> GenParser Char st Id
listBrackets keys idKeys = 
    do l <- nextListToks afterPlace keys -- start somehow
       (c, p) <- option ([], []) (comps idKeys)
       return (Id l c p)

caslListBrackets :: GenParser Char st Id
caslListBrackets = listBrackets casl_keys casl_keys
