{- Generated by DrIFT (Automatic class derivations for Haskell) -}
{-# LINE 1 "Syntax/AS_Structured.der.hs" #-}
{-| 
   
Module      :  $Header: /repository/caslbook/lncs2960-CD/Tools/Hets/src/Syntax/AS_Structured.hs,v 1.1 2004/02/13 14:50:49 5maeder Exp $
Copyright   :  (c) Klaus Lttich, Uni Bremen 2002-2004
Licence     :  similar to LGPL, see HetCATS/LICENCE.txt or LIZENZ.txt

Maintainer  :  hets@tzi.de
Stability   :  provisional
Portability :  non-portable(Grothendieck)

   These data structures describe the abstract syntax tree for heterogenous 
   structured specifications in HetCASL.

-}
{-
   todo:
     - ATermConversion SML-CATS has now his own module 
       (s. HetCATS/aterm_conv/)
     - LaTeX Pretty Printing
-}

module Syntax.AS_Structured where

-- DrIFT command:
{-! global: UpPos !-}

import Common.Id
import Common.AS_Annotation

import Logic.Logic (AnyLogic(Logic), rcoerce)
import Logic.Grothendieck
import Common.Result

data SPEC = Basic_spec G_basic_spec 
	  | Translation (Annoted SPEC) RENAMING 
	  | Reduction (Annoted SPEC) RESTRICTION 
	  | Union [(Annoted SPEC)] [Pos]
	    -- pos: "and"s
	  | Extension [(Annoted SPEC)] [Pos]
	    -- pos: "then"s
	  | Free_spec (Annoted SPEC) [Pos]
	    -- pos: "free"
	  | Cofree_spec (Annoted SPEC) [Pos]
	    -- pos: "cofree"
	  | Local_spec (Annoted SPEC) (Annoted SPEC) [Pos]
	    -- pos: "local", "within"
	  | Closed_spec (Annoted SPEC) [Pos]
	    -- pos: "closed"
          | Group (Annoted SPEC) [Pos]
	    -- pos: "{","}"
          | Spec_inst SPEC_NAME [Annoted FIT_ARG] [Pos]
	    -- pos: many of "[","]"; one balanced pair per FIT_ARG
	  | Qualified_spec Logic_name (Annoted SPEC) [Pos]
	    -- pos: "logic", Logic_name,":"
          | Data AnyLogic (Annoted SPEC) (Annoted SPEC) [Pos]
            -- pos: "data"
	    deriving (Show)


{- Renaming and Hiding can be performend with intermediate Logic
   mappings / Logic projections.

-}
data RENAMING = Renaming [G_mapping] [Pos]
	        -- pos: "with", list of comma pos 
		 deriving (Show,Eq)

data RESTRICTION = Hidden [G_hiding] [Pos]
		   -- pos: "hide", list of comma pos 
		 | Revealed G_symb_map_items_list [Pos]
		   -- pos: "reveal", list of comma pos 
		   deriving (Show,Eq)

data G_mapping = G_symb_map G_symb_map_items_list
	       | G_logic_translation Logic_code
		 deriving (Show,Eq)

data G_hiding = G_symb_list G_symb_items_list
	       | G_logic_projection Logic_code
		 deriving (Show,Eq)

data SPEC_DEFN = Spec_defn SPEC_NAME GENERICITY (Annoted SPEC) [Pos]
	         -- pos: "spec","=",opt "end"
		 deriving (Show)

data GENERICITY = Genericity PARAMS IMPORTED [Pos]
		  -- pos: many of "[","]" opt ("given", commas) 
		  deriving (Show)

data PARAMS = Params [Annoted SPEC]
	      deriving (Show)

data IMPORTED = Imported [Annoted SPEC]
		deriving (Show)

data FIT_ARG = Fit_spec (Annoted SPEC) G_symb_map_items_list [Pos]
	       -- pos: opt "fit"
	     | Fit_view VIEW_NAME [Annoted FIT_ARG] [Pos] [Annotation]
	       -- The list of Annotations is written before the keyword 'view'
	       -- pos: "view", opt many of "[","]"
	       deriving (Show)

data VIEW_DEFN = View_defn VIEW_NAME GENERICITY VIEW_TYPE
			   [G_mapping] [Pos]
	         -- pos: "view",":",opt "=", opt "end" 
		  deriving (Show)

data VIEW_TYPE = View_type (Annoted SPEC) (Annoted SPEC) [Pos]
	         -- pos: "to"
		 deriving (Show)

type SPEC_NAME = SIMPLE_ID
type VIEW_NAME = SIMPLE_ID

data Logic_code = Logic_code (Maybe Token) 
                             (Maybe Logic_name) 
			     (Maybe Logic_name) [Pos]
		 -- pos: "logic",<encoding>,":",<src-logic>,"->",<targ-logic>
                 -- one of <encoding>, <src-logic> or <targ-logic>
                 -- must be given (by Just)
                 -- "logic bla"    => <encoding> only 
                 -- "logic bla ->" => <src-logic> only
                 -- "logic -> bla" => <targ-logic> only
                 -- "logic bla1 -> bla2" => <src-logic> and <targ-logic>
                 -- -- "logic bla1:bla2"    => <encoding> and <src-logic>
                 -- ^ this notation is not very useful and is not maintained
                 -- "logic bla1:bla2 ->" => <encoding> and <src-logic> (!)
                 -- "logic bla1: ->bla2" => <encoding> and <targ-logic>
		  deriving (Show,Eq)

data Logic_name = Logic_name Token (Maybe Token)
		  deriving (Show,Eq)

homogenizeGM :: AnyLogic
              -> [Syntax.AS_Structured.G_mapping] -> Result G_symb_map_items_list
homogenizeGM (Logic lid) gsis = 
  foldl homogenize1 (return (G_symb_map_items_list lid [])) gsis 
  where
  homogenize1 res 
       (Syntax.AS_Structured.G_symb_map (G_symb_map_items_list lid1 sis1)) = do
    (G_symb_map_items_list lid sis) <- res
    sis1' <- rcoerce lid1 lid nullPos sis1
    return (G_symb_map_items_list lid (sis++sis1'))
  homogenize1 res _ = res 
{- ? Generated by DrIFT : Look, but Don't Touch. (works w/ haddock) ? -}
instance PosItem SPEC where
    up_pos_l _ (Basic_spec aa) = (Basic_spec aa)
    up_pos_l _ (Translation aa ab) = (Translation aa ab)
    up_pos_l _ (Reduction aa ab) = (Reduction aa ab)
    up_pos_l fn1 (Union aa ab) = (Union aa (fn1 ab))
    up_pos_l fn1 (Extension aa ab) = (Extension aa (fn1 ab))
    up_pos_l fn1 (Free_spec aa ab) = (Free_spec aa (fn1 ab))
    up_pos_l fn1 (Cofree_spec aa ab) = (Cofree_spec aa (fn1 ab))
    up_pos_l fn1 (Local_spec aa ab ac) = (Local_spec aa ab (fn1 ac))
    up_pos_l fn1 (Closed_spec aa ab) = (Closed_spec aa (fn1 ab))
    up_pos_l fn1 (Group aa ab) = (Group aa (fn1 ab))
    up_pos_l fn1 (Spec_inst aa ab ac) = (Spec_inst aa ab (fn1 ac))
    up_pos_l fn1 (Qualified_spec aa ab ac) =
	(Qualified_spec aa ab (fn1 ac))
    up_pos_l fn1 (Data aa ab ac ad) = (Data aa ab ac (fn1 ad))
    get_pos_l (Basic_spec _) = Nothing
    get_pos_l (Translation _ _) = Nothing
    get_pos_l (Reduction _ _) = Nothing
    get_pos_l (Union _ ab) = Just ab
    get_pos_l (Extension _ ab) = Just ab
    get_pos_l (Free_spec _ ab) = Just ab
    get_pos_l (Cofree_spec _ ab) = Just ab
    get_pos_l (Local_spec _ _ ac) = Just ac
    get_pos_l (Closed_spec _ ab) = Just ab
    get_pos_l (Group _ ab) = Just ab
    get_pos_l (Spec_inst _ _ ac) = Just ac
    get_pos_l (Qualified_spec _ _ ac) = Just ac
    get_pos_l (Data _ _ _ ad) = Just ad

instance PosItem RENAMING where
    up_pos_l fn1 (Renaming aa ab) = (Renaming aa (fn1 ab))
    get_pos_l (Renaming _ ab) = Just ab

instance PosItem RESTRICTION where
    up_pos_l fn1 (Hidden aa ab) = (Hidden aa (fn1 ab))
    up_pos_l fn1 (Revealed aa ab) = (Revealed aa (fn1 ab))
    get_pos_l (Hidden _ ab) = Just ab
    get_pos_l (Revealed _ ab) = Just ab



instance PosItem SPEC_DEFN where
    up_pos_l fn1 (Spec_defn aa ab ac ad) =
	(Spec_defn aa ab ac (fn1 ad))
    get_pos_l (Spec_defn _ _ _ ad) = Just ad

instance PosItem GENERICITY where
    up_pos_l fn1 (Genericity aa ab ac) = (Genericity aa ab (fn1 ac))
    get_pos_l (Genericity _ _ ac) = Just ac



instance PosItem FIT_ARG where
    up_pos_l fn1 (Fit_spec aa ab ac) = (Fit_spec aa ab (fn1 ac))
    up_pos_l fn1 (Fit_view aa ab ac ad) = (Fit_view aa ab (fn1 ac) ad)
    get_pos_l (Fit_spec _ _ ac) = Just ac
    get_pos_l (Fit_view _ _ ac _) = Just ac

instance PosItem VIEW_DEFN where
    up_pos_l fn1 (View_defn aa ab ac ad ae) =
	(View_defn aa ab ac ad (fn1 ae))
    get_pos_l (View_defn _ _ _ _ ae) = Just ae

instance PosItem VIEW_TYPE where
    up_pos_l fn1 (View_type aa ab ac) = (View_type aa ab (fn1 ac))
    get_pos_l (View_type _ _ ac) = Just ac

instance PosItem Logic_code where
    up_pos_l fn1 (Logic_code aa ab ac ad) =
	(Logic_code aa ab ac (fn1 ad))
    get_pos_l (Logic_code _ _ _ ad) = Just ad


--  Imported from other files :-
