-- -----------------------------------------------------------------------
--
-- $Source: /repository/uni/htk/resources/Tooltip.hs,v $
--
-- HTk - a GUI toolkit for Haskell  -  (c) Universitaet Bremen
--
-- $Revision: 1.4 $ from $Date: 2003/09/23 08:49:35 $  
-- Last modification by $Author: cxl $
--
-- -----------------------------------------------------------------------

module Tooltip (

  HasTooltip(..)

) where

import Wish
import GUIObject
import ReferenceVariables
import Computation


-- -----------------------------------------------------------------------
-- Tooltips (tix balloons, only available if using tixwish)
-- -----------------------------------------------------------------------

-- destruction is ignored, if no tooltip is defined

---
-- Widgets can have tooltips (if you are using tixwish).
class GUIObject w => HasTooltip w where
---
-- Sets the tooltip text for the given widget.
  tooltip :: String -> w -> IO w
---
-- Destroys the tooltip of the given widget (if exists).
  destroyTooltip :: w -> IO ()

  tooltip str w =
     do tixAvailable <- isTixAvailable
     	(if tixAvailable then 
     	  do
     	    nm <- getObjectName (toGUIObject w)
     	    execTclScript
     	      ["destroy " ++ show nm ++ "ttip",
     	       "tixBalloon " ++ show nm ++ "ttip",
     	       show nm ++ "ttip bind " ++ show nm ++" -msg \"" ++ 
     	       str ++ "\""]
     	 else done) >> return w

  destroyTooltip w =
     do tixAvailable <- isTixAvailable
     	(if tixAvailable then
     	  do
     	   nm <- getObjectName (toGUIObject w)
     	   execTclScript ["destroy " ++ show nm ++ "ttip"]
         else done)
