(* ------------------------------------------------------------------------ *)
(* reader.sml                                                               *)
(* specification reader for the casl standalone tool                        *)
(* Pascal Schmidt <pharao90@tzi.de>                                         *)
(* ------------------------------------------------------------------------ *)

(* $Id: reader.sml,v 1.1 2004/02/13 11:29:10 7till Exp $ *)


signature ReaderSig
=
sig
  val read_files : Options.casl_options -> string list ->
                   (string * (GlobalEnv.lib_env * GlobalEnv.global_env
                    * AS.LIB_DEFN)) list
end

structure Reader : ReaderSig
=
struct
open Utils

(* ------------------------------------------------------------------------ *)
(* Utility functions                                                        *)
(* ------------------------------------------------------------------------ *)

fun stripext s = let
                   val n = explode s
                 in
                   if (rev (take (5,rev n)))=explode(".casl") then
                     implode(rev (drop (5,rev n)))
                   else
                   if (rev (take (4,rev n)))=explode(".trm") then
                     implode(rev (drop (4,rev n)))
                   else
                   if (rev (take (4,rev n)))=explode(".baf") then
                     implode(rev (drop (4,rev n)))
                   else
		   if (rev (take (8,rev n)))=explode(".gen_trm") then
		       implode(rev(drop (8,rev n)))
		   else
		   if (rev (take (8,rev n)))=explode(".gen_baf") then
		       implode(rev(drop (8,rev n)))
		   else
		   if (rev (take (4,rev n)))=explode(".xml") then
		       implode(rev(drop (4,rev n)))
		   else
                     s
                 end

fun isbaf s = let
                val n = explode s
              in
                (rev (take (4,rev n)))=explode(".baf") 
		orelse
		(rev (take (8,rev n)))=explode(".gen_baf") 
              end

fun addext l s = if (Options.input_xml l) then
                   s ^ ".xml"
                 else
                   if (Options.input_casl l) then
                     s ^ ".casl"
                   else
     		   if (Options.input_gen_aterm l) then
		     if (Options.input_bin l) then
			 s ^ ".gen_baf"
                     else
			 s ^ ".gen_trm"
		   else
                     if (Options.input_bin l) then
                       s ^ ".baf"
                     else
                       s ^ ".trm"

fun prep_name l s = addext l (stripext s)

fun prep_names l n = (map (prep_name l)) n

fun flat (a,(b,c)) = (a,b,c)

(* ------------------------------------------------------------------------ *)
(* Reader functions                                                         *)
(* ------------------------------------------------------------------------ *)

fun clibenv l = if (Options.input_basic l) then
                  !LibraryAnalysis.basic_lib_env
                else
                  GlobalEnv.empty_lib_env

fun readf l x = if (not (exists x)) then
                  ( print ("Warning: file "^x^" does not exist.\n") ;
                    ("",((clibenv l),GlobalEnv.empty_global_env,
                     AS.empty_lib_defn)) )
                else
                 (Global.cur_file := x;
                  if (Options.input_xml l) then
                    let
                      val (ldef,genv) = xml_iface.file2lib x
                    in
                      (stripext x,(clibenv l,genv,ldef))
                    end
                  else
                  if (Options.input_casl l) then
                    if (Options.input_static l) then
                      (stripext x,(LibraryAnalysis.parse_and_check (clibenv l) (fn x=>()) false
                       (read_without_cr x)))
                    else
                      (stripext x,((clibenv l),GlobalEnv.empty_global_env,
                       ((CASLParser.parse false) o read_without_cr) x))
                  else
		   if (Options.input_gen_aterm l) then
(*		       if (Options.input_static l) then*)
			   (stripext x,
			    LibraryAnalysis.check 
				((clibenv l)) 
				(fn x=>()) 
				false 
				(AT_gen.as_LIB_DEFN(ATLib.file_to_aterm(x))))
		       (*else
			   (stripext x,
			    (flat((clibenv l),
				  (AT_gen.as_LIB_DEFN(ATLib.file_to_aterm(x)))
				  )
			     )
			    )*)
		   else
                    if (Options.input_static l) then
                      (stripext x,LibraryAnalysis.check ((clibenv l)) (fn x=>()) false (snd
                       (AT.load_casfix x)))
                    else
                      (stripext x,(flat ((clibenv l),AT.load_casfix x)))
                 )

fun unbin l x = if (exists x) then
                if (Options.input_bin l) then
                  if (isbaf x) then
                    ( OS.Process.system ("mv "^x^" /tmp/"^(stripext x));
                      OS.Process.system ("baf2trm < /tmp/"^(stripext x)^" > "^x);
                      () )
                  else
                    ()
                else
                  ()
                else
                  ()

fun rebin l x = if (exists ("/tmp/"^(stripext x))) then
                if (Options.input_bin l) then
                  if (isbaf x) then
                    ( OS.Process.system ("mv /tmp/"^(stripext x)^" "^x);
                      () )
                  else
                    ()
                else
                  ()
                else
                  ()

fun do_file l x = let
                    val a = unbin l x
                    val b = readf l x
                    val c = rebin l x
                  in
                    b
                  end

fun read_files l n = (map (do_file l)) (prep_names l n)

end
