(* ------------------------------------------------------------------------ *)
(* writer_graph.sml                                                         *)
(* graph writer for the casl standalone tool                                *)
(* Pascal Schmidt <pharao90@tzi.de>                                         *)
(* ------------------------------------------------------------------------ *)

(* $Id: writer_graph.sml,v 1.1 2004/02/13 11:29:10 7till Exp $ *)


signature WriterGraphSig
=
sig
    val write_graphs : Options.casl_options -> (string
                       * ('a * GlobalEnv.global_env * AS.LIB_DEFN)) list
                       -> unit list
end
                                                                                                                                               
structure WriterGraph : WriterGraphSig
=
struct

open Utils

fun basen []       = []
  | basen ("/"::t) = []
  | basen (h::t)   = h :: (basen t)

fun basename x = (implode o rev o basen o rev o explode) x

fun writef l (x,(le,(ge,a),tr)) = if (x<>"") then
                                if (Options.output_graph l) then

                                 ( if (Options.graph_davinci l) then
                                    write (out (x^".davinci"))
                                    (ModuleGraph.module_graph_davinci ge tr)
                                  else
                                    () ;
                                  if (Options.graph_dot l) then
                                    write (out (x^".dot"))
                                    (ModuleGraph.module_graph_dot ge tr)
                                  else
                                    () ;
                                  if (Options.graph_ps l) then
                                    ( out (x^".ps");
                                      write ("/tmp/"^(basename x))
                                      (ModuleGraph.module_graph_dot ge tr);
                                      OS.Process.system("dot -Tps /tmp/"^(basename x)^
                                      " -o "^x^".ps") ;
                                      OS.Process.system("rm /tmp/"^(basename x));
                                      () )
                                  else
                                    () )
                                else
                                  ()
                              else
                                ()


fun write_graphs l n = (map (writef l)) n

end
