
structure CASL98Pre =
struct

local open Library Term Mixfix
in
infix |>

val sign =
 CASL98Pure.sign
   |> Sign.prep_ext
   |> Sign.add_path "/"
   |> curry Sign.add_modesyntax
("", true)
[("predication2", "[ID , PredType , TTerms ] => Atom ", Mixfix ("'( pred _ : _ ') '( _ ')", [], 30)),
 ("predication3", "SIMPLE_ID  => Atom ", Mixfix ("_ ", [], 30)),
 ("predication4", "[TTermList ] => Atom ", Mixfix ("_ ", [], 30)),
 ("literal", "[Literal ] => SimpleTerm ", Mixfix (" _ ", [], max_pri)),
 ("char", "CHAR  => SimpleTerm ", Mixfix ("_", [], max_pri)),
 ("sign", "[SIGN ] => SimpleTerm ", Mixfix (" _ ", [], max_pri)),
 ("words", "[WORDS ] => SimpleTerm ", Mixfix (" _ ", [], max_pri)),
 ("dot_words", "[DOT_WORDS ] => SimpleTerm ", Mixfix (" _ ", [], max_pri)),
 ("digit", "[DIGIT ] => SimpleTerm ", Mixfix (" _ ", [], max_pri)),
 ("pterm", "[PLACE ] => SimpleTerm ", Mixfix (" _ ", [], max_pri)),
 ("emptyset", "SimpleTerm ", Mixfix ("{}", [], max_pri)),
 ("lessthan", "SimpleTerm ", Mixfix ("<", [], max_pri)),
 ("times", "SimpleTerm ", Mixfix ("*", [], max_pri)),
 ("question", "SimpleTerm ", Mixfix ("?", [], max_pri)),
 ("divides", "SimpleTerm ", Mixfix ("'/", [], max_pri)),
 ("arrow", "SimpleTerm ", Mixfix ("->", [], max_pri)),
 ("parrow", "SimpleTerm ", Mixfix ("->?", [], max_pri)),
 ("unequal", "SimpleTerm ", Mixfix ("<>", [], max_pri)),
 ("varterm", "[SIMPLE_ID , TOKEN_ID ] => SimpleTerm ", Mixfix ("'( var _ : _ ')", [], max_pri)),
 ("qualconstterm", "[ID , OpType ] => SimpleTerm ", Mixfix ("'( op  _ : _ ')", [], max_pri)),
 ("whenElseTerm", "[SimpleTerm , Formula , SimpleTerm ] => SimpleTerm ", Mixfix ("_ when _ else _", [31, 0, 30], 30)),
 ("cast", "[SimpleTerm , SIMPLE_ID ] => SimpleTerm ", Mixfix (" _ as _", [990], 990)),
 ("sortedTerm", "[SimpleTerm , TOKEN_ID ] => SimpleTerm ", Mixfix (" _ : _", [990], 990)),
 ("parTerm", "TTerms  => SimpleTerm ", Mixfix (" '( _ ')", [], max_pri)),
 ("braceTerm", "TTerms  => SimpleTerm ", Mixfix (" '{ _ '}", [], max_pri)),
 ("sqTerm1", "TTerms  => SimpleTerm ", Mixfix (" '[ _ ']", [], max_pri)),
 ("sqTerm2", "SimpleTerm ", Mixfix (" '[ ']", [], max_pri)),
 ("term1", "[SimpleTerm ] => TTerm ", Mixfix ("_", [], max_pri)),
 ("term2", "[SimpleTerm , TTerm ] => TTerm ", Mixfix ("_ _", [], max_pri)),
 ("termlist1", "[SimpleTerm , SimpleTerm ] => TTermList ", Mixfix ("_ _", [], max_pri)),
 ("termlist2", "[SimpleTerm , TTermList ] => TTermList ", Mixfix ("_ _", [], max_pri)),
 ("_idT", "TTerm  => TTerms ", Mixfix ("_", [], max_pri)),
 ("_consT", "[TTerm , TTerms ] => TTerms ", Mixfix ("_ ,/ _", [], max_pri))]


|> Sign.add_name "CASL98Pre";

end;
end;


