(*									   *)
(* Project: CATS 							   *)
(* Author: Kolyang, University of Bremen    			           *)
(* Date: 1998				 	        		   *)
(* Purpose of this file: Basic CASL Goaling infrastructure		   *)
(*			 						   *)	
(*									   *)
(* *********************************************************************** *)

(*  ID:         $Id: CASLTheory.sml,v 1.1 2004/02/13 11:28:52 7till Exp $ *)

(* Provides a notion of CASL theory and basic functions for manipulating
   theories, similar to Isabelle's theories
*) 


signature CASLTHEORY =
  sig
  datatype casltheory       = CASLthy of{casl_env : GlobalEnv.spec_lenv , thy   : theory};
  exception CASLTHEORY of string * casltheory list
  val get_caslaxiom : casltheory -> string -> thm
  val get_caslthm   : casltheory -> string -> thm
  val rep_casltheory        : casltheory -> {casl_env : GlobalEnv.spec_lenv, thy   : theory}
  val caslsign_of           : casltheory -> GlobalEnv.spec_lenv * Sign.sg
  val caslsyn_of            :  casltheory -> Syntax.syntax
(*  val stamps_of_caslthy     : casltheory -> string ref list *)
  val caslparents_of        : casltheory -> theory list 
  val caslsubthy            : casltheory * casltheory -> bool
  val casleq_thy            : casltheory * casltheory -> bool
(*  val merge_casltheories    : casltheory * casltheory -> casltheory *)
  val merge_caslthy_list    : theory list -> casltheory list -> casltheory 
(*  val delete_caslthm_db     : casltheory -> unit *)
  val caslaxioms_of : casltheory -> (string * thm) list
  val add_caslthyname : string -> casltheory -> casltheory 
  val print_casltheory     : casltheory -> unit
  val caslthms_of	    : casltheory -> (string * thm) list;
  val pprint_casltheory    : casltheory -> pprint_args -> unit;
end;


structure CASLTheory : CASLTHEORY =
struct


open Theory GlobalEnv;

datatype casltheory   = CASLthy of{casl_env  : spec_lenv, thy   : theory};

fun get_caslaxiom (CASLthy casltheo)  =  get_axiom (#thy casltheo);

fun get_caslthm   (CASLthy casltheo)  =  get_thm (#thy casltheo);

fun rep_casltheory (CASLthy x) = x

fun caslaxioms_of caslthy = axioms_of(#thy (rep_casltheory caslthy))
fun caslthms_of caslthy = thms_of(#thy (rep_casltheory caslthy))


fun caslsign_of (CASLthy {casl_env, thy}) =(casl_env, #sign (rep_theory thy))

(*fun delete_caslthm_db (CASLthy {casl_env, thy}) = delete_thm_db thy *)


fun casl_merge (SPEC_ENV(Sigma1,HSigma1,senv1),
                SPEC_ENV(Sigma2,HSigma2,senv2)) =
    SPEC_ENV(LocalEnv.signature_union(Sigma1,Sigma2),
             LocalEnv.signature_union(HSigma1,HSigma2),
             union_env [senv1,senv2])
 
	
fun merge_caslthy_list hthys Zsch = 
  let val caslenvS = map (fn CASLthy XS => #casl_env XS) Zsch;
      val thyS  = map (fn CASLthy XS => #thy XS) Zsch;
      val envir = foldl casl_merge (empty_spec_lenv,caslenvS)
  in  CASLthy{casl_env = envir,
           thy  = Theory.prep_ext_merge  (hthys@thyS)} (*was merge_thy_list till now*)
  end; 

(*errors involving theories*)
exception CASLTHEORY of string * casltheory list;


val caslsyn_of = #syn o Sign.rep_sg o snd o caslsign_of;

(*stamps associated with a theory*)
(*val stamps_of_caslthy = #stamps o Sign.rep_sg o snd o caslsign_of;*)

(*FIXME !!! return all ancestors*)
fun caslparents_of (CASLthy {casl_env, thy}) = parents_of thy

fun add_caslthyname name (CASLthy {casl_env, thy}) = CASLthy{casl_env= casl_env, 
                                                thy = add_name name thy} 


(* FIXME ! compare theories*)
val caslsubthy = Sign.subsig o pairself (snd o caslsign_of);
val casleq_thy = Sign.eq_sg o pairself (snd o caslsign_of);

(*fun merge_casltheories (thy1, thy2) = merge_caslthy_list [] [thy1, thy2];*)


fun print_casltheory (CASLthy {casl_env, thy}) = print_theory thy

val pprint_casltheory = Sign.pprint_sg o Theory.sign_of o (#thy) o rep_casltheory;

end;

