CASL_context List.casl;

AddsimpAll ();

set trace_simp;

val digit_defs = [Nat_1_def, Nat_2_def, Nat_3_def, Nat_4_def, Nat_5_def];
val rev_digit_defs = map (fn x => x RS sym) digit_defs;

Goal "forall n:Nat . n = #testlist";
by (ALLGOALS Simp_tac);
by (simp_tac (HOL_ss addsimps rev_digit_defs) 1);
by (simp_tac (HOL_ss addsimps digit_defs) 1);

Goal "forall L:List . L++[] = L";
by (induct_tac "L" 1);
by (ALLGOALS Simp_tac);
qed "concat_nil_right";

Goal "forall K,L,M : List . K++(L++M) = (K++L)++M";
by (induct_tac "K" 1);
by (ALLGOALS Simp_tac);
qed "concat_assoc";

Addsimps [concat_nil_right,concat_assoc];

Goal "forall K,L:List .  reverse(K)++reverse(L) =  reverse(L++K)";
by (induct_tac "L" 1);
by (ALLGOALS Simp_tac);
qed "concat_reverse";

Goal "forall K,L:List . #(K++L) = #K + #L";
by (induct_tac "K" 1);
by (ALLGOALS Simp_tac);
qed "count_concat";

Addsimps [count_concat];

CASL_context Tree.casl;

AddsimpAll ();
AddSimpParents ();

Goal "forall t:Tree . #t = #flatten(t)";
by (induct_tac "t" 1);
by (ALLGOALS Simp_tac);
qed "count_flatten";


