(*  Title:      Pure/ML-Systems/polyml.ML
    ID:         $Id: polyml-4.x.ML,v 1.1 2004/02/13 11:29:19 7till Exp $
    Author:     Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Compatibility file for Poly/ML (version 4.x).
*)

(* SMLNJ for library.ML *)
structure ML_interface =
struct
(*  Title:      Pure/ML-Systems/smlnj.ML
    ID:         $Id: polyml-4.x.ML,v 1.1 2004/02/13 11:29:19 7till Exp $
    Author:     Carsten Clasohm and Markus Wenzel, TU Muenchen

Compatibility file for Standard ML of New Jersey versions 109.27 to
109.33, and 110 or later.
*)

(** ML system related **)
open PolyML

(* in Poly/ML is no variable accessible for the print_depth,
 but get_print_depth: fn unit -> int *)

(* make OS.Process.isSuccess visible after opening *) 
val isSuccess = OS.Process.isSuccess

(* restore old-style character / string functions *)

fun ord s = Char.ord (String.sub (s, 0));
val chr = str o Char.chr;
val explode = (List.map str) o String.explode;
val implode = String.concat;

(*Note start point for timing*)
fun startTiming() = 
  let val CPUtimer = Timer.startCPUTimer();
      val time = Timer.checkCPUTimer(CPUtimer)
  in  (CPUtimer,time)  end;

(*Finish timing and return string*)
fun endTiming (CPUtimer, {sys,usr}) =
  let open Time  (*...for Time.toString, Time.+ and Time.- *)
      val {sys=sys2,usr=usr2} = Timer.checkCPUTimer(CPUtimer)
  in  "User " ^ toString (usr2-usr) ^
      (*"  GC " ^ toString (gc2-gc) ^*)
      "  All "^ toString (sys2-sys + usr2-usr) ^
      " secs"
      handle Time => ""
  end;

end;(* End of ML_interface for library.ML *)






