(* ----------------------------------------------------------------------- *)
(* regions.sml                            Pascal Schmidt <pharao90@tzi.de> *)
(* ----------------------------------------------------------------------- *)
(* calculation with regions and other misc info                            *)
(* ----------------------------------------------------------------------- *)

(* $Id: regions.sml,v 1.1 2004/02/13 11:29:20 7till Exp $ *)

structure latex_regions
=
struct

  exception RegionExpected
  
  local open AS in

    (* formula requires brackets around it *)  
    fun formula_bracketed (pos_FORMULA (_,b,_)) = b
      | formula_bracketed _                     = raise RegionExpected

    (* convert region to 4-tuple *)
    fun region_to_tuple ((a,b),(c,d)) = (a,b,c,d)

    (* ------------------------------------------------------------------- *)
    (* test functions for region 4-tuples                                  *)
    (* ------------------------------------------------------------------- *)
    
    (* assuming coordinates are x,y not y,x *)

    (* single element contained on one line *)
    fun is_single_line (_,a,_,b) = (a=b)
    
    (* single element spans multiple lines *)
    fun is_multiline (_,a,_,b) = (a<b)

    (* two elements on the same line *)
    fun is_same_line (_,_,_,a) (_,_,_,b) = (a=b)
    
    (* two elements adjacent to each other on different lines *) 
    fun is_adjacent_y (_,_,_,a) (_,b,_,_) = ((a+1)=b)
    
    (* two elements adjacent to each other on the same line *)
    fun is_adjacent_x (_,_,a,b) (_,_,x,y) = (b=y) andalso (x>a)

    (* vertical space between two elements *)
    fun is_space_between (_,_,_,a) (_,b,_,_) = ((a+1)<b)

  end

end
