(* ----------------------------------------------------------------------- *)
(* xml_iface.sml                          Pascal Schmidt <pharao90@tzi.de> *)
(* ----------------------------------------------------------------------- *)
(* interface functions for XML generator                                   *)
(* ----------------------------------------------------------------------- *)

(* $Id: xml_iface-poly.sml,v 1.1 2004/02/13 11:29:21 7till Exp $ *)

signature xml_iface_sig
=
sig
  val lib2string     : bool -> AS.LIB_DEFN -> string
  val lib2file       : bool -> AS.LIB_DEFN -> string -> unit

  val lib_env2string : bool -> (AS.LIB_DEFN * GlobalEnv.global_env) -> string
  val lib_env2file   : bool -> (AS.LIB_DEFN * GlobalEnv.global_env) -> string
                       -> unit

  val libitem2string : bool -> AS.LIB_ITEM -> string
  val libitem2file   : bool -> AS.LIB_ITEM -> string -> unit

  val casenv2string  : bool -> GlobalEnv.global_env -> string
  val casenv2file    : bool -> GlobalEnv.global_env -> string -> unit

  val fcasenv2string : bool -> GlobalEnv.f_global_env -> string
  val fcasenv2file   : bool -> GlobalEnv.f_global_env -> string -> unit

  val file2lib       : string -> AS.LIB_DEFN * GlobalEnv.global_env
end

structure xml_iface : xml_iface_sig
=
struct

  exception NotImplementedInPolyML

  fun file2lib s = raise NotImplementedInPolyML

  fun lib2string b tr = raise NotImplementedInPolyML
  
  fun lib2file b tr f = raise NotImplementedInPolyML

  fun lib_env2string b (tr,ge) = raise NotImplementedInPolyML
  
  fun lib_env2file b (tr,ge) f = raise NotImplementedInPolyML

  fun libitem2string b tr = raise NotImplementedInPolyML
  
  fun libitem2file b tr f = raise NotImplementedInPolyML
  
  fun casenv2string b g = raise NotImplementedInPolyML

  fun casenv2file b g f = raise NotImplementedInPolyML

  fun fcasenv2string b g = raise NotImplementedInPolyML

  fun fcasenv2file b g f = raise NotImplementedInPolyML
end
