(* *********************************************************************** *)
(*									   *)
(* Project: HOL-CASL 							   *)
(* Author: Till Mossakowski, University of Bremen          		   *)
(* Date: 05.11.2001				 			   *)
(* Purpose of this file: Proof script for Basic/SimpleDatatypes            *)
(*			 						   *)	
(*									   *)
(* *********************************************************************** *)

print_mode := ["Inj"];  (* Show injections, but not types *)


(************************ Specification Boolean *******************************)

CASL_context Boolean.casl;

(* Abbreviations for getting axioms *)
val getBoolean = get_caslaxiom Boolean.casl;

(* Feed all axioms into simplifier - a bit dangerous ... *)

AddsimpAll ();

Goal "forall x:Boolean . Not(Not(x))=x";
by (induct_tac "x" 1);
by (ALLGOALS Simp_tac);
qed "Boolean_Not_Not";

Addsimps [Boolean_Not_Not];

Goal "forall x,y:Boolean .  x And y = Not(Not(x) Or Not(y))";
by (Simp_tac 1);
qed "Boolean_de_Morgan";


