    
c*********************************************************************
c   main program
c
      program tur_model
      parameter (nxm=200,nym=151)
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc2/ delf(nym),delu(nym),delv(nym),delw(nym)
      common /blog/ csmodel, kemodel, low_re, high_re, zonal
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      logical csmodel, kemodel, low_re, high_re, zonal, convg 
	CHARACTER*80 input_name, output_name
      data igrowt/3/,itmax/15/,epst/0.01/
      data dunp/0.0025/,dvnp/0.0005/ 
c   ------------------------------------------------------
      write(6,*) "Enter input file name (include extension name)"
      read(5, *) input_name
      write(6,*) "Enter output file name"
      read(5, *) output_name 
      open(unit=5, file=input_name, status="OLD")
      open(unit=6, file=output_name)

      call input
      call ivpt
      call eddy
c
      if(kemodel) then
c
         call keinitk
         call keinitg
      endif
c
      nx   = 0
c
c  loop of b. l. calculations
c
10    nx = nx + 1
      rx    = rl*ue(nx)*x(nx)
      sqrx  = sqrt(rx)
      xsqrx = x(nx) / sqrx
      write(6,300)
      write(6,320) nx,x(nx),xc(nx),rx,ue(nx),p2(nx)
      if(nx .eq.1) goto 110
c
c  setup the minmum iterations required to introduce 
c  under-relaxation procedure for higher-order turbulence models
c
      itmin = 1
      if(low_re) then
         itmin = 2
         if(nx.le.3) itmin = 5 
      endif
      it    = 0
      igrow = 0
      convg = .false.
c
c  loop of iteration
c
   30 it    = it + 1
      if(it .gt. itmax) then
c
c  solution fails to converge after itmax iterations. cal. stops
c
         write(6,220) nx
         nxt  = nx - 1
         index=2
         goto 110
      elseif(v(1,2) .lt. 0.0) then 
c
c  flow separates; cal. stops
c
         write(6,230) nx
         nxt  = nx - 1
         index= 2
         goto 110
      else
c
         if(csmodel) then
c
c  c. s. model
c
            call coeftr
            call solv3
         elseif(kemodel ) then 
c
c  k. e. model, including zonal method
c
            call kecoef 
            call kesolv  
         endif
c
         write(6,1001) it,v(1,2),delv(1),delw(1) 
c
c   check for convergence
c
         if(it .gt.itmin) then
            if(abs(delv(1)/v(1,2)) .lt. epst) then 
c
c   sol has converged;  check for growth
c
               if(np .lt. npt .and. igrow .le. igrowt) then
                  if(abs(v(np,2)) .gt. dvnp .or. abs(1.0-
     +                   u(np-2,2)/u(np,2)).gt.dunp) then
                     igrow = igrow + 1
                     call growth
                  else 
c
c  both growth and convergence are satified. sol. converges
c
                     convg = .true.
                  endif
               else
                  convg = .true.
               endif
            endif
         endif
c
         if(.not.convg) goto 30
      endif
      index = 1
c
c  print and calculate b. l. data
c
  110 call output(index) 
      if(nx .lt. nxt) goto 10
C     call qwik
      close(5)
	close(6)
	PRINT*," "
	PRINT*,"Calculations are successfully completed."
      PRINT*,"The output is saved in ", output_name
	PRINT*," "
 	PRINT*,"Hit any key to close this DOS-window."
 	READ(5,*)
      stop
c
c----------------------------------------------------------------------
  220 format(1x,'**iterations exceed max **at nx = ',i3/
     1       '   calculation stopped ')
  230 format(1x,'**flow separated **at nx = ',i3/
     1       '   calculation stopped ')
  300 format(/66('*-')/)
  320 format(3x,4hnx =,i5,4x,3hx =,f10.5,4x,5hx/c =,f10.5,
     +       4x,4hrx =,e10.3,4x,4hue =,f10.5,4x,4hp2 =,f10.5/)
 1001 format(3x,'convergence history: it,v1,delv1,delw',i3,3e12.4) 

      end
c
      subroutine growth
c
c  this subroutine defines the profiles when the b.l. grows
c
      parameter (nxm=200,nym=151)
      real k,kk 
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc3/ ff(nym),uu(nym),vv(nym),kk(nym),gg(nym),e3(nym)
      common /cek0/ k(nym,2),g(nym,2),s(nym,2),q(nym,2),gd(nym,2),
     +              z(nym,2),bs(nym),edvcs(nym),yk(nym),uv(nym),
     +              cmu(nym),b2(nym,2),b3(nym,2),fmu(nym,2),
     +              f1(nym,2),f2(nym,2),sigg(nym,2),sigk(nym,2),
     +              yplus(nym),uplus(nym)
      common /blog/ csmodel, kemodel, low_re, high_re, zonal

      logical csmodel, kemodel, low_re, high_re, zonal 
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      if(np.ge.npt) return
      j1    = np
      np1   = np+1
      np    = min0(npt,np+2)
      i1    = 1
      if(nx.eq.1) il = 2
      do i=i1,2
         do j=np1,np
            f(j,i)   = f(j-1,i)+u(j-1,i)*deta(j-1)
            u(j,i)   = u(j-1,i)
            v(j,i)   = 0.0
            b(j,i)   = b(j-1,i)
            w(j,i)   = w(j-1,i)
         enddo
         if(i.eq.2) then
            do  j=np1,np
               ff(j)    = ff(j-1)
               uu(j)    = uu(j-1)
               vv(j)    = vv(j-1)
            enddo
         endif
c
         if(kemodel) then
c
c  additional data for zonal model
c
            do j=np1,np
               g(j,i)   = g(j-1,i)
               k(j,i)   = k(j-1,i)
               s(j,i)   = 0.0
               z(j,i)   = 0.0
               q(j,i)   = 0.0
               fmu(j,i) = fmu(j-1,i)
               f1(j,i)  = f1(j-1,i)
               f2(j,i)  = f2(j-1,i)
               sigg(j,i)= sigg(j-1,i)
               sigk(j,i)= sigk(j-1,i)
               gd(j,i)  = gd(j-1,i)
            enddo
            if(i.eq.2) then
               do j=np1,np
                  kk(j)    = kk(j-1)
                  gg(j)    = gg(j-1)
               enddo
            endif
         endif
      enddo
c
      return
c
  700 format(1h0,'** boundary layer growth.',i2,' point(s) added',
     1           ' to the upper wake. **')
      end
c 
      subroutine input
      parameter (nxm=200,nym=151)
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blog/ csmodel, kemodel, low_re, high_re, zonal 
      common /smry/ cf(nxm),umin(nxm),tht2(nxm),dls2(nxm),h2(nxm),
     +              rtht2(nxm),rdls2(nxm)
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      common /work/ d1(nxm), d2(nxm), d3(nxm)
      common /init/ cnu,rthta,cfa,uref,chord,yplusw,vgp,yedge
      common /csmod/ ffs(nxm),alfas(nxm)
c
      dimension yc(nxm)
      character*80 title,subtitle 
C     character*80 file23 
      logical csmodel, kemodel, low_re, high_re, zonal  
c   ------------------------------------------------------
c  read data 
c
      read ( 5,3010 ) title
      read ( 5,3010 ) subtitle
      read ( 5,*    ) nxt,model 
      read ( 5,3010 ) subtitle
      read ( 5,*    ) (xc(i) , i=1,nxt)
      read ( 5,3010 ) subtitle
      read ( 5,*    ) (yc(i) , i=1,nxt)
      read ( 5,3010 ) subtitle
      read ( 5,*    ) (ue(i) , i=1,nxt)
      read ( 5,3010 ) subtitle
      read ( 5,*    ) uref,cfa,rthta,cnu,chord
c
c  read qwikplot file name for post-process
c
C     read ( 5,3010 ) file23
c
c     open(23,file=file23,form='unformatted')
      npt   = nym
      cdamp = 200.0
      icmu  = 0
      vgp   = 1.12
c
c  set the first grid size off the wall
c
      if(model.gt.0) then 
c
c  low_re k. e. model
         yplusw = 0.50
      else
c
c  cs, zonal, or high ke model
         yplusw = 1.00
      endif
c
      rl   = uref / cnu
      x(1) = amax1(xc(1)*chord, 0.05 )
      do i = 2,nxt
         x(i)=x(i-1)+chord*sqrt((xc(i)-xc(i-1))**2+(yc(i)-yc(i-1))**2)
      enddo
c
c  introduce xo to reduce the effective computational length scale
c  to better control yplus at the wall
c
      xnn  = 4.0
      ratio  = x(nxt) / x(1)
      if(ratio .gt. xnn) then
         xo  = (x(nxt) - xnn * x(1)) / (xnn-1.0)
         do i = 1,nxt
            x(i) = x(i) + xo
         enddo
      endif
c
c  calculate p1 and p2
c
      call diff1(nxt, x, ue, duedx)
      do i = 1,nxt
         p2(i)   = x(i) * duedx(i) / ue(i)
         p1(i)   = 0.5 * (1.0 + p2(i))
         ffs(i)  = 1.0
         alfas(i)= 0.0168
      enddo
c
c set logic variables for turbulence models 
c
      kemodel = .false.
      low_re  = .false.
      high_re = .false.
      zonal   = .false.
      csmodel = .false.
      if(model .eq. 0) then
c
c  c. s. model
c
         csmodel = .true.
      else
c
c  variation k. e. model
c
         kemodel = .true.
         if(model.gt.0) then
            low_re = .true.
         elseif(model.eq.-1) then
            zonal = .true.
         elseif(model.eq.-2) then
            high_re = .true.
         endif
      endif
c
c   print out data
c
      write(6,2001) title
      write(6,2002) (i,x(i),xc(i),yc(i),ue(i),p1(i),p2(i),
     +               i=1,nxt)
      write(6,2003) rl,uref,cfa,rthta,cnu,chord,model,icmu
c
      return
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -  -
 3010 format(a80)
 2001 format(/20x,a80,/)
 2002 format(1x,'geometry coordinates and pressure gradients',
     +      /1x,3x,2hnx,5x,1hx,11x,2hxc,11x,2hyc,11x,2hue,
     +           11x,2hp1,11x,2hp2,7x/(1h ,i5,6f12.5))
 2003 format(1x,'***** boundary layer input data *****',
     +      /1h ,5x,'reference reynolds number       rl =',e12.4,
     +      /1h ,5x,'reference velocity,           uref =',e12.4,
     +      /1h ,5x,'cf at the 1st station,          cf =',e12.4,
     +      /1h ,5x,'rtheta at the 1st station,  rtheta =',e12.4,
     +      /1h ,5x,'kinematic viscosity,           cnu =',e12.4,
     +      /1h ,5x,'reference length,            chord =',e12.4,
     +      /1h ,5x,'turb. model control flag,    model =',i5,
     +      /1h ,5x,'option for cmu formula,      icmu  =',i5)
      end
c
      subroutine ivpt
c
c  --------------------------------------------------------------------
c
c  generate turbulent b. l. profiles based on :
c  1. Granville's modification of Coles' wake law
c  2. Thompson's profile for the blending region, y+: 4~50
c
      parameter (nxm=200,nym=151)
      real k
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      common /work/ d1(nxm), d2(nxm), d3(nxm)
      common /cek0/ k(nym,2),g(nym,2),s(nym,2),q(nym,2),gd(nym,2),
     +              z(nym,2),bs(nym),edvcs(nym),yk(nym),uv(nym),
     +              cmu(nym),b2(nym,2),b3(nym,2),fmu(nym,2),
     +              f1(nym,2),f2(nym,2),sigg(nym,2),sigk(nym,2),
     +              yplus(nym),uplus(nym)
      common /cek1/ cedv(nym),ce1,ce2,ce3,sigke,sigge,yplus1,jeta,
     +              fmu1,fmu2,sigk1,rgmin,rkmin
      common /init/ cnu,rthta,cfa,uref,chord,yplusw,vgp,yedge
c
      dimension ff(nym),df(nym)
      data ck1,ck2,ck3,ck4,cb,rk/1.0828,-0.41394,2.26564,-0.32396,
     +                        5.2,0.41/
      data pi/3.14159265/
c---------------------------------------------------------------------
      grang(x1,x2,x3,y1,y2,y3,x0)= (x0-x2)*(x0-x3)/(x1-x2)/(x1-x3)*y1
     1           +(x0-x1)*(x0-x3)/(x2-x1)/(x2-x3)*y2+(x0-x1)*(x0-x2)
     2           /(x3-x1)/(x3-x2)*y3
      nx    = 1
      rx    = rl * ue(nx) * x(nx)
      sqrx  = sqrt(rx)
      xsqrx = x(nx)/sqrx
      cfo2  = cfa/2.0
      utau  = sqrt(cfo2)
      crk   = cb*rk
      thetap= rthta*utau
      theta = rthta/rl/ue(nx)
      jeta  = 1
c
c  generate velocity profile along streamline direction
c  loop of iteration for calculating delta
      it = 0
      yy = 0.125
c
c  note that ypluse is the estimated yplus at the edge of b. l.
c  and yplusw is yplus at the first point away from the wall
c
   10 ypluse = thetap/yy
      ylog   = alog(ypluse)
      pie    = 0.5*(rk/utau-ylog-crk)
      delta0 = 1.0
      deta(1)= yplusw/ypluse
      call grid(np,npt,yk,deta,a,vgp,delta0)
c
      u(1,2) = 0.0
      ff(1)  = 0.0
      df(1)  = 0.0
      theta1 = 0.0
      dtheta = 0.0
      v(1,2) = ypluse*utau
      dyj    = 1.0
      jj = 0
      do j = 2,np
         yj    = yk(j)
         ystar = ypluse*yk(j)
         ylog = alog(ystar)
         uwake = (pie*(1-cos(pi*yj))+yj**2*(1.0-yj))/rk
         duwake= (0.5*(1-cos(pi*yj)))/rk/yy
         vwake = ((pie*pi*sin(pi*yj)+yj*(2.0-3.0*yj)))/rk
         if(ystar .le. 4.0) then
c
c  sublayer
            us  = ystar
            dus = -thetap*yk(j)/yy**2
            vj  = ypluse
            us   = us + uwake
            dus  = dus+ duwake
            vj   = vj + vwake
            jj = jj + 1
         else
            if(ystar .lt. 50.0) then
c
c  blending region
               us   = ck1+ylog*(ck2+ylog*(ck3+ck4*ylog))
               dus  = -(ck2+ylog*(2.0*ck3+3.0*ck4*ylog))/yy
               vj   = -dus*yy/yk(j)
               us   = us + uwake
               dus  = dus+ duwake
               vj   = vj + vwake
            else
c
c  fully turbulent region
               us   = (ylog+crk)/rk+ uwake
               dus  = (-1)/rk/yy + duwake
               vj   = (1.0/yk(j))/rk + vwake
            endif
         endif
c
         u(j,2) = us*utau
         du     = dus*utau
         v(j,2) = vj*utau
         ff(j)  = u(j,2)*(1.0-u(j,2))
         df(j)  = du*(1.0-2.0*u(j,2))
         theta1 = theta1+0.5*(yk(j)-yk(j-1))*(ff(j)+ff(j-1))
         dtheta = dtheta+0.5*(yk(j)-yk(j-1))*(df(j)+df(j-1))
      enddo
c
      u(np,2) = 1.0
c
      delta = theta/yy
      dyy   = (theta1-yy)/(dtheta-1.0)
      if(abs(dyy/yy) .gt. 1.0e-05 .and. it.lt.10) then
         yy = yy - dyy
         it = it+1
         go to 10
      endif
c
c   transform velocity and grids in the calculation coordinates
c
      yk2eta = delta/xsqrx
      eta(1) = yk(1)*yk2eta
      do j = 2,npt
         eta(j)    = yk(j)*yk2eta
         deta(j-1) = eta(j) - eta(j-1)
         a(j)      = 0.5*deta(j-1)
      enddo
c
      f(1,2)  = 0.0
      vconvt  = 1. / yk2eta
      v(1,2)  = v(1,2) * vconvt
      w(1,2) = sqrt(cfo2)
      do j = 2,np
         w(j,2) = w(1,2)
         v(j,2) = v(j,2) * vconvt
         f(j,2) = f(j-1,2)+a(j)*(u(j,2)+u(j-1,2))
      enddo
c
      if(abs(v(np,2)) .gt. 0.0005 .or. abs(1.0-u(np-2,2))
     +          .gt.0.005) call growth

      return
      end
c
      subroutine grid(np,npt,y,dy,a,vgp,etae)
c
c  this subroutine generates b.l. grid in eta direction for given
c  np,npt,etae,dy(1) and vgp 
c
      dimension y(1),dy(1),a(1)
c  ---------------------------------------------------------------
c   generate grid for given etae( =y(np)), dy(1) and vgp1
c
   10 np  = alog(1.0+(vgp-1.0)*etae/dy(1))/alog(vgp)+1.001
      if(np .lt. npt*2/3) go to 20
      vgp   = 1.05 * vgp
      go to 10
   20 em    = dy(1)*(vgp**(np-1)-1.0)/(vgp-1.0)
      dy(1) = dy(1)*etae/em
      y(1)  = 0.0
      do j = 2,npt
         y(j) = y(j-1) + dy(j-1)
         dy(j)= vgp*dy(j-1)
         a(j) = 0.5*dy(j-1)
         if(y(j) .le. etae) np = j
      enddo
      return
      end

      subroutine output(index) 
c
c  the subroutine calculates the b. l. parameters & print out the
c  profiles
c
      parameter (nxm=200,nym=151)
      real k,kk 
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc3/ ff(nym),uu(nym),vv(nym),kk(nym),gg(nym),e3(nym)
      common /blog/ csmodel, kemodel, low_re, high_re, zonal
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      common /smry/ cf(nxm),umin(nxm),tht2(nxm),dls2(nxm),h2(nxm),
     +              rtht2(nxm),rdls2(nxm)
      common /cek0/ k(nym,2),g(nym,2),s(nym,2),q(nym,2),gd(nym,2),
     +              z(nym,2),bs(nym),edvcs(nym),yk(nym),uv(nym),
     +              cmu(nym),b2(nym,2),b3(nym,2),fmu(nym,2),
     +              f1(nym,2),f2(nym,2),sigg(nym,2),sigk(nym,2),
     +              yplus(nym),uplus(nym)
      dimension d1(nxm)
      logical csmodel, kemodel, low_re, high_re, zonal 
      data rk,cb,ck1,ck2,ck3,ck4,ckf1/0.41,5.2,5.94884,13.4682,
     +     13.5718,-785.20,-48.754/
c    - - - - - - - - - - -- - - - - - - - - - - - - - - - - - - - - - --
      if(index .eq. 2) goto 100
c
      if(csmodel) then
         cf(nx) = 2.0*v(1,2)/sqrx
         w(1,2) = sqrt(cf(nx)/2.0)
         do j = 1,np
            w(j,2) = w(1,2)
         enddo
      else
         cf(nx)   = 2.0*w(1,2)**2
      endif
c
      do j = 1,np
         yplus(j) = sqrx * eta(j) * w(1,2)
         uv(j)    = edv(j)*v(j,2)/sqrx
         uplus(j) = u(j,2) /w(1,2)
         yk(j)    = eta(j)*xsqrx
      enddo
      sum1 = 0.0
      sum2 = 0.0
      t1   = 1.0 - u(1,2)
      t3   = t1 * u(1,2)
      do j = 2,np
         t2   = 1.0 - u(j,2)
         t4   = t2 * u(j,2)
         sum1 = sum1 + a(j)*(t1+t2)
         sum2 = sum2 + a(j)*(t3+t4)
         t1 = t2
         t3 = t4
      enddo
      dls2(nx) = xsqrx * sum1
      tht2(nx) = xsqrx * sum2
c
      if (high_re) then
c
c  calculate near wall contributions to dels & tht2  
c  for high-reynolds-number k. e. model
c
         yplus1 = sqrx * eta(1) * w(1,2)
         yg     = alog(yplus1)
         y1     = yk(1) 
         wf1    = y1 * w(1,2) * ((yg-1.0)/rk + cb + ckf1/yplus1)
         aplus  = 0.5*(ck1*yg**2+ck2*yg + ck3 +ck4/yplus1)
         wdls2  = y1 - wf1
         wth2   = wf1 - y1 * cf(nx) * aplus 
         dls2(nx) = dls2(nx) + wdls2
         tht2(nx) = tht2(nx) + wth2
      endif
c 
      rtht2(nx)= rl*tht2(nx)*ue(nx)
      rdls2(nx)= rl*dls2(nx)*ue(nx)
      h2(nx)   = dls2(nx)/tht2(nx)
c
      write(6,350)  cf(nx),h2(nx),tht2(nx),dls2(nx),rtht2(nx),
     +              rdls2(nx)
c
c  print out profiles
c
      if(csmodel) then
c
c  cs model
c
         write(6,430)
         write(6,440) (j,eta(j),yk(j),f(j,2),u(j,2),v(j,2),b(j,2),
     +                 uv(j),yplus(j),uplus(j),edv(j),j=1,np) 
      elseif(kemodel ) then 
c
c  zonal or k. e. model  
c
         write(6,330) 
         write(6,340) (j,eta(j),yk(j),f(j,2),u(j,2),v(j,2),k(j,2),
     +      s(j,2),g(j,2),q(j,2),yplus(j),uplus(j),edv(j),j=1,np)

      endif
c
      if(nx .gt.1 .and. csmodel) call calfa 
c
c    shift profiles
c
      do j=1,np
         ff(j)     = f(j,1)
         uu(j)     = u(j,1)
         vv(j)     = v(j,1)
         f(j,1)    = f(j,2)
         u(j,1)    = u(j,2)
         v(j,1)    = v(j,2)
         b(j,1)    = b(j,2)
         w(j,1)    = w(j,2)
      enddo
c   
      if(kemodel) then
c
c  additional data for k. e. model
c
         do j=1,np
            kk(j)     = k(j,1)
            gg(j)     = g(j,1)
            k(j,1)    = k(j,2)
            s(j,1)    = s(j,2)
            z(j,1)    = z(j,2)
            g(j,1)    = g(j,2)
            q(j,1)    = q(j,2)
            fmu(j,1)  = fmu(j,2)
            f1(j,1)   = f1(j,2)
            f2(j,1)   = f2(j,2)
            b2(j,1)   = b2(j,2)
            b3(j,1)   = b3(j,2)
            sigg(j,1) = sigg(j,2)
            sigk(j,1) = sigk(j,2)
         enddo
      endif
c
100   if(nx .eq. nxt) then
c
c  write summary data
c
         call amean(1,6,xc,cf,d1,1)
         write(6,300)
         write(6,320) (i,xc(i),ue(i),cf(i),tht2(i),dls2(i),rtht2(i),
     1                 rdls2(i),h2(i),i=1,nxt)
         write(6,500)
      endif
c
      return
c----------------------------------------------------------------------
  300 format(/66('*-')/)
  320 format(1x,'*** summary of wall boundary layer calculation ***'/
     +       1x,3h nx,8x,2hxc,10x,2hue,10x,2hcf,8x,4htht2,8x,4hdls2,
     +       8x,4hrtht,8x,4hrdls,8x,4h h2 /(1h ,i3,8e12.4))

  330 format(/3x,1hj,5x,3heta, 9x,3hy/c,11x,1hf,9x,1hu,
     +           7x,1hv,10x,1hk,11x,1hs,11x,1hg,11x,
     +           1hq,8x,5hyplus,6x,5huplus,5x,3hedv)
  340 format(1x,i4,3e12.4,2f8.4,5e12.4,f7.3,e12.4)
  350 format(/7x,2hcf,10x,2hh2,11x,4htht2,8x,4hdls2,
     +        4x,7hrtheta2,5x,7hrdelst2/(1h ,6e12.4))
  430 format(/4x,1hj,6x,3heta,10x,3hy/c,12x,1hf,12x,1hu,
     +           12x,1hv,12x,1hb,11x,2huv,8x,5hyplus,
     +           8x,5huplus,8x,5hedv  )
  440 format(1x,i5,10e13.5)
  500 format(/,'******  calculation completed  ******')

      end
c
      subroutine smoth2(index)
c
c  smooth profiles near the edge of the b. l.
c
      parameter (nxm=200,nym=151)
      real k
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /cek0/ k(nym,2),g(nym,2),s(nym,2),q(nym,2),gd(nym,2),
     +              z(nym,2),bs(nym),edvcs(nym),yk(nym),uv(nym),
     +              cmu(nym),b2(nym,2),b3(nym,2),fmu(nym,2),
     +              f1(nym,2),f2(nym,2),sigg(nym,2),sigk(nym,2),
     +              yplus(nym),uplus(nym)
      common /cek1/ cedv(nym),ce1,ce2,ce3,sigke,sigge,yplus1,jeta,
     +              fmu1,fmu2,sigk1,rgmin,rkmin
      common /work/ d1(nxm), d2(nxm), d3(nxm)
c   - - - - - - - - - - - - -  -- - - - - - -  - - - - - - - - - - - - -
c    check for maximum v
c
      jmin = jeta
      jp   = jmin
      vmax = v(jmin,2)
      do j = jmin+1,np
         if(v(j,2) .gt. vmax) then 
            vmax = v(j,2)
            jp = j
         endif
      enddo
c
c   check for smoothness
c
      do 30 j = jp+1,np-1
         jj   = j
         if(u(j,2) .gt. u(np,2) .or. v(j,2) .lt. 0.0) go to 40
   30 continue
      return
   40 j1     = jj-1
      j1     = max(j1,jeta+1) 
c
c  smooth velocity profiles, f, u, & v 
c
      call amean(j1,np,eta,f(1,2),d1,1)
      call amean(j1,np,eta,u(1,2),d1,1)
      djp    = eta(j1)-eta(j1-1)
      vjp    = (u(j1,2)-u(j1-1,2))/djp
      do j=j1+1,np 
         djm      = eta(j)-eta(j-1)
         vjm      = (u(j,2)-u(j-1,2))/djm
         v(j-1,2) = (vjp*djm + vjm*djp)/(djm+djp)
         vjp      = vjm
         djp      = djm
      enddo
      v(np,2)= -v(np-1,2)+2.*(u(np,2)-u(np-1,2))/deta(np-1)
      if(index.eq.1) return
c
c  smooth k-e model variables 
c
      call amean(j1,np,eta,k(1,2),d1,1)
      call amean(j1,np,eta,g(1,2),d1,1)
      sjp    = (k(j1,2)-k(j1-1,2))/deta(j1-1)
      qjp    = (g(j1,2)-g(j1-1,2))/deta(j1-1)
      do j=j1+1,np
         djm    = eta(j) - eta(j-1)
         sjm    = (k(j,2)-k(j-1,2))/djm
         qjm    = (g(j,2)-g(j-1,2))/djm
         s(j-1,2) = (sjp*djm + sjm*djp)/(djm+djp)
         q(j-1,2) = (qjp*djm + qjm*djp)/(djm+djp)
         qjp    = qjm
         sjp    = sjm
         djp    = djm
      enddo
      s(np,2)= -s(np-1,2)+2.0*(k(np,2)-k(np-1,2))/deta(np-1)
      q(np,2)= -q(np-1,2)+2.0*(g(np,2)-g(np-1,2))/deta(np-1)
c
      return
      end
c
      subroutine coeftr
c
c   calculate coeffs. of b. l. finite-difference eqs.
c   in transformed variables( before switching).
c
      parameter (nxm=200,nym=151)
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc6/ s1(nym),s2(nym),s3(nym),s4(nym),s5(nym),s6(nym),
     +              s7(nym),s8(nym),r1(nym),r2(nym),r3(nym),r4(nym)
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
c   ----------------------------------------------------
c
      if(nx .le. 3) then
c
c  backward difference
c  use of backward difference to avoid oscillation due to initial 
c  conditions, which do not satisfy the governing equations exactly 
c
         cel  = x(nx) / (x(nx) - x(nx-1))
         celu = 0.5 * cel
      else
c
c  central difference
         cel  = 0.5*(x(nx)+x(nx-1))/(x(nx) - x(nx-1))
         celu = cel
      endif
c
      p1p     = p1(nx) + cel
      p2p     = p2(nx) + celu
      p1ph    = 0.5 * p1p
      celh    = 0.5 * cel 
c
c  calculate eddy viscosity
c
      call eddy
c
      do 100 j= 2,np
c
c  present station
         ub     = 0.5*(u(j,2) + u(j-1,2))
         vb     = 0.5*(v(j,2) + v(j-1,2))
         fb     = 0.5*(f(j,2) + f(j-1,2))
         fvb    = 0.5*(f(j,2)*v(j,2) + f(j-1,2)*v(j-1,2))
         usb    = 0.5*(u(j,2)**2 + u(j-1,2)**2)
         derbv  = (b(j,2)*v(j,2)-b(j-1,2)*v(j-1,2))/deta(j-1) 
c
c  previous station
         cfb    = 0.5*(f(j,1) + f(j-1,1))
         cvb    = 0.5*(v(j,1) + v(j-1,1))
         cfvb   = 0.5*(f(j,1)*v(j,1) + f(j-1,1)*v(j-1,1))
         cusb   = 0.5*(u(j,1)**2 + u(j-1,1)**2)
         cderbv = (b(j,1)*v(j,1)-b(j-1,1)*v(j-1,1))/deta(j-1) 
c
         if(nx.le. 3) then
c
c  backward diff.
            clb = 0.0
            c1  = 0.0
         else
c
c  central diff.
            clb = cderbv + p1(nx-1)*cfvb + p2(nx-1)*(1.-cusb)
            c1  = 1.0
         endif
c
         crb    = -clb - c1 * cvb * cel * (fb - cfb)
         r2(j)  = crb - (derbv + p1p*fvb+ p2(nx)*(1.-usb) -
     *            cel*vb*cfb - celu*(usb-cusb))
c
         s1(j)  =  b(j,2)/deta(j-1)  + p1ph*f(j,2)  -celh*cfb 
         s2(j)  = -b(j-1,2)/deta(j-1)+ p1ph*f(j-1,2)-celh*cfb
         s3(j)  =  c1* celh*cvb + p1ph*v(j,2)
         s4(j)  =  c1* celh*cvb + p1ph*v(j-1,2)
         s5(j)  = -p2p*u(j,2)
         s6(j)  = -p2p*u(j-1,2)
c
         r1(j)  = f(j-1,2) - f(j,2) + deta(j-1)*ub
         r3(j-1)= u(j-1,2) - u(j,2) + deta(j-1)*vb
  100 continue
c
      r1(1)  = 0.0
      r2(1)  = 0.0
      r3(np) = 0.0
      return
      end
c
      subroutine eddy
c
      parameter (nxm=200,nym=151)
      real k
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blog/ csmodel, kemodel, low_re, high_re, zonal
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      common /cek0/ k(nym,2),g(nym,2),s(nym,2),q(nym,2),gd(nym,2),
     +              z(nym,2),bs(nym),edvcs(nym),yk(nym),uv(nym),
     +              cmu(nym),b2(nym,2),b3(nym,2),fmu(nym,2),
     +              f1(nym,2),f2(nym,2),sigg(nym,2),sigk(nym,2),
     +              yplus(nym),uplus(nym)
      common /cek1/ cedv(nym),ce1,ce2,ce3,sigke,sigge,yplus1,jeta,
     +              fmu1,fmu2,sigk1,rgmin,rkmin
      common /csmod/ffs(nxm), alfas(nxm)
      dimension fint(nym),edvi(nym)
      logical csmodel, kemodel, low_re, high_re, zonal, outer
c
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
c   include p+ in inner eddy calculation for the pressure
c   gradient effect used in the cebeci model
c
      rkappa= 0.41
      utau  = sqrt(v(1,2)/sqrx)
      pplus = p2(nx)/(rx*utau**3)
      p118  = amin1(0.9,11.8*pplus)
      cn    = sqrt(1.0-p118)
      yeta  = sqrx*utau/26.0*cn
c
c  calculate inner eddy
c
      jn      = np
      if(zonal.and. nx.gt.1) jn = jeta
      do j = 1,jn
         jj     = j
         el     = 1.0
         yba    = yeta * eta(j)
         if(yba .lt. 10.0) el = 1.0 - exp(-yba)
         cedv(j) = rkappa**2*sqrx*(el*eta(j))**2
         edvi(j) = cedv(j)*v(j,2)
         edv(j)  = edvi(j)
         b(j,2)  = 1.0 + edv(j)
         edvcs(j)= edv(j)
         bs(j)   = b(j,2)
      enddo
c
      if(zonal.and. nx.gt.1) return
c
c  calculate fint using head's correlation
c
      call gamcal(np,eta,u(1,2),fint)
c
c  calculate outer eddy parameter, alfa
c
      if(nx.gt.1) then
         if(it .eq.1) then
            alfas(nx) = alfas(nx-1)
         else
            call calfa
         endif
      else
         alfas(nx) = 0.0168
      endif
c
c  calculate outer eddy
c
      sum   = 0.0
      term1 = 1.0 - u(1,2)/u(np,2)
      do j = 2,np
         term2 = 1.0 - amin1(1.0,u(j,2)/u(np,2))
         sum   = sum + a(j)*(term1+term2)
         term1 = term2
      enddo
c
c  search for location of the outer eddy
c
      edvo  = alfas(nx) * sqrx * sum 
      outer = .false.
      do j = 1,np
         if(.not.outer) then
            if(edvo * fint(j) .lt. edvi(j)) then 
               jout = j
               outer= .true.
            endif
         endif
      enddo
c
      if(.not.outer) then
         jm     = ismax(np,edvi,1)
         eddym  = edvi(jm)
         jout   = jm
         do j = jm,np
            edv(j) = eddym*fint(j) 
            b(j,2) = 1.0 +edv(j) 
         enddo
      else
c
c   outer eddy formulation
c
         do j=jout,np
            edv(j) = edvo*fint(j)
            b(j,2) = 1.0 + edv(j)
         enddo
      endif
c
      do j = 1,np
         bs(j)    = b(j,2)
         edvcs(j) = b(j,2) - 1.0
      enddo
      return
      end

c
      subroutine gamcal(np,eta,u,fint)
c
c  calculate intermittency 
c
      dimension eta(np),u(np),fint(np)
c
      dimension hh(13),ydel(13),sgdel(13)
      data hh/1.2,1.3,1.4,1.5,1.6,1.7,1.8,1.9,2.0,2.1,2.2,2.3,2.4/
      data ydel/0.50,0.665,0.8,0.843,0.864,0.88,0.89,0.898,0.905,
     1          0.913,0.921,0.928,0.936/
      data sgdel/0.180,0.156,0.142,0.136,0.133,0.131,0.1285,0.1279,
     1           0.1276,0.1273,0.127,0.1267,0.1264/

c
c  --------------------------------------------------------------------
c
      udel    = 0.995 * u(np)
      do j = 2 , np
         jj    = j
         if (u(j) .gt.udel) goto 20
      enddo
   20 edel   = eta(jj-1)+(eta(jj)-eta(jj-1))/(u(jj)-u(jj-1))*
     1         (udel-(u(jj-1)-u(1)))
c
c   calculate fint ( gamma in c. s. model) using head's correlation
c
c        calc. of h = dels/theta (based on x-value for 3d case)
c
      uj    = u(1)/u(np)
      termp = (1.-uj)
      termpt= uj*(1.-uj)
      sumu  = 0.0
      sumt  = 0.0
      do j  = 2,np
         aj    = 0.5*(eta(j)-eta(j-1))
         uj    = amin1(1.0,u(j) / u(np))
         term  = 1.- uj
         sumu  = sumu + aj*(term+termp)
         termp = term
         termt = uj * (1.- uj)
         sumt  = sumt + aj*(termt+termpt)
         termpt= termt
      enddo
      hcal  = sumu / sumt
      heq   = 1.4
      if(hcal.le. hh(1)) then
         ydelz  = ydel(1)
         sgdelz = sgdel(1)
      elseif(hcal.ge. hh(13)) then
         ydelz  = ydel(13)
         sgdelz = sgdel(13)
      else
         do j  = 2,13
            jj = j-1
            if(hcal .lt. hh(j) ) goto 60
         enddo
60       ydelz  = ydel(jj)+(ydel(jj+1)-ydel(jj))*(hcal-hh(jj))
     1              /(hh(jj+1)-hh(jj))
         sgdelz = sgdel(jj)+(sgdel(jj+1)-sgdel(jj))*(hcal-hh(jj))
     1              /(hh(jj+1)-hh(jj))
      endif
c
      sq2   = sqrt(2.0)
      do j  = 1,np
         etadel = amin1(1.5,eta(j)/edel) 
         z      = (etadel-ydelz)/(sq2*sgdelz)
         z1     = abs(z)
         t      = 1.0/(1.0 + 0.3275911*z1)
         erfz   = 1.0 + t*(-0.254829592 +t*(0.284496736 +t*
     1          (-1.421413741+ t*(1.453152027 - 1.061405429*t))))*
     1          exp(-z1**2)
         if(z .lt. 0.0) erfz=-erfz
         fint(j)= 0.5*(1.0 - erfz)
      enddo
c
      return
      end
c
      subroutine calfa
c
      parameter (nxm=200,nym=151)
      real kk
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc3/ ff(nym),uu(nym),vv(nym),kk(nym),gg(nym),e3(nym)
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      common /csmod/ffs(nxm), alfas(nxm)
      common /work/ d1(nxm), d2(nxm), d3(nxm)

c
c   step 1 calculate (du/dx)/(du/dy) at the location where shear is
c   maximum
c
      alfa= 0.0168 
      do j=1,np
         d1(j) = edv(j)*v(j,2)
      enddo
      jm       = ismax(np,d1,1)
      vm       = v(jm,2)
      tm       = d1(jm)
c
      if(nx.ge.3 .and. it.gt.1) then
c
c  3-p backward difference
c
         cx1  = x(nx)*(x(nx)-x(nx-1))/(x(nx-2)-x(nx-1))/
     1          (x(nx-2)-x(nx))
         cx2  = x(nx)*(x(nx)-x(nx-2))/(x(nx-1)-x(nx-2))/
     1          (x(nx-1)-x(nx))
         cx3  = x(nx)*(2.*x(nx)-x(nx-1)-x(nx-2))/
     1          (x(nx)-x(nx-2))/(x(nx)-x(nx-1))
         ue1  = ue(nx-2)
      else
c
         cx3  = x(nx)/(x(nx)-x(nx-1))
         cx2  = -cx3
         ue1  = 0.0
      endif
c
      du      = cx1 * uu(jm)+ cx2 * u(jm,1) + cx3 * u(jm,2)
      due     = cx1 * ue1+ cx2 * ue(nx-1) + cx3 * ue(nx)
      p2nx    = due / ue(nx)
      dudx    = du+p2nx*u(jm,2)+0.5*eta(jm)*v(jm,2)*(p2nx-1.0) 
      rr      = dudx/v(jm,2)/sqrx
      rt      = amax1(0.0,v(1,2)/tm)
      if(rt.gt.1.0) then
         cr   = (1.0 + rt) /rt
      else
         cr   = 6.0 /(1.0+2.0*rt*(2.0-rt))
      endif
c
c   step 3 : calculate ff
c
      fr   = cr * rr
      fr   = amin1(fr,0.5)
      fr   = amax1(fr,-1.50)
      rex  = 0.50
      ffs(nx)   = (1.- rex)*ffs(nx) + (1.0 -fr)*rex
      alfas(nx) = alfa / ffs(nx)**1.5
c
      return
      end
c
      subroutine solv3
      parameter (nxm=200,nym=151)
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc2/ delf(nym),delu(nym),delv(nym),delw(nym)
      common /blc6/ s1(nym),s2(nym),s3(nym),s4(nym),s5(nym),s6(nym),
     +              s7(nym),s8(nym),r1(nym),r2(nym),r3(nym),r4(nym)
      common/blc41/ a11(nym),a12(nym),a13(nym),a14(nym),a15(nym),
     1              a21(nym),a22(nym),a23(nym),a24(nym),a25(nym),
     2              a31(nym),a32(nym),a33(nym),a34(nym),a35(nym)
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      a11(1)= 1.0
      a12(1)= 0.0
      a13(1)= 0.0
      a21(1)= 0.0
      a22(1)= 1.0
      a23(1)= 0.0
      g11   =-1.0
      g12   =-a(2)
      g13   = 0.0
      g21   = s4(2)
      g23   =-s2(2)/a(2)
      g22   = g23+s6(2)
      a11(2)= 1.0
      a12(2)=-a(2)-g13
      a13(2)= a(2)*g13
      a21(2)= s3(2)
      a22(2)= s5(2)-g23
      a23(2)= s1(2)+a(2)*g23
      r1(2) = r1(2)-(g11*r1(1)+g12*r2(1)+g13*r3(1))
      r2(2) = r2(2)-(g21*r1(1)+g22*r2(1)+g23*r3(1))
c
c  forward sweep
c
      do 500 j=2,np
         den   = (a13(j-1)*a21(j-1)-a23(j-1)*a11(j-1)-a(j)*
     +                (a12(j-1)*a21(j-1)-a22(j-1)*a11(j-1)))
         den1  = a22(j-1)*a(j)-a23(j-1)
         g11   = (a23(j-1)+a(j)*(a(j)*a21(j-1)-a22(j-1)))/den
         g12   = -(a(j)*a(j)+g11*(a12(j-1)*a(j)-a13(j-1)))/den1
         g13   = (g11*a13(j-1)+g12*a23(j-1))/a(j)
         g21   = (s2(j)*a21(j-1)-s4(j)*a23(j-1)+a(j)*(s4(j)*
     +                a22(j-1)-s6(j)*a21(j-1)))/den
         g22   = (-s2(j)+s6(j)*a(j)-g21*(a(j)*a12(j-1)-a13(j-1)))/den1
         g23   = g21*a12(j-1)+g22*a22(j-1)-s6(j)
         a11(j)= 1.0
         a12(j)=-a(j)-g13
         a13(j)= a(j)*g13
         a21(j)= s3(j)
         a22(j)= s5(j)-g23
         a23(j)= s1(j)+a(j)*g23
         r1(j) = r1(j)-(g11*r1(j-1)+g12*r2(j-1)+g13*r3(j-1))
         r2(j) = r2(j)-(g21*r1(j-1)+g22*r2(j-1)+g23*r3(j-1))
500   continue
c
c  backward sweep
c
      delu(np) = r3(np)
      e1       = r1(np)-a12(np)*delu(np)
      e2       = r2(np)-a22(np)*delu(np)
      delv(np) = (e2*a11(np)-e1*a21(np))/(a23(np)*a11(np)-a13(np)*
     +                a21(np))
      delf(np) = (e1-a13(np)*delv(np))/a11(np)
      do j = np-1,1,-1
         e3       = r3(j)-delu(j+1)+a(j+1)*delv(j+1)
         den2     = a21(j)*a12(j)*a(j+1)-a21(j)*a13(j)-a(j+1)*a22(j)*
     +              a11(j)+a23(j)*a11(j)
         delv(j)  = (a11(j)*(r2(j)+e3*a22(j))-a21(j)*r1(j)-e3*a21(j)*
     +              a12(j))/den2
         delu(j)  =-a(j+1)*delv(j)-e3
         delf(j)  = (r1(j)-a12(j)*delu(j)-a13(j)*delv(j))/a11(j)
      enddo
c
      rex = 1.0
      if(it .gt. 5) rex = 0.7
c
c  update variables
c
      do j=1,np
         f(j,2)= f(j,2)+delf(j)*rex
         u(j,2)= u(j,2)+delu(j)*rex
         v(j,2)= v(j,2)+delv(j)*rex
      enddo
      u(1,2)= 0.0
      f(1,2)= 0.0
      call smoth2(1) 
      return
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      end
c
      subroutine kecoef 
c
c  calculation of matrix coeffs for high reynolds number k. e. model
c
      parameter (nxm=200,nym=151)
      real k,kb,kk,kkb 
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc3/ ff(nym),uu(nym),vv(nym),kk(nym),gg(nym),e3(nym)
      common /blog/ csmodel, kemodel, low_re, high_re, zonal
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      common /cek0/ k(nym,2),g(nym,2),s(nym,2),q(nym,2),gd(nym,2),
     +              z(nym,2),bs(nym),edvcs(nym),yk(nym),uv(nym),
     +              cmu(nym),b2(nym,2),b3(nym,2),fmu(nym,2),
     +              f1(nym,2),f2(nym,2),sigg(nym,2),sigk(nym,2),
     +              yplus(nym),uplus(nym)
      common /cek1/ cedv(nym),ce1,ce2,ce3,sigke,sigge,yplus1,jeta,
     +              fmu1,fmu2,sigk1,rgmin,rkmin 
      common /keeddy/ dcmudk(nym),dcmudg(nym),dcmudv(nym),dcmuds(nym),
     +              dedvdv(nym),dedvdk(nym),dedvdg(nym),dedvds(nym),
     +              db2dv(nym),db2dk(nym),db2dg(nym),db2ds(nym),
     +              db3dv(nym),db3dk(nym),db3dg(nym),db3ds(nym) 
      common /kebond/ game(3,8),gamm(2,8),gamw(5,8),rj(5)
      common /kematx/ ss(nym,16),pp(nym,16),qq(nym,16),r(8,nym)  
      common /keprod/ dissg(nym),dissgdk(nym),dissgdg(nym),
     +          prodg(nym),prodgdk(nym),prodgdg(nym),prodgdv(nym),
     +          prodk(nym),prodkdk(nym),prodkdg(nym),prodkdv(nym),
     +          prodkds(nym),prodgds(nym),prodgdw(nym)
      common /kelowr/ pdiffg(nym),pdfgdk(nym),pdfgdg(nym),pdfgds(nym),
     +          pdiffk(nym),pdfkdk(nym),pdfkdg(nym),pdfkds(nym),
     +          pdfkdz(nym),dgddk(nym),dgdds(nym),pdfgdq(nym),
     +          dsigkdk(nym),dsigkdg(nym),dfmudg(nym),dfmudk(nym),
     +          dsiggdk(nym),dsiggdg(nym),df2dk(nym),df2dg(nym),
     +          df1dk(nym),df1dg(nym),df1dw(nym),
     +          pdfgdkj(nym),pdfgdkj1(nym),pdfgdgj(nym),pdfgdgj1(nym),
     +          pdfgdsj(nym),pdfgdsj1(nym),pdfgdvj(nym),pdfgdvj1(nym),
     +          pdfgdwj(nym),pdfgdwj1(nym),dfmudw(nym),pdfgdw(nym)
      common /keterm/ prodks(nym),diffks(nym),dissks(nym),convks(nym),
     +          prodds(nym),diffds(nym),dissds(nym),convds(nym),
     +          ydel(nym)
      common /work/ d1(nxm), d2(nxm), d3(nxm)
      common /cek4/ jrmax,rmax,ravg
      logical csmodel, kemodel, low_re, high_re, zonal 
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
c  initialization of coefficients
c  note that ss - matrix coeff. of momentum equation;
c            pp - matrix coeff. of k-equation
c            qq - matrix coeff. of e-equation
c
      do i = 1,16
         do j = 1,np
            ss(j,i) = 0.0
            pp(j,i) = 0.0
            qq(j,i) = 0.0
         enddo
      enddo
c
c  calculate parameters
c
      call keparm 
c
c  wall or near-wall boundary conditions
c
      call kewall
c
      if(nx .gt. 4 .and. it .gt.1) then
c
c  3-p backward difference
c
         cx1  = x(nx)*(x(nx)-x(nx-1))/(x(nx-2)-x(nx-1))/
     1          (x(nx-2)-x(nx))
         cx2  = x(nx)*(x(nx)-x(nx-2))/(x(nx-1)-x(nx-2))/
     1          (x(nx-1)-x(nx))
         cx3  = x(nx)*(2.*x(nx)-x(nx-1)-x(nx-2))/(x(nx)-x(nx-2))/
     1          (x(nx)-x(nx-1))
         cx3h = 0.5 * cx3
      else
c
c  2-p backward difference
         cx1  = 0.0
         cx2  = - x(nx)/(x(nx)-x(nx-1))
         cx3  = -cx2
         cx3h = 0.5 * cx3
      endif
c
      p2(nx) = (cx1 * ue(nx-2)+cx2*ue(nx-1)+cx3*ue(nx))/ue(nx)
      p1(nx) = 0.5 * (p2(nx) + 1.0)
      p1h    = 0.5 * p1(nx)
      p2t3m1 = 3.*p2(nx) -1
      p2t3m1h= 0.5 * p2t3m1

	u995 = 0.995 *u(np,2)
	do j = 1,np
	   if(u(j,2) .gt. u995) goto 111
      enddo
111   del995 = eta(j-1)+(u(j,2)-u(j-1,2))/(eta(j)-eta(j-1))
     1         *(u995 - u(j-1,2))


      do 80 j=2,np
         jm1   = j-1
         ub    = 0.5*(u(j,2)+u(jm1,2))
         vb    = 0.5*(v(j,2)+v(jm1,2))
         fvb   = 0.5*(f(j,2)*v(j,2)+f(jm1,2)*v(jm1,2))
c
         fb    = 0.5*(f(j,2) + f(j-1,2))
         cfb   = 0.5*(f(j,1) + f(j-1,1))
         ffb   = 0.5*(ff(j)  + ff(j-1))
         xdfdx = cx1*ffb + cx2*cfb + cx3 * fb
         vxdfdx= cx3h
c
         usb   = 0.5*(u(j,2)**2 + u(j-1,2)**2)
         usb4  = 0.5*(u(j,1)**2 + u(j-1,1)**2)
         uusb  = 0.5*(uu(j)**2  + uu(j-1)**2)
         xdusdx= cx1 * uusb + cx2 * usb4 + cx3 * usb
         vxdusdxj= cx3*u(j,2)
         vxdusdxj1= cx3*u(j-1,2)
c
         derbv = (b(j,2)*v(j,2)-b(j-1,2)*v(j-1,2))/deta(j-1)
c
         r(2,j)   = f(j-1,2) - f(j,2) + deta(j-1)*ub
         r(1,j)   = w(j-1,2) - w(j,2)                        !w' = 0.0
c
c  coefficients of the momentum equation
c
         crb      = 0.5*xdusdx - vb *xdfdx
         r(3,j)   = crb-(derbv + p1(nx)*fvb + p2(nx)*(1.-usb))
         ss(j,1)  = vb*vxdfdx+p1h*v(j,2)                  !delf(j)
         ss(j,2)  = vb*vxdfdx+p1h*v(j-1,2)                !delf(j-1)
         ss(j,3)  =-(p2(nx)*u(j,2)+0.5*vxdusdxj)          !delu(j)
         ss(j,4)  =-(p2(nx)*u(j-1,2)+0.5*vxdusdxj1)       !delu(j-1)
c
         if(j .le. jeta) then 
c
c  coeffs. for the lower region of the zonal model, Eq. (9.2.23a)
c
            ss(j,5) = (b(j,2)+cedv(j)*v(j,2))/deta(j-1)
     +                +p1h*f(j,2)+0.5*xdfdx
            ss(j,6) = -(b(j-1,2)+cedv(j-1)*v(j-1,2))/deta(j-1) 
     +                +p1h*f(j-1,2)+0.5*xdfdx 
c
            r(4,j-1) = u(j-1,2) - u(j,2) + deta(j-1)*vb    
            r(5,j-1) = 0.0                              !k'  = 0.0
            r(6,j-1) = 0.0                              !s'  = 0.0     
            r(7,j-1) = 0.0                              !p'  = 0.0
            r(8,j-1) = 0.0                              !q'  = 0.0
c
c  conditions at the swtich location of the zonal model, j = jeta
c
            if(j .eq. jeta) then
c
c  eddy of c. s. = eddy of k. e.
c
               ak   = rx * cmu(j) * fmu(j,2)  
               r(4,j)= ak*k(j,2)**2 - g(j,2)*cedv(j)*v(j,2)
               gamm(1,3) = cedv(j)*g(j,2)
               gamm(1,4) = -2.*ak*k(j,2)
               gamm(1,6) = cedv(j)*v(j,2) 

c
c  production = dissipation
c
               r(5,j) = g(j,2)*(g(j,2)+gd(j,2))-ak*(k(j,2)*v(j,2))**2
               gamm(2,3)   = 2.0 * k(j,2)**2*v(j,2) * ak
               gamm(2,4)   = 2.0 * k(j,2)*v(j,2)**2 * ak
               gamm(2,6)   = -(2.0 * g(j,2) + gd(j,2))
            endif
         else
            ss(j,5) = (b(j,2)+dedvdv(j)*v(j,2))/deta(j-1)    
     +                +p1h*f(j,2)  +0.5*xdfdx 
            ss(j,6) =-(b(j-1,2)+dedvdv(j-1)*v(j-1,2))/deta(j-1)  
     +               +p1h*f(j-1,2)+0.5*xdfdx 
            ss(j,7) = v(j,  2)/deta(j-1)* dedvdk(j)
            ss(j,8) =-v(j-1,2)/deta(j-1)* dedvdk(j-1)
            ss(j,9) = v(j,  2)/deta(j-1)* dedvds(j)
            ss(j,10)=-v(j-1,2)/deta(j-1)* dedvds(j-1)
            ss(j,11)= v(j  ,2)/deta(j-1)* dedvdg(j)
            ss(j,12)=-v(j-1,2)/deta(j-1)* dedvdg(j-1)
c
c  coeffs of the k- and e- transport equations
c
            kb     = 0.5*(k(j,2) + k(j-1,2))
            ckb    = 0.5*(k(j,1) + k(j-1,1))
            kkb    = 0.5*(kk(j)  + kk(j-1))
            xdkdx  = cx1*kkb + cx2*ckb + cx3 * kb
            vxdkdx = cx3 
c 
            gb     = 0.5*(g(j,2) + g(j-1,2))
            cgb    = 0.5*(g(j,1) + g(j-1,1))
            ggb    = 0.5*(gg(j)  + gg(j-1))
            xdgdx  = cx1*ggb + cx2*cgb + cx3 * gb
            vxdgdx = cx3 
c
            sb    = 0.5*(s(j,2)+s(jm1,2))
            qb    = 0.5*(q(j,2)+q(jm1,2))
            gdb   = 0.5*(gd(j,2)+gd(jm1,2))
            fsb   = 0.5*(f(j,2)*s(j,2)+f(jm1,2)*s(jm1,2))
            fqb   = 0.5*(f(j,2)*q(j,2)+f(jm1,2)*q(jm1,2))
            ukb   = 0.5*(u(j,2)*k(j,2)+u(jm1,2)*k(jm1,2))
            ugb   = 0.5*(u(j,2)*g(j,2)+u(jm1,2)*g(jm1,2))
c
c         **********    coeffs of k-equation    ***********
c
c   total viscous diffusion term
            derb2s= (b2(j,2)*s(j,2)-b2(j-1,2)*s(j-1,2))/deta(j-1)
c   production term
            prodkb = 0.5 *(prodk(j)+prodk(j-1))
c   laminar pressure diffusion term
            pdfkb  =-(pdiffk(j) - pdiffk(j-1))/deta(j-1)
c   dissipation term
           disspk = gb + gdb
c   convection term
            convk  = (ub*xdkdx - sb*xdfdx)-p1(nx)*fsb+2.*p2(nx)*ukb
c
            convks(j) = -convk
            diffks(j) = derb2s + pdfkb
            prodks(j) = prodkb
            dissks(j) = -disspk
            ydel(j)   = 0.5*(eta(j)+eta(j-1))/del995
c
            r(4,j) = - (diffks(j)+prodks(j)+dissks(j)+convks(j))
c  Eq. (9.2.33)
            pp(j,1)= p1h * s(j,2) + sb * vxdfdx
            pp(j,2)= p1h * s(j-1,2) + sb * vxdfdx
            pp(j,3)= -0.5*xdkdx - p2(nx) * k(j  ,2)
            pp(j,4)= -0.5*xdkdx - p2(nx) * k(j-1,2)
            pp(j,5)= 0.5*prodkdv(j)  +db2dv(j)  *s(j,2)  /deta(j-1)
            pp(j,6)= 0.5*prodkdv(j-1)-db2dv(j-1)*s(j-1,2)/deta(j-1)
            pp(j,7)= (db2dk(j)*s(j,2)-pdfkdk(j))/deta(j-1)+
     +               0.5*(prodkdk(j)-dgddk(j)-vxdkdx*ub-2.0*
     +               p2(nx) *u(j,2))
            pp(j,8)=-(db2dk(j-1)*s(j-1,2)-pdfkdk(j-1))/deta(j-1)+
     +               0.5*(prodkdk(j-1)-dgddk(j-1)-vxdkdx*ub-2.0*
     +               p2(nx) *u(j-1,2))
            pp(j,9)= (b2(j,2)+db2ds(j)*s(j,2)-pdfkds(j))/deta(j-1)+
     +               0.5*(prodkds(j)-dgdds(j)+p1(nx)*f(j,2)+xdfdx)
            pp(j,10)=-(b2(j-1,2)+db2ds(j-1)*s(j-1,2)-pdfkds(j-1))
     +                 /deta(j-1)+
     +               0.5*(prodkds(j-1)-dgdds(j-1)+p1(nx)*f(j-1,2)+
     +               xdfdx)
            pp(j,11)= (db2dg(j)*s(j,2)-pdfkdg(j))/deta(j-1)
     +               +0.5*prodkdg(j  )-0.5
            pp(j,12)=-(db2dg(j-1)*s(j-1,2)-pdfkdg(j-1))/deta(j-1)
     +               +0.5*prodkdg(j-1)-0.5
c
c           ***********    coeffs of e-equation    ************
c
c   turbulent diffusion term
            derb3q= (b3(j,2)*q(j,2)-b3(j-1,2)*q(j-1,2))
     1              /deta(j-1)
c
c   production term
c
            prodgb = 0.5 * (prodg(j) + prodg(j-1))
c
c   dissipation term
c
            dissgb = 0.5 * (dissg(j) + dissg(j-1))
c
c   laminar pressure diffusion term. note that pdiffg stored at j-1/2
c
            pdiffgb= pdiffg(j)
c
c   convection term
c
            convg  = (ub*xdgdx-qb*xdfdx)-p1(nx)*fqb+p2t3m1*ugb
c
            diffds(j) = pdiffgb + derb3q
            prodds(j) = prodgb
            dissds(j) = - dissgb
            convks(j) = - convg
c
            r(5,j) = - (diffds(j)+prodds(j) +dissds(j)+convks(j))
c
            qq(j,1)= p1h * q(j,2) + qb * vxdfdx
            qq(j,2)= p1h * q(j-1,2) + qb * vxdfdx
            qq(j,3)= -p2t3m1h*g(j,2)  - 0.5*xdgdx
            qq(j,4)= -p2t3m1h*g(j-1,2)- 0.5*xdgdx
            qq(j,5)= db3dv(j)*q(j,2)/deta(j-1)+pdfgdvj(j)
     +               +0.5*prodgdv(j)
            qq(j,6)=-db3dv(j-1)*q(j-1,2)/deta(j-1)+pdfgdvj1(j)
     +               +.5*prodgdv(j-1)
            qq(j,7)= db3dk(j)*q(j,2)/deta(j-1)+pdfgdkj(j)
     +               +0.5*prodgdk(j)-0.5*dissgdk(j)
            qq(j,8)=-db3dk(j-1)*q(j-1,2)/deta(j-1)+pdfgdkj1(j)
     +               +0.5*prodgdk(j-1)-0.5*dissgdk(j-1)
            qq(j,9) = db3ds(j)*q(j,2)/deta(j-1)+0.5*prodgds(j)
     +               +pdfgdsj(j)
            qq(j,10)=-db3ds(j-1)*q(j-1,2)/deta(j-1)+0.5*prodgds(j-1)
     +               +pdfgdsj1(j)

            qq(j,11)= db3dg(j  )*q(j,2)/deta(j-1)+pdfgdgj(j)
     +               +0.5*(prodgdg(j)-dissgdg(j)-vxdgdx*ub-
     +                p2t3m1*u(j,2))
            qq(j,12)=-db3dg(j-1)*q(j-1,2)/deta(j-1)+pdfgdgj1(j)
     +               +.5*(prodgdg(j-1)-dissgdg(j-1)-vxdgdx*ub-
     +               p2t3m1*u(j-1,2))
            qq(j,13)= b3(j,2)/deta(j-1)  +p1h*f(j,2)+0.5*xdfdx
            qq(j,14)=-b3(j-1,2)/deta(j-1)+p1h*f(j-1,2)+0.5*xdfdx
c
            r(6,j-1) = u(j-1,2) - u(j,2) + deta(j-1)*vb         !u'  = v
            r(7,j-1) = k(j-1,2) - k(j,2) + deta(j-1)*sb         !k'  = s
            r(8,j-1) = g(j-1,2) - g(j,2) + deta(j-1)*qb         !p'  = q
         endif
   80 continue
c
c  edge boundary conditions
c
c  edge velocity
      j         = np
      game(1,2) = 1.0
      r(6,j)    = 1.0 - u(j,2)
c  
      xdkdx  = cx1 * kk(j) + cx2 * k(j,1) + cx3 * k(j,2)
      vxdkdx = cx3
      xdgdx  = cx1 * gg(j) + cx2 * g(j,1) + cx3 * g(j,2)
      vxdgdx = cx3
c  edge of k equation
      convk     = xdkdx + 2.*p2(nx)*k(j,2)
      disspk    = g(j,2)+gd(j,2)
      game(2,4) = vxdkdx + 2.*p2(nx)+dgddk(j)
      game(2,5) = dgdds(j)
      game(2,6) = 1.
      r(7,j)    = -convk - disspk
c
c  edge of e equation
c
      disspe    = ce2*f2(j,2)*g(j,2)**2/k(j,2)
      conve     = xdgdx+p2t3m1*g(j,2)
      game(3,4) = disspe*(df2dk(j)/f2(j,2)-1./k(j,2))
      game(3,6) = vxdgdx+p2t3m1+disspe*(df2dg(j)/f2(j,2)+2./g(j,2))
      r(8,j)    = -conve - disspe
c
c **********************************************************************
c
c  under_relax the residue for the first few iterations
c
      dxit = it-1 + (nx-1) 
      if(low_re) then
         reit = amin1(1.0 ,(0.30+0.200*dxit))
      else
         reit = amin1(1.0, (0.75+0.250*dxit))
      endif
c
      do ii = 1,8
         do j = 1,np
            r(ii,j) = reit*r(ii,j)
         enddo
      enddo
c
      return
      end
c
      subroutine keinitk
c
      parameter (nxm=200,nym=151)
      real k
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      common /init/ cnu,rthta,cfa,uref,chord,yplusw,vgp,yedge
      common /cek0/ k(nym,2),g(nym,2),s(nym,2),q(nym,2),gd(nym,2),
     +              z(nym,2),bs(nym),edvcs(nym),yk(nym),uv(nym),
     +              cmu(nym),b2(nym,2),b3(nym,2),fmu(nym,2),
     +              f1(nym,2),f2(nym,2),sigg(nym,2),sigk(nym,2),
     +              yplus(nym),uplus(nym)
      common /cek1/ cedv(nym),ce1,ce2,ce3,sigke,sigge,yplus1,jeta,
     +              fmu1,fmu2,sigk1,rgmin,rkmin
      common /keeddy/ dcmudk(nym),dcmudg(nym),dcmudv(nym),dcmuds(nym),
     +              dedvdv(nym),dedvdk(nym),dedvdg(nym),dedvds(nym),
     +              db2dv(nym),db2dk(nym),db2dg(nym),db2ds(nym),
     +              db3dv(nym),db3dk(nym),db3dg(nym),db3ds(nym) 
      common /blog/ csmodel, kemodel, low_re, high_re, zonal
      common /work/ d1(nxm), d2(nxm), d3(nxm)
      logical csmodel, kemodel, low_re, high_re, zonal
      data cc1,cc2,cc3,cc4/.1124E+00,-.1644E+00,.1121E+00, -.1498E-01/
c
c ----------------------------------------------------------------------
c
c  set freestream k & g
c
      rkmin = 2.5e-7
      vtfree= 0.025 
      rgmin = 0.09 * rx *rkmin**2 /vtfree
c
      if(.not. low_re) goto 100
c
c  k profile for low ke model
c  --------------------------
c determine a & b in the sublayer region

      jeta = 1
      do j = 1,np
         yplus(j) = sqrx * eta(j) * w(1,2)
         uv(j)    = edv(j)*v(j,2)/sqrx
         if(yplus(j).lt.4.) j4 = j
      enddo
c
      uv4  = (uv(j4+1) - uv(j4))/(yplus(j4+1)-yplus(j4))* 
     1       (4.-yplus(j4)) + uv(j4)
      uv_tw= uv4 / w(1,2)**2
c
c  calculate (uv_tw)'
c
      call diff1(np,yplus,uv,d1) 
      duv4 = (d1(j4+1) - d1(j4))/(yplus(j4+1)-yplus(j4))* 
     1       (4.-yplus(j4)) + d1(j4)
      duv4_tw = duv4 / w(1,2)**2
      tok     = 0.060     !y+ = 4
      dtok    = 0.015     !y+ = 4
      rkp     = uv_tw /tok
      dkp     = duv4_tw /tok - uv_tw *dtok/tok**2
c
      c1   = rkp 
      c2   = dkp        
      bb   = (2.*c2 - c1) / 32.
      ba   = (c1 - 64.*bb)/16.
c
      do j = 2,j4
         yp    = yplus(j)
         rkp   = yp**2 * (ba + bb*yp)
         rkot  = rkp * w(1,2)**2 / uv(j)
         tok   = 1. /rkot
      enddo
c
      jm   = ismax(np,uv,1)
      do j = 2,np
         yp =  sqrx * eta(j) * w(1,2)
         d2(j) = yp
         if(yp.le.4.0) then
c
c  k+ = a * y+**2 + b*y+**3
c
            rkp    = yp**2 * (ba + bb*yp)
            rkot   = w(1,2)**2/uv(j) * rkp
            tok    = 1. /rkot
            j4     = j
         elseif(yp.lt.60.) then
            alogy = alog(yp)
            tok = cc1 + cc2*alogy + cc3*alogy**2 + cc4*alogy**3
         else
            tok = 0.30
         endif
         k(j,2)   = uv(j) / tok
         if(j.gt.jm) k(j,2) = amax1(k(j,2),rkmin)
      enddo
      k (1,2) = 0.0
      js      = max0(2,j4-2)
      call amean(js,j4+2,eta,k(1,2),d1,1)
c
      call setvmin(np,eta,k(1,2),rkmin,d1)
c
      call diff1(np,eta,k(1,2),s(1,2))
c
      return
c
c  generate k profile for high_re ke model & zonal model
c  -----------------------------------------------------
c
100   continue
      yplus1 = 50.0
      do j = 1,np
         jeta  = j
         yplus(j) = sqrx * eta(j) * w(1,2)
         if(yplus(j).gt.yplus1) goto 10
      enddo
10    jeta = min0(jeta,jout)
c
c  high-reynolds-number k. e. model. chop off the grids near the wall
c
      if(high_re) then
         do j = jeta,npt
            jj  = j - jeta + 1
            if(j.le.np) then
               f(jj,2) = f(j,2)
               u(jj,2) = u(j,2)
               v(jj,2) = v(j,2)
               edv(jj) = edv(j)
               b(jj,2) = b(j,2)
               uv(jj)  = uv(j)
               yplus(jj) = yplus(j)
               uplus(jj) = uplus(j)
            endif
            eta(jj) = eta(j)
            a(jj)   = a(j)
            deta(jj)= deta(j)
            yk(jj)  = yk(j)
         enddo
         np  = np - jeta + 1

c  build up grids upto npt
c
         nptc = npt - jeta + 1
         do j = nptc+1,npt
            deta(j-1) = deta(j-2) * vgp
            eta(j)    = eta(j-1) + deta(j-1)
            a(j)      = 0.5 * deta(j-1)
         enddo
         jeta = 1
      endif
c
c  generate k profiles
c
      do j = jeta,np
         uv(j)    = edv(j)*v(j,2)/sqrx
         k(j,2)   = amax1(uv(j)/0.3,rkmin)
      enddo
c
c  set values of k near the edge of b. l.
c
      call setvmin(np-jeta+1,eta(jeta),k(jeta,2),rkmin,d1)
      call diff1(np-jeta+1,eta(jeta),k(jeta,2),s(jeta,2))
      if(zonal) then
c
c  setting k and g values equal to constant from wall to jeta
c  for zonal model
c

         do j = 1,jeta-1
            k(j,2) = k(jeta,2)
            s(j,2) = 0.0
         enddo
      endif
c
      return 
      end
c
      subroutine keinitg
c
c  generate g & other parameters  
c
      parameter (nxm=200,nym=151)
c
      real k
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      common /blog/ csmodel, kemodel, low_re, high_re, zonal
      common /cek0/ k(nym,2),g(nym,2),s(nym,2),q(nym,2),gd(nym,2),
     +              z(nym,2),bs(nym),edvcs(nym),yk(nym),uv(nym),
     +              cmu(nym),b2(nym,2),b3(nym,2),fmu(nym,2),
     +              f1(nym,2),f2(nym,2),sigg(nym,2),sigk(nym,2),
     +              yplus(nym),uplus(nym)
      common /cek1/ cedv(nym),ce1,ce2,ce3,sigke,sigge,yplus1,jeta,
     +              fmu1,fmu2,sigk1,rgmin,rkmin
      common /keeddy/ dcmudk(nym),dcmudg(nym),dcmudv(nym),dcmuds(nym),
     +              dedvdv(nym),dedvdk(nym),dedvdg(nym),dedvds(nym),
     +              db2dv(nym),db2dk(nym),db2dg(nym),db2ds(nym),
     +              db3dv(nym),db3dk(nym),db3dg(nym),db3ds(nym) 
      common /kelowr/ pdiffg(nym),pdfgdk(nym),pdfgdg(nym),pdfgds(nym),
     +          pdiffk(nym),pdfkdk(nym),pdfkdg(nym),pdfkds(nym),
     +          pdfkdz(nym),dgddk(nym),dgdds(nym),pdfgdq(nym),
     +          dsigkdk(nym),dsigkdg(nym),dfmudg(nym),dfmudk(nym),
     +          dsiggdk(nym),dsiggdg(nym),df2dk(nym),df2dg(nym),
     +          df1dk(nym),df1dg(nym),df1dw(nym),
     +          pdfgdkj(nym),pdfgdkj1(nym),pdfgdgj(nym),pdfgdgj1(nym),
     +          pdfgdsj(nym),pdfgdsj1(nym),pdfgdvj(nym),pdfgdvj1(nym),
     +          pdfgdwj(nym),pdfgdwj1(nym),dfmudw(nym),pdfgdw(nym)
      common /work/ d1(nxm), d2(nxm), d3(nxm)
      dimension rt(nym),ry(nym),fc(nym),damp(nym)
      data itmax/200/,eps/0.001/
      logical csmodel, kemodel, low_re, high_re, zonal
c
c  **********************************************************************
c
      if(high_re .or. zonal) goto 1000
c
c  initial guessing of g (eps) profile, assuming edv(k.e.) = edv(c.s)
c
      do j = 2,np
         cmu(j)   = 0.09
         yp       = yplus(j)
         argu     = yp*(0.01 + 0.00030*yp + 0.0000090*yp**2)
         fmu(j,2) = 1.0 - exp(-argu)
         cke      = cmu(j) * fmu(j,2) * rx
         g(j,2)   = amax1(cke * k(j,2)**2/edv(j),rgmin)
      enddo
      g(1,2)   = 0.0
      fmu(1,2) = 0.0
      cmu(1)   = 0.09
      call setvmin(np,eta,g(1,2),rgmin,d1)
c
c  calculate rt, ry, yp & fc
c
      do j = 2,np
         rt(j)    = rx * k(j,2)**2 / g(j,2)
         ry(j)    = sqrx * sqrt(k(j,2)) * eta(j)
         yplus(j) = sqrx * w(j,2) * eta(j)
         dy2      = (yplus(j)/cdamp)**2
         damp(j)  = 0.0
         if(dy2 .lt.50.) damp(j) = exp(-dy2)
      enddo
      damp(1) = 1.0
      rt(1) = 0.0
      ry(1) = 0.0
      yplus(1) = 0.0
      edv(1)= 0.0
      imrt = ismax(np-3,rt,1)
      imry = ismax(np-3,ry,1)
c     imrt = np + 1
c     imry = np + 1

      do j = imry,np
         ry(j) = ry(imry)
      enddo
      do j = imrt,np
         rt(j) = rt(imrt)
      enddo
c
c  calculate the righ-handed side, fc, of the governing equation
c
      do j = 2,np
         fc(j) = edv(j) /(cmu(j)*rx*k(j,2)**2)
      enddo
      fc(1) = fc(2)
c
      goto (101,102), model
c
101   continue
c
c  Huang & lin's model
c
c  improve initial guessings of fmu & eps (g)
c
      ce1    = 1.44
      ce2    = 1.92
      sigke  = 1.4
      sigge  = 1.3
      sigk1  = 0.1
      fmu1   = 0.01
      fmu2   = 0.008
c
      itermx = 3
      rex    = 0.5
c
c  improve initial guessing of fmu
c
      do iter = 1,itermx
         do j = 2,np
            cke      = cmu(j) * fmu(j,2) * rx
            ylam     = eta(j) * sqrt(g(j,2)/k(j,2))
            fmuj     = fmu(j,2)
            dfmuj    = 0.0
            if(j.gt.4) dfmuj = amax1(0.,fmu(j-1,2) -fmu(j-2,2))
            fmumin   = amin1(1.0, fmu(j-1,2)+ 0.5*dfmuj)
            fmu(j,2) = 1. - exp(-fmu1*ylam-fmu2*ylam**3)
            fmu(j,2) = amax1(fmu(j,2) ,fmumin)
            fmu(j,2) = rex * fmuj + (1.-rex) * fmu(j,2)
            g(j,2) = (cke * k(j,2)**2)/edv(j)
         enddo
         fmu(1,2) = 0.0
         g  (1,2) = 0.0
         jmx = ismax(np,g(1,2),1)
         gmx = g(jmx,2)
         do j = jmx,np
            g(j,2) = amax1(g(j,2),rgmin)
         enddo
      enddo
c
c  set values of g near the edge of b. l.
c
      jmx   = ismax(np-3,g(1,2),1)
      rgadm = g(jmx,2)/5.0
      if(rgmin .gt. rgadm) rgmin = rgadm
      do j = jmx,np
         g(j,2) = amax1(g(j,2),rgmin)
      enddo
      call setvmin(np,eta,g(1,2),rgmin,d1)
c
c  calculate other parameters
c
      d2(1)= 0.0
      do j = 2,np
         d2(j) = eta(j) * sqrt(g(j,2) / k(j,2))
      enddo
      jm = ismax(np-5,d2,1)
      ylamax = d2(jm)
      do j = jm,np
         d2(j) = ylamax
      enddo
      do j = 1,np
         f1(j,2) = 1.0
         f2(j,2) = 1.0
         fmu(j,2) = 1. - exp(-fmu1*d2(j)-fmu2*d2(j)**3)
         cke      = cmu(j) * fmu(j,2) * rx
         if(j.gt.1) g(j,2) = (cke * k(j,2)**2)/edv(j)
         expy1    = exp(- d2(j)*sigk1)
         sigk(j,2)= sigke - 1.1 * expy1
         sigg(j,2)= sigge - 1.0 * expy1
      enddo
c
      do j = 2,np
         gd(j,2)   = 0.5 * s(j,2)**2 / k(j,2) * damp(j)
         dgddk(j)  = -gd(j,2) / k(j,2)
         dgdds(j)  = s(j,2) / k(j,2) * damp(j)
      enddo
      gd(1,2)  = gd(2,2)
      dgddk(1) = 0.0
      dgdds(1) = 0.0
      dgdds(1) = dgdds(2)
      dgddk(1) = dgddk(2)
c
c  calculate z (dsdeta ) for huang & lin's model
      s(1,2) = 0.0
c
      call diff1(np,eta,s(1,2),z(1,2))
c
c  smoothing z values is needed to stabilize the solutions
c
      call amean(1,np,eta,z(1,2),d1,1)
      goto 100
c
102   continue
c
c  chien's model
c
      ce1  = 1.35
      ce2  = 1.80
      do j = 2,np
         fmu(j,2) = 1.0 - exp(-0.015*yplus(j))
         cke = cmu(j) * fmu(j,2) * rx
         g(j,2) = (cke * k(j,2)**2)/edv(j)
      enddo
c
c  set values of g near the edge of b. l.
c
      jmx   = ismax(np-3,g(1,2),1)
      rgadm = g(jmx,2)/5.0
      if(rgmin .gt. rgadm) rgmin = rgadm
      do j = jmx,np
         g(j,2) = amax1(g(j,2),rgmin)
      enddo
c
c  set values of g near the edge of b. l.
c
      call setvmin(np,eta,g(1,2),rgmin,d1)
c
      do j = 2,np
         rt(j)    = rx * k(j,2)**2 / g(j,2)
         gd(j,2)  = 2.0 * k(j,2) /eta(j)**2
         dgddk(j) = 2.0 / eta(j)**2
         dgdds(j) = 0.0
      enddo
      rt(1) = 0.0
      jm    = ismax(np-3,rt,1)
      jm    = np + 1
      do j = 1,np
         if(j.gt. jm) rt(j) = rt(jm)
         f1(j,2)  = 1.0
         f2(j,2)  = 1.0 - 0.22 * exp (-rt(j)**2/36.)
         sigk(j,2)= 1.0
         sigg(j,2)= 1.3
      enddo
      gd(1,2) = gd(2,2) 
      dgddk(1) = 0.0
      dgdds(1) = 0.0
      dgdds(1) = dgdds(2)
      dgddk(1) = dgddk(2)
c
c  calculate b2 & b3 & q ( derivative of p(e)) 
c
100   continue
c
      do j = 1,np
         b (j,2) = 1.0 + edv(j)
         b2(j,2) = 1. +  edv(j) / sigk(j,2)
         b3(j,2) = 1. +  edv(j) / sigg(j,2)
      enddo
      call diff1(np,eta,g(1,2),q(1,2))
      return
c
1000  continue
c
c  generate g (e) & other parameters for high ke model including zonal 
c  -------------------------------------------------------------------
c
c  generate g profile by assuming edv(k.e.) = edv(c.s.)
c
      do j = jeta,np
         cmu(j)   = 0.09
         fmu(j,2) = 1.0
         cke      = cmu(j) * fmu(j,2) * rx
         g(j,2)   = amax1(cke * k(j,2)**2/edv(j),rgmin)
      enddo
c
c  set values of g near the edge of b. l.
c
      call setvmin(np-jeta+1,eta(jeta),g(jeta,2),rgmin,d1)
c
c  calculate q (derivative of p (e) )
c
      call diff1(np-jeta+1,eta(jeta),g(jeta,2),q(jeta,2))
c
      if(zonal) then
c
c  setting k and g values equal to constant from wall to jeta
c  for zonal model
c
         do j = 1,jeta-1
            g(j,2) = g(jeta,2)
            q(j,2) = 0.0
         enddo
      endif
c
c  other parameters for k.e
c
      sigge= 1.3
      sigke= 1.0
      ce1  = 1.44
      ce2  = 1.92
      do j = 1,npt
c
c  parameters related to damping terms
c
         f1(j,2)  = 1.0
         f2(j,2)  = 1.0
         sigk(j,2)= sigke
         sigg(j,2)= sigge
c
c  variations of the damping terms
c
         df1dk(j) = 0.0
         df1dg(j) = 0.0
         df1dw(j) = 0.0
         df2dk(j) = 0.0
         df2dg(j) = 0.0
         dfmudg(j)= 0.0
         dfmudk(j)= 0.0
         dfmudw(j)= 0.0
         dsigkdg(j)= 0.0
         dsigkdk(j)= 0.0
         dsiggdg(j)= 0.0
         dsiggdk(j)=0.0
c
c  F term & its variations
c
         pdiffk(j) = 0.0
         pdfkdk(j) = 0.0
         pdfkds(j) = 0.0
         pdfkdz(j) = 0.0
         pdfkdg(j) = 0.0
c
c  D term & its variations
c
         gd(j,2)   = 0.0
         dgddk(j)  = 0.0
         dgdds(j)  = 0.0
c
c  E term & its variations
c
         pdiffg(j)   = 0.0
         pdfgdkj(j)  = 0.0
         pdfgdkj1(j) = 0.0
         pdfgdgj(J)  = 0.0
         pdfgdgj1(J) = 0.0
         pdfgdsj(j)  = 0.0
         pdfgdsj1(j) = 0.0
         pdfgdvj(j)  = 0.0
         pdfgdvj1(j) = 0.0
         pdfgdwj (j) = 0.0
         pdfgdwj1(j) = 0.0
      enddo
c
      do j = jeta,np
         b (j,2) = 1.0 + edv(j)
         b2(j,2) = 1.0 + edv(j) / sigk(j,2)
         b3(j,2) = 1.0 + edv(j) / sigg(j,2)
      enddo
c
      return
      end
c
      subroutine setvmin(np,eta,v,rvmin,d1)
c
c  logic to set v (g or k) values near the edge of b. l.
c
c  d1 : working area
c
      dimension eta(np),v(np),d1(np)
c
      jmx    = ismax(np-3,v,1)
      vm     = v(jmx)
      jm     = 0
      do j = jmx,np-1 
         if(v(j).le.rvmin) then
            v(j) = rvmin
            jm   = j
            goto 10
         endif
      enddo
c
10    if(jm.eq.0) then
c
c  search for the location where v is min
c
         do j = jmx,np
            if(v(j) .lt. vm) then
               vm   = v(j)
               jm   = j
            endif
         enddo
      endif
      do j = jm,np
         v(j) = rvmin
      enddo
      iss  = (np - jm) + 1
      n1   = max0(jm-3,1)
      call amean(n1,np,eta,v,d1,iss)
      return
      end
c
      subroutine keparm 
c
c  calculate low reynolds number k. e. model parameters
c
      parameter (nxm=200,nym=151)
      real k
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blog/ csmodel, kemodel, low_re, high_re, zonal
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      common /cek0/ k(nym,2),g(nym,2),s(nym,2),q(nym,2),gd(nym,2),
     +              z(nym,2),bs(nym),edvcs(nym),yk(nym),uv(nym),
     +              cmu(nym),b2(nym,2),b3(nym,2),fmu(nym,2),
     +              f1(nym,2),f2(nym,2),sigg(nym,2),sigk(nym,2),
     +              yplus(nym),uplus(nym)
      common /cek1/ cedv(nym),ce1,ce2,ce3,sigke,sigge,yplus1,jeta,
     +              fmu1,fmu2,sigk1,rgmin,rkmin
      common /keeddy/ dcmudk(nym),dcmudg(nym),dcmudv(nym),dcmuds(nym),
     +              dedvdv(nym),dedvdk(nym),dedvdg(nym),dedvds(nym),
     +              db2dv(nym),db2dk(nym),db2dg(nym),db2ds(nym),
     +              db3dv(nym),db3dk(nym),db3dg(nym),db3ds(nym) 
      common /keprod/ dissg(nym),dissgdk(nym),dissgdg(nym),
     +          prodg(nym),prodgdk(nym),prodgdg(nym),prodgdv(nym),
     +          prodk(nym),prodkdk(nym),prodkdg(nym),prodkdv(nym),
     +          prodkds(nym),prodgds(nym),prodgdw(nym)
      common /kelowr/ pdiffg(nym),pdfgdk(nym),pdfgdg(nym),pdfgds(nym),
     +          pdiffk(nym),pdfkdk(nym),pdfkdg(nym),pdfkds(nym),
     +          pdfkdz(nym),dgddk(nym),dgdds(nym),pdfgdq(nym),
     +          dsigkdk(nym),dsigkdg(nym),dfmudg(nym),dfmudk(nym),
     +          dsiggdk(nym),dsiggdg(nym),df2dk(nym),df2dg(nym),
     +          df1dk(nym),df1dg(nym),df1dw(nym),
     +          pdfgdkj(nym),pdfgdkj1(nym),pdfgdgj(nym),pdfgdgj1(nym),
     +          pdfgdsj(nym),pdfgdsj1(nym),pdfgdvj(nym),pdfgdvj1(nym),
     +          pdfgdwj(nym),pdfgdwj1(nym),dfmudw(nym),pdfgdw(nym)
c 
      common /work/ d1(nxm), d2(nxm), d3(nxm)
      dimension ry(nym),damp(nym),dampdk(nym) 
c
      logical csmodel, kemodel, low_re, high_re, zonal
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
c  calculate near wall damping terms f1,f2,fmu,sigk, sigg 
c  and their derivatives, which are model dependent
c 
      if(low_re) then 
         call kedamp
      elseif(zonal) then 
         call eddy
      endif       
c
c  calculate cmu & its variation according to george huang
c
      jl   = jeta
      if(low_re) jl = 2
      fmulim  = 0.0
c
c  modeling for freestream turbulent intensity
c
      do j = jl,np
         ry(j)   = eta(j) * sqrt(k(j,2))*sqrx
         drydk   = 0.5 * ry(j) / k(j,2)
         expry   = exp(- ry(j) /200.0)
         damp(j) = 1. - expry  
         dampdk(j) = expry  * drydk / 200.
      enddo
c
      if(icmu.eq.0 .or. nx .le. 2) then
         do j = jeta,np
            dcmudk(j)= 0.0
            dcmudg(j)= 0.0
            dcmudv(j)= 0.0
            dcmuds(j)= 0.0
            cmu(j)   = 0.09
         enddo
      else
         do j = jl,np
            if(fmu(j,2) .gt.fmulim) then
               prodj   = 0.30*sqrx*k(j,2)* abs(v(j,2))
               dissj   = g(j,2) + gd(j,2)
               parr    = dissj / prodj
               if(parr.gt.1.0) then
                  dcmudk(j) = 0.0
                  dcmudg(j) = 0.0
                  dcmudv(j) = 0.0
                  dcmuds(j) = 0.0
                  cmu(j)    = 0.09
               else
                  par     = 1. + (parr-1.)*damp(j)
                  dproddk = 0.30*sqrx* abs(v(j,2))
                  dproddv = 0.30*sqrx* k(j,2)
                  if(v(j,2).lt. 0.0) dproddv = - dproddv  
                  ddissdg = 1.0
                  ddissdk = dgddk(j)  
                  ddissds = dgdds(j)
                  dpardk  = damp(j)*(ddissdk/prodj-parr*dproddk/
     +                      prodj) + (parr-1.)*dampdk(j)
                  dpardv  = damp(j)*(-parr*dproddv/prodj)
                  dpardg  = damp(j)*(ddissdg/prodj)
                  dpards  = damp(j)*(ddissds/prodj)
                  cmu(j)   = 0.09 * par   
                  dcmudk(j)= 0.09 * dpardk 
                  dcmudg(j)= 0.09 * dpardg 
                  dcmudv(j)= 0.09 * dpardv
                  dcmuds(j)= 0.09 * dpards
               endif
            else
               cmu(j)    = 0.09
               dcmudk(j) = 0.0
               dcmudg(j) = 0.0
               dcmudv(j) = 0.0
               dcmuds(j) = 0.0
            endif
         enddo
         if(jl .eq.2) cmu(1) = 0.09
      endif
c
c  calculate b, b2, b3, & production and dissipation terms of the k
c  transport equation and their variations
c
      do j = jl,np
         edv(j )  = rx * cmu(j) * fmu(j,2) * k(j,2)**2 / g(j,2)
         b(j,2)   = 1. + edv(j)
         b2(j,2)  = 1. + edv(j) /sigk(j,2)
         b3(j,2)  = 1. + edv(j) /sigg(j,2)
         dedvdk(j)= edv(j)*(2./ k(j,2) + dfmudk(j) /fmu(j,2) +
     1              dcmudk(j)/cmu(j))
         dedvdg(j)= edv(j)*(-1./g(j,2) + dfmudg(j) /fmu(j,2) +
     1              dcmudg(j)/cmu(j))
         dedvdv(j)= edv(j)/cmu(j)*dcmudv(j)
         dedvds(j)= edv(j)/cmu(j)*dcmuds(j)
         db2dk(j) = (dedvdk(j)-edv(j)/sigk(j,2)*dsigkdk(j))/sigk(j,2)
         db2dg(j) = (dedvdg(j)-edv(j)/sigk(j,2)*dsigkdg(j))/sigk(j,2)
         db2ds(j) = dedvds(j)/sigk(j,2)
         db2dv(j) = dedvdv(j)/sigk(j,2)
         db3dg(j) = (dedvdg(j)-edv(j)/sigg(j,2)*dsiggdg(j))/sigg(j,2)
         db3dk(j) = (dedvdk(j)-edv(j)/sigg(j,2)*dsiggdk(j))/sigg(j,2)
         db3ds(j) = dedvds(j)/sigg(j,2)
         db3dv(j) = dedvdv(j)/sigg(j,2)
         vsq      = v(j,2)**2
         prodk(j) = edv(j) * vsq
         prodkdk(j) = dedvdk(j) * vsq
         prodkds(j) = dedvds(j) * vsq
         prodkdg(j) = dedvdg(j) * vsq
         prodkdv(j) = dedvdv(j) * vsq + 2.*edv(j) * v(j,2)
      enddo
c
c  calculate product and dissipation terms of the dissipation
c  transport equation and their vairations
c
      do j = jl , np
         vsq      = v(j,2)**2
         dvsqdv   = 2. * v(j,2)
         vsqk     = vsq * k(j,2)
         dvsqkdv  = dvsqdv*k(j,2)
         dvsqkdk  = vsq
         term     = ce1*f1(j,2)*cmu(j)*fmu(j,2)*rx
         dtermdk  = term*(dfmudk(j)/fmu(j,2)+dcmudk(j)/cmu(j)+
     +                    df1dk(j) /f1(j,2))
         dtermdg  = term*(dfmudg(j)/fmu(j,2)+dcmudg(j)/cmu(j)+
     +                    df1dg(j) /f1(j,2))
         dtermdw  = term*dfmudw(j) /fmu(j,2)
         dtermdv  = term*dcmudv(j) /cmu(j)
         dtermds  = term*dcmuds(j) /cmu(j)
         prodg(j) = term*vsqk
         prodgdk(j) = term * dvsqkdk + dtermdk * vsqk
         prodgdg(j) = dtermdg * vsqk
         prodgds(j) = dtermds * vsqk
         prodgdw(j) = dtermdw * vsqk
         prodgdv(j) = term * dvsqkdv + dtermdv * vsqk
c
         dissgj     = ce2*f2(j,2)*g(j,2)/k(j,2)
         dissg(j)   = dissgj*g(j,2)
         dissgdk(j) = dissg(j)*(-1./k(j,2)+df2dk(j)/f2(j,2))
         dissgdg(j) = 2.*dissgj+dissg(j)*df2dg(j)/f2(j,2)
      enddo
c
c  set values at the wall
c
      if(jl .eq. 2) then
         j        = 1
         b(1,2)   = 1.0
         b2(1,2)  = 1.0
         b3(1,2)  = 1.0
         edv(1)   = 0.0
         dedvdk(1) = 0.0
         dedvdg(1) = 0.0
         dedvdv(1) = 0.0
         db2dk(1)  = 0.0
         db2ds(1)  = 0.0
         db2dg(1)  = 0.0
         db2dv(1)  = 0.0
         db3dg(1)  = 0.0
         db3dk(1)  = 0.0
         db3ds(1)  = 0.0
         db3dv(1)  = 0.0
         prodk(1)  = 0.0
         prodkdk(1)= 0.0
         prodkds(1)= 0.0
         prodkdg(1)= 0.0
         prodkdv(1)= 0.0
         prodg(1)  = 0.0
         prodgdk(1) = 0.0
         prodgds(1) = 0.0
         prodgdv(1) = 0.0
         prodgdg(1) = 0.0
c
c  huang or chien's model
c
         dissg1  = dissg(2)-(dissg(3)-dissg(2))/deta(2)*deta(1)
         dissg(1)= amax1(0.,dissg1)
         if(model .eq. 1) dissg(1) = 0.0
         dissgdk(1) = dissgdk(2)-(dissgdk(3)-dissgdk(2))/
     1                   deta(2)*deta(1)
         dissgdg(1) = dissgdg(2)-(dissgdg(3)-dissgdg(2))/
     1                   deta(2)*deta(1)
      endif
c
      if(zonal) then
         do j = 1,jeta-1
            b2(j,2) = 1. + edv(j) / sigk(j,2)
            b3(j,2) = 1. + edv(j) / sigg(j,2)
         enddo
      endif
c
c  calculate D, E, & F terms & their variations, which are model-
c  dependent 
c
      if(low_re) call kedef
c
      return
      end
c
      subroutine kedef
c
c  calculate D, E & F terms in k. e. model associated with low Reynolds
c  effects
c

      parameter (nxm=200,nym=151)
c
      real k
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      common /cek0/ k(nym,2),g(nym,2),s(nym,2),q(nym,2),gd(nym,2),
     +              z(nym,2),bs(nym),edvcs(nym),yk(nym),uv(nym),
     +              cmu(nym),b2(nym,2),b3(nym,2),fmu(nym,2),
     +              f1(nym,2),f2(nym,2),sigg(nym,2),sigk(nym,2),
     +              yplus(nym),uplus(nym)
      common /cek1/ cedv(nym),ce1,ce2,ce3,sigke,sigge,yplus1,jeta,
     +              fmu1,fmu2,sigk1,rgmin,rkmin
      common /keeddy/ dcmudk(nym),dcmudg(nym),dcmudv(nym),dcmuds(nym),
     +              dedvdv(nym),dedvdk(nym),dedvdg(nym),dedvds(nym),
     +              db2dv(nym),db2dk(nym),db2dg(nym),db2ds(nym),
     +              db3dv(nym),db3dk(nym),db3dg(nym),db3ds(nym) 
      common /kelowr/ pdiffg(nym),pdfgdk(nym),pdfgdg(nym),pdfgds(nym),
     +          pdiffk(nym),pdfkdk(nym),pdfkdg(nym),pdfkds(nym),
     +          pdfkdz(nym),dgddk(nym),dgdds(nym),pdfgdq(nym),
     +          dsigkdk(nym),dsigkdg(nym),dfmudg(nym),dfmudk(nym),
     +          dsiggdk(nym),dsiggdg(nym),df2dk(nym),df2dg(nym),
     +          df1dk(nym),df1dg(nym),df1dw(nym),
     +          pdfgdkj(nym),pdfgdkj1(nym),pdfgdgj(nym),pdfgdgj1(nym),
     +          pdfgdsj(nym),pdfgdsj1(nym),pdfgdvj(nym),pdfgdvj1(nym),
     +          pdfgdwj(nym),pdfgdwj1(nym),dfmudw(nym),pdfgdw(nym)
      common /work/ d1(nxm), d2(nxm), d3(nxm)
c
      dimension pdiffgs(nym),dypdw(nym),damp(nym)
c  -----------------------------------------------------------------------
c
c  calculate yp, damp & their derivatives
c
      do j = 1,np
         yplus(j) = sqrx * w(j,2) * eta(j)
         dy2      = (yplus(j)/cdamp)**2
         damp(j)  = 0.0
         if(dy2 .lt.50.) damp(j) = exp(-dy2)
         dypdw(j) = yplus(j) / w(j,2)
      enddo
c
c  calculate F & its variations, which are zero except model 1
c
      do j = 1,np
         pdiffk(j) = 0.0
         pdfkdk(j) = 0.0
         pdfkds(j) = 0.0
         pdfkdz(j) = 0.0
         pdfkdg(j) = 0.0
      enddo
c
      goto (101,102), model
c
c  huang & lin's model (model 1)
c
101   continue
c
c  calculae D, E, & F
c
c  --------------------------------------------------------------------
c
c
      call diff1(np,eta,s(1,2),z(1,2))
c
c  smoothing z values is needed to stabilize the solutions
c
      call amean(1,np,eta,z(1,2),d1,1)
c
      do j = 2,np
c
c  D & its variation
c
         z(j,2)    = z(j,2) * damp(j)
         gd(j,2)   = 0.5 * s(j,2)**2 / k(j,2)* damp(j)
         dgddk(j)  = -gd(j,2) / k(j,2)
         dgdds(j)  = s(j,2)/ k(j,2)* damp(j)
c
c  F & its variation
c
         tg        = g(j,2) + gd(j,2)
         pdiffk(j) = (0.5 * s(j,2)*z(j,2) - 0.25 * s(j,2)**3
     1                /k(j,2))/tg
         pdfkdk(j) = 0.25 *s(j,2)**3/k(j,2)**2 /tg - pdiffk(j)
     1                /tg * dgddk(j)
         pdfkds(j) = (0.5 * z(j,2) - 0.75 * s(j,2)**2/k(j,2))
     1                /tg -pdiffk(j)/tg * dgdds(j)
         pdfkdz(j) = 0.5 * s(j,2) /tg
         pdfkdg(j) = -pdiffk(j)/tg
c
         pdiffk(j) = pdiffk(j)*damp(j)
         pdfkdk(j) = pdfkdk(j)*damp(j)
         pdfkds(j) = pdfkds(j)*damp(j)
         pdfkdz(j) = pdfkdz(j)*damp(j)
         pdfkdg(j) = pdfkdg(j)*damp(j)
c
c  E & its variation ( = d(pdiffg)/deta)
c
         pdiffgs(j) =  g(j,2)/k(j,2) * s(j,2) * damp(j)
         pdfgdk(j)  = -pdiffgs(j)/k(j,2)
         pdfgdg(j)  =  pdiffgs(j)/g(j,2)
         pdfgds(j)  =  g(j,2)/k(j,2) * damp(j)
      enddo
      pdiffk(1) = 0.0
      pdfkdg(1) = 0.0
      pdfkdz(1) = 0.0
      pdfkds(1) = 0.0
      pdfkdk(1) = 0.0
c     pdfkds(1) = pdfkds(2)
c     pdfkdk(1) = pdfkdk(2)

      pdiffgs(1)= pdfgds(2) * s(1,2)
      pdfgdk(1) = pdfgdk(2)
      pdfgdg(1) = pdfgdg(2)
      pdfgds(1) = pdfgds(2)
c     pdiffgs(1)= 0.0
      pdfgdk(1) = 0.0
      pdfgdg(1) = 0.0
      pdfgds(1) = 0.0

c
      gd(1,2) = gd(2,2)
      dgddk(1) = 0.0
      dgdds(1) = 0.0
      dgdds(1) = dgdds(2)
      dgddk(1) = dgddk(2)
c
c
c  E & its variation (=pdiffg) , E stored at j-1/2
c  the variables defined here are to be used in subroutine kecoef
c
      do j = 2,np
         pdiffg(j)   = -(pdiffgs(j)-pdiffgs(j-1))/deta(j-1)
         pdfgdkj(j)  = -pdfgdk(j)  / deta(j-1)
         pdfgdkj1(j) = pdfgdk(j-1) / deta(j-1)
         pdfgdgj(J)  = -pdfgdg(j)  / deta(j-1)
         pdfgdgj1(J) = pdfgdg(j-1) / deta(j-1)
         pdfgdsj(j)  = -pdfgds(j)  / deta(j-1)
         pdfgdsj1(j) = pdfgds(j-1) / deta(j-1)
         pdfgdvj(j)  = 0.0
         pdfgdvj1(j) = 0.0
         pdfgdwj (j) = 0.
         pdfgdwj1(j) = 0.
      enddo
c
      return
c
c  Chien's model
c
102   continue
c
c calcualte D
c
      do j = 2,np
         gd(j,2)  = 2.0 * k(j,2) /eta(j)**2
         dgddk(j) = 2.0 / eta(j)**2
         dgdds(j) = 0.0
      enddo
      gd(1,2)  = gd(2,2)
      dgdds(1) = 0.0
      dgddk(1) = dgddk(2)
c
c  calculate E, which is defined at j - 1/2
c
      do j = 2,np
         pdiffgs(j)= -2. * g(j,2)/eta(j)**2*exp(-0.5 *yplus(j))
         pdfgdk(j) = 0.0
         pdfgds(j) = 0.0
         pdfgdg(j) = pdiffgs(j) / g(j,2)
         pdfgdw(j) = pdiffgs(j) * (-0.5*dypdw(j))
      enddo
      j  = 1
      pdiffgs(j)= -2.*g(2,2)/eta(2)**2
      pdfgdg(j) = pdfgdg(2)
      pdfgdk(j) = 0.0
      pdfgdw(j) = 0.0
      pdfgds(j) = 0.0
      do j = 2,np
         pdiffg(j)  = 0.5 * (pdiffgs(j) + pdiffgs(j-1))
         pdfgdkj(j) = 0.5 * pdfgdk(j)
         pdfgdkj1(j)= 0.5 * pdfgdk(j-1)
         pdfgdgj (j)= 0.5 * pdfgdg(j)
         pdfgdgj1(j)= 0.5 * pdfgdg(j-1)
         pdfgdsj (j)= 0.5 * pdfgds(j)
         pdfgdsj1(j)= 0.5 * pdfgds(j-1)
         pdfgdwj (j)= 0.5 * pdfgdw(j  )
         pdfgdwj1(j)= 0.5 * pdfgdw(j-1)
      enddo
c
      return
      end
c
c
      subroutine kedamp
c
c  calculate damping k. e. model's dampling terms : f1, f2, fmu, sigk,
c  sige & their variations
c
      parameter (nxm=200,nym=151)
      real k
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      common /cek0/ k(nym,2),g(nym,2),s(nym,2),q(nym,2),gd(nym,2),
     +              z(nym,2),bs(nym),edvcs(nym),yk(nym),uv(nym),
     +              cmu(nym),b2(nym,2),b3(nym,2),fmu(nym,2),
     +              f1(nym,2),f2(nym,2),sigg(nym,2),sigk(nym,2),
     +              yplus(nym),uplus(nym)
      common /cek1/ cedv(nym),ce1,ce2,ce3,sigke,sigge,yplus1,jeta,
     +              fmu1,fmu2,sigk1,rgmin,rkmin
      common /keeddy/ dcmudk(nym),dcmudg(nym),dcmudv(nym),dcmuds(nym),
     +              dedvdv(nym),dedvdk(nym),dedvdg(nym),dedvds(nym),
     +              db2dv(nym),db2dk(nym),db2dg(nym),db2ds(nym),
     +              db3dv(nym),db3dk(nym),db3dg(nym),db3ds(nym) 
      common /kelowr/ pdiffg(nym),pdfgdk(nym),pdfgdg(nym),pdfgds(nym),
     +          pdiffk(nym),pdfkdk(nym),pdfkdg(nym),pdfkds(nym),
     +          pdfkdz(nym),dgddk(nym),dgdds(nym),pdfgdq(nym),
     +          dsigkdk(nym),dsigkdg(nym),dfmudg(nym),dfmudk(nym),
     +          dsiggdk(nym),dsiggdg(nym),df2dk(nym),df2dg(nym),
     +          df1dk(nym),df1dg(nym),df1dw(nym),
     +          pdfgdkj(nym),pdfgdkj1(nym),pdfgdgj(nym),pdfgdgj1(nym),
     +          pdfgdsj(nym),pdfgdsj1(nym),pdfgdvj(nym),pdfgdvj1(nym),
     +          pdfgdwj(nym),pdfgdwj1(nym),dfmudw(nym),pdfgdw(nym)
      common /work/ d1(nxm), d2(nxm), d3(nxm)
c
      dimension rt(nym),ry(nym),drtdk(nym),drtdg(nym),
     1          drydk(nym),drydg(nym),dypdw(nym),damp(nym)
c
c  ------------------------------------------------------------------
c  calculate rt, ry, yp & their derivatives
c
      do j = 2,np
         rt(j) = rx * k(j,2)**2 / g(j,2)
         ry(j) = sqrx * sqrt(k(j,2)) * eta(j)
         yplus(j) = sqrx * w(j,2) * eta(j)
         dy2      = (yplus(j)/cdamp)**2
         damp(j)  = 0.0
         if(dy2 .lt.50.) damp(j) = exp(-dy2)
         dypdw(j) = yplus(j) / w(j,2)
      enddo
c
      damp(1) = 1.0
      rt(1) = 0.0
      ry(1) = 0.0
      yplus(1) = 0.0
      dypdw(1) = 0.0
      imrt = ismax(np-3,rt,1)
      imry = ismax(np-3,ry,1)
c     imrt = np+1
c     imry = np+1
      do j = 2,np
         if(j.le.imrt) then
            drtdk(j) = 2. * rt(j) / k(j,2)
            drtdg(j) = -rt(j) / g(j,2)
         else
            rt(j) = rt(imrt)
            drtdk(j) = 0.0
            drtdg(j) = 0.0
         endif
c
         jy = min0(j,imry)
         ry(j) = ry(jy)
         drydk(j) = 0.5 * ry(jy) / k(jy,2)
         drydg(j) = 0.0
      enddo
      drtdk(1) = drtdk(2) - (drtdk(3)-drtdk(2))/deta(2)*deta(1)
      drtdk(1) = amax1(0.0,drtdk(1))
      drtdg(1) = drtdg(2) - (drtdg(3)-drtdg(2))/deta(2)*deta(1)
      drtdg(1) = amax1(0.0,drtdg(1))
      drydk(1) = 0.0
      drydk(1) = drydk(2) - (drydk(3)-drydk(2))/deta(2)*deta(1)
      drydk(1) = amax1(0.0,drydk(1))

      dypdw(1) = 0.0
      do j = 1,np
         drydk(j) = 0.0
      enddo
c
      goto (101,102), model
c
c  huang & lin's model (model 1)
c
101   continue
c
c  set fmu limit for calculating cmu based on Huang's formula
c
      d2(1)= 0.0
      do j = 2,np
         d2(j) = eta(j) * sqrt(g(j,2) / k(j,2))
      enddo
      jm = ismax(np-3,d2,1)
      ylamax = d2(jm)
c     jm = np + 1
c
      do j = 1,np
         f1(j,2) = 1.0
         f2(j,2) = 1.0
         df1dk(j) = 0.0
         df1dg(j) = 0.0
         df2dk(j) = 0.0
         df2dg(j) = 0.0
         ylam = d2(j)
         if(j.gt.jm) then
            ylam = ylamax
            dylamdg = 0.0
            dylamdk = 0.0
c           dylamdg = 0.5 * ylam /g(jm,2)
c           dylamdk = -0.5 * ylam /k(jm,2)
         else
            if(j.eq.1) then
               dylamdg = 0.0
               dylamdk = 0.0
            else
               dylamdg = 0.5 * ylam /g(j,2)
               dylamdk = -0.5 * ylam /k(j,2)
            endif
         endif
c
         fmu(j,2) = 1. - exp(-fmu1*ylam - fmu2 * ylam**3)
         dfmudylam= (fmu(j,2)-1.)*(-fmu1-3.*fmu2 * ylam**2)
         dfmudg(j)= dfmudylam * dylamdg
         dfmudk(j)= dfmudylam * dylamdk
         dfmudw(j)= 0.0
         expy1    = exp(-sigk1 * ylam)
         dexpdylam= -sigk1 * expy1
         dexpdk   = dexpdylam * dylamdk
         dexpdg   = dexpdylam * dylamdg
         sigk(j,2)= sigke - 1.1 * expy1
         sigg(j,2)= sigge - 1.0 * expy1
         dsigkdg(j) = -1.1 * dexpdg
         dsigkdk(j) = -1.1 * dexpdk
         dsiggdg(j) = -1.0 * dexpdg
         dsiggdk(j) = -1.0 * dexpdk
      enddo
c
      do j = 2,np
         gd(j,2)   = 0.5 * s(j,2)**2 / k(j,2)* damp(j)
         dgddk(j)  = -gd(j,2) / k(j,2)
         dgdds(j)  = s(j,2)/ k(j,2)* damp(j)
      enddo
      gd(1,2) = gd(2,2)
      dgddk(1) = 0.0
      dgdds(1) = 0.0
      dgdds(1) = dgdds(2)
      dgddk(1) = dgddk(2)
      return
c
c  Chien's model
c
102   continue
      do j = 1,np
         f1(j,2)   = 1.0
         df1dk(j)  = 0.0
         df1dg(j)  = 0.0
         df1dw(j)  = 0.0
         f2(j,2)   = 1.0 - 0.22 * exp (-rt(j)**2/36.)
         df2drt    = rt(j)/18.*(1.-f2(j,2))
         df2dk(j)  = df2drt * drtdk(j)
         df2dg(j)  = df2drt * drtdg(j)
         fmu(j,2)  = 1. - exp(-0.0115*yplus(j))
         dfmudyp   = 0.0115 * (1.-fmu(j,2))
         dfmudk(j) = 0.0
         dfmudg(j) = 0.0
         dfmudw(j) = dfmudyp * dypdw(j)
         sigk(j,2) = 1.0
         sigg(j,2) = 1.3
         dsigkdk(j)= 0.0
         dsigkdg(j)= 0.0
         dsiggdk(j)= 0.0
         dsiggdg(j)= 0.0
      enddo
      do j = 2,np
         gd(j,2)  = 2.0 * k(j,2) /eta(j)**2
         dgddk(j) = 2.0 / eta(j)**2
         dgdds(j) = 0.0
      enddo
      gd(1,2)  = gd(2,2)
      dgdds(1) = 0.0
      dgddk(1) = dgddk(2)
c
      return
      end
c
      subroutine kesolv 
      parameter (nxm=200,nym=151)
      real k
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc2/ delf(nym),delu(nym),delv(nym),delw(nym)
      common /blog/ csmodel, kemodel, low_re, high_re, zonal
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      common /cek0/ k(nym,2),g(nym,2),s(nym,2),q(nym,2),gd(nym,2),
     +              z(nym,2),bs(nym),edvcs(nym),yk(nym),uv(nym),
     +              cmu(nym),b2(nym,2),b3(nym,2),fmu(nym,2),
     +              f1(nym,2),f2(nym,2),sigg(nym,2),sigk(nym,2),
     +              yplus(nym),uplus(nym)
      common /cek1/ cedv(nym),ce1,ce2,ce3,sigke,sigge,yplus1,jeta,
     +              fmu1,fmu2,sigk1,rgmin,rkmin
      common /kebond/ game(3,8),gamm(2,8),gamw(5,8),rj(5)
      common /kematx/ ss(nym,16),pp(nym,16),qq(nym,16),r(8,nym) 
      common /work/ d1(nxm), d2(nxm), d3(nxm)
c
      common /blsolk/aa(8,8,nym),cc(3,8,nym),gamj(5,8,nym),
     1          ccc(5,8,nym),gamjc(3,8,nym),bbc(3,8),
     1          yy(8,nym),bb(5,8),dumm(8),nrow(8,nym),
     1          um(8,nym),icol,irow,isrowc,isrowk
c
      logical csmodel, kemodel, low_re, high_re, zonal
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
c
c  data initialization
c
      icol   = 8
      irow   = 8
      isrowc = 3
      isrowk = 5
      do j   = 1,np
         do kk = 1,icol
            yy(kk,j) = 0.0
            do i = 1,irow
               aa(i,kk,j) = 0.0
            enddo
            do i = 1,isrowk
               gamj(i,kk,j) = 0.0
            enddo
            do i = 1,irow - isrowk
               cc  (i,kk,j) = 0.0
            enddo
            do i = 1,isrowc
               gamjc(i,kk,j)= 0.0
            enddo
            do i = 1,irow - isrowc
               ccc (i,kk,j) = 0.0
            enddo
         enddo
      enddo
c
c  forward sweep
c
      if(zonal) then
c
c  forward sweep in the inner layer of the zonal method; 
c  it has to be treated separatedly because of the different
c  ABC structure
c
c  set aa matrix at j = 1
c
c     due to wall b. c.'s
c
         j   = 1
         do l=1,isrowc
            r(l,1)= rj(l)
            do i=1,icol
               aa(l,i,1) = gamw(l,i)
            enddo
         enddo
c
c     due to the equations : u'=v, k'=0.,s'=0,g'=0 & q'=0
c
         aa(4,2,1) = -1.0
         aa(4,3,1) = -a(2)
         aa(5,4,1) = -1.0
         aa(6,5,1) = -1.0
         aa(7,6,1) = -1.0
         aa(8,7,1) = -1.0
c
         call gauss(aa,nrow,irow,icol,nym,j)
c
c  loop of the sweep in the inner zone 
c
         do j = 2,jeta
c
c  set up B matrix coeffs
c
            do kk = 1,icol
               do i = 1,isrowc
                  bbc(i,kk) = 0.0
               enddo
            enddo
            bbc(1,8) = -1.0
            bbc(2,1) = -1.0
            bbc(2,2) = -a(j)
            bbc(3,1) = ss(j,2)
            bbc(3,2) = ss(j,4)
            bbc(3,3) = ss(j,6)
c
c  set up C matrix coeffs
c
            ccc(1,2,j-1) = 1.0
            ccc(1,3,j-1) = -a(j)
            ccc(2,4,j-1) = 1.0
            ccc(3,5,j-1) = 1.0
            ccc(4,6,j-1) = 1.0
            ccc(5,7,j-1) = 1.0
c
            call gamsv(gamjc,aa,nrow,bbc,irow,icol,nym,isrowc,
     +                 dumm,j)
c
c  set up aa matrix coeffs
c
            aa(1,1,j) = 0.0
            aa(1,2,j) =    -gamjc(1,4,j) *ccc(1,2,j-1)
            aa(1,3,j) =    -gamjc(1,4,j) *ccc(1,3,j-1)
            aa(1,4,j) =    -gamjc(1,5,j) *ccc(2,4,j-1)
            aa(1,5,j) =    -gamjc(1,6,j) *ccc(3,5,j-1)
            aa(1,6,j) =    -gamjc(1,7,j) *ccc(4,6,j-1)
            aa(1,7,j) =    -gamjc(1,8,j) *ccc(5,7,j-1)
            aa(1,8,j) = 1.0
            aa(2,1,j) = 1.0
            aa(2,2,j) = -a(j)-gamjc(2,4,j) *ccc(1,2,j-1)
            aa(2,3,j) =      -gamjc(2,4,j) *ccc(1,3,j-1)
            aa(2,4,j) =      -gamjc(2,5,j) *ccc(2,4,j-1)
            aa(2,5,j) =      -gamjc(2,6,j) *ccc(3,5,j-1)
            aa(2,6,j) =      -gamjc(2,7,j) *ccc(4,6,j-1)
            aa(2,7,j) =      -gamjc(2,8,j) *ccc(5,7,j-1)
            aa(2,8,j) = 0.0
            aa(3,1,j) = ss(j,1)
            aa(3,2,j) = ss(j,3)-gamjc(3,4,j) *ccc(1,2,j-1)
            aa(3,3,j) = ss(j,5)-gamjc(3,4,j) *ccc(1,3,j-1)
            aa(3,4,j) =        -gamjc(3,5,j) *ccc(2,4,j-1)
            aa(3,5,j) =        -gamjc(3,6,j) *ccc(3,5,j-1)
            aa(3,6,j) =        -gamjc(3,7,j) *ccc(4,6,j-1)
            aa(3,7,j) =        -gamjc(3,8,j) *ccc(5,7,j-1)
            aa(3,8,j) = 0.0
c
            if(j.lt.jeta) then
               aa(4,2,j) = -1.0
               aa(4,3,j) = -a(j+1)
               aa(5,4,j) = -1.0
               aa(6,5,j) = -1.0
               aa(7,6,j) = -1.0
               aa(8,7,j) = -1.0
            else
c
c  match conditons at j = jeta
c
c  1. eddy of c. s. = eddy of k. e.
c
               aa(4,3,j) = gamm(1,3)
               aa(4,4,j) = gamm(1,4)
               aa(4,6,j) = gamm(1,6)
c
c  2. production = dissipation
c
               aa(5,3,j) = gamm(2,3)
               aa(5,4,j) = gamm(2,4)
               aa(5,6,j) = gamm(2,6)
c
               aa(6,2,j) = -1.0
               aa(6,3,j) = -a(j+1)
               aa(7,4,j) = -1.0
               aa(7,5,j) = -a(j+1)
               aa(8,6,j) = -1.0
               aa(8,7,j) = -a(j+1)
            endif
c
            call gauss(aa,nrow,irow,icol,nym,j)
         enddo
c
c  calculate yy matrix coeffs. in the inner zone
c
         do i = 1,irow
            yy(i,1) = r(i,1)
         enddo
c
         do j = 2,jeta
            do i = 1,isrowc
               sum   = 0.0
               do kk = 1,icol
                  sum = sum + gamjc(i,kk,j) * yy(kk,j-1)
               enddo
               yy(i,j) = r(i,j) - sum
            enddo
            do i = isrowc+1,irow
               yy(i,j) = r(i,j)
            enddo
         enddo
      else
c
c  set up data ke model at j = 1
c
c  1. aa matrix
c
         j     = 1
c
c     due to wall b. c.'s
c
         do l=1,isrowk
            r(l,1)= rj(l)
            do i=1,icol
               aa(l,i,1) = gamw(l,i)
            enddo
         enddo
c     due to the equations: u' = v, k'= s, g'= q
c
         aa(6,2,1) = -1. 
         aa(6,3,1) = -a(2)
         aa(7,4,1) = -1.0
         aa(7,5,1) = -a(2)
         aa(8,6,1) = -1.0
         aa(8,7,1) = -a(2)
         call gauss(aa,nrow,irow,icol,nym,1)
c
c  2. yy matrix
c
         do i = 1,irow
            yy(i,1) = r(i,1)
         enddo
      endif
c
c  -------------------- forward sweep ---------------------------- 
c  forward sweep for ke model or outer zone of the zonal model; they 
c  are grouped because they have the same ABC structure
c
      do j = jeta+1,np
c
c  set up bb matrix coeffs
c
         do l = 1,5  
            do i = 1,8
               bb(l,i) = 0.0
            enddo
         enddo
c
         bb(1,8) = -1.
         bb(2,1) = -1.
         bb(2,2) = -a(j)
         do kk = 1,8
            kk2  = kk * 2
            bb(3,kk) = ss(j,kk2) 
            bb(4,kk) = pp(j,kk2)
            bb(5,kk) = qq(j,kk2)
         enddo
c
c  set up cc matrix coeffs
c
         cc(1,2,j-1) = 1.0
         cc(1,3,j-1) = -a(j)
         cc(2,4,j-1) = 1.0
         cc(2,5,j-1) = -a(j)
         cc(3,6,j-1) = 1.0
         cc(3,7,j-1) = -a(j)
c
c  solve for gamj
c
         call gamsv(gamj,aa,nrow,bb,irow,icol,nym,isrowk,dumm,j)

c
c  calculate aa mxtrix coeffs at j
c
         aa(1,1,j) = 0.0
         aa(1,2,j) =    -gamj(1,6,j) * cc(1,2,j-1)
         aa(1,3,j) =    -gamj(1,6,j) * cc(1,3,j-1)
         aa(1,4,j) =    -gamj(1,7,j) * cc(2,4,j-1)
         aa(1,5,j) =    -gamj(1,7,j) * cc(2,5,j-1)
         aa(1,6,j) =    -gamj(1,8,j) * cc(3,6,j-1)
         aa(1,7,j) =    -gamj(1,8,j) * cc(3,7,j-1)
         aa(1,8,j) = 1.0
         aa(2,1,j) = 1.0
         aa(2,2,j) =-a(j)-gamj(2,6,j) * cc(1,2,j-1)
         aa(2,3,j) =     -gamj(2,6,j) * cc(1,3,j-1)
         aa(2,4,j) =     -gamj(2,7,j) * cc(2,4,j-1)
         aa(2,5,j) =     -gamj(2,7,j) * cc(2,5,j-1)
         aa(2,6,j) =     -gamj(2,8,j) * cc(3,6,j-1)
         aa(2,7,j) =     -gamj(2,8,j) * cc(3,7,j-1)
         aa(2,8,j) = 0.0
         aa(3,1,j) = ss(j,1)
         aa(3,2,j) = ss(j,3)-gamj(3,6,j) * cc(1,2,j-1)
         aa(3,3,j) = ss(j,5)-gamj(3,6,j) * cc(1,3,j-1)
         aa(3,4,j) = ss(j,7)-gamj(3,7,j) * cc(2,4,j-1)
         aa(3,5,j) = ss(j,9)-gamj(3,7,j) * cc(2,5,j-1)
         aa(3,6,j) = ss(j,11)-gamj(3,8,j) * cc(3,6,j-1)
         aa(3,7,j) = ss(j,13)-gamj(3,8,j) * cc(3,7,j-1)
         aa(3,8,j) = 0.0
         aa(4,1,j) = pp(j,1)
         aa(4,2,j) = pp(j,3)-gamj(4,6,j) * cc(1,2,j-1)
         aa(4,3,j) = pp(j,5)-gamj(4,6,j) * cc(1,3,j-1)
         aa(4,4,j) = pp(j,7)-gamj(4,7,j) * cc(2,4,j-1)
         aa(4,5,j) = pp(j,9)-gamj(4,7,j) * cc(2,5,j-1)
         aa(4,6,j) = pp(j,11)-gamj(4,8,j) * cc(3,6,j-1)
         aa(4,7,j) = pp(j,13)-gamj(4,8,j) * cc(3,7,j-1)
         aa(4,8,j) = 0.0
         aa(5,1,j) = qq(j,1)
         aa(5,2,j) = qq(j,3)-gamj(5,6,j) * cc(1,2,j-1)
         aa(5,3,j) = qq(j,5)-gamj(5,6,j) * cc(1,3,j-1)
         aa(5,4,j) = qq(j,7)-gamj(5,7,j) * cc(2,4,j-1)
         aa(5,5,j) = qq(j,9)-gamj(5,7,j) * cc(2,5,j-1)
         aa(5,6,j) = qq(j,11)-gamj(5,8,j) * cc(3,6,j-1)
         aa(5,7,j) = qq(j,13)-gamj(5,8,j) * cc(3,7,j-1)
         aa(5,8,j) = 0.0
         if(j.ne.np) then
c
c  inner points
c
            aa(6,2,j) = -1.0
            aa(6,3,j) = -a(j+1)
            aa(7,4,j) = -1.0
            aa(7,5,j) = -a(j+1)
            aa(8,6,j) = -1.0
            aa(8,7,j) = -a(j+1)
         else
c
c  edge boundary conditions
c
            do kk = 1,3
               do i = 1,8
                  aa(kk+5,i,j) = game(kk,i)
               enddo
            enddo
         endif
         call gauss(aa,nrow,irow,icol,nym,j)
      enddo
c
c  calculate yy matrix coeffs
c
      do j = jeta+1,np
         do i = 1,isrowk
            sum   = 0.0
            do kk = 1,icol
               sum = sum + gamj(i,kk,j) * yy(kk,j-1)
            enddo
            yy(i,j) = r(i,j) - sum
         enddo
         do i = isrowk+1,irow
            yy(i,j) = r(i,j)
         enddo
      enddo
c
c  -------------  backward sweep  ------------------------- 
c
      call usolv(aa,nrow,um,yy,irow,icol,nym,np)
      do j  = np-1,1,-1
         jp1    = j + 1
         if(j.lt.jeta) then
c
c  inner region of the zonal model
c
            yy(4,j)=yy(4,j)-(ccc(1,2,j)*um(2,jp1)+ccc(1,3,j)*
     1              um(3,jp1))
            yy(5,j)=yy(5,j)-ccc(2,4,j)*um(4,jp1)
            yy(6,j)=yy(6,j)-ccc(3,5,j)*um(5,jp1)
            yy(7,j)=yy(7,j)-ccc(4,6,j)*um(6,jp1)
            yy(8,j)=yy(8,j)-ccc(5,7,j)*um(7,jp1)
         else
c
c  outer region of the zonal model or complete region of ke model
c
            yy(6,j)=yy(6,j)-(cc(1,2,j)*um(2,jp1)+cc(1,3,j)*
     1              um(3,jp1))
            yy(7,j)=yy(7,j)-(cc(2,4,j)*um(4,jp1)+cc(2,5,j)*
     1              um(5,jp1))
            yy(8,j)=yy(8,j)-(cc(3,6,j)*um(6,jp1)+cc(3,7,j)*
     1              um(7,jp1))
         endif
         call usolv(aa,nrow,um,yy,irow,icol,nym,j)
      enddo
c
c  update the variables
c
      idxt= nx - 1 + (it-1)
      if(low_re) then
         rex = amin1(1.0,0.50 + 0.15*idxt)
      else
         rex = amin1(1.0,0.75 + 0.15*idxt)
      endif
      if(it.gt.10) rex = amin1(rex,0.80)
c
      do j = 1,np 
         f(j,2)= f(j,2)+um(1,j)*rex
         u(j,2)= u(j,2)+um(2,j)*rex
         v(j,2)= v(j,2)+um(3,j)*rex
         k(j,2)= k(j,2)+um(4,j)*rex
         s(j,2)= s(j,2)+um(5,j)*rex
         g(j,2)= g(j,2)+um(6,j)*rex
         q(j,2)= q(j,2)+um(7,j)*rex
         w(j,2)= w(j,2)+um(8,j)*rex
      enddo
c 
      if(zonal) then
c
c  reset k, g eta in the inner region for the zonal method
c
         do j = 1,jeta-1 
            k(j,2) = k(jeta,2)
            g(j,2) = g(jeta,2)
            s(j,2) = 0.
            q(j,2) = 0.
         enddo
      endif
c
      if(low_re) then
c
c  low-reynolds-number k. e. model
c
         k(1,2) = 0.0
         g(1,2) = 0.0
         u(1,2) = 0.0
         f(1,2) = 0.0
      elseif(zonal) then
c
c  zonal model
         u(1,2) = 0.0
         f(1,2) = 0.0
      endif
c
      delv(1) = um(3,1)
      delu(1) = um(2,1)
      delw(1) = um(8,1)
c
c   eliminate negative turbulent energy $ dissipation
c   k
      jk  = 0
      jg  = 0
      do j= jeta+1,np
         if(k(j,2) .lt. 0.0) then
            jk = j
            goto 102
         endif
      enddo
  102 if(jk.ne.0) then
         do j = jk,np
            k(j,2) = abs(k(j,2))
         enddo
         jneg = jk
         j1  = max0(2,jneg-2)
         call amean(j1,np,eta,k(1,2),d1,1)
         call diff1(np,eta,k(1,2),s(1,2))
      endif
c
c  repeat for g
      do j = jeta+1,np
         if(g(j,2).lt.0.0) then
            jg = j
            goto 115
         endif
      enddo
  115 if(jg.ne.0) then
         do j = jg,np
            g(j,2)= abs(g(j,2))
         enddo
         j1 = max0(2,jneg-2)
         call amean(j1,np,eta,g(1,2),d1,1)
         call diff1(np,eta,g(1,2),q(1,2))
      endif
c
c  eliminate overshooting near the edge of b. l.
c
      call smoth2(2) 
      return
      end
c
      subroutine kewall
c
c   this subroutine computes the 'wall' boundary conditions 
c
      parameter (nxm=200,nym=151)
      real k
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
      common /blog/ csmodel, kemodel, low_re, high_re, zonal
      common /cek0/ k(nym,2),g(nym,2),s(nym,2),q(nym,2),gd(nym,2),
     +              z(nym,2),bs(nym),edvcs(nym),yk(nym),uv(nym),
     +              cmu(nym),b2(nym,2),b3(nym,2),fmu(nym,2),
     +              f1(nym,2),f2(nym,2),sigg(nym,2),sigk(nym,2),
     +              yplus(nym),uplus(nym)
      common /cek1/ cedv(nym),ce1,ce2,ce3,sigke,sigge,yplus1,jeta,
     +              fmu1,fmu2,sigk1,rgmin,rkmin
      common /keeddy/ dcmudk(nym),dcmudg(nym),dcmudv(nym),dcmuds(nym),
     +              dedvdv(nym),dedvdk(nym),dedvdg(nym),dedvds(nym),
     +              db2dv(nym),db2dk(nym),db2dg(nym),db2ds(nym),
     +              db3dv(nym),db3dk(nym),db3dg(nym),db3ds(nym) 
      common /kebond/ game(3,8),gamm(2,8),gamw(5,8),rj(5)
      logical csmodel, kemodel, low_re, high_re, zonal
c
      data rk,cb,ck1,ck2,ck3,ck4,ckf1/0.41,5.2,5.94884,13.4682,
     +     13.5718,-785.20,-48.754/
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c
      do i=1,8
         do l=1,5
            gamw(l,i)= 0.0
         enddo
      enddo
c
      if(.not.high_re) then
c
c  wall boundary condtions
c
c    b. c. no 1
c
         gamw(1,1)= 1.0
         rj(1)    = 0.0             !f = 0
c
c   b. c .no 2
c
         gamw(2,2)= 1.0
         rj(2)    = 0.0             !u = 0
c
c   b. c. no 3
c   dummy b. c. note that w = utau / ue 
c
         w(1,2) = sqrt(abs(v(1,2))/ sqrx)
         do j = 1,np
            w(j,2) = w(1,2)
         enddo
         gamw(3,3)= 1.0
         gamw(3,8)= -2. * sqrx * w(1,2) 
         rj(3)    = sqrx * w(1,2)**2 - v(1,2)
         if(low_re) then
c
c   wall boundary condition for k and e
c
c   b. c. no 4 : k = 0.0
            gamw(4,4) = 1.0
            rj(4)  = 0.0
c
c   b. c. no 5 * g (e) = 0.0
            gamw(5,6) = 1.0
            rj(5)     = 0.0
         endif
      else
c
c  law of wall 
c
         yplus1    = eta(1) * sqrx * w(1,2)
         yg        = alog(yplus1)
         gamw(1,2) = 1.0
         gamw(1,8) = -(yg/rk + cb) - 1./rk 
         rj(1)     = w(1,2)*(yg/rk + cb) - u(1,2)
c
c  normal velocity component
c
         crhs      = u(1,2)*eta(1)*(p1(nx)+cel*(1.-w(1,1)/w(1,2)))
         clhs      = cel*(f(1,2)-f(1,1))+p1(nx)*f(1,2)
         gamw(2,1) = cel +p1(nx) 
         gamw(2,2) = -eta(1)*(p1(nx)+cel*(1.-w(1,1)/w(1,2)))
         gamw(2,8) = -u(1,2)*eta(1)*cel*w(1,1)/w(1,2)**2
         rj(2)     = crhs - clhs
c
c  bradshaw's turbulent structure near the wall
c  tau = sqrt(cmu) * k
c
         ak    = fmu(1,2)*cmu(1)*sqrx
         gamw(3,3) = ak*k(1,2)
         gamw(3,4) = ak*v(1,2)
         gamw(3,6) = -sqrt(cmu(1))
         rj(3)     = sqrt(cmu(1))*g(1,2) - ak * k(1,2)*v(1,2)
c
c  eddy of c. s. model = eddy of k. e. model
c
         rkappa= 0.41
         pplus = p2(nx)/(rx*w(1,2)**3)
         p118  = amin1(0.8,11.8*pplus)
         cn    = sqrt(1.0-p118)
         el    = 1.0 - exp(-yplus1*cn/26.0)
         ak    = fmu(1,2)*cmu(1)*rx
         edv1      = sqrx*(rkappa*eta(1)*el)**2
         gamw(4,3) = -edv1*g(1,2)
         gamw(4,4) = 2.*ak*k(1,2)
         gamw(4,6) = -edv1*v(1,2) 
         rj(4)     = edv1*v(1,2)*g(1,2) - ak*k(1,2)**2
c
c  relation between shear at y1 and wall shear
c
         yplus1    = eta(1) * sqrx * w(1,2)
         yg        = alog(yplus1)
         dygdw     = 1./w(1,2)
         dypdw     = yplus1/w(1,2)
         tau1      = ak * k(1,2)**2/g(1,2)*v(1,2)
         alfastr   = 0.5 * (ck1*yg**2 + ck2*yg + ck3 + ck4/yplus1)
         daldw     = 0.5*(2.*ck1*yg*dygdw+ck2*dygdw-ck4/yplus1**2*dypdw)
         alfay1    = alfastr*eta(1)
         dalfdw    = eta(1) * daldw
         gamw(5,3) = tau1/v(1,2)
         gamw(5,4) = 2.*tau1/k(1,2)
         gamw(5,6) =-tau1/g(1,2)
         gamw(5,8) =-2.*w(1,2)*(sqrx+alfay1*(cel+2.*p2(nx)))      
     +              -dalfdw*(cel*(w(1,2)**2-w(1,1)**2)+
     +               2.*p2(nx)*w(1,2)**2)
         rj(5)     = w(1,2)**2*sqrx+alfay1*(cel*(w(1,2)**2-w(1,1)**2)+ 
     +               2.*p2(nx)*w(1,2)**2)-p2(nx)*eta(1)-tau1
      endif
      return
      end
c
      subroutine gamsv(gamj,delj,nrow,bj,n01,n02,n03,n04,dumm,jd)
      dimension gamj(n04,n01,n03),delj(n01,n02,n03),bj(n04,n01),
     1          nrow(n01,n03),dumm(n01)
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      do i=1,n04
         dumm(1) = bj(i,1)/delj(1,1,jd-1)
         do j=2,n01
            j1 = j-1
            sumd = bj(i,j)
            do k=1,j1
               sumd = sumd-dumm(k)*delj(k,j,jd-1)
            enddo
            dumm(j) = sumd/delj(j,j,jd-1)
         enddo
         do jb=2,n01
            j = n01-jb+1
            j1 = j+1
            sumd = dumm(j)
            do k=j1,n01
               sumd = sumd-dumm(k)*delj(k,j,jd-1)
            enddo
            dumm(j)= sumd
         enddo
         do k=1,n01
            ii = nrow(k,jd-1)
            gamj(i,ii,jd)= dumm(k)
         enddo
      enddo
      return
      end  
c
      subroutine gauss(x,nrow,n1,n2,n3,jd)
      dimension x(n1,n2,n3),nrow(n1,n3)
      logical switch
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      do k=1,n1
         nrow(k,jd)=k
      enddo
      do k=2,n1
         switch= .true.
         k1    = k-1
         term  = abs(x(k1,k1,jd))
         do l=k,n1
            if(abs(x(l,k1,jd)) .ge. term) then
               switch= .false.
               ls    = l
               term  = abs(x(l,k1,jd))
            endif
         enddo
         if(.not.switch) then
            ns    = nrow(k1,jd)
            nrow(k1,jd)= nrow(ls,jd)
            nrow(ls,jd)= ns
            do l=1,n1
               te    = x(k1,l,jd)
               x(k1,l,jd)= x(ls,l,jd)
               x(ls,l,jd)= te
            enddo
         endif
c
         xk1   = x(k1,k1,jd)
         do i=k,n1
            x(i,k1,jd)= x(i,k1,jd)/xk1
            do j=k,n1
               x(i,j,jd)= x(i,j,jd)-x(i,k1,jd)*x(k1,j,jd)
            enddo
         enddo
      enddo
      return
      end
c
      subroutine usolv(delj,nrow,uj,yj,n01,n02,n03,jd)
      dimension delj(n01,n02,n03),uj(n01,n03),yj(n01,n03),nrow(n01,n03)
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      n1 = nrow(1,jd)
      uj(1,jd) = yj(n1,jd)
      do i=2,n01
         ni = nrow(i,jd)
         sumu = yj(ni,jd)
         i1    = i-1
         do k=1,i1
            sumu  = sumu-delj(i,k,jd)*uj(k,jd)
         enddo
         uj(i,jd)= sumu
      enddo
      uj(n01,jd)= uj(n01,jd)/delj(n01,n01,jd)
      do ib=2,n01
         i     = n01-ib+1
         i1    = i+1
         sumu  = uj(i,jd)
         do k=i1,n01
            sumu  = sumu-delj(i,k,jd)*uj(k,jd)
         enddo
         uj(i,jd)= sumu/delj(i,i,jd)
      enddo
      return
      end
c
      subroutine qwik(index)
c
c  generate qwikplot file for b. l. summary
c
      parameter (nxm=200,nym=151)
      common /blc0/ nx,nxt,np,npt,it,model,icmu
      common /blc1/ f(nym,2),u(nym,2),v(nym,2),w(nym,2),b(nym,2),
     +              edv(nym),eta(nym),deta(nym),a(nym)
      common /smry/ cf(nxm),umin(nxm),tht2(nxm),dls2(nxm),h2(nxm),
     +              rtht2(nxm),rdls2(nxm)
      common /blc5/ x(nxm),xc(nxm),ue(nxm),duedx(nxm),p1(nxm),p2(nxm),
     +              rl,rx,sqrx,xsqrx,cel,celh,p1h,cdamp,jout
c
c  -------------------------------------------------------------------
c
      write(23) '>summary',0,0.0
      write(23) 'x       ',nxt,(x(i),i=1,nxt)
      write(23) 'xc      ',nxt,(xc(i),i=1,nxt)
      write(23) 'ue      ',nxt,(ue(i),i=1,nxt)
      write(23) 'cf      ',nxt,(cf(i),i=1,nxt)
      write(23) 'theta   ',nxt,(tht2(i),i=1,nxt)
      write(23) 'delst   ',nxt,(dls2(i),i=1,nxt)
      write(23) 'h       ',nxt,(h2(i),i=1,nxt)
      write(23) 'rtheta  ',nxt,(rtht2(i),i=1,nxt)
      write(23) 'rdelst  ',nxt,(rdls2(i),i=1,nxt)
      write(23) '<summary',0,0.0
      return
      end

      subroutine amean(ns,nd,x,y,d,it)
c
c   smooth data using 3-pts weighting formula
c   ns   :  starting point of the data to be smoothed
c   nd   :  end point of the data to be smoothed
c   x, y :  independent + dependent varaibles of the data
c           to be smoothed
c   it   :  cycles of data smoothing
c
      dimension x(nd),y(nd),d(nd)
c --------------------------------------------------
      if(it.lt.1) return
      nm    = nd -ns
      if(nm .lt.2) return
c
      ndm1  = nd - 1
      nsp1  = ns + 1
      do k=1,it
         do i = ns,nd
            d(i) = y(i)
         enddo
         do i=nsp1,ndm1
            f1    = (x(i + 1) -x(i))/(x(i+1) - x(i-1))
            y(i)  = 0.5*(f1*d(i-1)+d(i)+(1.0-f1)*d(i+1))
         enddo
      enddo
      return
      end
c
      subroutine diff1 (n,x,f,fp)
c
c  calculate 1st derivative  of the input function at the input pts. 
c  using weighted angles 
c
      dimension x(n),f(n),fp(n)
      n1      = n-1
      dx      = x(2)-x(1)
      df      = f(2)-f(1)
      ang2    = atan2(df,dx)
      dli     = dx
      dfi     = df
      ang1i   = ang2
      dl2     = dx
      do 10 i = 2,n1
         ang1    = ang2
         dl1     = dl2
         i1      = i+1
         dx      = x(i1)-x(i)
         df      = f(i1)-f(i)
         ang2    = atan2(df,dx)
         dl2     = dx
         ang     = (dl2*ang1+dl1*ang2)/(dl1+dl2)
         fp(i)   = tan(ang)
   10 continue
      fp(1)   = 2.*dfi/dli - fp(2)
      fp(n)   = 2.*df /dl2 - fp(n1)
c
      return
      end
c
      function ismax(n,a,m)
c
c  fund the location of the max value
c
      dimension a(m,n)
      amax  = a(m,1)
      ismax = 1
      do i=1,n
         if (a(m,i) .gt. amax) then
            amax  = a(m,i)
            ismax = i
         end if
      enddo
      return
      end
c
      function ismin(n,a,m)
c
c  fund the location of the min value
c
      dimension a(m,n)
      amin  = a(m,1)
      ismin = 1
      do i=1,n
         if (a(m,i) .lt. amin) then
            amin  = a(m,i)
            ismin = i
         end if
      enddo
      return
      end

      function isamax(n,a,m)
c
c   fund the location of the absolute max value
c
      dimension a(m,n)
      amax   = abs(a(m,1))
      isamax = 1
      do i=1,n
         absa= abs(a(m,i))
         if (absa .gt. amax) then
            amax  = absa
            isamax = i
         end if
      enddo
      return
      end
