% Model identification
%
% Identify models for conversion
%
clc
echo on
u=[xH2in-25.0E-6 Tj-330];
y=[C-0.333];

n = 60; % number of points
ninput = 2; 
plotopt = 2;
nout = 2;
delt = 0.1;

[ureg, yreg]=wrtreg(u,y,n);
[theta1,yres1]=mlr(ureg,yreg,ninput,plotopt);
pause % press enter to continue

% Identify models for q

y=[q-3.555E-3];

[ureg2, yreg2]=wrtreg(u,y,n);
[theta2,yres2]=mlr(ureg2,yreg2,ninput,plotopt);
pause % press enter to continue

figure
swmodel = imp2step(delt,nout,theta1,theta2);
plotstep(swmodel)
pause % press enter to continue
%
% smooth the model (some points at the beginning and
% some points at the end
%
a = swmodel;
[r,c]=size(swmodel);
    
a(r-7,1) = a(r-9,1);
a(r-5,1) = a(r-9,1);
%
a(r-5,2) = a(r-7,2);
a(r-4,2) = a(r-6,2);
%
a(1,2) = 0.0;
a(3,2) = 0.0;
a(2,2) = 0.0;
a(4,2) = 0.0;
%
echo off;
swmodel=a;
plotstep(swmodel);
    
    
    
   
    
  
