function y=signal(Fmin,Fmax,Tmin,Tmax,maxF,minF,slope);

% the down signal generator

%Fmin=0.001; % min step change
%Fmax=0.003; % max step change

%Tmin=1;   %min step length
%Tmax=7;  % max step length


%minF=0.519;  %min value at the end of sgn
%maxF=0.531;  %max value at the end of signal

%slope=0.0001;

% down vector
clear Th;

r1   = rand(1);
r2   = rand(1);
r3   = rand(1);
Th(1)=(Tmax-Tmin)*r3(1)+Tmin;
  
i = 2;
inpF = maxF;

while inpF>minF,
   r1    = rand(1);
   r2    = rand(1);
   r3    = rand(1);
   T     = (Tmax-Tmin)*r3+Tmin;
   Th(i) = Th(i-1)+T; 

% decision maker
% deciding up (1) or down  (-1)
    
   if r1 < 0.5  % up ro down
        r1 = -1;
   else
        r1 = 1; % if bigger then half, positive value
   end

%amplitude
   Fa = (Fmax-Fmin)*r2+Fmin;  % OK
   bias = -((Th(i)*slope))+maxF;
   inpF(i) = bias+(r1*Fa);
   if inpF(i)>maxF
      inpF(i) = maxF
   end 
   i = i+1;
end %end while

[p,q] = size(Th);
size(inpF);
u2 = [];
t2 = [];

for i = 1:1:q-1,
   t1 = [Th(i) Th(i)];
   t2 = [t2 t1];
   u1 = [inpF(i) inpF(i+1)];
   u2 = [u2 u1];
end

dwn = [t2' u2' ] ;
y = dwn;