% Generation of input signals before running HSRdatgen
% Files used: MPRBSup.m and MPRBSdown.m

%% ======== GENERATION INPUT 1 SEQUENCE ===============
clear all;
clc
Fmin  = 1E-6;   % min step change
Fmax  = 3E-6;   % max step change
Tmin  = 1;      % min step length
Tmax  = 12;     % max step length
minF  = 22E-6;  % min value at the end of signal
maxF  = 30E-6;  % max value at the end of signal
slope = 1E-8;

% RMRI signal generatorfunction
sgn1 = mprbsup(Fmin,Fmax,Tmin,Tmax,maxF,minF,slope);

% add the data
% signal through all the range
% adds the signals and delay them

up=[sgn1];

%----------------end -------up signal

clear sgn1;

Fmin  = 1E-6;   % min step change
Fmax  = 3E-6;   % max step change
Tmin  = 1;      % min step length
Tmax  = 12;     % max step length
minF  = 22E-6;  % min value at the end of signal
maxF  = 30E-6;  % max value at the end of signal
slope = 1E-8;

% RMRI signal generatorfunction

sgn1=mprbsdown(Fmin,Fmax,Tmin,Tmax,maxF,minF,slope);

% adds the signals and delay them
a = 0;
b = 0;
a = max(up(:,1))
b = sgn1(:,1);
n = size(b);

for i=1:n,
   b(i)=b(i)+a;
end

bb   = sgn1(:,2);
sgn1 = [b bb];
maxtotal = max(sgn1(:,1))

% steady state

v  = 25E-6*ones(1,600);
t  = [1:600];
in = [t; v]';

% ------ delay in

a = max(sgn1(:,1))
b = in(:,1);
n = size(b);

for i = 1:n,
   b(i) = b(i)+a;
end

bb = in(:,2);
in = [b bb];
maxtotal = max(in(:,1));
xH2in = [up;sgn1;in];
plot(xH2in(:,1),xH2in(:,2));
title('xH2in perturbation pattern');
xlabel('time, sec');
ylabel('xH2in conc');
pause

%% ======== GENERATION INPUT 2 SEQUENCE ===============

Fmin  = 0.5;  % min step change
Fmax  = 0.9;  % max step change
Tmin  = 0.45; % min step length
Tmax  = 11;   % max step length
minF  = 330;  % min value at the end of signal
maxF  = 333;  % max value at the end of signal
slope = 0.01;

% RMRI signal generatorfunction
sgn1=mprbsup(Fmin,Fmax,Tmin,Tmax,maxF,minF,slope);

% add the data signal through all the range
% adds the signals and delay them
% mx=max(all(:,1)); % how long 

v  = 330*ones(1,1120);
t  = [1:1120];
in = [t; v]';

% delay sign1
a = max(in(:,1))
b = sgn1(:,1);
n = size(b);

for i=1:n,
   b(i) = b(i)+a;
end

bb   = sgn1(:,2);
sgn1 = [b bb];
up   = [in;sgn1];

%----------------end up signal ---------------
% -----------------dwn signal ----------------

clear sgn1;

Fmin  = 0.5;  % min step change
Fmax  = 0.9;  % max step change
Tmin  = 0.45; % min step length
Tmax  = 11;   % max step length
minF  = 330;  % min value at the end of signal
maxF  = 333;  % max value at the end of signal
slope = 0.01;

sgn1 = mprbsdown(Fmin,Fmax,Tmin,Tmax,maxF,minF,slope);

%adds the signals and delay them
a = 0;
b = 0;
a = max(up(:,1))
b = sgn1(:,1);
n = size(b);

for i = 1:n,
   b(i) = b(i)+a;
end

bb   = sgn1(:,2);
sgn1 = [b bb];
max1 = max(sgn1(:,1))
Tj = [up;sgn1];
plot(Tj(:,1),Tj(:,2));
title('Tj perturbation pattern');
xlabel('time, sec');
ylabel('Tj, degK');