function out = hsrx(u)
%
% definition of inputs
%
Convsp = u(1);
qsp    = u(2);
Conv   = u(3);
q      = u(4);
F      = u(5);
psi    = u(6);
xH2    = u(7);
rhom   = u(8);
xca    = u(9);
M      = u(10);
H      = u(11);
T      = u(12);
%
% definition of constants
%
Vr    = 0.001855;
b     = 8.821;
delt  = 0.1;
kpa   = 8.172E7;
kpb   = 1.080E9;
Eactp = 45E3;
R     = 8.314;
UA    = 0.155682;
dHrp  = -2.033;
Hin   = 1.10;
Fin   = 1.0;
xmin  = 1.0;
%
% control equation for Conv control
%
H2    = M*xH2/Vr;
xm    = xmin*(1-Conv);
xmsp  = xmin*(1-Convsp);
Rsp   = Fin*(xmin-xmsp) - M*(xmsp-xm)/delt;
kp    = Rsp/(M*xca*psi*rhom);
v1    = kp/(kpa+kpb*(H2^0.4));
Tsp   = -Eactp/(R*log(v1));
Tj    = Tsp - (1/UA)*(M*dHrp*(xmsp-xm)/delt ...
        -Fin*dHrp*(xmin-xmsp) + Fin*Hin - F*H);
%
% extended control equation for q control
% q = f(H2, psi, rhom)   .. eqn(28)
% dq/dt = (df/dH2)*(dH2/dt) + (df/dpsi)*(dpsi/dT)*(dT/dt) +
%         (df/drhom)*(drhom/dT)*(dT/dt)
%  
% simplification is deletion of the 2nd and 3rd line
% 2nd line: contribution from dpsi/dT
% 3rd line: contribution from drhom/dT
%
xH2in = rhom*Vr*psi*(qsp - q)/(b*Fin*delt) + F*xH2/Fin + ...
        (M*xH2/(psi*Fin))*(-0.03063+0.00012*Tsp)*(Tsp-T)/delt + ...
        (M*xH2/(rhom*Fin))*(6.8265-0.0286*Tsp)*(Tsp-T)/delt;
%
[out] = [xH2in Tj Tsp];
% end of code