%
% Plotting the process signals for Fig24, P22spdc
% and Dahlin
% and.
% CHOOSE PROPER VALUE OF IFLAG!
% Fig24   - plot output by choosing iflag = 0
% P22spdc - plot both outputs by choosing iflag = 1
% Dahlin  - plot process input and output by choosing 
%           iflag = 2
%
iflag = 0;
load Output
plot(y2(1,:),y2(2,:),'k',y2(1,:),y2(3,:),'k')
xlabel('time, sec','Fontsize', 15)
ylabel('y, ysp','Fontsize',15)
grid
pause 
% clear
%
% Set iflag = 1 to also plot the second output for
% sp22dpdc
%
if iflag == 1
   load Output1;
   plot(y1(1,:),y1(2,:),'k',y1(1,:),y1(3,:),'k')
   xlabel('time, sec','Fontsize', 15)
   ylabel('y, ysp','Fontsize',15)
   grid
   pause 
%  clear 
end
%
% set iflag = 2 to plot the output of the Dahlin 
% controller
% recalculate u vector for plotting staircase 
%
if iflag == 2
   load input;
   [m,n]=size(u);
   load input
   u = u';
   for i = 1:n
      u1(2*i-1,1) = u(i,1);
      u1(2*i,1)   = u(i,1) + 0.99;
%
      u1(2*i-1,2) = u(i,2);
      u1(2*i,2)   = u(i,2);
   end
   u1 = u1';
   plot(u1(1,:), u1(2,:));
   xlabel('time, sec','Fontsize', 15)
   ylabel('u','Fontsize',15)
   grid
   pause
   clear
end

